// (c) Ivan Gagis
// e-mail: igagis@gmail.com
// Version: 1

// Description:
//          Music playback thread class

#pragma once

#include <deque>

#include <ting/debug.hpp>
#include <ting/types.hpp>
#include <ting/Array.hpp>
#include <ting/Thread.hpp>

#include <aumiks/synth/synth.hpp>

//==============================================================================
//==============================================================================
//==============================================================================
class PlaybackThread : public ting::MsgThread{
	friend class PushMusicDataMessage;
	friend class PlayerSwitchMessage;
	friend class ResetPlaybackMessage;

	
	ting::Ref<aumiks::Instrument> instr;//current instrument
	ting::Ref<aumiks::Instrument::Channel> ch;

	std::deque<ting::Array<ting::byte> > musicDataQueue;

	bool playerHasSwitched;

	enum EMusicAction{
		NOTE_ON = 0,
		NOTE_OFF = 1
	};

	struct MusicAction{
		ting::byte id;
		ting::u32 timestamp;
		ting::byte volume;
		float freq;
	};

	ting::Array<MusicAction> curMusicData;
public:
	PlaybackThread();
	~PlaybackThread(){};

	//override
	void Run();

	void ResetPlayback_ts();

	void PushNewPlaybackData_ts(ting::Array<ting::byte> data);

	void HandlePlayerSwitch_ts();
private:

	static bool ParseMusicData(
			ting::Array<MusicAction>& ma,
			const ting::byte* dataStart,
			const ting::byte* const dataEnd
		);
};
//==============================================================================
//==============================================================================
//==============================================================================



class PushMusicDataMessage : public ting::Message{
	PlaybackThread* t;

	ting::Array<ting::byte> data;

public:
	PushMusicDataMessage(
			PlaybackThread* thread,
			ting::Array<ting::byte> musicData
		) :
			t(thread),
			data(musicData)
	{
		ASSERT(this->t)
	}

	//override
	void Handle();
};



class PlayerSwitchMessage : public ting::Message{
	PlaybackThread* t;
public:
	PlayerSwitchMessage(PlaybackThread* thread) :
			t(thread)
	{
		ASSERT(this->t)
	}

	//override
	void Handle(){
		this->t->playerHasSwitched = true;
	}
};



class ResetPlaybackMessage : public ting::Message{
	PlaybackThread* t;
public:
	ResetPlaybackMessage(PlaybackThread* thread) :
			t(thread)
	{
		ASSERT(this->t)
	}

	//override
	void Handle();
};


