#include "backgrounds.h"
#include "ui_backgrounds.h"
#include <QFileDialog>

backgrounds::backgrounds(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::backgrounds)
{
    ui->setupUi(this);
    ui->scrollArea->setWidget(ui->widget);
    clockdir = "/etc/hildon/theme/backgrounds/clock.png";
    appdir =  "/etc/hildon/theme/backgrounds/applicationmanager.png";
    mdir = "/etc/hildon/theme/mediaplayer/background.png";
    ldir = "/etc/hildon/theme/backgrounds/lockslider.png";
    const QString COLOR_STYLE("QPushButton { border-image: url(%2); border: 2px solid white; }");
    ui->clock->setStyleSheet(COLOR_STYLE.arg(clockdir));
    ui->appmanager->setStyleSheet(COLOR_STYLE.arg(appdir));
    ui->mplayer->setStyleSheet(COLOR_STYLE.arg(mdir));
    ui->lock->setStyleSheet(COLOR_STYLE.arg(ldir));
    lastpath = "/home/user/MyDocs/";
}

backgrounds::~backgrounds()
{
    delete ui;
}

void backgrounds::on_clock_clicked()
{
    const QString COLOR_STYLE("QPushButton { border-image: url(%2); border: 2px solid white; }");
    QString clockdir2 = QFileDialog::getOpenFileName(this, "Select Image", lastpath, "Images (*.jpeg *.jpg *.gif *.png *.bmp *.tiff)");
    if (clockdir2.isEmpty()) return;

    lastpath = (QFileInfo(clockdir2).absolutePath());
    clockdir = clockdir2;
    ui->clock->setStyleSheet(COLOR_STYLE.arg(clockdir));
    ui->clockset->setDisabled(false);
}

void backgrounds::on_appmanager_clicked()
{
    const QString COLOR_STYLE("QPushButton { border-image: url(%2); border: 2px solid white; }");
    QString appdir2 = QFileDialog::getOpenFileName(this, "Select Image", lastpath, "Images (*.jpeg *.jpg *.gif *.png *.bmp *.tiff)");
    if (appdir2.isEmpty()) return;

    lastpath = (QFileInfo(appdir2).absolutePath());
    appdir = appdir2;
    ui->appmanager->setStyleSheet(COLOR_STYLE.arg(appdir));
    ui->appmanagerset->setDisabled(false);
}

void backgrounds::on_mplayer_clicked()
{
    const QString COLOR_STYLE("QPushButton { border-image: url(%2); border: 2px solid white; }");
    QString mdir2 = QFileDialog::getOpenFileName(this, "Select Image", lastpath, "Images (*.jpeg *.jpg *.gif *.png *.bmp *.tiff)");
    if (mdir2.isEmpty()) return;

    lastpath = (QFileInfo(mdir2).absolutePath());
    mdir = mdir2;
    ui->mplayer->setStyleSheet(COLOR_STYLE.arg(mdir));
    ui->mplayerset->setDisabled(false);
}

void backgrounds::on_lock_clicked()
{
    const QString COLOR_STYLE("QPushButton { border-image: url(%2); border: 2px solid white; }");
    QString ldir2 = QFileDialog::getOpenFileName(this, "Select Image", lastpath, "Images (*.jpeg *.jpg *.gif *.png *.bmp *.tiff)");
    if (ldir2.isEmpty()) return;

    lastpath = (QFileInfo(ldir2).absolutePath());
    ldir = ldir2;
    ui->lock->setStyleSheet(COLOR_STYLE.arg(ldir));
    ui->lockset_2->setDisabled(false);
}

void backgrounds::on_clockset_clicked()
{
    ui->clockset->setDisabled(true);
    QPixmap original = clockdir;
    QSize size = QSize::QSize(800, 424);
    QPixmap resized = original.scaled(size);
    resized.save("/opt/theme-customizer/clock.png");
    QStringList args;
    args << "changeimagepushed" << "clock.png";
    QProcess *jau = new QProcess(this);
    jau->start("/sbin/launchcustomizer", args);
    system("run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:'Image saved!'");
}

void backgrounds::on_appmanagerset_clicked()
{
    ui->appmanagerset->setDisabled(true);
    QPixmap original = appdir;
    QSize size = QSize::QSize(800, 424);
    QPixmap resized = original.scaled(size);
    resized.save("/opt/theme-customizer/appmanager.png");
    QStringList args;
    args << "changeimagepushed" << "appmanager.png";
    QProcess *jau = new QProcess(this);
    jau->start("/sbin/launchcustomizer", args);
    system("run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:'Image saved!'");
}

void backgrounds::on_mplayerset_clicked()
{
    ui->mplayerset->setDisabled(true);
    QPixmap original = mdir;
    QSize size = QSize::QSize(800, 424);
    QPixmap resized = original.scaled(size);
    resized.save("/opt/theme-customizer/mplayer.png");
    QStringList args;
    args << "changeimagepushed" << "mplayer.png";
    QProcess *jau = new QProcess(this);
    jau->start("/sbin/launchcustomizer", args);
    system("run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:'Image saved!'");
}

void backgrounds::on_lockset_2_clicked()
{
    ui->lockset_2->setDisabled(true);
    QPixmap original = ldir;
    QSize size = QSize::QSize(800, 480);
    QPixmap resized = original.scaled(size);
    resized.save("/opt/theme-customizer/lock.png");
    QStringList args;
    args << "changeimagepushed" << "lock.png";
    QProcess *jau = new QProcess(this);
    jau->start("/sbin/launchcustomizer", args);
    system("run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:'Image saved!'");
}
