#include "mainwindow.h"
#include "ui_mainwindow.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow),
    progress(tr("Setting up the theme, please wait..."), tr("Abort"), 0, 0, this),
    progress2(tr("Searching and importing fonts, please wait..."), tr("Abort"), 0, 0, this),
    colors()
{
    ui->setupUi(this);
    ui->scrollArea->setWidget(ui->widget);
    readdirs();
    oldfonts();
    readSettings();
    QRegExp regexer("^\\#[0-9a-fA-F]{6,6}$");
    QRegExp regexer_icon("^[0-9]{1,3}$");
    QRegExp regexer_book("^[0-9]{2,3}$");
    QRegExp regexer_snap("^[0-9]{1,2}$");
  //  QValidator* actualvalidator;
    // actualvalidator = new QRegExpValidator(regexer, this);
    //QRegExpValidator validator();
    ui->font1->setValidator(new QRegExpValidator(regexer, ui->font1));
    ui->font2->setValidator(new QRegExpValidator(regexer, ui->font2));
    ui->font3->setValidator(new QRegExpValidator(regexer, ui->font3));
    ui->font4->setValidator(new QRegExpValidator(regexer, ui->font4));
    ui->font5->setValidator(new QRegExpValidator(regexer, ui->font5));
    ui->font6->setValidator(new QRegExpValidator(regexer, ui->font6));
    ui->font7->setValidator(new QRegExpValidator(regexer, ui->font7));
    ui->font8->setValidator(new QRegExpValidator(regexer, ui->font8));
    ui->lineEdit->setValidator(new QRegExpValidator(regexer_icon, ui->lineEdit));
    ui->lineEdit_2->setValidator(new QRegExpValidator(regexer_book, ui->lineEdit_2));
    ui->Snap->setValidator(new QRegExpValidator(regexer_snap, ui->Snap));
    QImage png("/opt/theme-customizer/customizer.png");
    QPixmap image;
    image = image.fromImage(png);
    ui->logo->setPixmap(image);
    ui->logo->setGeometry(0,0,79,900);

}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::oldfonts()
{

    QFile file("/etc/hildon/theme/colors.config");
    file.open(QFile::ReadOnly);

    QTextStream stream ( &file );
    QString line;
    QHash<QString, QString> variables;
    do {
        line = stream.readLine();

        QStringList splittedLine = line.split("=");

        if (splittedLine.count()==2) {
        variables.insert(splittedLine.at(0), splittedLine.at(1));
    }
    } while (!line.isNull());

    file.close();


    fonts.clear();
    fonts.append(variables.value("DefaultTextColor"));
    fonts.append(variables.value("SecondaryTextColor"));
    fonts.append(variables.value("ActiveTextColor"));
    fonts.append(variables.value("DisabledTextColor"));


    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");
    const QString COLOR_STYLE2("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");

    ui->fontprimary->setStyleSheet(COLOR_STYLE.arg(variables.value("DefaultTextColor"), variables.value("DefaultBackgroundColor"), variables.value("DefaultTextColor")));
    ui->font1->setText(variables.value("DefaultTextColor"));
    f1=variables.value("DefaultTextColor");

    ui->fontsecondary->setStyleSheet(COLOR_STYLE.arg(variables.value("SecondaryTextColor"), variables.value("DefaultBackgroundColor"), variables.value("SecondaryTextColor")));
    ui->font2->setText(variables.value("SecondaryTextColor"));
    f2=variables.value("SecondaryTextColor");

    ui->fontactive->setStyleSheet(COLOR_STYLE.arg(variables.value("ActiveTextColor"), variables.value("DefaultBackgroundColor"), variables.value("ActiveTextColor")));
    ui->font3->setText(variables.value("ActiveTextColor"));
    f3=variables.value("ActiveTextColor");

    ui->fontdisabled->setStyleSheet(COLOR_STYLE.arg(variables.value("DisabledTextColor"), variables.value("DefaultBackgroundColor"), variables.value("DisabledTextColor")));
    ui->font4->setText(variables.value("DisabledTextColor"));
    f4=variables.value("DisabledTextColor");

    ui->fontpainted->setStyleSheet(COLOR_STYLE2.arg(variables.value("PaintedTextColor"), variables.value("SelectionColor"), variables.value("PaintedTextColor")));
    ui->font5->setText(variables.value("PaintedTextColor"));
    f5=variables.value("PaintedTextColor");

    ui->fontdisabled_2->setStyleSheet(COLOR_STYLE.arg(variables.value("SelectionColor"), variables.value("DefaultBackgroundColor"), variables.value("SelectionColor")));
    ui->font6->setText(variables.value("SelectionColor"));
    f6=variables.value("SelectionColor");

    ui->fontbutton->setStyleSheet(COLOR_STYLE.arg(variables.value("ButtonTextColor"), variables.value("DefaultBackgroundColor"), variables.value("ButtonTextColor")));
    ui->font7->setText(variables.value("ButtonTextColor"));
    f7=variables.value("ButtonTextColor");

    ui->fontbuttonpressed->setStyleSheet(COLOR_STYLE.arg(variables.value("ButtonTextPressedColor"), variables.value("DefaultBackgroundColor"), variables.value("ButtonTextPressedColor")));
    ui->font8->setText(variables.value("ButtonTextPressedColor"));
    f8=variables.value("ButtonTextPressedColor");
}

void MainWindow::readdirs()
{
    QDir colors("/usr/share/icons");
    QStringList colorstobox = colors.entryList(QDir::AllDirs | QDir::NoDotAndDotDot, QDir::DirsFirst);
    colorstobox.removeOne("default");
    ui->Iconset->addItems(colorstobox);
}

void MainWindow::writeSettings()
{
    QSettings sett("ThemeCustomizer", "Boxes");
//    sett.setValue("icons", ui->Icons->currentIndex());
    sett.setValue("snap", ui->Snap->text());
    sett.setValue("fontsize", ui->FontSize->currentIndex());
    sett.setValue("iconset", ui->Iconset->currentIndex());
    sett.setValue("appsize", ui->lineEdit->text());
    sett.setValue("booksize", ui->lineEdit_2->text());

    QString Icons;
    if ( ui->Icons->checkState() == Qt::Checked ) {
        sett.setValue("icons", "1");
    }
    else {
        sett.setValue("icons", "0");
    }
}

void MainWindow::readSettings()
{
    QSettings sett("ThemeCustomizer", "Boxes");
    int icons = sett.value("icons").toInt();
    int snap = sett.value("snap").toInt();
    int fontsize = sett.value("fontsize").toInt();
    int iconset = sett.value("iconset").toInt();
    int appsize = sett.value("appsize").toInt();
    int booksize = sett.value("booksize").toInt();
    QString appsizestring = sett.value("appsize").toString();
    QString booksizestring = sett.value("booksize").toString();
    QString snapstring = sett.value("snap").toString();
    // ui->Icons->setCurrentIndex(icons);
    // ui->Snap->setCurrentIndex(snap);

    if ( icons == 1 ) {
        ui->Icons->setCheckState(Qt::Checked);
    } else {
        ui->Icons->setCheckState(Qt::Unchecked);
    }

    ui->FontSize->setCurrentIndex(fontsize);
    ui->Iconset->setCurrentIndex(iconset);

    if ( appsize > 15 ) {
    ui->lineEdit->setText(appsizestring);
    ui->horizontalSlider->setValue(appsize);
    }

    if ( booksize > 25 ) {
    ui->lineEdit_2->setText(booksizestring);
    ui->horizontalSlider_2->setValue(booksize);
    }

    if ( snap > 3 ) {
    ui->Snap->setText(snapstring);
    ui->horizontalSlider_3->setValue(snap);
    }
}

void MainWindow::on_pushButton_clicked()
{
        QString checkboxstate;
        if ( ui->checkBoxActivate->checkState() == Qt::Checked ) {
            checkboxstate = "Reboot";
        }
        else {
            checkboxstate = "0";
        }

        QString Icons;
        if ( ui->Icons->checkState() == Qt::Checked ) {
            Icons = "Show icons";
        }
        else {
            Icons = "Don't show icon backgrounds";
        }

        writeSettings();
        QString varattu;
        varattu = "Theme Customizer";
        progress.setWindowModality(Qt::WindowModal);
        progress.setWindowTitle(varattu);
        progress.setCancelButton(0);
        QStringList arguments;
        arguments << ui->FontSize->currentText() << ui->Fonter->currentText() << ui->Iconset->currentText() << Icons << ui->lineEdit->text() << ui->Snap->text() << checkboxstate << fonts << f1 << f2 << f3 << f4 << ui->lineEdit_2->text() << f5 << f6 << f7 << f8;
        QProcess *process = new QProcess(this);
        connect(process, SIGNAL(finished(int)), this, SLOT(processFinished(int)));
        process->start("/sbin/launchcustomizer", arguments);
        progress.show();


}

void MainWindow::processFinished(int)
{

    if ( ui->checkBoxActivate->checkState() == Qt::Unchecked ) {

        QProcess *process2 = new QProcess(this);
        process2->start("/usr/sbin/dsmetool -k /usr/bin/hildon-home");

        sleep(3);

        QProcess *process5 = new QProcess(this);
        process5->start("/usr/sbin/dsmetool -t /usr/bin/hildon-home");

        sleep(15);

        QProcess *process4 = new QProcess(this);
        process4->start("killall hildon-desktop");

        sleep(10);

        QProcess *process6 = new QProcess(this);
        process6->start("killall hildon-status-menu");

        sleep(10);

   //     QProcess *process8 = new QProcess(this);
   //     process8->start("/usr/bin/run-standalone.sh dbus-send --print-reply --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteDialog string:\"All done! Restarting device is recommended to reload all new values.\" uint32:0 string:'NAO OK!'");

        sleep(5);

        QProcess *process7 = new QProcess(this);
        process7->start("killall theme-customizer");
    }

    progress.cancel();
    oldfonts();
//        writeSettings();
}

void MainWindow::on_horizontalSlider_valueChanged(int value)
{
    QString slaideri = QString::number(value);
    ui->lineEdit->setText(slaideri);
}

void MainWindow::on_horizontalSlider_2_valueChanged(int value)
{
    QString slaideri2 = QString::number(value);
    ui->lineEdit_2->setText(slaideri2);
}

void MainWindow::on_horizontalSlider_3_valueChanged(int value)
{
    QString slaideri3 = QString::number(value);
    ui->Snap->setText(slaideri3);
}

void MainWindow::on_fontprimary_clicked()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");

    QColor current = f1;
    QColor color1 = colors.getColor(current.name());
    f1 = color1.name();

    if (!color1.isValid()) return;

    ui->fontprimary->setStyleSheet(COLOR_STYLE.arg(f1, variables.value("DefaultBackgroundColor"), f1));
    ui->font1->setText(f1);
}


void MainWindow::on_fontsecondary_clicked()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");

    QColor current = f2;
    QColor color2 = colors.getColor(current.name());
    f2 = color2.name();

    if (!color2.isValid()) return;

    ui->fontsecondary->setStyleSheet(COLOR_STYLE.arg(f2, variables.value("DefaultBackgroundColor"), f2));
    ui->font2->setText(f2);
}

void MainWindow::on_fontactive_clicked()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");

    QColor current = f3;
    QColor color3 = colors.getColor(current.name());
    f3 = color3.name();

    if (!color3.isValid()) return;

    ui->fontactive->setStyleSheet(COLOR_STYLE.arg(f3, variables.value("DefaultBackgroundColor"), f3));
    ui->font3->setText(f3);
}

void MainWindow::on_fontdisabled_clicked()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");

    QColor current = f4;
    QColor color4 = colors.getColor(current.name());
    f4 = color4.name();

    if (!color4.isValid()) return;

    ui->fontdisabled->setStyleSheet(COLOR_STYLE.arg(f4, variables.value("DefaultBackgroundColor"), f4));
    ui->font4->setText(f4);
}

void MainWindow::on_fontpainted_clicked()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");

    QColor current = f5;
    QColor color5 = colors.getColor(current.name());
    f5 = color5.name();

    if (!color5.isValid()) return;

    ui->fontpainted->setStyleSheet(COLOR_STYLE.arg(f5, f6, f5));
    ui->font5->setText(f5);
}

void MainWindow::on_fontdisabled_2_clicked()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");

    QColor current = f6;
    QColor color6 = colors.getColor(current.name());
    f6 = color6.name();

    if (!color6.isValid()) return;

    ui->fontdisabled_2->setStyleSheet(COLOR_STYLE.arg(f6, variables.value("DefaultBackgroundColor"), f6));
    ui->font6->setText(f6);
    ui->fontpainted->setStyleSheet(COLOR_STYLE.arg(f5, f6, f5));
}

void MainWindow::on_fontbutton_clicked()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");

    QColor current = f7;
    QColor color7 = colors.getColor(current.name());
    f7 = color7.name();

    if (!color7.isValid()) return;

    ui->fontbutton->setStyleSheet(COLOR_STYLE.arg(f7, variables.value("DefaultBackgroundColor"), f7));
    ui->font7->setText(f7);
}

void MainWindow::on_fontbuttonpressed_clicked()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");

    QColor current = f8;
    QColor color8 = colors.getColor(current.name());
    f8 = color8.name();

    if (!color8.isValid()) return;

    ui->fontbuttonpressed->setStyleSheet(COLOR_STYLE.arg(f8, variables.value("DefaultBackgroundColor"), f8));
    ui->font8->setText(f8);
}

void MainWindow::on_lineEdit_editingFinished()
{
    QString slvalue = ui->lineEdit->text();
    int svalue = slvalue.toInt();
    ui->horizontalSlider->setValue(svalue);
}

void MainWindow::on_lineEdit_2_editingFinished()
{
    QString slvalue = ui->lineEdit_2->text();
    int svalue = slvalue.toInt();
    ui->horizontalSlider_2->setValue(svalue);
}

void MainWindow::on_Snap_editingFinished()
{
    QString slvalue = ui->Snap->text();
    int svalue = slvalue.toInt();
    ui->horizontalSlider_3->setValue(svalue);
}

void MainWindow::on_checkBoxActivate_stateChanged(int )
{
    if ( ui->checkBoxActivate->checkState() == Qt::Checked ) {
        ui->pushButton->setText(tr("Save and reboot"));
    }
    else {
        ui->pushButton->setText(tr("Apply changes"));
    }
}

void MainWindow::on_fontimport_triggered()
{

    QMessageBox msgBox;
    msgBox.setWindowTitle(tr("Theme Customizer - font import"));
    msgBox.setText(tr("Do you want to import fonts from MyDocs?"));
    msgBox.setInformativeText(tr("Note: this function will only import .ttf and .otf fonts from root of MyDocs"));
    msgBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
    msgBox.setDefaultButton(QMessageBox::Yes);
    int ret = msgBox.exec();

    if ( ret == QMessageBox::Yes ) {

        QString varattu2;
        varattu2 = tr("Importing fonts");
        progress2.setWindowModality(Qt::WindowModal);
        progress2.setWindowTitle(varattu2);
        progress2.setCancelButton(0);
        QStringList arguments2;
        arguments2 << "importfontspushed";
        QProcess *process2 = new QProcess(this);
        connect(process2, SIGNAL(finished(int)), this, SLOT(process2Finished(int)));
        process2->start("/sbin/launchcustomizer", arguments2);
        progress2.show();

    }

}

void MainWindow::process2Finished(int)
{
    progress2.cancel();
}

void MainWindow::on_about_triggered()
{
    QMessageBox msgBox;
    msgBox.setWindowTitle(tr("About Theme Customizer"));
    msgBox.setText("Author: D-Iivil - Licence: Freeware & open source");
    msgBox.setTextFormat(Qt::RichText);
    msgBox.setInformativeText("<html><a href=\"https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=ricky%40hevikaraoke%2efi&lc=FI&item_name=Here%27s%20some%20money%20for%20beer%2e&no_note=0&currency_code=EUR&bn=PP%2dDonationsBF%3abtn_donate_SM%2egif%3aNonHostedGuest\">Donate some beer money to author</a></html>");
    msgBox.setStandardButtons(QMessageBox::Ok);
    msgBox.setDefaultButton(QMessageBox::Ok);
    msgBox.exec();
}

void MainWindow::on_font1_editingFinished()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");
    f1 = ui->font1->text();
    ui->fontprimary->setStyleSheet(COLOR_STYLE.arg(f1, variables.value("DefaultBackgroundColor"), f1));

}

void MainWindow::on_font2_editingFinished()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");
    f2 = ui->font2->text();
    ui->fontsecondary->setStyleSheet(COLOR_STYLE.arg(f2, variables.value("DefaultBackgroundColor"), f2));
}

void MainWindow::on_font3_editingFinished()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");
    f3 = ui->font3->text();
    ui->fontactive->setStyleSheet(COLOR_STYLE.arg(f3, variables.value("DefaultBackgroundColor"), f3));
}

void MainWindow::on_font4_editingFinished()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");
    f4 = ui->font4->text();
    ui->fontdisabled->setStyleSheet(COLOR_STYLE.arg(f4, variables.value("DefaultBackgroundColor"), f4));
}

void MainWindow::on_font5_editingFinished()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");
    f5 = ui->font5->text();
    ui->fontpainted->setStyleSheet(COLOR_STYLE.arg(f5, f6, f5));
}

void MainWindow::on_font6_editingFinished()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");
    f6 = ui->font6->text();
    ui->fontdisabled_2->setStyleSheet(COLOR_STYLE.arg(f6, variables.value("DefaultBackgroundColor"), f6));
    ui->fontpainted->setStyleSheet(COLOR_STYLE.arg(f5, f6, f5));
}

void MainWindow::on_font7_editingFinished()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");
    f7 = ui->font7->text();
    ui->fontbutton->setStyleSheet(COLOR_STYLE.arg(f7, variables.value("DefaultBackgroundColor"), f7));
}

void MainWindow::on_font8_editingFinished()
{
    const QString COLOR_STYLE("QPushButton { color : %2; background-color: %3; border: 2px; border-style: solid; border-color: %4; border-radius: 8px; margin: 5px; padding: 5px;}");
    f8 = ui->font8->text();
    ui->fontbuttonpressed->setStyleSheet(COLOR_STYLE.arg(f8, variables.value("DefaultBackgroundColor"), f8));
}
