#include "mainwindow.h"
#include "ui_mainwindow.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow),
    progress("Setting up the theme, please wait...", "Abort", 0, 0, this),
    colors()
{
    ui->setupUi(this);
    ui->scrollArea->setWidget(ui->widget);
    readdirs();
    oldfonts();
    readSettings();
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::oldfonts()
{

    QFile file("/etc/hildon/theme/colors.config");
    file.open(QFile::ReadOnly);
 //   if (!file.open (IO_ReadOnly))
       // didn't work
    QTextStream stream ( &file );
    QString line;
    QHash<QString, QString> variables;
    do {
        line = stream.readLine();
        //Split
        QStringList splittedLine = line.split("=");
        //Maybe add some checks here (splittedLine.count == 2 etc.)
        if (splittedLine.count()==2) {
        variables.insert(splittedLine.at(0), splittedLine.at(1));
    }
    } while (!line.isNull());

    file.close();
//    QString oldfont1 = variables.value("DefaultTextColor");
//    QString oldfont2 = ui->font2->text();
//    QString oldfont3 = ui->font3->text();
//    QString oldfont4 = ui->font4->text();

    fonts.clear();
    fonts.append(variables.value("DefaultTextColor"));
    fonts.append(variables.value("SecondaryTextColor"));
    fonts.append(variables.value("ActiveTextColor"));
    fonts.append(variables.value("DisabledTextColor"));

    const QString COLOR_STYLE("QLabel { color : %2; }");

    ui->font1->setStyleSheet(COLOR_STYLE.arg(variables.value("DefaultTextColor")));
    ui->font1->setText(variables.value("DefaultTextColor"));

    ui->font2->setStyleSheet(COLOR_STYLE.arg(variables.value("SecondaryTextColor")));
    ui->font2->setText(variables.value("SecondaryTextColor"));

    ui->font3->setStyleSheet(COLOR_STYLE.arg(variables.value("ActiveTextColor")));
    ui->font3->setText(variables.value("ActiveTextColor"));

    ui->font4->setStyleSheet(COLOR_STYLE.arg(variables.value("DisabledTextColor")));
    ui->font4->setText(variables.value("DisabledTextColor"));
}

void MainWindow::readdirs()
{
    QDir colors("/usr/share/icons");
    QStringList colorstobox = colors.entryList(QDir::AllDirs | QDir::NoDotAndDotDot, QDir::DirsFirst);
    ui->Iconset->addItems(colorstobox);
}

void MainWindow::writeSettings()
{
    QSettings sett("ThemeCustomizer", "Boxes");
    sett.setValue("icons", ui->Icons->currentIndex());
    sett.setValue("snap", ui->Snap->text());
    sett.setValue("fontsize", ui->FontSize->currentIndex());
    sett.setValue("iconset", ui->Iconset->currentIndex());
    sett.setValue("appsize", ui->lineEdit->text());
    sett.setValue("booksize", ui->lineEdit_2->text());
}

void MainWindow::readSettings()
{
    QSettings sett("ThemeCustomizer", "Boxes");
    int icons = sett.value("icons").toInt();
    int snap = sett.value("snap").toInt();
    int fontsize = sett.value("fontsize").toInt();
    int iconset = sett.value("iconset").toInt();
    int appsize = sett.value("appsize").toInt();
    int booksize = sett.value("booksize").toInt();
    QString appsizestring = sett.value("appsize").toString();
    QString booksizestring = sett.value("booksize").toString();
    QString snapstring = sett.value("snap").toString();
    ui->Icons->setCurrentIndex(icons);
    // ui->Snap->setCurrentIndex(snap);
    ui->FontSize->setCurrentIndex(fontsize);
    ui->Iconset->setCurrentIndex(iconset);

    if ( appsize > 15 ) {
    ui->lineEdit->setText(appsizestring);
    ui->horizontalSlider->setValue(appsize);
    }

    if ( booksize > 25 ) {
    ui->lineEdit_2->setText(booksizestring);
    ui->horizontalSlider_2->setValue(booksize);
    }

    if ( snap > 3 ) {
    ui->Snap->setText(snapstring);
    ui->horizontalSlider_3->setValue(snap);
    }
}

void MainWindow::on_pushButton_clicked()
{
        QString checkboxstate;
        if ( ui->checkBoxActivate->checkState() == Qt::Checked ) {
            checkboxstate = "Reboot";
        }
        else {
            checkboxstate = "0";
        }
        writeSettings();
        QString varattu;
        varattu = "Theme Customizer";
        progress.setWindowModality(Qt::WindowModal);
        progress.setWindowTitle(varattu);
        progress.setCancelButton(0);
        QStringList arguments;
        arguments << ui->FontSize->currentText() << ui->Fonter->currentText() << ui->Iconset->currentText() << ui->Icons->currentText() << ui->lineEdit->text() << ui->Snap->text() << checkboxstate << fonts << ui->font1->text() << ui->font2->text() << ui->font3->text() << ui->font4->text() << ui->lineEdit_2->text() ;
        QProcess *process = new QProcess(this);
        connect(process, SIGNAL(finished(int)), this, SLOT(processFinished(int)));
        process->start("/sbin/launchcustomizer", arguments);
        progress.show();


}

void MainWindow::processFinished(int)
{

    if ( ui->checkBoxActivate->checkState() == Qt::Unchecked ) {

        QProcess *process2 = new QProcess(this);
        process2->start("/usr/sbin/dsmetool -k /usr/bin/hildon-home");

        sleep(3);

        QProcess *process5 = new QProcess(this);
        process5->start("/usr/sbin/dsmetool -t /usr/bin/hildon-home");

        sleep(15);

        QProcess *process4 = new QProcess(this);
        process4->start("killall hildon-desktop");

        sleep(10);

        QProcess *process6 = new QProcess(this);
        process6->start("killall hildon-status-menu");

        sleep(10);

        QProcess *process8 = new QProcess(this);
        process8->start("/usr/bin/run-standalone.sh dbus-send --print-reply --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteDialog string:\"All done! Restarting device is recommended to reload all new values.\" uint32:0 string:'NAO OK!'");

        sleep(5);

        QProcess *process7 = new QProcess(this);
        process7->start("killall theme-customizer");
    }

    progress.cancel();
    oldfonts();
//        writeSettings();
}

void MainWindow::on_horizontalSlider_valueChanged(int value)
{
    QString slaideri = QString::number(value);
    ui->lineEdit->setText(slaideri);
}

void MainWindow::on_horizontalSlider_2_valueChanged(int value)
{
    QString slaideri2 = QString::number(value);
    ui->lineEdit_2->setText(slaideri2);
}

void MainWindow::on_horizontalSlider_3_valueChanged(int value)
{
    QString slaideri3 = QString::number(value);
    ui->Snap->setText(slaideri3);
}

void MainWindow::on_fontprimary_clicked()
{
    const QString COLOR_STYLE("QLabel { color : %2; }");

    QColor current = ui->font1->text();
    QColor color1 = colors.getColor(current.name());
    QString clr1 = color1.name();

    if (!color1.isValid()) return;

    ui->font1->setStyleSheet(COLOR_STYLE.arg(color1.name()));
    ui->font1->setText(clr1);
}


void MainWindow::on_fontsecondary_clicked()
{
    const QString COLOR_STYLE("QLabel { color : %2; }");

    QColor current = ui->font2->text();
    QColor color2 = colors.getColor(current.name());
    QString clr2 = color2.name();

    if (!color2.isValid()) return;

    ui->font2->setStyleSheet(COLOR_STYLE.arg(color2.name()));
    ui->font2->setText(clr2);
}

void MainWindow::on_fontactive_clicked()
{
    const QString COLOR_STYLE("QLabel { color : %2; }");

    QColor current = ui->font3->text();
    QColor color3 = colors.getColor(current.name());
    QString clr3 = color3.name();

    if (!color3.isValid()) return;

    ui->font3->setStyleSheet(COLOR_STYLE.arg(color3.name()));
    ui->font3->setText(clr3);
}

void MainWindow::on_fontdisabled_clicked()
{
    const QString COLOR_STYLE("QLabel { color : %2; }");

    QColor current = ui->font4->text();
    QColor color4 = colors.getColor(current.name());
    QString clr4 = color4.name();

    if (!color4.isValid()) return;

    ui->font4->setStyleSheet(COLOR_STYLE.arg(color4.name()));
    ui->font4->setText(clr4);
}

void MainWindow::on_lineEdit_editingFinished()
{
    QString slvalue = ui->lineEdit->text();
    int svalue = slvalue.toInt();
    ui->horizontalSlider->setValue(svalue);
}

void MainWindow::on_lineEdit_2_editingFinished()
{
    QString slvalue = ui->lineEdit_2->text();
    int svalue = slvalue.toInt();
    ui->horizontalSlider_2->setValue(svalue);
}

void MainWindow::on_Snap_editingFinished()
{
    QString slvalue = ui->Snap->text();
    int svalue = slvalue.toInt();
    ui->horizontalSlider_3->setValue(svalue);
}

void MainWindow::on_checkBoxActivate_stateChanged(int )
{
    if ( ui->checkBoxActivate->checkState() == Qt::Checked ) {
        ui->pushButton->setText("Save and reboot");
    }
    else {
        ui->pushButton->setText("Apply changes");
    }
}
