#ifndef MANAGECOMMAND_H
#define MANAGECOMMAND_H

#include <QSqlRecord>
#include <QList>
#include "qobject.h"
#include "Command.h"

class managecommand : public QObject
{
    Q_OBJECT
public:
    managecommand();
    void analyse(Command*);
public slots:
    void    recvFromServer(unsigned char *data, int len);
    void    retDB(QList<QSqlRecord>, int);
signals:
    void clearOutBuffer(int);
    void sendQuery(QString, int);
private:
    bool isConnect;
    std::string username;
    std::map<int, void (managecommand::*)(Command *) > TabCmdHead;
    std::map<int, void (managecommand::*)(QList<QSqlRecord>, int) > TabRet;
    std::map<int, void (managecommand::*)(Command *) > TabCmdIdSys;
    std::map<int, void (managecommand::*)(Command *) > TabCmdIdBookmark;

    void ActionCommand(Command*);
    void ActionHeaderNote(Command*);
    void ActionHeaderFile(Command*);
    void ActionHeaderContact(Command*);
    void ActionHeaderBookmark(Command*);
    void ActionHeaderAgenda(Command*);
    void ActionHeaderWeather(Command*);
    void ActionHeaderSetting(Command*);
    void ActionHeaderEvent(Command*);
    void ActionHeaderSys(Command*);

    // id sys
    void SysAskConnection(Command *);
//id book
    void BMAskBookmark();
};

#endif // MANAGECOMMAND_H
