#include "connection.h"
#include "manage.h"

Manage::Manage() : QObject()
{
    std::cout << "MANAGE CREATED" << std::endl;
    this->dataBase = QSqlDatabase::addDatabase("QSQLITE");
    this->isConnect = false;
    this->isSynching = false;

    // HEADER COMMAND
    this->TabCmdHead[HEADERNOTE] = &Manage::ActionHeaderNote;
    this->TabCmdHead[HEADERFILE] = &Manage::ActionHeaderFile;
    this->TabCmdHead[HEADERCONTACT] = &Manage::ActionHeaderContact;
    this->TabCmdHead[HEADERBOOKMARK] = &Manage::ActionHeaderBookmark;
    this->TabCmdHead[HEADERAGENDA] = &Manage::ActionHeaderAgenda;
    this->TabCmdHead[HEADERWEATHER] = &Manage::ActionHeaderWeather;
    this->TabCmdHead[HEADERSETTING] = &Manage::ActionHeaderSetting;
    this->TabCmdHead[HEADEREVENT] = &Manage::ActionHeaderEvent;
    this->TabCmdHead[HEADERSYS] = &Manage::ActionHeaderSys;

    // ID COMMAND SYSTEM
    this->TabCmdIdSys[ANSWERCONNECTION] = &Manage::SysAskConnection;
    this->TabCmdIdSys[ENDSYNC] = &Manage::EndSync;
    // BOOKMARKS
    this->TabCmdIdBookmark[ANSWERASKBOOKMARK] = &Manage::SyncBookMark;
    this->TabCmdIdBookmark[ENDBOOKMARK] = &Manage::SyncEndBookMark;
    // NOTES
    this->TabCmdIdNote[ANSWERASKNOTE] = &Manage::SyncNote;
    this->TabCmdIdNote[ENDNOTE] = &Manage::SyncEndNote;
    // CONTACT
    this->TabCmdIdContact[ANSWERASKCONTACT] = &Manage::SyncContact;
    this->TabCmdIdContact[ENDCONTACT] = &Manage::SyncEndContact;
    // AGENDA
    this->TabCmdIdAgenda[ANSWERASKAGENDA] = &Manage::SyncAgenda;
    this->TabCmdIdAgenda[ENDAGENDA] = &Manage::SyncEndAgenda;
    // WEATHER
    this->TabCmdIdWeather[ANSWERASKWEATHERLOC] = &Manage::SyncWeather;
    this->TabCmdIdWeather[ENDWEATHERLOC] = &Manage::SyncEndWeather;
    // SETTING
    this->TabCmdIdSetting[ANSWERSETTING] = &Manage::SyncSetting;
    this->TabCmdIdSetting[ENDSETTING] = &Manage::SyncEndSetting;
    // EVENT
    this->TabCmdIdEvent[ANSWEREVENT] = &Manage::SyncEvent;
    this->TabCmdIdEvent[ENDEVENT] = &Manage::SyncEndEvent;
    // OPENING AND INITIALIZING LOCAL DB
    this->openDatabase("tepee");
    if (!this->checkExistLocalDatabase())
        this->createLocalDatabase();
}

Manage::~Manage()
{
    if (this->dataBase.open())
        this->dataBase.close();
    this->dataBase.removeDatabase(this->dataBase.connectionName());
}

void    Manage::lostServerConnection()
{
    std::cout << "MANAGER REACTING TO LOST CONNECTION" << std::endl;
    if (this->isSynching)
        this->EndSync(NULL);
    this->isConnect = false;
}

void    Manage::recvFromServer(unsigned char *data, int len)
{
    // BUILD inCMD FROM RECEIVED DATA
    std::cout << "RECEIVE DATA" << std::endl;
    int     total = 0;
    int     tmp   = 0;
    while (len > 0)
    {
        Command     *cmd = new Command();
        tmp = cmd->parseCmd(data, len);
        if (cmd->isCommandValid())
        {
            data  += tmp;
            total += tmp;
            len   -= tmp;
            this->ActionCommand(cmd);
        }
        else
            break;
    }
    data -= total;
    delete []data;
    emit (clearOutBuffer(total));
}



bool Manage::openDatabase(QString dbname)
{
    std::cout << dbname.toStdString() << std::endl;
    this->localDBName = dbname;
    this->dataBase.setHostName("localhost");

#ifdef Q_OS_LINUX
    // NOTE: We have to store database file into user home folder in Linux
    QString path(QDir::home().path());
    path.append(QDir::separator()).append(this->localDBName);
    path = QDir::toNativeSeparators(path);
    this->dataBase.setDatabaseName(path);
#else
    this->dataBase.setDatabaseName(this->localDBName);
#endif
    return (this->dataBase.open());
}

bool Manage::checkExistLocalDatabase()
{
    if (dataBase.open())
    {
        QSqlQuery qry;
        qry.prepare( "SELECT * FROM exist" );
        return (qry.exec());
    }
    return (false);
}

void Manage::createLocalDatabase()
{
    if (dataBase.open())
    {
        QSqlQuery query(this->dataBase);
        if (query.prepare("CREATE TABLE IF NOT EXISTS exist (id INTEGER UNIQUE PRIMARY KEY)"))

            if (query.exec())
            {
                if(query.prepare("CREATE TABLE IF NOT EXISTS `bookmark` (`id` text NOT NULL PRIMARY KEY  , `lastup` text NOT NULL, `title` text NOT NULL,  `adress` text NOT NULL, `status` INTERGER)"))
                    query.exec();
                if (query.prepare("CREATE TABLE IF NOT EXISTS `settings` ( `id` INTEGER  PRIMARY KEY AUTOINCREMENT,`username` text NOT NULL, `password` text NOT NULL, `adress` text NOT NULL, `port` text NOT NULL, `background` text NOT NULL, `styleColor` text NOT NULL, `styleOpacity` REAL)"))
                    query.exec();
                if (query.prepare("CREATE TABLE IF NOT EXISTS `note` ( `id`  text NOT NULL PRIMARY KEY  ,  `lastup` text NOT NULL,`title` text NOT NULL, `content` text NOT NULL, `status` INTEGER)"))
                    query.exec();
                if (query.prepare("CREATE TABLE IF NOT EXISTS `contact` ( `id`  text NOT NULL PRIMARY KEY  ,  `lastup` text NOT NULL,`firstname` text NOT NULL, `lastname` text NOT NULL, `email` text NOT NULL , `adress`text NOT NULL, `cellphone` text NOT NULL, `homephone` text NOT NULL, `imgsrc` text, `birthday` text NOT NULL, `status` INTEGER, `friend` INTEGER, `usernamecontact`)"))
                    query.exec();
                if (query.prepare("CREATE TABLE IF NOT EXISTS `weather` ( `id`  INTEGER  PRIMARY KEY AUTOINCREMENT, `numday` INTEGER, `nummonth` INTEGER, `numyear` INTEGER , `nameday` text NOT NULL, `namemonth` text NOT NULL, `highttemp` INTEGER, `lowtemp` INTEGER, `conditions` text NOT NULL, `country` text NOT NULL, `city` text NOT NULL)"))
                    query.exec();
                if (query.prepare("CREATE TABLE IF NOT EXISTS `locationweather` ( `id` text NOT NULL PRIMARY KEY  ,  `lastup` text NOT NULL, `country` text NOT NULL, `city` text NOT NULL, `status` INTEGER)"))
                    query.exec();
                if (query.prepare("CREATE TABLE IF NOT EXISTS `agenda` (`id`  text NOT NULL PRIMARY KEY  ,  `lastup` text NOT NULL, `taskName` text NOT NULL, `taskComment` text NOT NULL,  `taskStartDate` text NOT NULL, taskEndDate text NOT NULL, `status` INTEGER)"))
                    query.exec();
                if (query.prepare("CREATE TABLE IF NOT EXISTS `infouser` (`id` text NOT NULL PRIMARY KEY, `lastup` text NOT NULL, `lastname` text NOT NULL, `firstname` text NOT NULL, `mail` text, `birthday` text, `homephone` text,`cellphone` text, `adress` text, `visibility` INTEGER, `status` INTEGER)"))
                    query.exec();
                if (query.prepare("CREATE TABLE IF NOT EXISTS `events` (`id` text NOT NULL PRIMARY KEY, `lastup` text NOT NULL, `country` text NOT NULL, `city` text NOT NULL, `description` text NOT NULL, `title` text NOT NULL, `date` text NOT NULL, `hour` text NOT NULL, `createFName` text NOT NULL, `createLName` text NOT NULL, `contactList` text NOT NULL, `status` INTEGER)"))
                    query.exec();
                else
                    std::cout << "fails create " << std::endl;
            }
    }
}

QList<QSqlRecord> Manage::execQuery(QString query)
{
    QList<QSqlRecord> results;
    if (this->dataBase.open())
    {
        std::cout << "DATABASE EXEC RECV " << query.toStdString() << std::endl;
        QSqlQuery Q(query, this->dataBase);
        results.push_back(Q.record());
        while (Q.next())
            results.push_back(Q.record());
    }
    return results;
}

void Manage::execQuery(QString query, int type)
{
    if (this->dataBase.open())
    {
        std::cout << "DATABASE EXEC RECV " << query.toStdString() << std::endl;
        QSqlQuery Q(query, this->dataBase);
        QList<QSqlRecord> results;
        results.push_back(Q.record());
        while (Q.next())
            results.push_back(Q.record());
        emit (queryRet(results, type));
    }
}

void Manage::ActionCommand(Command*c)
{
    std::cout << "ACTIONCOMMAND" << std::endl;
    int idH = c->getIdHeader();
    std::cout << "HEADER = " <<  idH << std::endl;
    std::cout << "CMD = " << c->getIdCmd() << std::endl;
    if (this->TabCmdHead.find(idH) != this->TabCmdHead.end())
        (this->*this->TabCmdHead[idH])((Command*)(c));
}

void Manage::ActionHeaderNote(Command*c)
{
    if (this->TabCmdIdNote.find(c->getIdCmd()) != this->TabCmdIdNote.end())
        (this->*this->TabCmdIdNote[c->getIdCmd()])(c);
}

void Manage::ActionHeaderFile(Command*c)
{
    (void)c;
}

void Manage::ActionHeaderContact(Command*c)
{
    if (this->TabCmdIdContact.find(c->getIdCmd()) != this->TabCmdIdContact.end())
        (this->*this->TabCmdIdContact[c->getIdCmd()])(c);
}

void Manage::ActionHeaderBookmark(Command*c)
{
    if (this->TabCmdIdBookmark.find(c->getIdCmd()) != this->TabCmdIdBookmark.end())
        (this->*this->TabCmdIdBookmark[c->getIdCmd()])(c);
}

void Manage::ActionHeaderAgenda(Command*c)
{
    if (this->TabCmdIdAgenda.find(c->getIdCmd()) != this->TabCmdIdAgenda.end())
        (this->*this->TabCmdIdAgenda[c->getIdCmd()])(c);
}
void Manage::ActionHeaderWeather(Command*c)
{
    if (this->TabCmdIdWeather.find(c->getIdCmd()) != this->TabCmdIdWeather.end())
        (this->*this->TabCmdIdWeather[c->getIdCmd()])(c);
}
void Manage::ActionHeaderSetting(Command*c)
{
    if (this->TabCmdIdSetting.find(c->getIdCmd()) != this->TabCmdIdSetting.end())
        (this->*this->TabCmdIdSetting[c->getIdCmd()])(c);
}
void Manage::ActionHeaderEvent(Command*c)
{
    std::cout << "RECEIVED  EVENT +++++++++++++++++++++++++++++" << std::endl;
    if (this->TabCmdIdEvent.find(c->getIdCmd()) != this->TabCmdIdEvent.end())
        (this->*this->TabCmdIdEvent[c->getIdCmd()])(c);
}

//SYS

void Manage::ActionHeaderSys(Command*c)
{
    if (this->TabCmdIdSys.find(c->getIdCmd()) != this->TabCmdIdSys.end())
        (this->*this->TabCmdIdSys[c->getIdCmd()])(c);
}

void Manage::AuthOnServer(QString user, QString pass)
{
//    std::cout << "MANAGE AUTH ON SERV" << std::endl;
    if (!this->isConnect)
    {
        Command *C = new Command;
        sys *s = new sys;

        C->setIdHeader(HEADERSYS);
        memset(s, 0, sizeof(sys));
        s->idCmd = ASKCONNECTION;

        memset(s->username, 0, sizeof(s->username));
        memset(s->password, 0, sizeof(s->password));
        memcpy(s->username, user.toStdString().c_str(), user.size());
        memcpy(s->password, pass.toStdString().c_str(), pass.size());

        C->sy = s;
        C->setSize(sizeof(command) + sizeof(sys));
        emit(sendData(C->ConvertToAnswer(), C->getSize()));
//        std::cout << "SENDING AUTH DATA ON SERV" << std::endl;
    }
    else
        this->StartSync();
}

void Manage::SysAskConnection(Command *c)
{
    if (!this->isConnect)
    {
        if (c->sy->Connect)
        {
            this->isConnect = true;
            this->username = c->sy->username;
//            std::cout << "AUTH OK"<< std::endl;
        }
        else
            std::cout << "AUTH FAIL" << std::endl;
    }
    if (this->isConnect)
        this->StartSync();
}

void    Manage::StartSync()
{
    if (!this->isSynching)
    {
        this->isSynching = true;
        Command *C = new Command;
        C->sy = new sys;
        C->setIdHeader(HEADERSYS);
        C->sy->idCmd = ASKSYNC;
        C->setSize(sizeof(command) + sizeof(sys));
        std::cout << "SENDING SYNC REQUEST ------------" << std::endl;
        emit(sendData(C->ConvertToAnswer(), C->getSize()));
        emit(synchingProgress(QVariant(SYNC_START)));
    }
}

void    Manage::EndSync(Command *)
{
    std::cout << "----------------------ENDING SYNC-------------------------" << std::endl;
    this->isSynching = false;
    emit(synchingProgress(QVariant(SYNC_END)));
}

void    Manage::SyncBookMark(Command *C)
{
    if (!this->isSynching)
        return ;
    QString query = "SELECT * FROM bookmark";
    QList<QSqlRecord> Books = this->execQuery(query);
    QList<QSqlRecord>::iterator it = Books.begin();
    ++it;
    bool found = false;
    while (it != Books.end())
    {
        if ((*it).value("id").toString().compare(QString(C->b->idTime)) == 0)
        {
            found = true;
            break;
        }
        ++it;
    }
    if (found)
    {
        QDateTime local = QDateTime::fromString((*it).value("lastup").toString(), "dd.MM.yyyy.hh.mm.ss.zzz");
        QDateTime server = QDateTime::fromString(QString(C->b->lastup), "dd.MM.yyyy.hh.mm.ss.zzz");
        if (server > local)
        {
            if (C->b->status == DEL)
                query = "DELETE FROM bookmark WHERE id = '" + (*it).value("id").toString() + "'";
            else
                query = "UPDATE bookmark SET lastup = '" + QString(C->b->lastup) + "', title = '" + QString(C->b->title) + "', adress = '" + QString(C->b->adress) + "', status = " + QString::number(VALID) + " WHERE id = '" + (*it).value("id").toString() + "'";
            this->execQuery(query);
        }
        else if (server < local)
        {
            Command *C1 = new Command;
            C1->b = new bookmark;
            C1->setIdHeader(HEADERBOOKMARK);
            C1->setSize(sizeof(command) + sizeof(bookmark));
            memset(C1->b, 0, sizeof(bookmark));
            memset(C1->b->title, 0, sizeof(C1->b->title));
            memset(C1->b->adress, 0, sizeof(C1->b->adress));
            memset(C1->b->idTime, 0, sizeof(C1->b->idTime));
            memset(C1->b->lastup, 0, sizeof(C1->b->lastup));
            memcpy(C1->b->title, (*it).value("title").toString().toStdString().c_str(), (*it).value("title").toString().size());
            memcpy(C1->b->adress, (*it).value("adress").toString().toStdString().c_str(), (*it).value("adress").toString().size());
            memcpy(C1->b->idTime, (*it).value("id").toString().toStdString().c_str(), (*it).value("id").toString().size());
            memcpy(C1->b->lastup, (*it).value("lastup").toString().toStdString().c_str(), (*it).value("lastup").toString().size());
            if ((*it).value("status").toInt() == DEL)
            {
                query = "DELETE FROM bookmark WHERE id = '" + (*it).value("id").toString() + "'";
                C1->b->idCmd = DELBOOKMARK;
            }
            else
            {
                query = "UPDATE bookmark SET status = " + QString::number(VALID) + " WHERE id = '" + (*it).value("id").toString() + "'";
                C1->b->idCmd = UPDATEBOOKMARK;
            }
            emit(sendData(C1->ConvertToAnswer(), C1->getSize()));
            this->execQuery(query);
        }
    }
    else
        if (C->b->status != DEL)
        {
            query = "INSERT INTO bookmark (id, lastup, title, adress, status) VALUES ('" + QString(C->b->idTime) + "','" + QString(C->b->lastup) + "','" + QString(C->b->title) + "', '" + QString(C->b->adress) + "', " + QString::number(VALID) + ");";
            this->execQuery(query);
        }
}


void    Manage::SyncEndBookMark(Command *C)
{
    if (!this->isSynching)
        return ;
    QString query = "SELECT * FROM bookmark WHERE status = " + QString::number(MODIF);
    QList<QSqlRecord> Books = this->execQuery(query);
    QList<QSqlRecord>::iterator it = Books.begin();
    ++it;
    while (it != Books.end())
    {
        Command *C = new Command;
        C->b = new bookmark;
        C->setIdHeader(HEADERBOOKMARK);
        memset(C->b, 0, sizeof(bookmark));
        memset(C->b->title, 0, sizeof(C->b->title));
        memset(C->b->adress, 0, sizeof(C->b->adress));
        memset(C->b->idTime, 0, sizeof(C->b->idTime));
        memset(C->b->lastup, 0, sizeof(C->b->lastup));
        C->b->idCmd = ADDBOOKMARK;
        C->setSize(sizeof(command) + sizeof(bookmark));
        memcpy(C->b->title, (*it).value("title").toString().toStdString().c_str(), (*it).value("title").toString().size());
        memcpy(C->b->adress, (*it).value("adress").toString().toStdString().c_str(), (*it).value("adress").toString().size());
        memcpy(C->b->idTime, (*it).value("id").toString().toStdString().c_str(), (*it).value("id").toString().size());
        memcpy(C->b->lastup, (*it).value("lastup").toString().toStdString().c_str(), (*it).value("lastup").toString().size());
        emit(sendData(C->ConvertToAnswer(), C->getSize()));
        ++it;
    }
    query = "UPDATE bookmark SET status = " + QString::number(VALID) + " WHERE status = " + QString::number(MODIF);
    this->execQuery(query);
    query = "SELECT * FROM bookmark";
    this->execQuery(query, FILLBM);
    emit(synchingProgress(QVariant(SYNC_BM)));

}

void    Manage::SyncNote(Command *C)
{
    if (!this->isSynching)
        return ;
    QString query = "SELECT * FROM note";
    QList<QSqlRecord> Books = this->execQuery(query);
    QList<QSqlRecord>::iterator it = Books.begin();
    ++it;
    bool found = false;
    while (it != Books.end())
    {
        if ((*it).value("id").toString().compare(QString(C->n->idTime)) == 0)
        {
            found = true;
            break;
        }
        ++it;
    }
    if (found)
    {
        QDateTime local = QDateTime::fromString((*it).value("lastup").toString(), "dd.MM.yyyy.hh.mm.ss.zzz");
        QDateTime server = QDateTime::fromString(QString(C->n->lastup), "dd.MM.yyyy.hh.mm.ss.zzz");
        if (server > local)
        {
            if (C->n->status == DEL)
                query = "DELETE FROM note WHERE id = '" + (*it).value("id").toString() + "'";
            else
                query = "UPDATE note SET lastup = '" + QString(C->n->lastup) + "', title = '" + QString(C->n->title) + "', content = '" + QString(C->n->content) + "', status = " + QString::number(VALID) + " WHERE id = '" + (*it).value("id").toString() + "'";
            this->execQuery(query);
        }
        else if (server < local)
        {
            Command *C1 = new Command;
            C1->n = new note;
            C1->setIdHeader(HEADERNOTE);
            C1->setSize(sizeof(command) + sizeof(note));
            memset(C1->n, 0, sizeof(note));
            memset(C1->n->title, 0, sizeof(C1->n->title));
            memset(C1->n->content, 0, sizeof(C1->n->content));
            memset(C1->n->idTime, 0, sizeof(C1->n->idTime));
            memset(C1->n->lastup, 0, sizeof(C1->n->lastup));
            memcpy(C1->n->title, (*it).value("title").toString().toStdString().c_str(), (*it).value("title").toString().size());
            memcpy(C1->n->content, (*it).value("content").toString().toStdString().c_str(), (*it).value("content").toString().size());
            memcpy(C1->n->idTime, (*it).value("id").toString().toStdString().c_str(), (*it).value("id").toString().size());
            memcpy(C1->n->lastup, (*it).value("lastup").toString().toStdString().c_str(), (*it).value("lastup").toString().size());
            if ((*it).value("status").toInt() == DEL)
            {
                query = "DELETE FROM note WHERE id = '" + (*it).value("id").toString() + "'";
                C1->n->idCmd = DELNOTE;
            }
            else
            {
                query = "UPDATE note SET status = " + QString::number(VALID) + " WHERE id = '" + (*it).value("id").toString() + "'";
                C1->n->idCmd = UPDATENOTE;
            }
            emit(sendData(C1->ConvertToAnswer(), C1->getSize()));
            this->execQuery(query);
        }
    }
    else
        if (C->n->status != DEL)
        {
            query = "INSERT INTO note (id, lastup, title, content, status) VALUES ('" + QString(C->n->idTime) + "','" + QString(C->n->lastup) + "','" + QString(C->n->title) + "', '" + QString(C->n->content) + "', " + QString::number(VALID) + ");";
            this->execQuery(query);
        }
}

void    Manage::SyncEndNote(Command *)
{
    if (!this->isSynching)
        return ;
    QString query = "SELECT * FROM note WHERE status = " + QString::number(MODIF);
    QList<QSqlRecord> Books = this->execQuery(query);
    QList<QSqlRecord>::iterator it = Books.begin();
    ++it;
    while (it != Books.end())
    {
        Command *C = new Command;
        C->n = new note;
        C->setIdHeader(HEADERNOTE);
        memset(C->n, 0, sizeof(note));
        memset(C->n->title, 0, sizeof(C->n->title));
        memset(C->n->content, 0, sizeof(C->n->content));
        memset(C->n->idTime, 0, sizeof(C->n->idTime));
        memset(C->n->lastup, 0, sizeof(C->n->lastup));
        C->n->idCmd = ADDNOTE;
        C->setSize(sizeof(command) + sizeof(note));
        memcpy(C->n->title, (*it).value("title").toString().toStdString().c_str(), (*it).value("title").toString().size());
        memcpy(C->n->content, (*it).value("content").toString().toStdString().c_str(), (*it).value("content").toString().size());
        memcpy(C->n->idTime, (*it).value("id").toString().toStdString().c_str(), (*it).value("id").toString().size());
        memcpy(C->n->lastup, (*it).value("lastup").toString().toStdString().c_str(), (*it).value("lastup").toString().size());
        emit(sendData(C->ConvertToAnswer(), C->getSize()));
        ++it;
    }
    query = "UPDATE note SET status = " + QString::number(VALID) + " WHERE status = " + QString::number(MODIF);
    this->execQuery(query);
    query = "SELECT * FROM note";
    this->execQuery(query, FILLNOTE);
    emit(synchingProgress(QVariant(SYNC_NOTE)));

}

void    Manage::SyncContact(Command *C)
{
    if (!this->isSynching)
        return ;
    QString query = "SELECT * FROM contact";
    QList<QSqlRecord> Books = this->execQuery(query);
    QList<QSqlRecord>::iterator it = Books.begin();
    ++it;
    bool found = false;
    while (it != Books.end())
    {
        if ((*it).value("id").toString().compare(QString(C->c->idTime)) == 0)
        {
            found = true;
            break;
        }
        ++it;
    }
    if (found)
    {
        QDateTime local = QDateTime::fromString((*it).value("lastup").toString(), "dd.MM.yyyy.hh.mm.ss.zzz");
        QDateTime server = QDateTime::fromString(QString(C->c->lastup), "dd.MM.yyyy.hh.mm.ss.zzz");
        if (server > local)
        {
//            std::cout << "CHECKING CONTACT FROM SERVER" << std::endl;
            if (C->c->status == DEL)
                query = "DELETE FROM contact WHERE id = '" + (*it).value("id").toString() + "'";
            else
                query = "UPDATE contact SET lastup = '" + QString(C->c->lastup) + "', firstname = '" + QString(C->c->firstname) + "', lastname = '" + QString(C->c->lastname) + "', email = '" + QString(C->c->email) + "', adress = '" + QString(C->c->address) + "', homephone = '" + QString(C->c->homephone) + "', cellphone = '" + QString(C->c->cellphone) + "', imgsrc = '" + (*it).value("imgsrc").toString() + "', birthday = '" + QString(C->c->birthday) + "', status = " + QString::number(VALID) + " WHERE id = '" + (*it).value("id").toString() + "'";
            this->execQuery(query);
        }
        else if (server < local)
        {
            Command *C1 = new Command;
            C1->c = new contact;
            C1->setIdHeader(HEADERCONTACT);
            C1->setSize(sizeof(command) + sizeof(contact));
            memset(C1->c, 0, sizeof(contact));
            memset(C1->c->firstname, 0, sizeof(C1->c->firstname));
            memset(C1->c->lastname, 0, sizeof(C1->c->lastname));
            memset(C1->c->email, 0, sizeof(C1->c->lastname));
            memset(C1->c->address, 0, sizeof(C1->c->address));
            memset(C1->c->homephone, 0, sizeof(C1->c->homephone));
            memset(C1->c->cellphone, 0, sizeof(C1->c->cellphone));
            memset(C1->c->birthday, 0, sizeof(C1->c->birthday));
            memset(C1->c->usernamecontact, 0, sizeof(C1->c->usernamecontact));
            memset(C1->c->idTime, 0, sizeof(C1->c->idTime));
            memset(C1->c->lastup, 0, sizeof(C1->c->lastup));

            memcpy(C1->c->firstname, (*it).value("firstname").toString().toStdString().c_str(), (*it).value("firstname").toString().size());
            memcpy(C1->c->lastname, (*it).value("lastname").toString().toStdString().c_str(), (*it).value("lastname").toString().size());
            memcpy(C1->c->email, (*it).value("email").toString().toStdString().c_str(), (*it).value("email").toString().size());
            memcpy(C1->c->address, (*it).value("adress").toString().toStdString().c_str(), (*it).value("adress").toString().size());
            memcpy(C1->c->homephone, (*it).value("homephone").toString().toStdString().c_str(), (*it).value("homephone").toString().size());
            memcpy(C1->c->cellphone, (*it).value("cellphone").toString().toStdString().c_str(), (*it).value("cellphone").toString().size());
            memcpy(C1->c->idTime, (*it).value("id").toString().toStdString().c_str(), (*it).value("id").toString().size());
            memcpy(C1->c->lastup, (*it).value("lastup").toString().toStdString().c_str(), (*it).value("lastup").toString().size());
            memcpy(C1->c->birthday, (*it).value("birthday").toString().toStdString().c_str(), (*it).value("birthday").toString().size());
            C1->c->isfriend = (*it).value("friend").toInt();
            memcpy(C1->c->usernamecontact, (*it).value("usernamecontact").toString().toStdString().c_str(), (*it).value("usernamecontact").toString().size());

            if ((*it).value("status").toInt() == DEL)
            {
//                std::cout << "DEL DU CONTACT LOCAL  " << std::endl;
                query = "DELETE FROM contact WHERE id = '" + (*it).value("id").toString() + "'";
                C1->c->idCmd = DELCONTACT;
            }
            else
            {
//                std::cout << "UPDATE DU CONTACT SUR SERVER" << std::endl;
                query = "UPDATE contact SET status = " + QString::number(VALID) + " WHERE id = '" + (*it).value("id").toString() + "'";
                C1->c->idCmd = UPDATECONTACT;
            }
            emit(sendData(C1->ConvertToAnswer(), C1->getSize()));
            this->execQuery(query);
        }
    }
    else
        if (C->c->status != DEL)
        {
            query = "INSERT INTO contact (firstname, lastname, email, adress, homephone, cellphone, birthday, id, lastup, status, friend, usernamecontact) VALUES ( '" + QString(C->c->firstname) + "','" + QString(C->c->lastname) + "','" + QString(C->c->email) + "','" + QString(C->c->address)+ "','" + QString(C->c->homephone) + "','" + QString(C->c->cellphone)+ "','" + QString(C->c->birthday)+ "','" + QString(C->c->idTime) + "','" + QString(C->c->lastup) + "', " + QString::number(VALID) + "," + QString::number(C->c->isfriend) + ", '" +  QString(C->c->usernamecontact)  + "')";
            this->execQuery(query);
        }
}

void    Manage::SyncEndContact(Command *)
{
    if (!this->isSynching)
        return ;
    QString query = "SELECT * FROM contact WHERE status = " + QString::number(MODIF);
    QList<QSqlRecord> Books = this->execQuery(query);
    QList<QSqlRecord>::iterator it = Books.begin();
    ++it;
//    std::cout << "SENDING NEW CONTACT TO SERVER" << std::endl;
    while (it != Books.end())
    {
        Command *C1 = new Command;
        C1->c = new contact;
        C1->setIdHeader(HEADERCONTACT);
        C1->setSize(sizeof(command) + sizeof(contact));
        memset(C1->c, 0, sizeof(contact));
        memset(C1->c->firstname, 0, sizeof(C1->c->firstname));
        memset(C1->c->lastname, 0, sizeof(C1->c->lastname));
        memset(C1->c->email, 0, sizeof(C1->c->lastname));
        memset(C1->c->address, 0, sizeof(C1->c->address));
        memset(C1->c->homephone, 0, sizeof(C1->c->homephone));
        memset(C1->c->cellphone, 0, sizeof(C1->c->cellphone));
        memset(C1->c->birthday, 0, sizeof(C1->c->birthday));
        memset(C1->c->idTime, 0, sizeof(C1->c->idTime));
        memset(C1->c->lastup, 0, sizeof(C1->c->lastup));
          memset(C1->c->usernamecontact, 0, sizeof(C1->c->usernamecontact));
        C1->c->idCmd = ADDCONTACT;
        C1->c->isfriend =  (*it).value("friend").toInt();
        memcpy(C1->c->firstname, (*it).value("firstname").toString().toStdString().c_str(), (*it).value("firstname").toString().size());
        memcpy(C1->c->lastname, (*it).value("lastname").toString().toStdString().c_str(), (*it).value("lastname").toString().size());
        memcpy(C1->c->email, (*it).value("email").toString().toStdString().c_str(), (*it).value("email").toString().size());
        memcpy(C1->c->address, (*it).value("adress").toString().toStdString().c_str(), (*it).value("adress").toString().size());
        memcpy(C1->c->homephone, (*it).value("homephone").toString().toStdString().c_str(), (*it).value("homephone").toString().size());
        memcpy(C1->c->cellphone, (*it).value("cellphone").toString().toStdString().c_str(), (*it).value("cellphone").toString().size());
        memcpy(C1->c->idTime, (*it).value("id").toString().toStdString().c_str(), (*it).value("id").toString().size());
        memcpy(C1->c->lastup, (*it).value("lastup").toString().toStdString().c_str(), (*it).value("lastup").toString().size());
        memcpy(C1->c->birthday, (*it).value("birthday").toString().toStdString().c_str(), (*it).value("birthday").toString().size());
        memcpy(C1->c->usernamecontact, (*it).value("usernamecontact").toString().toStdString().c_str(), (*it).value("usernamecontact").toString().size());

//        std::cout << "SENDING CONTACT" << std::endl;
        emit(sendData(C1->ConvertToAnswer(), C1->getSize()));
        ++it;
    }
    query = "UPDATE contact SET status = " + QString::number(VALID) + " WHERE status = " + QString::number(MODIF);
    this->execQuery(query);
    query = "SELECT * FROM contact";
    this->execQuery(query, FILLCONTACT);
    emit(synchingProgress(QVariant(SYNC_CONTACT)));

}

void    Manage::SyncAgenda(Command *C)
{
    if (!this->isSynching)
        return ;
//    std::cout << "----------------------------------------------------------" << std::endl;
    QString query = "SELECT * FROM agenda";
    QList<QSqlRecord> Books = this->execQuery(query);
    QList<QSqlRecord>::iterator it = Books.begin();
    ++it;
    bool found = false;
    while (it != Books.end())
    {
        if ((*it).value("id").toString().compare(QString(C->a->idTime)) == 0)
        {
            found = true;
            break;
        }
        ++it;
    }
//    std::cout << "----------------------------------------------------------" << std::endl;

    if (found)
    {
        QDateTime local = QDateTime::fromString((*it).value("lastup").toString(), "dd.MM.yyyy.hh.mm.ss.zzz");
        QDateTime server = QDateTime::fromString(QString(C->a->lastup), "dd.MM.yyyy.hh.mm.ss.zzz");
        if (server > local)
        {
            if (C->a->status == DEL)
                query = "DELETE FROM agenda WHERE id = '" + (*it).value("id").toString() + "'";
            else
                query = "UPDATE agenda SET lastup = '" + QString(C->a->lastup) + "', taskName = '" + QString(C->a->taskName) + "', taskComment = '" + QString(C->a->taskComment) + "', taskStartDate = '" + QString(C->a->taskStartDate) + "', taskEndDate = '" + QString(C->a->taskEndDate) + "', status = " + QString::number(VALID) + " WHERE id = '" + (*it).value("id").toString() + "'";
            this->execQuery(query);
        }
        else if (server < local)
        {
            Command *C1 = new Command;
            C1->a = new agenda;
            C1->setIdHeader(HEADERAGENDA);
            C1->setSize(sizeof(command) + sizeof(agenda));
            memset(C1->a, 0, sizeof(agenda));
            memset(C1->a->taskName, 0, sizeof(C1->a->taskName));
            memset(C1->a->taskComment, 0, sizeof(C1->a->taskComment));
            memset(C1->a->idTime, 0, sizeof(C1->a->idTime));
            memset(C1->a->lastup, 0, sizeof(C1->a->lastup));
            memset(C1->a->taskStartDate, 0, sizeof(C1->a->taskStartDate));
            memset(C1->a->taskEndDate, 0, sizeof(C1->a->taskEndDate));

            memcpy(C1->a->taskName, (*it).value("taskName").toString().toStdString().c_str(), (*it).value("taskName").toString().size());
            memcpy(C1->a->taskComment, (*it).value("taskComment").toString().toStdString().c_str(), (*it).value("taskComment").toString().size());
            memcpy(C1->a->taskStartDate, (*it).value("taskStartDate").toString().toStdString().c_str(), (*it).value("taskStartDate").toString().size());
            memcpy(C1->a->taskEndDate, (*it).value("taskEndDate").toString().toStdString().c_str(), (*it).value("taskEndDate").toString().size());
            memcpy(C1->a->idTime, (*it).value("id").toString().toStdString().c_str(), (*it).value("id").toString().size());
            memcpy(C1->a->lastup, (*it).value("lastup").toString().toStdString().c_str(), (*it).value("lastup").toString().size());
            if ((*it).value("status").toInt() == DEL)
            {
                query = "DELETE FROM agenda WHERE id = '" + (*it).value("id").toString() + "'";
                C1->a->idCmd = DELAGENDA;
            }
            else
            {
                query = "UPDATE agenda SET status = " + QString::number(VALID) + " WHERE id = '" + (*it).value("id").toString() + "'";
                C1->a->idCmd = UPDATEAGENDA;
            }
            emit(sendData(C1->ConvertToAnswer(), C1->getSize()));
            this->execQuery(query);
        }
    }
    else
        if (C->a->status != DEL)
        {
            query = "INSERT INTO agenda (id, lastup, taskName, taskComment, taskStartDate, taskEndDate, status) VALUES ('" + QString(C->a->idTime) + "','" + QString(C->a->lastup) + "','" + QString(C->a->taskName) + "', '" + QString(C->a->taskComment) + "', '" + QString(C->a->taskStartDate) + "', '" + QString(C->a->taskEndDate) +  "', " + QString::number(VALID) + ");";
            this->execQuery(query);
        }
}

void    Manage::SyncEndAgenda(Command *)
{
    if (!this->isSynching)
        return ;
    QString query = "SELECT * FROM agenda WHERE status = " + QString::number(MODIF);
    QList<QSqlRecord> Books = this->execQuery(query);
    QList<QSqlRecord>::iterator it = Books.begin();
    ++it;
    while (it != Books.end())
    {
        Command *C = new Command;
        C->a = new agenda;
        C->setIdHeader(HEADERAGENDA);
        C->setSize(sizeof(command) + sizeof(agenda));
        memset(C->a, 0, sizeof(agenda));
        memset(C->a->taskName, 0, sizeof(C->a->taskName));
        memset(C->a->taskComment, 0, sizeof(C->a->taskComment));
        memset(C->a->idTime, 0, sizeof(C->a->idTime));
        memset(C->a->lastup, 0, sizeof(C->a->lastup));
        memset(C->a->taskStartDate, 0, sizeof(C->a->taskStartDate));
        memset(C->a->taskEndDate, 0, sizeof(C->a->taskEndDate));
        C->a->idCmd = ADDAGENDA;
        memcpy(C->a->taskName, (*it).value("taskName").toString().toStdString().c_str(), (*it).value("taskName").toString().size());
        memcpy(C->a->taskComment, (*it).value("taskComment").toString().toStdString().c_str(), (*it).value("taskComment").toString().size());
        memcpy(C->a->taskStartDate, (*it).value("taskStartDate").toString().toStdString().c_str(), (*it).value("taskStartDate").toString().size());
        memcpy(C->a->taskEndDate, (*it).value("taskEndDate").toString().toStdString().c_str(), (*it).value("taskEndDate").toString().size());
        memcpy(C->a->idTime, (*it).value("id").toString().toStdString().c_str(), (*it).value("id").toString().size());
        memcpy(C->a->lastup, (*it).value("lastup").toString().toStdString().c_str(), (*it).value("lastup").toString().size());
        emit(sendData(C->ConvertToAnswer(), C->getSize()));
        ++it;
    }
    query = "UPDATE agenda SET status = " + QString::number(VALID) + " WHERE status = " + QString::number(MODIF);
    this->execQuery(query);
    query = "SELECT * FROM agenda";
    this->execQuery(query, ASKTASK);
    emit(synchingProgress(QVariant(SYNC_AGENDA)));
}

void    Manage::SyncWeather(Command *C)
{
    if (!this->isSynching)
        return ;
//    std::cout << "----------------------------------------------------------" << std::endl;
    QString query = "SELECT * FROM locationweather";
    QList<QSqlRecord> Books = this->execQuery(query);
    QList<QSqlRecord>::iterator it = Books.begin();
    ++it;
    bool found = false;
    while (it != Books.end())
    {
        if ((*it).value("id").toString().compare(QString(C->w->idTime)) == 0)
        {
            found = true;
            break;
        }
        ++it;
    }
//    std::cout << "---------------------------- WEATHER LOC ------------------------------" << std::endl;

    if (found)
    {
        QDateTime local = QDateTime::fromString((*it).value("lastup").toString(), "dd.MM.yyyy.hh.mm.ss.zzz");
        QDateTime server = QDateTime::fromString(QString(C->w->lastup), "dd.MM.yyyy.hh.mm.ss.zzz");
        if (server > local)
        {
            if (C->w->status == DEL)
                query = "DELETE FROM locationweather WHERE id = '" + (*it).value("id").toString() + "'";
            else
                query = "UPDATE locationweather SET lastup = '" + QString(C->w->lastup) + "', country = '" + QString(C->w->country) + "', city = '" + QString(C->w->city) + "', status = " + QString::number(VALID) + " WHERE id = '" + (*it).value("id").toString() + "'";
            this->execQuery(query);
        }
        else if (server < local)
        {
            Command *C1 = new Command;
            C1->w = new weather;
            C1->setIdHeader(HEADERWEATHER);
            C1->setSize(sizeof(command) + sizeof(weather));
            memset(C1->w, 0, sizeof(weather));
            memset(C1->w->country, 0, sizeof(C1->w->country));
            memset(C1->w->city, 0, sizeof(C1->w->city));
            memset(C1->w->idTime, 0, sizeof(C1->w->idTime));
            memset(C1->w->lastup, 0, sizeof(C1->w->lastup));

            memcpy(C1->w->country, (*it).value("country").toString().toStdString().c_str(), (*it).value("country").toString().size());
            memcpy(C1->w->city, (*it).value("city").toString().toStdString().c_str(), (*it).value("city").toString().size());
            memcpy(C1->w->idTime, (*it).value("id").toString().toStdString().c_str(), (*it).value("id").toString().size());
            memcpy(C1->w->lastup, (*it).value("lastup").toString().toStdString().c_str(), (*it).value("lastup").toString().size());
            if ((*it).value("status").toInt() == DEL)
            {
                query = "DELETE FROM locationweather WHERE id = '" + (*it).value("id").toString() + "'";
                C1->w->idCmd = DELWEATHERLOC;
            }
            else
            {
                query = "UPDATE locationweather SET status = " + QString::number(VALID) + " WHERE id = '" + (*it).value("id").toString() + "'";
                C1->w->idCmd = UPDATEWEATHERLOC;
            }
            emit(sendData(C1->ConvertToAnswer(), C1->getSize()));
            this->execQuery(query);
        }
    }
    else
        if (C->w->status != DEL)
        {
            query = "INSERT INTO locationweather (id, lastup, country, city, status) VALUES ('" + QString(C->w->idTime) + "','" + QString(C->w->lastup) + "','" + QString(C->w->country) + "', '" + QString(C->w->city) + "', " + QString::number(VALID) + ");";
            this->execQuery(query);
        }
}


void    Manage::SyncEndWeather(Command *C)
{
    if (!this->isSynching)
        return ;
    QString query = "SELECT * FROM locationweather WHERE status = " + QString::number(MODIF);
    QList<QSqlRecord> Books = this->execQuery(query);
    QList<QSqlRecord>::iterator it = Books.begin();
    ++it;
    while (it != Books.end())
    {
        Command *C1 = new Command;
        C1->w = new weather;
        C1->setIdHeader(HEADERWEATHER);
        C1->setSize(sizeof(command) + sizeof(weather));
        memset(C1->w, 0, sizeof(weather));
        memset(C1->w->country, 0, sizeof(C1->w->country));
        memset(C1->w->city, 0, sizeof(C1->w->city));
        memset(C1->w->idTime, 0, sizeof(C1->w->idTime));
        memset(C1->w->lastup, 0, sizeof(C1->w->lastup));
        C1->w->idCmd = ADDWEATHERLOC;
        memcpy(C1->w->country, (*it).value("country").toString().toStdString().c_str(), (*it).value("country").toString().size());
        memcpy(C1->w->city, (*it).value("city").toString().toStdString().c_str(), (*it).value("city").toString().size());
        memcpy(C1->w->idTime, (*it).value("id").toString().toStdString().c_str(), (*it).value("id").toString().size());
        memcpy(C1->w->lastup, (*it).value("lastup").toString().toStdString().c_str(), (*it).value("lastup").toString().size());
        emit(sendData(C1->ConvertToAnswer(), C1->getSize()));
        ++it;
    }
    query = "UPDATE locationweather SET status = " + QString::number(VALID) + " WHERE status = " + QString::number(MODIF);
    this->execQuery(query);
    query = "SELECT * FROM locationweather ";
    this->execQuery(query, ASKWEATHERLOCATION);
    emit(synchingProgress(QVariant(SYNC_WEATHERLOC)));
}


void    Manage::SyncSetting(Command *C)
{
    if (!this->isSynching)
        return ;
    QString query = "SELECT * FROM infouser";
    QList<QSqlRecord> Books = this->execQuery(query);
    QList<QSqlRecord>::iterator it = Books.begin();
    ++it;
    bool found = false;
    while (it != Books.end())
    {
        if ((*it).value("id").toString().compare(QString(C->se->idTime)) == 0)
        {
            found = true;
            break;
        }
        ++it;
    }
    if (found)
    {
        QDateTime local = QDateTime::fromString((*it).value("lastup").toString(), "dd.MM.yyyy.hh.mm.ss.zzz");
        QDateTime server = QDateTime::fromString(QString(C->se->lastup), "dd.MM.yyyy.hh.mm.ss.zzz");
        if (server > local)
        {
//            std::cout << "CHECKING INFO FROM SERVER" << std::endl;
            if (C->se->status == DEL)
                query = "DELETE FROM infouser WHERE id = '" + (*it).value("id").toString() + "'";
            else
                query = "UPDATE infouser SET lastup = '" + QString(C->se->lastup) + "', firstname = '" + QString(C->se->firstname) + "', lastname = '" + QString(C->se->lastname) + "', mail = '" + QString(C->se->email) + "', adress = '" + QString(C->se->address) + "', homephone = '" + QString(C->se->homephone) + "', cellphone = '" + QString(C->se->cellphone) + "', birthday = '" + QString(C->se->birthday) + "', status = " + QString::number(VALID) + ", visibility = " + QString::number(C->se->visibility)+ " WHERE id = '" + (*it).value("id").toString() + "'";
            this->execQuery(query);
        }
        else if (server < local)
        {
            Command *C1 = new Command;
            C1->se = new setting;
            C1->setIdHeader(HEADERSETTING);
            C1->setSize(sizeof(command) + sizeof(setting));
            memset(C1->se, 0, sizeof(setting));
            memset(C1->se->firstname, 0, sizeof(C1->se->firstname));
            memset(C1->se->lastname, 0, sizeof(C1->se->lastname));
            memset(C1->se->email, 0, sizeof(C1->se->lastname));
            memset(C1->se->address, 0, sizeof(C1->se->address));
            memset(C1->se->homephone, 0, sizeof(C1->se->homephone));
            memset(C1->se->cellphone, 0, sizeof(C1->se->cellphone));
            memset(C1->se->birthday, 0, sizeof(C1->se->birthday));
            memset(C1->se->idTime, 0, sizeof(C1->se->idTime));
            memset(C1->se->lastup, 0, sizeof(C1->se->lastup));

            memcpy(C1->se->firstname, (*it).value("firstname").toString().toStdString().c_str(), (*it).value("firstname").toString().size());
            memcpy(C1->se->lastname, (*it).value("lastname").toString().toStdString().c_str(), (*it).value("lastname").toString().size());
            memcpy(C1->se->email, (*it).value("email").toString().toStdString().c_str(), (*it).value("email").toString().size());
            memcpy(C1->se->address, (*it).value("adress").toString().toStdString().c_str(), (*it).value("adress").toString().size());
            memcpy(C1->se->homephone, (*it).value("homephone").toString().toStdString().c_str(), (*it).value("homephone").toString().size());
            memcpy(C1->se->cellphone, (*it).value("cellphone").toString().toStdString().c_str(), (*it).value("cellphone").toString().size());
            memcpy(C1->se->idTime, (*it).value("id").toString().toStdString().c_str(), (*it).value("id").toString().size());
            memcpy(C1->se->lastup, (*it).value("lastup").toString().toStdString().c_str(), (*it).value("lastup").toString().size());
            memcpy(C1->se->birthday, (*it).value("birthday").toString().toStdString().c_str(), (*it).value("birthday").toString().size());
            C1->se->visibility =  (*it).value("visibility").toInt();
            if ((*it).value("status").toInt() == DEL)
            {
//                std::cout << "DEL DU info LOCAL  " << std::endl;
                query = "DELETE FROM infouser WHERE id = '" + (*it).value("id").toString() + "'";
                C1->se->idCmd = DELSETTING;
            }
            else
            {
//                std::cout << "UPDATE DU info SUR SERVER" << std::endl;
                query = "UPDATE infouser SET status = " + QString::number(VALID) + " WHERE id = '" + (*it).value("id").toString() + "'";
                C1->se->idCmd = UPDATESETTING;
            }
            emit(sendData(C1->ConvertToAnswer(), C1->getSize()));
            this->execQuery(query);
        }
    }
    else
        if (C->se->status != DEL)
        {
            query = "INSERT INTO infouser (firstname, lastname, mail, adress, homephone, cellphone, birthday, id, lastup, status, visibility) VALUES ( '" + QString(C->se->firstname) + "','" + QString(C->se->lastname) + "','" + QString(C->se->email) + "','" + QString(C->se->address)+ "','" + QString(C->se->homephone) + "','" + QString(C->se->cellphone)+ "','" + QString(C->se->birthday)+ "','" + QString(C->se->idTime) + "','" + QString(C->se->lastup) + "', " + QString::number(VALID) + " ," + QString::number(C->se->visibility) + ")";
            this->execQuery(query);
        }
}


void    Manage::SyncEndSetting(Command *)
{
    if (!this->isSynching)
        return ;
    QString query = "SELECT * FROM infouser WHERE status = " + QString::number(MODIF);
    QList<QSqlRecord> Books = this->execQuery(query);
    QList<QSqlRecord>::iterator it = Books.begin();
    ++it;
 //   std::cout << "SENDING NEW info TO SERVER" << std::endl;
    while (it != Books.end())
    {
        Command *C1 = new Command;
        C1->se = new setting;
        C1->setIdHeader(HEADERSETTING);
        C1->setSize(sizeof(command) + sizeof(setting));
        memset(C1->se, 0, sizeof(setting));
        memset(C1->se->firstname, 0, sizeof(C1->se->firstname));
        memset(C1->se->lastname, 0, sizeof(C1->se->lastname));
        memset(C1->se->email, 0, sizeof(C1->se->lastname));
        memset(C1->se->address, 0, sizeof(C1->se->address));
        memset(C1->se->homephone, 0, sizeof(C1->se->homephone));
        memset(C1->se->cellphone, 0, sizeof(C1->se->cellphone));
        memset(C1->se->birthday, 0, sizeof(C1->se->birthday));
        memset(C1->se->idTime, 0, sizeof(C1->se->idTime));
        memset(C1->se->lastup, 0, sizeof(C1->se->lastup));
        C1->c->idCmd = ADDSETTING;
        memcpy(C1->se->firstname, (*it).value("firstname").toString().toStdString().c_str(), (*it).value("firstname").toString().size());
        memcpy(C1->se->lastname, (*it).value("lastname").toString().toStdString().c_str(), (*it).value("lastname").toString().size());
        memcpy(C1->se->email, (*it).value("email").toString().toStdString().c_str(), (*it).value("email").toString().size());
        memcpy(C1->se->address, (*it).value("adress").toString().toStdString().c_str(), (*it).value("adress").toString().size());
        memcpy(C1->se->homephone, (*it).value("homephone").toString().toStdString().c_str(), (*it).value("homephone").toString().size());
        memcpy(C1->se->cellphone, (*it).value("cellphone").toString().toStdString().c_str(), (*it).value("cellphone").toString().size());
        memcpy(C1->se->idTime, (*it).value("id").toString().toStdString().c_str(), (*it).value("id").toString().size());
        memcpy(C1->se->lastup, (*it).value("lastup").toString().toStdString().c_str(), (*it).value("lastup").toString().size());
        memcpy(C1->se->birthday, (*it).value("birthday").toString().toStdString().c_str(), (*it).value("birthday").toString().size());
        C1->se->visibility = (*it).value("visibility").toInt();
//        std::cout << "SENDING INFO" << std::endl;
        emit(sendData(C1->ConvertToAnswer(), C1->getSize()));
        ++it;
    }
    query = "UPDATE infouser SET status = " + QString::number(VALID) + " WHERE status = " + QString::number(MODIF);
    this->execQuery(query);
    emit(synchingProgress(QVariant(SYNC_INFOUSER)));
    emit(execQuery("SELECT * FROM infouser", FILLUSERINFO));
}



void    Manage::SyncEvent(Command *C)
{
    std::cout << "--------------------------SYNCEVENT--------------------------------" << std::endl;
    if (!this->isSynching)
        return ;
    QString query = "SELECT * FROM events";
    QList<QSqlRecord> Event = this->execQuery(query);
    QList<QSqlRecord>::iterator it = Event.begin();
    ++it;
    bool found = false;
    while (it != Event.end())
    {
        if ((*it).value("id").toString().compare(QString(C->e->idTime)) == 0)
        {
            found = true;
            break;
        }
        ++it;
    }
    std::cout << "----------------------------------------------------------" << std::endl;
    std::cout << "ID CMD " << C->getIdCmd() << std::endl;
    std::cout << "SIZE " << C->getSize() << std::endl;
    std::cout << "ID HEADER " << C->getIdHeader() << std::endl;
    std::cout << "----------------------------------------------------------" << std::endl;


    if (found)
    {
        std::cout << "EVENT EXIST ON LOCAL BASE" << std::endl;
        QDateTime local = QDateTime::fromString((*it).value("lastup").toString(), "dd.MM.yyyy.hh.mm.ss.zzz");
        QDateTime server = QDateTime::fromString(QString(C->e->lastup), "dd.MM.yyyy.hh.mm.ss.zzz");
        if (server > local)
        {
            std::cout << "TAKING EVENT VERSION FROM SERVER" << std::endl;
            if (C->e->status == DEL)
                query = "DELETE FROM events WHERE id = '" + (*it).value("id").toString() + "'";
            else
                query = "UPDATE events SET lastup = '" + QString(C->e->lastup) + "',  country = '" + QString(C->e->country) + "', city = '" + QString(C->e->city) + "', description = '" + QString(C->e->description) + "', title = '" + QString(C->e->title) + "', date = '" + QString(C->e->date) + "', hour = '" + QString(C->e->hour) + "', createFName = '" + QString(C->e->createFName) + "', createLName = '"+ QString(C->e->createLName) + "', contactList = '" + QString(C->e->contactList) + "', status = " + QString::number(VALID) + " WHERE id = '" + (*it).value("id").toString() + "'";
            this->execQuery(query);
        }
        else if (server < local)
        {
            std::cout << "TAKING EVENT VERSION FROM CLIENT" << std::endl;
            Command *C1 = new Command;
            C1->e = new events;
            C1->setIdHeader(HEADEREVENT);
            C1->setSize(sizeof(command) + sizeof(events));
            memset(C1->e, 0, sizeof(events));
            memset(C1->e->country, 0, sizeof(C1->e->country));
            memset(C1->e->city, 0, sizeof(C1->e->city));
            memset(C1->e->description, 0, sizeof(C1->e->description));
            memset(C1->e->title, 0, sizeof(C1->e->title));
            memset(C1->e->date, 0, sizeof(C1->e->date));
            memset(C1->e->hour, 0, sizeof(C1->e->hour));
            memset(C1->e->createFName, 0, sizeof(C1->e->createFName));
            memset(C1->e->createLName, 0, sizeof(C1->e->createLName));
            memset(C1->e->contactList, 0, sizeof(C1->e->contactList));
            memset(C1->e->idTime, 0, sizeof(C1->e->idTime));
            memset(C1->e->lastup, 0, sizeof(C1->e->lastup));

            memcpy(C1->e->country, (*it).value("country").toString().toStdString().c_str(), (*it).value("country").toString().size());
            memcpy(C1->e->city, (*it).value("city").toString().toStdString().c_str(), (*it).value("city").toString().size());
            memcpy(C1->e->description, (*it).value("description").toString().toStdString().c_str(), (*it).value("description").toString().size());
            memcpy(C1->e->title, (*it).value("title").toString().toStdString().c_str(), (*it).value("title").toString().size());
            memcpy(C1->e->date, (*it).value("date").toString().toStdString().c_str(), (*it).value("date").toString().size());
            memcpy(C1->e->hour, (*it).value("hour").toString().toStdString().c_str(), (*it).value("hour").toString().size());
            memcpy(C1->e->createFName, (*it).value("createFName").toString().toStdString().c_str(), (*it).value("createFName").toString().size());
            memcpy(C1->e->createLName, (*it).value("createLName").toString().toStdString().c_str(), (*it).value("createLName").toString().size());
            memcpy(C1->e->contactList, (*it).value("contactList").toString().toStdString().c_str(), (*it).value("contactList").toString().size());

            memcpy(C1->e->idTime, (*it).value("id").toString().toStdString().c_str(), (*it).value("id").toString().size());
            memcpy(C1->e->lastup, (*it).value("lastup").toString().toStdString().c_str(), (*it).value("lastup").toString().size());
            if ((*it).value("status").toInt() == DEL)
            {
                query = "DELETE FROM events WHERE id = '" + (*it).value("id").toString() + "'";
                C1->e->idCmd = DELEVENT;
            }
            else
            {
                query = "UPDATE events SET status = " + QString::number(VALID) + " WHERE id = '" + (*it).value("id").toString() + "'";
                C1->e->idCmd = UPDATEEVENT;
            }
            emit(sendData(C1->ConvertToAnswer(), C1->getSize()));
            this->execQuery(query);
        }
    }
    else
    {
        std::cout << "ADDING EVENT IN DATABASE" << std::endl;
        if (C->e->status != DEL)
        {
            query = "INSERT INTO events (id, lastup, country, city, description, title, date, hour, createFName, createLName, contactList, status) VALUES ('" + QString(C->e->idTime) + "','" + QString(C->e->lastup) + "','" + QString(C->e->country) + "', '" + QString(C->e->city) + "', '" + QString(C->e->description) + "', '" + QString(C->e->title) + "', '" + QString(C->e->date)+ "', '" + QString(C->e->hour)+ "', '" + QString(C->e->createFName)+ "', '" + QString(C->e->createLName)+ "', '" + QString(C->e->contactList) +  "', " + QString::number(VALID) + ");";
            this->execQuery(query);
        }
    }
}


void    Manage::SyncEndEvent(Command *C)
{
    std::cout << "SYNC END EVENT" << std::endl;

    if (!this->isSynching)
        return ;
    QString query = "SELECT * FROM events WHERE status = " + QString::number(MODIF);
    QList<QSqlRecord> Books = this->execQuery(query);
    QList<QSqlRecord>::iterator it = Books.begin();
    ++it;
    std::cout << "SENDING NEW EVENT TO SERVER" << std::endl;
    while (it != Books.end())
    {
        std::cout << "MAKING EVENT COMMAND" << std::endl;
        Command *C1 = new Command;
        C1->e = new events;
        C1->setIdHeader(HEADEREVENT);
        C1->setSize(sizeof(command) + sizeof(events));
        memset(C1->e, 0, sizeof(events));
        memset(C1->e->country, 0, sizeof(C1->e->country));
        memset(C1->e->city, 0, sizeof(C1->e->city));
        memset(C1->e->description, 0, sizeof(C1->e->description));
        memset(C1->e->title, 0, sizeof(C1->e->title));
        memset(C1->e->date, 0, sizeof(C1->e->date));
        memset(C1->e->hour, 0, sizeof(C1->e->hour));
        memset(C1->e->createFName, 0, sizeof(C1->e->createFName));
        memset(C1->e->createLName, 0, sizeof(C1->e->createLName));
        memset(C1->e->contactList, 0, sizeof(C1->e->contactList));
        memset(C1->e->idTime, 0, sizeof(C1->e->idTime));
        memset(C1->e->lastup, 0, sizeof(C1->e->lastup));
        C1->e->idCmd = ADDEVENT;
        memcpy(C1->e->country, (*it).value("country").toString().toStdString().c_str(), (*it).value("country").toString().size());
        memcpy(C1->e->city, (*it).value("city").toString().toStdString().c_str(), (*it).value("city").toString().size());
        memcpy(C1->e->description, (*it).value("description").toString().toStdString().c_str(), (*it).value("description").toString().size());
        memcpy(C1->e->title, (*it).value("title").toString().toStdString().c_str(), (*it).value("title").toString().size());
        memcpy(C1->e->date, (*it).value("date").toString().toStdString().c_str(), (*it).value("date").toString().size());
        memcpy(C1->e->hour, (*it).value("hour").toString().toStdString().c_str(), (*it).value("hour").toString().size());
        memcpy(C1->e->createFName, (*it).value("createFName").toString().toStdString().c_str(), (*it).value("createFName").toString().size());
        memcpy(C1->e->createLName, (*it).value("createLName").toString().toStdString().c_str(), (*it).value("createLName").toString().size());
        memcpy(C1->e->contactList, (*it).value("contactList").toString().toStdString().c_str(), (*it).value("contactList").toString().size());
        memcpy(C1->e->idTime, (*it).value("id").toString().toStdString().c_str(), (*it).value("id").toString().size());
        memcpy(C1->e->lastup, (*it).value("lastup").toString().toStdString().c_str(), (*it).value("lastup").toString().size());
        std::cout << "SENDING INFO EVENTS--------------" << std::endl;
        std::cout << C1->e->idTime << " ____ "  << C1->e->lastup  << std::endl;
        emit(sendData(C1->ConvertToAnswer(), C1->getSize()));
        ++it;
    }
    query = "UPDATE events SET status = " + QString::number(VALID) + " WHERE status = " + QString::number(MODIF);
    this->execQuery(query);
    query = "SELECT * FROM events";
    this->execQuery(query, FILLEVENT);
}
