// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1

Item
{
    property    alias   text : text_elem.text
    property    variant color_gradient : blue_black_grad

    Gradient
    {
        id : blue_black_grad
        GradientStop {position : 0.0; color : "#000033"}
        GradientStop {position : 1.0; color : "black"}
    }

    Gradient
    {
        id : qt_green_grad
        GradientStop {position : 0.0; color : "#01DF01"}
        GradientStop {position : 1.0; color : "#298A08"}
    }

    Gradient
    {
        id : highlight_grad
        GradientStop {position : 0.0; color : tepee.highLightColor}
        GradientStop {position : 1.0; color : tepee.highLightColor2}
    }

    signal buttonClicked();

    scale : elem_ma.pressed ? 0.9 : 1
    Rectangle
    {
        anchors.fill: parent
        radius : 15
        smooth : true
        border
        {
            width : 1
            color : "grey"
        }
        color : tepee.elemBackColor
        gradient : color_gradient
        opacity : tepee.elemBackOpacity
    }

    Text
    {
        id : text_elem
        anchors.centerIn: parent
        color : "white"
        font.pointSize: tepee.textSize;
    }
    MouseArea
    {
        id : elem_ma
        anchors.fill: parent
        onClicked: {buttonClicked()}
    }
}
