// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1
import "DateLogic.js" as DateLogic

Item
{
    property int currentDayNum;
    property int currentMonthNum;
    property int currentDayWeekNum;
    property int currentYear;
    property string currentDayName;
    property string currentMonthName;
    property variant optionalMod : null;
    property bool   backButton : false
    property int viewType : 0; // DIFFERENT VIEW TYPES ARE

    width : main_win_rec.width
    height : main_win_rec.height - (2 * tepee.mobileRes)
    y : tepee.mobileRes

    signal   backButtonClicked();


    function    setDayIndex(idx)
    {
        day_info_view.currentIndex = idx;
        month_gridview.currentIndex = idx;
        if (optionalMod)
            optionalMod.currentIndex = idx;
    }

    function    getDayModel()
    {
        return monthJsModel;
    }

    ListModel
    {
        id : monthJsModel
    }

    function    setNewDate(dateElem)
    {
        DateLogic.setNewDate(dateElem);
        reloadModels();
        upDateDateInfos();
        year_sel_view.currentIndex = (currentYear % 100 > new Date().getFullYear % 100) ? (currentYear % 100 - ((new Date().getFullYear() % 100) + 1)) : 99 - ((new Date().getFullYear() % 100) - currentYear % 100)
        console.log(year_sel_view.currentIndex);
    }

    function    setSelectedDate(day, month)
    {
        DateLogic.setMonthNum(month);
        reloadModels();
        DateLogic.setDayOfMonthNum(day);
        upDateDateInfos();
    }

    Component.onCompleted:
    {
        DateLogic.generateYearModel(yearSelectModel);
        reloadModels();
        upDateDateInfos();
        if (viewType === 0)
        {
            month_sel_item.opacity = 0;
            day_sel_info_item.opacity = 0;
        }
    }

    function    upDateDateInfos()
    {
        currentDayNum = DateLogic.getDayNum();
        currentMonthNum = DateLogic.getMonthNum();
        currentDayWeekNum = DateLogic.getDayOfWeekNum();
        currentYear = DateLogic.getYear();
        currentDayName = DateLogic.getDayOfWeekName(0, true);
        currentMonthName = DateLogic.getMonthName(0, true);
        setDayIndex(currentDayNum - 1);
    }

    function    reloadModels()
    {
        upDateDateInfos();
        DateLogic.generateDayInMonthModel(monthJsModel);
        DateLogic.generateMonthModel(monthSelectModel);
        month_sel_view.currentIndex = currentMonthNum;
    }


    // CALENDAR VIEW
    Item
    {
        id : calendar_view_item

        anchors
        {
            left : parent.left
            right : parent.horizontalCenter
            top : parent.top
            leftMargin : tepee.mobileRes / 4
            topMargin : tepee.mobileRes  / 4
            bottomMargin : tepee.mobileRes  / 4
            rightMargin : (viewType == 0) ? 0 : tepee.mobileRes / 4
            bottom : parent.bottom
        }

        Rectangle
        {
            anchors.fill: parent
            color : tepee.elemBackColor
            radius : 45
            opacity : tepee.elemBackOpacity
            smooth : true
            border
            {
                color : "grey"
                width : 1
            }
        }
        // MONTH NAME AND YEAR REC
        Rectangle
        {
            id : month_selector
            radius : 15
            color : "transparent"
            scale : month_select_ma.pressed ? 0.9 : 1.0
            border
            {
                color : "grey"
                width : 1
            }
            height : (tepee.screenSize == "large") ? tepee.mobileRes : 3 * tepee.mobileRes / 4
            anchors
            {
                left : parent.left
                top : parent.top
                right : parent.right
                margins : tepee.mobileRes / 4
            }
            Text
            {
                anchors.centerIn: parent
                color : "white"
                text : currentMonthName + " " + currentYear;
                font.pointSize: tepee.textSize
            }
            Text
            {
                color : "white"
                anchors
                {
                    verticalCenter : parent.verticalCenter
                    left : parent.left
                    leftMargin : tepee.mobileRes / 4
                }
                font.pointSize: tepee.textSize
                text : "<"
            }
            Text
            {
                color : "white"
                anchors
                {
                    verticalCenter : parent.verticalCenter
                    right : parent.right
                    rightMargin : tepee.mobileRes / 4
                }
                text : ">"
                font.pointSize: tepee.textSize

            }
            MouseArea
            {
                id : month_select_ma
                anchors.fill: parent
                property int xBeg;
                onPressed:
                {
                    xBeg = mouseX;
                }
                onReleased:
                {
                    if (Math.abs(xBeg -  mouseX) > 20)
                    {
                        if (xBeg - mouseX < 0)
                            DateLogic.setMonthNum(currentMonthNum - 1);
                        else
                            DateLogic.setMonthNum(currentMonthNum + 1);
                        DateLogic.setDayOfMonthNum(1);
                        reloadModels();
                        setDayIndex(0);
                    }
                }
            }
        }

        // GRIDVIEW OF SMALL DAY
        Rectangle
        {
            id : month_grid_Rec
            anchors
            {
                top : month_selector.bottom
                bottom : parent.bottom
                left : parent.left
                right : parent.right
                margins : tepee.mobileRes / 4

            }
            border
            {
                color : "grey"
                width : 1
            }
            color : "transparent"
            radius : 15
            // MODEL FOR DAYS OF MONTH
            GridView
            {
                id : month_gridview
                model : monthJsModel
                clip : true
                anchors.fill: parent
                delegate : cal_del
                highlight: cal_del_highlight
                cellHeight: Math.floor(width / 5);
                cellWidth: Math.floor(width / 5);
            }
        }
    }


    // BACK BUTTON
    Button
    {
        id : back_button
        anchors
        {
            horizontalCenter : parent.horizontalCenter
            top : parent.bottom
            topMargin : - tepee.mobileRes / 2
        }

        resImg : tepee.mobileRes
        numId : 173
        text : "Back"
        buttonColor: "blue"
        buttonShape: "round"
        opacity : backButton ? 1 : 0
        onButtonClicked:
        {
            backButtonClicked();
        }
    }


    // MONTH SELECTOR VIEW
    Item
    {
        id : month_sel_item
        opacity : (viewType == 1) ? 1 : 0
        anchors
        {
            left : parent.horizontalCenter
            top : parent.top
            right : parent.right
            bottom : parent.verticalCenter
            margins : tepee.mobileRes / 4
        }
        Rectangle
        {
            color : tepee.elemBackColor
            opacity : tepee.elemBackOpacity
            smooth : true
            radius : 40
            anchors.fill: parent
            border
            {
                color : "grey"
                width : 1
            }
        }
        ListModel
        {
            id : monthSelectModel
        }
        ListView
        {
            id : month_sel_view
            anchors
            {
                fill: parent
                margins : tepee.mobileRes / 4
            }
            model: monthSelectModel
            highlight: month_sel_highlight
            delegate: month_del
            spacing: tepee.mobileRes / 8
            clip : true
        }
    }

    Item
    {
        id : year_sel_item
        opacity : (viewType == 2) ? 1 : 0
        anchors
        {
            left : parent.horizontalCenter
            top : parent.top
            right : parent.right
            bottom : parent.verticalCenter
            margins : tepee.mobileRes / 4
        }
        Rectangle
        {
            color : tepee.elemBackColor
            opacity : tepee.elemBackOpacity
            smooth : true
            radius : 40
            anchors.fill: parent
            border
            {
                color : "grey"
                width : 1
            }
        }
        ListModel
        {
            id : yearSelectModel
        }
        ListView
        {
            id : year_sel_view
            anchors
            {
                fill: parent
                margins : tepee.mobileRes / 4
            }
            model: yearSelectModel
            highlight: month_sel_highlight
            highlightMoveSpeed: 4000
            delegate: year_del
            spacing: tepee.mobileRes / 8
            clip : true
        }
    }


    // DAY SELECTOR INFO VIEW
    Item
    {
        id : day_sel_info_item
        anchors
        {
            left : parent.horizontalCenter
            top : parent.verticalCenter
            right : parent.right
            bottom : parent.bottom
            margins: tepee.mobileRes / 4
        }
        Rectangle
        {
            radius : 40
            color : tepee.elemBackColor
            opacity : tepee.elemBackOpacity
            smooth : true
            anchors.fill: parent
            border
            {
                color : "grey"
                width : 1
            }
        }
        ListView
        {
            id : day_info_view
            spacing: tepee.mobileRes / 8
            anchors
            {
                fill: parent
                margins : tepee.mobileRes / 4
            }
            model: monthJsModel
            highlight: day_info_del_highlight
            delegate: day_info_del
            clip : true
        }
    }

    // SMALL DAY VIEW
    Component
    {
        id : cal_del
        Rectangle
        {
            scale : dayDelegateMa.pressed ? 0.9 : 1
            color : "transparent";
            width: month_gridview.cellWidth;
            height: month_gridview.cellHeight;
            MouseArea
            {
                id : dayDelegateMa
                anchors.fill: parent
                onClicked:
                {
                    DateLogic.setDayOfMonthNum(dayNum);
                    upDateDateInfos();
                }
            }
            Rectangle
            {
                id : delegate_back
                border.color : (!isToday) ? "white" : "blue"
                border.width : (!isToday) ? 1 : 3
                radius : 15
                smooth : true
                anchors.fill : parent
                color : tepee.elemBackColor
                opacity : tepee.elemBackOpacity
            }

            Text
            {
                text : dayNum
                color : "white"
                anchors.centerIn : parent
                font.pointSize: tepee.textSize
            }
        }
    }
    Component
    {
        id : cal_del_highlight
        Rectangle
        {
            gradient :
                Gradient {
                GradientStop {position : 0.0; color : tepee.highLightColor}
                GradientStop {position : 1.0; color : tepee.highLightColor2}
            }
            opacity : 0.4
            radius : 15
            smooth : true
            width: month_gridview.cellWidth;
            height: month_gridview.cellHeight;
            border
            {
                color : "white"
                width : 1
            }
        }

    }
    // MONTH DEL
    Component
    {
        id : month_del
        Item
        {

            width : month_sel_view.width
            height : 3 * tepee.mobileRes / 5
            scale : month_del_ma.pressed ? 0.9 : 1.0

            Rectangle
            {
                gradient :
                    Gradient    {
                    GradientStop {position : 0.0; color : "#000033"}
                    GradientStop {position : 1.0; color : tepee.elemBackColor}
                }
                opacity : 0.4
                smooth : true
                radius : 15
                border.color : "grey"
                border.width: 1
                anchors.fill: parent
            }
            MouseArea
            {
                id : month_del_ma
                anchors.fill: parent
                onClicked:
                {
                    DateLogic.setMonthNum(monthNum);
                    reloadModels();
                    setDayIndex(0);
                }
            }
            Text
            {
                anchors.centerIn: parent
                color : "white"
                font.pointSize: tepee.textSize
                text : monthName;
            }
        }
    }

    Component
    {
        id : month_sel_highlight
        Rectangle
        {
            width : month_sel_view.width
            height : 3 * tepee.mobileRes / 5
            gradient :
                Gradient    {
                GradientStop {position : 0.0; color : tepee.highLightColor}
                GradientStop {position : 1.0; color : tepee.highLightColor2}
            }
            opacity : 0.4
            smooth : true
            radius : 15
            border.color : "grey"
            border.width: 1
        }
    }

    // YEAR DEL
    Component
    {
        id : year_del
        Item
        {

            width : year_sel_view.width
            height : 3 * tepee.mobileRes / 5
            scale : year_del_ma.pressed ? 0.9 : 1.0

            Rectangle
            {
                gradient :
                    Gradient    {
                    GradientStop {position : 0.0; color : "#000033"}
                    GradientStop {position : 1.0; color : tepee.elemBackColor}
                }
                opacity : 0.4
                smooth : true
                radius : 15
                border.color : "grey"
                border.width: 1
                anchors.fill: parent
            }
            MouseArea
            {
                id : year_del_ma
                anchors.fill: parent
                onClicked:
                {
                    year_sel_view.currentIndex = index;
                    DateLogic.setCurYearDate(yearNum);
                    reloadModels();
                    setDayIndex(0);
                }
            }
            Text
            {
                anchors.centerIn: parent
                color : "white"
                font.pointSize: tepee.textSize
                text : yearNum;
            }
        }
    }


    // BIG DAY DEL
    Component
    {
        id : day_info_del
        Item
        {
            width : day_info_view.width
            height : day_info_view.height
            scale : day_inf_ma.pressed ? 0.9 : 1
            Rectangle
            {
                anchors.fill: parent
                opacity : 0.4
                smooth : true
                radius : 15
                color : "transparent"
                border.color : "grey"
                border.width: 1
            }
            MouseArea
            {
                id : day_inf_ma
                anchors.fill: parent
                onClicked:
                {
                    DateLogic.setDayOfMonthNum(dayNum);
                    upDateDateInfos();
                }
            }

            Text
            {
                anchors.centerIn: parent
                color : "white"
                font.pointSize: tepee.textSize
                text : dayName + " " + currentMonthName + " " + dayNum
            }
        }
    }
    Component
    {
        id : day_info_del_highlight
        Rectangle
        {
            width : day_info_view.width
            height : day_info_view.height
            gradient :
                Gradient    {
                GradientStop {position : 0.0; color : tepee.highLightColor}
                GradientStop {position : 1.0; color : tepee.highLightColor2}
            }
            opacity : 0.4
            smooth : true
            radius : 15
            border.color : "grey"
            border.width: 1
        }
    }

}
