#include "eventlogic.h"

int eventElem::nextId = 0;

eventElem::eventElem(QObject *p) : ListItem(p)
{
    this->eventId = eventElem::nextId++;
}

eventElem::eventElem(QString title_, QString description_, QString country_, QString city_, QString date_, QString hour_, QString creatorFName_, QString creatorLName_, QString contactList_, QString idTime_)
{
    this->title = title_;
    this->description = description_;
    this->country = country_;
    this->city = city_;
    this->date = date_;
    this->hour = hour_;
    this->creatorFName = creatorFName_;
    this->creatorLName = creatorLName_;
    this->contacts = contactList_;
    this->idTime = idTime_;
    this->eventId = eventElem::nextId++;
}

int     eventElem::id() const
{
    return this->eventId;
}

QVariant    eventElem::data(int role) const
{
    switch (role)
    {
    case titleEvent:
        return this->getEventTitle();
    case descriptionEvent :
        return this->getEventDescription();
    case countryEvent :
        return this->getEventCountry();
    case cityEvent :
        return this->getEventCity();
    case dateEvent :
        return this->getEventDate();
    case hourEvent :
        return this->getEventHour();
    case creatorFNameEvent :
        return this->getEventCreatorFName();
    case creatorLNameEvent :
        return this->getEventCreatorLName();
    case idEvent :
        return this->id();
    case contactsEvent :
        return this->getEventContacts();
    default :
        return QVariant();
    }
}

QHash<int, QByteArray>  eventElem::roleNames() const
{
    QHash<int, QByteArray>  roles;
    roles[titleEvent] = "event_title";
    roles[descriptionEvent] = "event_description";
    roles[countryEvent] = "event_country";
    roles[cityEvent] = "event_city";
    roles[dateEvent] = "event_date";
    roles[hourEvent] = "event_hour";
    roles[creatorFNameEvent] = "event_creator_fname";
    roles[creatorLNameEvent] = "event_creator_lname";
    roles[contactsEvent] = "event_contacts";
    roles[idEvent] = "event_id";
    return roles;
}

QString   eventElem::getEventContacts()  const
{
    return this->contacts;
}  

QString     eventElem::getEventCountry() const
{
    return this->country;
}

QString     eventElem::getEventCity() const
{
    return this->city;
}

QString     eventElem::getEventTitle()  const
{
    return this->title;
}

QString     eventElem::getEventDescription() const
{
    return this->description;
}

QString     eventElem::getEventIdTime() const
{
    return this->idTime;
}

QString     eventElem::getEventDate() const
{
    return this->date;
}

QString     eventElem::getEventHour() const
{
    return this->hour;
}

QString     eventElem::getEventCreatorFName() const
{
    return this->creatorFName;
}

QString     eventElem::getEventCreatorLName() const
{
    return this->creatorLName;
}

void        eventElem::setEventTitle(QString a)
{
    this->title = a;
}

void        eventElem::setEventDescription(QString a)
{
    this->description = a;
}

void        eventElem::setEventCountry(QString a)
{
    this->country = a;
}

void        eventElem::setEventCity(QString a)
{
    this->city = a;
}

void        eventElem::setEventHour(QString a)
{
    this->hour = a;
}

void        eventElem::setEventDate(QString a)
{
    this->date = a;
}

void        eventElem::setEventCreatorFName(QString a)
{
    this->creatorFName = a;
}

void        eventElem::setEventCreatorLName(QString a)
{
    this->creatorLName = a;
}

void        eventElem::setEventContactList(QString a)
{
    this->contacts = a;
}


eventLogic::eventLogic(QObject *p) :  QObject(p)
{
    this->eventModel = new ListModel(new eventElem);
}

ListModel*  eventLogic::getEventModel()
{
    return this->eventModel;
}

void        eventLogic::addEvent(QString title, QString description, QString country, QString city, QString date, QString hour, QString creatorFName_, QString creatorLName_, QString contactList)
{
    QString time = QDateTime::currentDateTime().toString("dd.MM.yyyy.hh.mm.ss.zzz");
    this->eventModel->appendRow(new eventElem(title, description, country, city, date, hour, creatorFName_, creatorLName_, contactList, time));
    QString query;
    query = "INSERT INTO events (id, lastup, country, city, description, title, date, hour, createFName, createLName, contactList, status) VALUES ('" + time + "','" + time + "','" + country + "', '" + city + "', '" + description + "', '" + title + "', '" + date + "', '" + hour+ "', '" + creatorFName_ + "', '" + creatorLName_+ "', '" + contactList +  "', " + QString::number(MODIF) + ");";
    emit(SendQueryEvent(query, SETEVENT));
}

void        eventLogic::editEvent(QString title, QString description, QString country, QString city, QString date, QString hour, QString creatorFName, QString creatorLName, QString contactList, int id)
{
    ListItem *e = this->eventModel->find(id);
    if (e == NULL)
        return ;
    int row = this->eventModel->getRowFromItem(e);
    if (row > -1)
    {
        eventElem *ev = (eventElem *)e;
        QString query;
        query = "UPDATE events SET lastup = '" + QDateTime::currentDateTime().toString("dd.MM.yyyy.hh.mm.ss.zzz") + "',  country = '" + country + "', city = '" + city + "', description = '" + description + "', title = '" + title + "', date = '" + date + "', hour = '" + hour + "', createFName = '" + creatorFName + "', createLName = '"+ creatorLName + "', contactList = '" + contactList + "', status = " + QString::number(MODIF) + " WHERE id = '" + ev->getEventIdTime() + "'";
        emit(SendQueryEvent(query, SETEVENT));
        ev->setEventTitle(title);
        ev->setEventDescription(description);
        ev->setEventCountry(country);
        ev->setEventCity(city);
        ev->setEventHour(hour);
        ev->setEventDate(date);
        ev->setEventCreatorFName(creatorFName);
        ev->setEventCreatorLName(creatorLName);
        ev->setEventContactList(contactList);
        this->eventModel->updateModelFromElem(ev);
    }
}

void        eventLogic::rmEvent(int id)
{
    ListItem *e = this->eventModel->find(id);
    if (e == NULL)
        return ;
    int row = this->eventModel->getRowFromItem(e);
    if (row > -1)
    {
        eventElem *ev = (eventElem *)e;
        QString query;
        query = "UPDATE events SET status = " + QString::number(DEL) + ", lastup = '" +   QDateTime::currentDateTime().toString("dd.MM.yyyy.hh.mm.ss.zzz") + "' WHERE id = '" + ev->getEventIdTime() + "'";
        emit(SendQueryEvent(query, SETEVENT));
        this->eventModel->removeRow(row);
    }
}

void        eventLogic::rcvEvent(QList<QSqlRecord> q, int status)
{
    if (status == FILLEVENT)
    {
        this->eventModel->removeRows(0, this->eventModel->rowCount());
        QList<QSqlRecord>::iterator it = q.begin();
        ++it;
        std::cout << "QWERTY ------ QWERTY" << std::endl;
        while (it != q.end())
        {
            if ((*it).value("status").toInt() != DEL)
                this->eventModel->appendRow(new eventElem((*it).value("title").toString(), (*it).value("description").toString(), (*it).value("country").toString(), (*it).value("city").toString(), (*it).value("date").toString(), (*it).value("hour").toString(), (*it).value("createFName").toString(), (*it).value("createLName").toString(), (*it).value("contactList").toString(), (*it).value("id").toString()));
            ++it;
        }
        // RECOIT TOUT LES EVENT ET AUSSI LES CONTACTS A ASSIGNER AU BOOKMARK COURANT

    }
}

void        eventLogic::loadEventsFromDB()
{
    std::cout << "LOADEVENTS -------- LOADEVENTS" << std::endl;
    QString query = "SELECT * FROM events";
    emit (SendQueryEvent(query, FILLEVENT));
}
