/*
 * Qt C++/QML WebThumbnail example
 * (c) 2010 Dennis Noordsij <dennis.noordsij@movial.com>
 * http://wiki.forum.nokia.com/index.php/Custom_QML_Component:_Website_Thumbnails
 *
 * You may re-use parts or all of this sourcecode in your own projects,
 * including proprietary and/or commercial, without attribution or restriction.
 */

#include <QWebPage>
#include <QWebFrame>
#include <QWebSettings>
#include <QSize>
#include <QPainter>
#include <QImage>
#include <QDebug>
#include <QElapsedTimer>
#include "webthumbnailjob.h"

WebThumbnailJob::WebThumbnailJob(const QUrl &url, QObject *parent)
	: QObject(parent),
	  m_webpage(0),
	  m_url(url),
	  m_pixmap(),
	  m_state(Queued)
{
}

WebThumbnailJob::~WebThumbnailJob()
{
	delete m_webpage;
}

const QUrl & WebThumbnailJob::getUrl() const
{
	return m_url;
}

const QPixmap & WebThumbnailJob::getPixmap() const
{
	return m_pixmap;
}

enum WebThumbnailJob::State WebThumbnailJob::getState() const
{
	return m_state;
}

void WebThumbnailJob::loadStarted()
{
	m_state = Loading;
	emit started();
}

void WebThumbnailJob::loadFinished(bool b)
{
	if (b) {
		QImage image( QSize(256, 256), QImage::Format_ARGB32_Premultiplied);
		QPainter painter(&image);
		painter.setRenderHint(QPainter::Antialiasing, true);
		painter.setRenderHint(QPainter::TextAntialiasing, true);
		painter.setRenderHint(QPainter::SmoothPixmapTransform, true);
		m_webpage->mainFrame()->render(&painter, QRegion(0, 0, 256, 256) );
		painter.end();

		m_pixmap = QPixmap::fromImage(image);
		delete m_webpage;
		m_webpage = 0;
		m_state = Loaded;
		emit finished(m_pixmap);
	} else {
		m_state = Error;
		emit error();

		delete m_webpage;
		m_webpage = 0;
	}
	emit jobDone(this);
}

void WebThumbnailJob::start( bool js, bool plugins, int width, int height )
{
	m_webpage = new QWebPage;
	QWebSettings * settings = m_webpage->settings();
	settings->setAttribute( QWebSettings::AutoLoadImages, true);
	settings->setAttribute( QWebSettings::JavascriptEnabled, js);
	settings->setAttribute( QWebSettings::PluginsEnabled, plugins);
	settings->setAttribute( QWebSettings::JavaEnabled, false);
	settings->setAttribute( QWebSettings::DeveloperExtrasEnabled, false);
	settings->setAttribute( QWebSettings::OfflineStorageDatabaseEnabled, false);
	settings->setAttribute( QWebSettings::OfflineWebApplicationCacheEnabled, false);
	settings->setAttribute( QWebSettings::LocalStorageDatabaseEnabled, false);
	m_webpage->mainFrame()->setScrollBarPolicy(Qt::Horizontal, Qt::ScrollBarAlwaysOff);
	m_webpage->mainFrame()->setScrollBarPolicy(Qt::Vertical, Qt::ScrollBarAlwaysOff);
	m_webpage->mainFrame()->setZoomFactor( 0.5 );
	m_webpage->setViewportSize( QSize(width, height) );

	connect(m_webpage, SIGNAL(loadStarted()), this, SLOT(loadStarted()));
	connect(m_webpage, SIGNAL(loadProgress(int)), this, SLOT(loadProgress(int)));
	connect(m_webpage, SIGNAL(loadFinished(bool)), this, SLOT(loadFinished(bool)));
	m_webpage->mainFrame()->load( m_url );
}

void WebThumbnailJob::loadProgress(int p)
{
	emit progress(p);
}



