// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1
Item
{
    id : roundSelector
    width : 300
    height : 300
    property int centerX : x + width / 2
    property int centerY : y + height / 2
    property real oldAngle;
    property int  angle : 0;
    Component.onCompleted:
    {
        console.log(" x " + roundSelector.x + " y " + roundSelector.y + " width " + roundSelector.width + " height " + roundSelector.height);
    }

    function getPressedAngle(mouseX, mouseY)
    {
        var angle = Math.atan2(mouseY - roundSelector.centerY,
                               mouseX - roundSelector.centerX);
        if (angle < 0)
            angle += 2 * Math.PI;
        return angle;
    }

    function radianToDegree(angle)
    {
        return (180 * angle / Math.PI);
    }

    function angleDiff(angle)
    {
        while(angle < roundSelector.oldAngle)
            angle += 2 * Math.PI;
        return (angle - roundSelector.oldAngle);
    }
    Image
    {
        id : selectorImg
        source : "UIElements/roundselector.png"
    }
    MouseArea
    {
        anchors.fill: parent
        onPressed:
        {
            roundSelector.oldAngle = roundSelector.getPressedAngle(mouseX, mouseY);
            console.log("Old Angle " + radianToDegree(roundSelector.oldAngle));
            console.log("Center X " + roundSelector.centerX + " Center Y" + roundSelector.centerY);
        }
        onPositionChanged:
        {
            var currentAngle = angleDiff(roundSelector.getPressedAngle(mouseX, mouseY));
            roundSelector.angle = radianToDegree(currentAngle);
            roundSelector.rotation = roundSelector.angle;
            console.log("Current Angle " + roundSelector.angle);
        }
    }
}
