// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1
import Qt.labs.folderlistmodel 1.0

Item
{
    id : contact_item
    property int currentContactId : -1;
    property bool isFriend;
    property string curUsername : "";
    width : (main_win_rec.width)
    height : (main_win_rec.height - (2 * tepee.mobileRes))
    y : tepee.mobileRes
    x : 0

    Component
    {
        id : contact_delegate_info
        Item
        {
            id : main_rec
            width : contact_inf_rec.width
            height : contact_inf_rec.height
            scale : info_contact_del_ma.pressed ? 0.9 : 1

            MouseArea
            {
                id : info_contact_del_ma
                anchors.fill: parent

                onClicked:
                {
                    contact_view.currentIndex = index;
                    contact_view_info.currentIndex = index;
                    currentContactId = contact_id;
                    switchToBigView(contact_firstname, contact_lastname, contact_address, contact_email,
                                    contact_homenumber, contact_cellnumber, contact_imgsrc, contact_birthday);

                }
                onPressAndHold:
                {
                    currentContactId = contact_id;
                    switchToEditView(contact_firstname, contact_lastname, contact_address, contact_email
                                     , contact_homenumber, contact_cellnumber, contact_imgsrc, contact_birthday);
                }
            }

            Rectangle
            {
                id : pic_rec
                anchors.top: parent.top
                anchors.right: parent.right
                anchors.margins: tepee.mobileRes / 2
                width : tepee.mobileRes
                height : tepee.mobileRes
                border.width : 4
                border.color : "grey"
                radius : 15
                color : "transparent"
                Image
                {
                    anchors.fill : parent
                    source : contact_imgsrc
                }
            }
            Text
            {
                id : fname_i
                anchors.left : parent.left
                anchors.top : pic_rec.bottom
                anchors.margins: tepee.mobileRes / 4
                color : "white"
                text : contact_firstname
                font.pointSize: (tepee.mobileRes == 139) ? 22 : (tepee.mobileRes == 80) ? 14 : 6
            }
            Text
            {
                id : lname_i
                anchors.top : fname_i.bottom
                anchors.topMargin : tepee.mobileRes / 8
                anchors.left : parent.left
                anchors.leftMargin:  tepee.mobileRes / 2
                color : "white"
                text : contact_lastname
                font.pointSize: (tepee.mobileRes == 139) ? 25 : (tepee.mobileRes == 80) ? 16 : 7
            }
        }
    }

    function switchToEditView(fname, lname, addr, email, hnum, cnum, img, db, friend, user)
    {
        contact_edit_add.opacity = 1;
        contact_edit_add.y = 0;
        list_item.y =  main_win_rec.height;
        //        contact_inf_rec.y =  main_win_rec.height;
        contact_add_choose.opacity = 0;
        tepee_user_search_box.opacity = 0;
        list_item.opacity = 0;
        //        contact_inf_rec.opacity = 0;
        fname_tb.inputText = fname;
        lname_tb.inputText = lname;
        email_tb.inputText = email;
        home_tb.inputText = hnum;
        cell_tb.inputText = cnum;
        addr_tb.inputText = addr;
        id_img_tb.source = img;
        console.log("DATE " + db);
        birth_selec_rec.birthDate = db;
        if (friend)
            isFriend = true;
        else
            isFriend = false;
        if (user)
            curUsername = user;
    }

    function switchToBigView(fname_, lname_, addr, email_, hnum, cnum, img, db)
    {
        list_item.y =  main_win_rec.height;
        //        contact_inf_rec.y =  main_win_rec.height;
        contact_big_view.x = tepee.mobileRes;
        list_item.opacity = 0;
        contact_add_choose.opacity = 0;
        //        contact_inf_rec.opacity = 0;
        contact_big_view.opacity = 1;
        contact_big_view.fname = fname_;
        contact_big_view.lname = lname_;
        contact_big_view.haddr = addr;
        contact_big_view.email = email_;
        contact_big_view.hnumber = hnum;
        contact_big_view.cnumber = cnum;
        contact_big_view.imgsrc = img;
        contact_big_view.birthday = db
    }

    function switchToReadView()
    {
        contact_edit_add.opacity = 0;
        contact_big_view.opacity = 0;
        tepee_user_search_box.opacity = 0;
        contact_big_view.x = - 2 * main_win_rec.width;
        contact_edit_add.y = -main_win_rec.height;
        list_item.y =  0;
        //        contact_inf_rec.y = 0;
        list_item.opacity = 1;
        //        contact_inf_rec.opacity = 1;
        contact_view.currentIndex = -1;
        contact_view_info.currentIndex = -1;
    }

    function    switchToAddView()
    {
        //        contact_edit_add.y = 0;
        list_item.y =  main_win_rec.height;
        //        contact_inf_rec.y =  main_win_rec.height;
        contact_add_choose.y = 0;

        contact_edit_add.opacity = 0;
        list_item.opacity = 0;
        //        contact_inf_rec.opacity = 0;
        contact_add_choose.opacity = 1;
    }

    Component
    {
        id : contact_highlight_info
        Rectangle
        {
            gradient :
                Gradient {
                GradientStop {position : 0.0; color : tepee.highLightColor}
                GradientStop {position : 1.0; color : tepee.highLightColor2}
            }
            opacity : 0.4
            radius : 45
            smooth : true
            width : contact_inf_rec.width
            height : contact_inf_rec.height
        }
    }


    ////////CONTACT IN SMALL LIST ON LEFT

    Component
    {
        id : contact_delegate
        Item
        {
            id : del_rec
            width : content_rec.width
            height : tepee.mobileRes
            //            color : "transparent"
            scale : contact_list_view_ma.pressed ? 0.9 : 1
            Rectangle
            {
                gradient :
                    Gradient    {
                    GradientStop {position : 0.0; color : "#000033"}
                    GradientStop {position : 1.0; color : tepee.elemBackColor}
                }
                opacity : 0.4
                smooth : true
                radius : 15
                border.color : "grey"
                border.width: 1
                anchors.fill: parent
            }
            Text
            {
                id : fname_t
                anchors.verticalCenter: parent.verticalCenter
                anchors.left : parent.left
                anchors.leftMargin: tepee.mobileRes / 2
                text : contact_firstname
                font.pointSize: (tepee.mobileRes == 139) ? 15 : (tepee.mobileRes == 80) ? 12 : 4
                color : "white"
            }
            Text
            {
                id : lname_t
                anchors.verticalCenter: parent.verticalCenter
                anchors.left : fname_t.right
                anchors.leftMargin: tepee.mobileRes / 4
                text : contact_lastname
                font.pointSize: (tepee.mobileRes == 139) ? 15 : (tepee.mobileRes == 80) ? 12 : 4
                color : "white"
            }
            Rectangle
            {
                width : tepee.mobileRes / 2
                height : width
                radius : 360
                smooth : true
                anchors
                {
                    verticalCenter : parent.verticalCenter
                    right : parent.right
                    rightMargin : tepee.mobileRes / 2
                }
                gradient :
                    Gradient {
                    GradientStop {position : 0.0; color : "#01DF01"}
                    GradientStop {position : 1.0; color : "#298A08"}
                }
                Text
                {
                    text : "T"
                    anchors.centerIn: parent
                    color : "white"
                    font.pointSize: tepee.textSize
                }

                opacity : contact_friend ? opacity = 1 : opacity = 0;
            }

            MouseArea
            {
                id : contact_list_view_ma
                anchors.fill: parent
                onClicked:
                {
                    contact_view.currentIndex = index;
                    contact_view_info.currentIndex = index;
                    currentContactId = contact_id;
                }
                onDoubleClicked:
                {

                }
            }
        }
    }

    Component
    {
        id : contact_highlight
        Rectangle
        {
            gradient :
                Gradient {
                GradientStop {position : 0.0; color : tepee.highLightColor}
                GradientStop {position : 1.0; color : tepee.highLightColor2}
            }
            opacity : 0.4
            radius : 15
            smooth : true
            id : highlight_rec
            width : content_rec.width
            height : tepee.mobileRes
        }
    }

    Item
    {
        id : list_item
        width : parent.width
        height : parent.height
        x : 0
        y : 0
        // REC ON LEFT WITH SMALL CONTACTS
        Behavior on y {NumberAnimation {duration : 500}}
        Behavior on opacity {NumberAnimation {duration : 500}}
        Item
        {
            id : contact_rec
            anchors
            {
                left : parent.left
                right : parent.horizontalCenter
                top : parent.top
                bottom : parent.bottom
                topMargin : tepee.mobileRes / 4
                bottomMargin : tepee.mobileRes / 4
                leftMargin : tepee.mobileRes / 2
                rightMargin : tepee.mobileRes / 2
            }
            Rectangle
            {
                id : content_rec
                border.width: 2
                border.color: "grey"
                radius : 45
                color : tepee.elemBackColor
                opacity : tepee.elemBackOpacity
                anchors.fill : parent

            }
            ListView
            {
                id : contact_view
                anchors.fill: parent
                clip : true
                scale : 0.9
                model : contactModel
                delegate: contact_delegate
                highlight : contact_highlight
                highlightMoveSpeed: 800
                spacing : 2
            }
        }

        // EDIT ADD CONTACT MOD
        Rectangle
        {
            id : contact_inf_rec
            anchors
            {
                left : parent.horizontalCenter
                right : parent.right
                top : parent.top
                bottom : parent.bottom
                topMargin : tepee.mobileRes / 4
                bottomMargin : tepee.mobileRes / 4
                leftMargin : tepee.mobileRes / 2
                rightMargin : tepee.mobileRes / 2
            }
            color : "transparent"
            Rectangle
            {
                anchors.fill: parent
                color : tepee.elemBackColor
                opacity : tepee.elemBackOpacity
                radius : 45
                border.color: "grey"
                border.width: 2
            }
            ListView
            {
                id : contact_view_info
                anchors.fill: contact_inf_rec
                clip : true
                spacing : 2
                model : contactModel
                delegate: contact_delegate_info
                highlight : contact_highlight_info
                orientation : ListView.Horizontal
                highlightMoveSpeed: 1600
            }
        }

        //ADD CONTACT BUTTON
        Button
        {
            id : back_button
            anchors.horizontalCenter: parent.horizontalCenter
            anchors.bottom: parent.verticalCenter
            buttonColor: "blue"
            buttonShape: "round"
            resImg: tepee.mobileRes
            numId : 136
            text : "New"
            opacity : 1
            onButtonClicked:
            {
                currentContactId = -1;
                switchToAddView();
                //                switchToEditView("", "", "", "", "", "", "", new Date());

            }
        }
        // DELETE CONTACT_BUTTON
        Button
        {
            id : del_button
            anchors.top : parent.verticalCenter
            anchors.horizontalCenter: parent.horizontalCenter
            //        anchors.verticalCenter: contact_rec.verticalCenter
            buttonColor: "red"
            buttonShape: "round"
            resImg: tepee.mobileRes
            numId : 136
            text : "Del"
            opacity : 1
            onButtonClicked:
            {
                if (currentContactId != -1)
                {
                    del_check_item.opacity = 1;
                    list_item.opacity = 0;
                }
                else
                {
                    empty_del.opacity = 1;
                }
            }
        }
    }
    // DELE CHECK
    Item
    {
        id : del_check_item
        opacity: 0
        Behavior on opacity {NumberAnimation {duration : 500}}
        width: main_win_rec.width / 2
        height: main_win_rec.height / 3
        y : main_win_rec.height / 2 - del_check_item.height
        x : main_win_rec.width / 2 - del_check_item.width / 2
        Rectangle
        {
            anchors.fill: parent
            color : tepee.elemBackColor
            opacity : tepee.elemBackOpacity
            radius : 15
        }
        Text
        {
            anchors.centerIn: parent
            text : "Do you really want to delete this contact ?"
            color : "white"
            font.pointSize: (tepee.mobileRes == 139) ? 15 : (tepee.mobileRes == 80) ? 12 : 4
        }
        Button
        {
            id : validateDelButton
            anchors.bottom: parent.bottom
            anchors.bottomMargin: 5
            x : (parent.width / 2) - validateDelButton.width
            buttonColor: "blue"
            buttonShape: "rectangle"
            text : "Yes"
            resImg : tepee.mobileRes
            numId : 170
            opacity : 1
            onButtonClicked:
            {
                if (currentContactId != -1)
                    apCtrl.removeContact(currentContactId);
                currentContactId = -1;
                del_check_item.opacity = 0;
                list_item.opacity = 1;
            }
        }
        Button
        {
            id : cancelDelButton
            anchors.bottom: parent.bottom
            anchors.bottomMargin: 5
            anchors.left : validateDelButton.right
            buttonColor: "red"
            buttonShape: "rectangle"
            text : "No"
            resImg : tepee.mobileRes
            numId : 171
            opacity : 1
            onButtonClicked:
            {
                del_check_item.opacity = 0;
                list_item.opacity = 1;
            }
        }

    }

    // NO CONTACT SELECTED
    Item
    {
        id : empty_del
        opacity: 0
        Behavior on opacity {NumberAnimation {duration : 500}}
        width: main_win_rec.width / 3
        height: main_win_rec.height / 3
        y : main_win_rec.height / 2 - empty_del.height
        x : main_win_rec.width / 2 - empty_del.width / 2
        Rectangle
        {
            anchors.fill: parent
            color : tepee.elemBackColor
            opacity : tepee.elemBackOpacity
            radius : 15
        }
        Text
        {
            anchors.centerIn: parent
            text : "No Contact Selected"
            color : "white"
            font.pointSize: (tepee.mobileRes == 139) ? 15 : (tepee.mobileRes == 80) ? 12 : 4
        }
        MouseArea
        {
            anchors.fill: parent
            onClicked:
            {
                empty_del.opacity = 0;
            }
        }
    }

    // CONTACT BIG View

    Item
    {
        id : contact_big_view
        opacity : 0
        x : - 2 * main_win_rec.width;
        width : main_win_rec.width - (2 * tepee.mobileRes)
        height : main_win_rec.height - (2 * tepee.mobileRes)
        property string fname;
        property string lname;
        property string email;
        property string haddr;
        property string hnumber;
        property string cnumber;
        property date birthday;
        property string imgsrc;
        Behavior on x {NumberAnimation {duration : 500}}
        Behavior on opacity {NumberAnimation {duration : 500}}


        Rectangle
        {
            color : tepee.elemBackColor
            opacity : tepee.elemBackOpacity
            border.color: "grey"
            border.width : 2
            radius : 45
            anchors.fill: parent;
        }

        Button
        {
            id : back_contact_button
            anchors.top: parent.bottom
            anchors.topMargin: -tepee.mobileRes / 2
            anchors.horizontalCenter: parent.horizontalCenter
            resImg : tepee.mobileRes
            numId : 177
            text : "Back"
            buttonColor: "blue"
            buttonShape: "round"
            opacity : 1
            onButtonClicked:
            {
                switchToReadView();
            }
        }

        Text
        {
            id : fname_i
            anchors.left : parent.left
            anchors.top : parent.top
            anchors.margins: tepee.mobileRes / 2
            color : "white"
            text : contact_big_view.fname;
            font.pointSize: (tepee.mobileRes == 139) ? 22 : (tepee.mobileRes == 80) ? 14 : 6
        }
        Text
        {
            id : lname_i
            anchors.left : parent.left
            anchors.top: fname_i.bottom
            anchors.leftMargin:  tepee.mobileRes
            color : "white"
            text : contact_big_view.lname;
            font.pointSize: (tepee.mobileRes == 139) ? 25 : (tepee.mobileRes == 80) ? 16 : 7
        }


        Rectangle
        {
            id : contact_img_big
            anchors.top: parent.top
            anchors.right: parent.right
            anchors.margins: tepee.mobileRes / 2
            width : 2 * tepee.mobileRes
            height : 2 * tepee.mobileRes
            border.width : 4
            border.color : "grey"
            radius : 15
            color : "transparent"
            Image
            {
                anchors.fill : parent
                source : contact_big_view.imgsrc;
            }
        }
        Text
        {
            id : birth_i
            anchors.top : contact_img_big.bottom
            anchors.topMargin : tepee.mobileRes / 4
            anchors.left: contact_img_big.left
            text : "BirthDay : " + Qt.formatDate(contact_big_view.birthday, "dd/MM/yyyy");
            font.pointSize: (tepee.mobileRes == 139) ? 15 : (tepee.mobileRes == 80) ? 12 : 4
            color : "white"
        }
        Text
        {
            id : email_i
            anchors.top : lname_i.bottom
            anchors.topMargin : tepee.mobileRes / 2
            anchors.left : fname_i.left
            text : contact_big_view.email
            font.pointSize: (tepee.mobileRes == 139) ? 15 : (tepee.mobileRes == 80) ? 12 : 4
            color : "white"
        }
        Rectangle
        {
            Image
            {
                source : "ui_svg/mail.png";
                smooth : true;
                anchors.centerIn: parent;
                scale: (tepee.mobileRes === 139) ? 1 : (tepee.mobileRes === 80) ? 0.8 : 0.6
                height: (tepee.mobileRes === 139) ? 80 : (tepee.mobileRes === 80) ? 60 : 60
                width: (tepee.mobileRes === 139) ? 80 : (tepee.mobileRes === 80) ? 60 : 60
            }
            scale : ecall_ma.pressed ? 0.9 : 1.0
            color : "blue"
            opacity : email_i.text.length > 0 ? 1.0 : 0
            gradient :
                Gradient {
                GradientStop {position : 0.0; color : "#01DF01"}
                GradientStop {position : 1.0; color : "#298A08"}
            }
            smooth : true
            radius : 15
            width : tepee.mobileRes / 2
            height : tepee.mobileRes / 2
            anchors
            {
                left : numc_i.right
                leftMargin : tepee.mobileRes / 4
                top : email_i.top
                topMargin : - tepee.mobileRes / 8
            }
            MouseArea
            {
                id : ecall_ma
                anchors.fill : parent
                onClicked:
                {
                    Qt.openUrlExternally("mailto:" + email_i.text);
                }
            }
        }


        Text
        {
            id : numh_i
            anchors.top : email_i.bottom
            anchors.topMargin  : tepee.mobileRes / 2
            anchors.left: parent.left
            anchors.leftMargin: tepee.mobileRes / 2
            text : (contact_big_view.hnumber != "") ? "Home Number : " +  contact_big_view.hnumber : ""
            font.pointSize: (tepee.mobileRes == 139) ? 15 : (tepee.mobileRes == 80) ? 12 : 4
            color : "white"
        }
        Rectangle
        {
            scale : hcall_ma.pressed ? 0.9 : 1.0
            opacity : numh_i.text.length > 0 ? 1.0 : 0
            Image
            {
                source : "ui_svg/phone.png";
                smooth : true;
                anchors.centerIn: parent;
                scale: (tepee.mobileRes === 139) ? 1 : (tepee.mobileRes === 80) ? 0.8 : 0.6
                height: (tepee.mobileRes === 139) ? 80 : (tepee.mobileRes === 80) ? 60 : 60
                width: (tepee.mobileRes === 139) ? 80 : (tepee.mobileRes === 80) ? 60 : 60
            }

            color : "blue"
            gradient :
                Gradient {
                GradientStop {position : 0.0; color : tepee.highLightColor}
                GradientStop {position : 1.0; color : tepee.highLightColor2}
            }
            smooth : true
            radius : 15
            width : tepee.mobileRes / 2
            height : tepee.mobileRes / 2
            anchors
            {
                left : numc_i.right
                leftMargin : tepee.mobileRes / 4
                top : numh_i.top
                topMargin : - tepee.mobileRes / 8
            }
            MouseArea
            {
                id : hcall_ma
                anchors.fill : parent
                onClicked:
                {
                    Qt.openUrlExternally("tel:" + numh_i.text);
                }
            }
        }

        Text
        {
            id : numc_i
            opacity : numc_i.text.length > 0 ? 1.0 : 0
            anchors.top : numh_i.bottom
            anchors.topMargin : tepee.mobileRes / 2
            anchors.left: parent.left
            anchors.leftMargin: tepee.mobileRes / 2
            text : (contact_big_view.cnumber != "") ? "Cell Number      : " + contact_big_view.cnumber : ""
            font.pointSize: (tepee.mobileRes == 139) ? 15 : (tepee.mobileRes == 80) ? 12 : 4
            color : "white"
        }
        Rectangle
        {
            scale : ccall_ma.pressed ? 0.9 : 1.0
            opacity : numc_i.text.length > 0 ? 1.0 : 0

            Image
            {
                source : "ui_svg/phone.png";
                smooth : true;
                anchors.centerIn: parent;
                scale: (tepee.mobileRes === 139) ? 1 : (tepee.mobileRes === 80) ? 0.8 : 0.6
                height: (tepee.mobileRes === 139) ? 80 : (tepee.mobileRes === 80) ? 60 : 60;
                width: (tepee.mobileRes === 139) ? 80 : (tepee.mobileRes === 80) ? 60 : 60;
            }
            color : "blue"
            gradient :
                Gradient {
                GradientStop {position : 0.0; color : tepee.highLightColor}
                GradientStop {position : 1.0; color : tepee.highLightColor2}
            }
            smooth : true
            radius : 15
            width : tepee.mobileRes / 2
            height : tepee.mobileRes / 2
            anchors
            {
                left : numc_i.right
                leftMargin : tepee.mobileRes / 4
                top : numc_i.top
                topMargin : - tepee.mobileRes / 8
            }
            MouseArea
            {
                id : ccall_ma
                anchors.fill : parent
                onClicked:
                {
                    Qt.openUrlExternally("tel:" + numc_i.text);
                }
            }
        }
    }


    // ADD TYPE SELECTOR

    Item
    {
        id : contact_add_choose
        width : main_win_rec.width - (2 * tepee.mobileRes)
        height : main_win_rec.height - (2 * tepee.mobileRes)
        x : tepee.mobileRes
        y : - main_win_rec.height
        opacity : 0
        Behavior on y {NumberAnimation {duration : 500}}
        Behavior on opacity {NumberAnimation {duration : 750}}

        Item
        {
            scale : add_tepee_user_rec_ma.pressed ? 0.9 : 1
            anchors
            {
                margins : tepee.mobileRes
                right : parent.horizontalCenter
                left : parent.left
                top : parent.top
                bottom : parent.bottom
            }
            Rectangle
            {
                id : add_tepee_user_rec
                color : tepee.elemBackColor
                opacity : tepee.elemBackOpacity
                radius : 45
                anchors.fill: parent
            }
            MouseArea
            {
                id : add_tepee_user_rec_ma
                anchors.fill: parent
                onClicked :
                {
                    tepee_user_search_box.opacity = 1;
                    tepee_user_search_box.inText = "Search Contact Here"
                    contact_add_choose.opacity = 0;
                }
            }
            Text
            {
                text : "Add New Tepee User"
                color : "white"
                anchors.centerIn : add_tepee_user_rec
                font.pointSize: tepee.textSize

            }
        }

        Item
        {
            scale : add_standard_user_ma.pressed ? 0.9 : 1
            anchors
            {
                margins : tepee.mobileRes
                left : parent.horizontalCenter
                right : parent.right
                top : parent.top
                bottom : parent.bottom
            }
            Rectangle
            {
                id : add_standard_user
                color : tepee.elemBackColor
                opacity : tepee.elemBackOpacity
                radius : 45
                anchors.fill: parent
            }
            MouseArea
            {
                id : add_standard_user_ma
                anchors.fill: parent
                onClicked:
                {
                    switchToEditView("", "", "", "", "", "", "", new Date());
                }
            }
            Text
            {
                text : "Add New Regular User"
                color : "white"
                anchors.centerIn : add_standard_user
                font.pointSize: tepee.textSize
            }

        }
    }

    // Tepee User Search Box
    SearchBox
    {
        id : tepee_user_search_box
        x : tepee.mobileRes
        width : main_win_rec.width - (2 * tepee.mobileRes)
        height : main_win_rec.height - (2 * tepee.mobileRes)
        opacity : 0;
        Behavior on opacity {NumberAnimation {duration : 750}}
        onContactSelected :
        {
            switchToEditView(firstname, lastname, addr, email, hnum, cnum, "", new Date(), true, username);
        }
        onBackPressed:
        {
            switchToReadView();
        }
    }



    //// WINDOW FOR CONTACT EDITION
    Item
    {

        id : contact_edit_add
        y : - main_win_rec.height
        opacity: 0
        Behavior on y {NumberAnimation {duration : 500}}
        Behavior on opacity {NumberAnimation {duration : 500}}
        width : main_win_rec.width - (2 * tepee.mobileRes)
        height : main_win_rec.height - (2 * tepee.mobileRes)
        x : tepee.mobileRes

        Rectangle
        {
            id : content_edit_rec
            color : tepee.elemBackColor
            opacity : tepee.elemBackOpacity
            border.color: "grey"
            border.width : 2
            radius : 45
            width : main_win_rec.width - (2 * tepee.mobileRes)
            height : main_win_rec.height - (2 * tepee.mobileRes)
            Behavior on rotation {NumberAnimation {duration : 500}}
        }
        Flickable
        {
            anchors.fill: parent
            id : contact_edit_flick
            contentWidth: contact_edit_add.width
            contentHeight: 2 * contact_edit_add.height
            clip: true
            Item
            {
                id : input_fields
                anchors.fill: parent
                Behavior on opacity {NumberAnimation {duration : 500}}
                TextBox
                {
                    id : fname_tb
                    width : content_edit_rec.width / 4
                    //  height: (mobileView == 139) ? 30 : (mobileView == 80) ? 25 : 15
                    anchors.top : parent.top
                    anchors.topMargin: tepee.mobileRes / 2
                    anchors.left: parent.left
                    anchors.leftMargin: tepee.mobileRes / 2
                    titleText: "FirstName :  ";
                    inputText: ""
                    inline : true;
                    mobileView: tepee.mobileRes
                    onInputTextChanged:
                    {
                        if (inputText.length >= 32 || inputText.length == 0)
                            line_edit = false;
                        else
                            line_edit = true;
                        inputRight(line_edit);
                    }
                }
                TextBox
                {
                    id : lname_tb
                    width : content_edit_rec.width / 4
                    // height: (mobileView == 139) ? 30 : (mobileView == 80) ? 25 : 15
                    anchors.top : fname_tb.bottom
                    anchors.topMargin: tepee.mobileRes / 4
                    anchors.left : parent.left
                    anchors.leftMargin: tepee.mobileRes / 2
                    inputText: ""
                    titleText: "LastName :   "
                    inline : true
                    mobileView: tepee.mobileRes
                    onInputTextChanged:
                    {
                        if (inputText.length >= 32 || inputText.length == 0)
                            line_edit = false;
                        else
                            line_edit = true;
                        inputRight(line_edit);
                    }
                }
                TextBox
                {
                    id : cell_tb
                    width : content_edit_rec.width / 4
                    //    height: (mobileView == 139) ? 30 : (mobileView == 80) ? 25 : 15
                    anchors.top : lname_tb.bottom
                    anchors.topMargin: tepee.mobileRes / 4
                    anchors.left : parent.left
                    anchors.leftMargin: tepee.mobileRes / 2
                    inputText: ""
                    titleText: "Cell Number :"
                    inline : true
                    mobileView: tepee.mobileRes
                    onInputTextChanged:
                    {
                        var reg2 = new RegExp("\d{10}");
                        var str = new String(inputText);
                        line_edit = false;
                        if (inputText.length == 10)
                            line_edit = true;
                        inputRight(line_edit);
                    }
                }
                TextBox
                {
                    id : home_tb
                    width : content_edit_rec.width / 4
                    //   height: (mobileView == 139) ? 30 : (mobileView == 80) ? 25 : 15
                    anchors.top : cell_tb.bottom
                    anchors.topMargin: tepee.mobileRes / 4
                    anchors.left : parent.left
                    anchors.leftMargin: tepee.mobileRes / 2
                    inputText: ""
                    titleText: "Home Number :"
                    inline : true
                    mobileView: tepee.mobileRes
                    onInputTextChanged:
                    {
                        var reg2 = new RegExp("\d{10}");
                        var str = new String(inputText);
                        line_edit = false;
                        if (inputText.length == 10)
                            line_edit = true;
                        inputRight(line_edit);
                    }
                }
                TextBox
                {
                    id : email_tb
                    width : content_edit_rec.width / 3
                    //   height: (mobileView == 139) ? 30 : (mobileView == 80) ? 25 : 15
                    anchors.top : home_tb.bottom
                    anchors.topMargin: tepee.mobileRes / 4
                    anchors.left : parent.left
                    anchors.leftMargin: tepee.mobileRes / 2
                    inputText: ""
                    titleText: "Email :      "
                    inline : true
                    mobileView: tepee.mobileRes
                    onInputTextChanged:
                    {
                        line_edit = false;
                        inputRight(line_edit);
                    }
                }
                TextBox
                {
                    id : addr_tb
                    width : 2 * content_edit_rec.width / 5
                    //   height: (mobileView == 139) ? 30 : (mobileView == 80) ? 25 : 15
                    anchors.top : email_tb.bottom
                    anchors.topMargin: tepee.mobileRes / 4
                    anchors.left : parent.left
                    anchors.leftMargin: tepee.mobileRes / 2
                    inputText: ""
                    titleText: "Address :    "
                    inline : true
                    mobileView: tepee.mobileRes
                }

                Text
                {
                    id : birthday_txt
                    anchors
                    {
                        left : addr_tb.left
                        top :  addr_tb.bottom
                        topMargin : tepee.mobileRes / 2
                    }
                    color : "white"
                    font.pointSize : tepee.textSize;
                    text : "BirthDay :             "
                }


                Rectangle
                {
                    id : birth_selec_rec
                    property date birthDate;
                    scale : birth_prev_ma.pressed ? 0.9 : 1
                    color : "transparent"
                    radius : 5
                    width : 2 * tepee.mobileRes
                    height : addr_tb.height
                    anchors
                    {
                        left : birthday_txt.right
                        verticalCenter : birthday_txt.verticalCenter
                    }
                    border
                    {
                        width : 3
                        color : "#4b4b4b"
                    }

                    MouseArea
                    {
                        id : birth_prev_ma
                        anchors.fill : parent
                        onClicked:
                        {
                            birth_date_selector.opacity = 1;
                            birth_date_selector.setNewDate(birth_selec_rec.birthDate);
                            input_fields.opacity = 0;
                            content_edit_rec.opacity = 0;
                        }
                    }
                    Text
                    {
                        id : birthday_set_prev_txt
                        anchors.centerIn: parent
                        color : "white"
                        font.pointSize: tepee.textSize
                        text : Qt.formatDate(birth_selec_rec.birthDate, "dd/MM/yyyy");
                    }
                }
                Rectangle
                {
                    scale : img_rec_ma.pressed ? 0.9 : 1
                    id : picture_contact_rec;
                    anchors.top : parent.top
                    anchors.topMargin: tepee.mobileRes / 2
                    width : 2 * tepee.mobileRes
                    height : 2 * tepee.mobileRes
                    x : content_edit_rec.width - (5 * tepee.mobileRes / 2)
                    radius : 15
                    border.color: "grey"
                    border.width : 8
                    color : "transparent"
                    Image
                    {
                        anchors.fill: parent
                        id : id_img_tb
                    }
                    MouseArea
                    {
                        id : img_rec_ma
                        anchors.fill: parent
                        onClicked:
                        {
                            input_fields.opacity = 0;
                            fileBrowserLoad.clearView = false;
                            fileBrowserLoad.source = "FileBrowser.qml"
                            fileBrowserLoad.opacity = 1;
                        }
                    }
                }
                Button
                {
                    id : save_edit_contact_button
                    anchors.top : picture_contact_rec.bottom
                    anchors.topMargin: tepee.mobileRes / 8
                    anchors.left: picture_contact_rec.left
                    buttonColor: "blue"
                    buttonShape: "rectangle"
                    numId : 130
                    resImg: tepee.mobileRes
                    text : "Save"
                    opacity : 1
                    onButtonClicked: saveContact()
                }
                Button
                {
                    id : cancel_edit_contact_button
                    anchors.top : picture_contact_rec.bottom
                    anchors.topMargin: tepee.mobileRes / 8
                    anchors.left: save_edit_contact_button.right
                    buttonColor: "red"
                    buttonShape: "rectangle"
                    resImg: tepee.mobileRes
                    numId : 131
                    text : "Cancel"
                    opacity : 1
                    onButtonClicked: switchToReadView();
                }

            }
        }

        ScrollBar
        {
            id: verticalScrollBar
            width: 12; height: contact_edit_flick.height - 12
            anchors.right: contact_edit_flick.right
            opacity: 0
            orientation: Qt.Vertical
            position: contact_edit_flick.visibleArea.yPosition
            pageSize: contact_edit_flick.visibleArea.heightRatio
        }

        states:
            [
            State
            {
                name: "ShowBars"
                when: contact_edit_flick.movingVertically
                PropertyChanges { target: verticalScrollBar; opacity: 1 }
            }
        ]


        BrowserLoader
        {
            id : fileBrowserLoad
            filename_loader : "file:///C:/Users/lemire_p";
            filterSearch_loader: ["*.png", "*.jpg"];
            width : content_edit_rec.width - tepee.mobileRes;
            height : content_edit_rec.height - tepee.mobileRes;
            cellHeight : tepee.mobileRes
            x : content_edit_rec.x + tepee.mobileRes / 2
            y : content_edit_rec.y + tepee.mobileRes / 2
            Behavior on opacity {NumberAnimation {duration : 500}}
            opacity: 0
            onSelectedNameChanged: contact_item.fileSelected(selectedName);
            onClearViewChanged: clearBrowser(clearView);
        }

        DatePicker
        {
            id : birth_date_selector
            opacity : 0
            backButton: true
            x : tepee.mobileRes
            anchors.fill: content_edit_rec
            viewType : 2
            onBackButtonClicked:
            {
                birth_selec_rec.birthDate = new Date(birth_date_selector.currentYear, birth_date_selector.currentMonthNum, birth_date_selector.currentDayNum)
                birth_date_selector.opacity = 0;
                content_edit_rec.opacity = tepee.elemBackOpacity;
                input_fields.opacity = 1;
            }
        }

    }

    function clearBrowser(p)
    {
        if (p)
        {
            input_fields.opacity = 1;
            fileBrowserLoad.opacity = 0;
            fileBrowserLoad.source = "";
        }
    }

    function fileSelected(file_path)
    {
        id_img_tb.source = file_path;
        clearBrowser(true);
    }

    function saveContact()
    {
        switchToReadView();
        console.log("ISFRINED VALUE ==== " + isFriend);
        if (currentContactId == -1)
            apCtrl.addContact(fname_tb.inputText, lname_tb.inputText,
                              email_tb.inputText, addr_tb.inputText,
                              home_tb.inputText, cell_tb.inputText,
                              id_img_tb.source, new Date(birth_date_selector.currentYear, birth_date_selector.currentMonthNum, birth_date_selector.currentDayNum), isFriend, curUsername);
        else
            apCtrl.editContact(fname_tb.inputText, lname_tb.inputText,
                               email_tb.inputText, addr_tb.inputText,
                               home_tb.inputText, cell_tb.inputText,
                               id_img_tb.source, birth_selec_rec.birthDate, currentContactId);
    }
}
