#include "filelogic.h"

Filelogic::Filelogic() : QObject()
{
    QString dir = QDir::homePath().toStdString().c_str();
    dir +=  "/ftp/" ;
    QDir d;
    if (!d.exists(dir))
        d.mkdir(dir);
    this->DirFtp = dir;
    this->filercvMod = new ListModel(new FileRcvElem, 0);
    this->ftp    = new QFtp;
    this->ftp->setTransferMode(QFtp::Active);
    QObject::connect(this->ftp, SIGNAL(stateChanged(int)), this, SLOT(rcvStateChange(int)));
    QObject::connect(this->ftp, SIGNAL(done(bool)), this, SLOT(endCommand(bool)));
    QObject::connect(this->ftp, SIGNAL(listInfo(QUrlInfo)), this, SLOT(listinfoaff(QUrlInfo)));
    QObject::connect(this->ftp, SIGNAL(dataTransferProgress(qint64,qint64)), this, SLOT(datatransaff(qint64,qint64)));
    QObject::connect(this->ftp, SIGNAL(dataTransferProgress(qint64,qint64)), this, SIGNAL(dataProgress(qint64,qint64)));

}


void Filelogic::connectToFtp(QString user , QString pass, QUrl addr)
{
    std::cout << "CONNECT TO HOST with user = " << user.toStdString() << " AND PASS = " << pass.toStdString()<< " AND ADDR = " << addr.toString().toStdString()<< std::endl;
   // this->ftp->connectToHost(addr.toString().toStdString().c_str());
    std::cout << "ID CONNECT = " << this->ftp->connectToHost(addr.toString(), 20021) << std::endl;
    std::cout << "ID LOGIN = " << this->ftp->login(user, pass)<< std::endl;
    std::cout << "ID LIST = " << this->ftp->list()<< std::endl;
}

void Filelogic::listFile()
{
    this->ftp->list();
}

void Filelogic::dowloadFile(QString name)
{
    std::cout << "DOWLOAD FILE"<< std::endl;
    QString dir = QDir::homePath().toStdString().c_str();
    dir +=  "/ftp/" ;
    dir +=  name;
    this->file = new QFile(dir.toStdString().c_str());
    if (file->open(QIODevice::WriteOnly))
        this->ftp->get(name, file);
}

void Filelogic::uploadFile(QString filename)
{
    std::cout << "UPLOAD" << std::endl;
    filename.remove(0, 8);
    this->file = new QFile(filename);
    int j = filename.lastIndexOf("/");
    filename.remove(0, j+1);
    if (this->file->open(QIODevice::ReadOnly))
        this->ftp->put(this->file, filename.toStdString().c_str());
    else
        std::cout << this->file->errorString().toStdString()<< std::endl;
    if (this->filercvMod->rowCount() > 0)
        this->filercvMod->removeRows(0, this->filercvMod->rowCount());
}

void Filelogic::rcvStateChange(int type)
{
    (void)type;
}

void Filelogic::endCommand(bool ok)
{
    (void)ok ;
}

void Filelogic::delFile(QString name, int id)
{
    ListItem *n = this->filercvMod->find(id);
    if (n == NULL)
        return ;
    int row = this->filercvMod->getRowFromItem(n);
    this->ftp->remove(name);
    if (this->filercvMod->rowCount() > 0)
        this->filercvMod->removeRow(row);
}

void Filelogic::datatransaff(qint64 done,qint64 total)
{
    if (done == total)
    {
        std::cout << "DOWLOAD OR UPLOAD END" << std::endl;
        this->file->close();
    }
    emit (dataProgress(done, total));
}

QString Filelogic::getDirFtp()
{
    return this->DirFtp;
}

void Filelogic::startCommand(int a)
{
    std::cout << "COMMAND ID " << a << " START" << std::endl;
}

void Filelogic::listinfoaff( const QUrlInfo & i)
{
    this->filercvMod->appendRow(new FileRcvElem(i.name(),i.size(), i.lastModified()));
}

//        ///////////////////////////  FILE_ELEM

int FileRcvElem::nextId = 0;

FileRcvElem::FileRcvElem(QObject *parent) : ListItem(parent)
{
    this->filename = "FileName";
    this->sizefile = 0;
    this->filercvId = FileRcvElem::nextId++;
}

FileRcvElem::FileRcvElem(QString name, qint64 size, QDateTime lur,  QObject*parent) : ListItem(parent)
{
    this->filename = name;
    this->sizefile = size;
    this->lu = lur;
    this->filercvId = FileRcvElem::nextId++;
}

int         FileRcvElem::id() const
{
    return (this->filercvId);
}

QVariant        FileRcvElem::data(int role) const
{
    switch (role)
    {
    case namefileRole :
        return this->getfilename();
    case sizefileRole :
        return this->getsizefile();
    case filercvIdRole :
        return this->getfilercvId();
    case luRole :
        return this->getlu();
    default :
        return QVariant();
    }
}

QHash<int, QByteArray> FileRcvElem::roleNames() const
{
    QHash<int, QByteArray> roles;
    roles[namefileRole] = "namefile";
    roles[sizefileRole] = "sizefile";
    roles[luRole] = "lu";
    roles[filercvIdRole] = "filercvId";
    return roles;
}

QString FileRcvElem::getfilename() const
{
    return this->filename;
}

qint64 FileRcvElem::getsizefile() const
{
    return this->sizefile;
}

int FileRcvElem::getfilercvId() const
{
    return this->filercvId;
}

ListModel* Filelogic::getfileftpMod()
{
    return this->filercvMod;
}

QDateTime FileRcvElem::getlu() const
{
    return this->lu;
}

