#ifndef COMMAND_H
#define COMMAND_H

#include "Description.h"
#include <map>
#include <stdlib.h>
#include <iostream>
#include <string.h>

class Command
{
public:
    Command();
    bool isCommandValid() const;
    int	parseCmd(unsigned char *data, int sizecmd);
    int getIdHeader() const;
    int getIdCmd() const;
    void setIdHeader(int);
    void setIdCmd(int);
    void setSize(int);
    unsigned char *ConvertToAnswer();
    int getSize() const;
    note *n;
    file *f;
    contact *c;
    bookmark *b;
    agenda *a;
    weather *w;
    setting *se;
    events *e;
    sys *sy;

private:
    int size;
    bool valid;
    int IdHeader;
    int IdCmd;
    std::map<int, int (Command::*)(unsigned char *, int) > TabCmdHead;
    int SaveHeaderNote(unsigned char *, int);
    int SaveHeaderFile(unsigned char *, int);
    int SaveHeaderContact(unsigned char *, int);
    int SaveHeaderBookmark(unsigned char *, int);
    int SaveHeaderAgenda(unsigned char *, int);
    int SaveHeaderWeather(unsigned char *, int);
    int SaveHeaderSetting(unsigned char *, int);
    int SaveHeaderEvent(unsigned char *, int);
    int SaveHeaderSys(unsigned char *, int);

    std::map<int, unsigned char* (Command::*)() > TabConvert;
    unsigned char *ConvertToAnswerNote();
    unsigned char *ConvertToAnswerFile();
    unsigned char *ConvertToAnswerContact();
    unsigned char *ConvertToAnswerBookmark();
    unsigned char *ConvertToAnswerAgenda();
    unsigned char *ConvertToAnswerWeather();
    unsigned char *ConvertToAnswerSetting();
    unsigned char *ConvertToAnswerEvents();
    unsigned char *ConvertToAnswerSys();

};

#endif // COMMAND_H
