#include "webpreviewelem.h"

webPreviewElem::webPreviewElem(QObject *parent) : QDeclarativeItem()
{
    this->currentStatus = Idle;
    this->currentProgress = 0;
    this->radius = 0;
    this->currentUrl = "";
    this->ctx = NULL;
    this->setFlag(QGraphicsItem::ItemHasNoContents, false);
}

webPreviewElem::~webPreviewElem()
{
}

QUrl        webPreviewElem::getUrl() const
{
    return this->currentUrl;
}

int         webPreviewElem::getProgress() const
{
    return this->currentProgress;
}

webPreviewElem::Status webPreviewElem::getStatus() const
{
    return this->currentStatus;
}

int         webPreviewElem::getRadius() const
{
    return this->radius;
}

ThumbnailLoader *webPreviewElem::getContext() const
{
    return this->ctx;
}

void        webPreviewElem::setRadius(int s)
{
    this->radius = s;
}

void        webPreviewElem::setUrl(QUrl a)
{
    if (this->currentUrl != a)
    {
        this->currentUrl = a;
        emit urlChanged();
        if (!this->currentUrl.isEmpty() && this->ctx)
        {
            this->ctx->loadThumbnail(this);
        }
    }
}

void        webPreviewElem::setContext(ThumbnailLoader *t)
{
    if (!this->ctx)
        this->ctx = t;
}

void        webPreviewElem::paint(QPainter *p, const QStyleOptionGraphicsItem *, QWidget *)
{
    if (this->currentStatus == Ready && !this->webPix.isNull())
    {
        p->save();
        if (this->radius > 0)
        {
            QPainterPath    roundedPath;
            roundedPath.addRoundedRect(QRect(0, 0, width(), height()), this->radius, this->radius);
            p->setClipPath(roundedPath);
        }
        p->setRenderHint(QPainter::Antialiasing, true);
        p->setRenderHint(QPainter::HighQualityAntialiasing, true);
        p->setRenderHint(QPainter::SmoothPixmapTransform, true);
        p->drawPixmap(0,0, width(), height(), this->webPix);
        p->restore();
    }
}

void        webPreviewElem::componentComplete()
{
    if (!this->currentUrl.isEmpty() && this->ctx)
    {
        this->ctx->loadThumbnail(this);
    }
}

///////////////SLOTS//////////////

void        webPreviewElem::started()
{
    this->currentStatus = Loading;
    emit statusChanged();
}

void        webPreviewElem::progress(int i)
{
    if(i != this->currentProgress)
    {
        this->currentProgress = i;
        emit progressChanged();
    }
}

void        webPreviewElem::finished(const QPixmap &pm)
{
    this->currentStatus = webPreviewElem::Ready;
    this->webPix = pm;
    emit (statusChanged());
    this->update(); // Update Paint Area
}

void        webPreviewElem::error()
{
    this->currentStatus = Error;
    emit (statusChanged());
}

