 import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
//import QtQuick 1.1

Item
{
    property color selectedColor : Qt.hsla(hue, saturation, light / 1.2, 1);
    property real  selectedOpacity : alpha
    property real  hue : hue_slider.value;
    property real  saturation : cursor_elem.x / gradient_area.width;
    property real  light : 1 - cursor_elem.y / gradient_area.height;
    property real  alpha : alpha_slider.value;
    property color hueColor : Qt.hsla(hue, 1, 0.5, 1);

    signal okPressed();
    signal cancelPressed();

    Rectangle
    {
        id : gradient_area
        width : 3 * tepee.mobileRes
        height : width
        color : "white"
        radius : 15
        Rectangle
        {
            radius : 15
            smooth : true
            anchors.fill: parent
            rotation: -90
            gradient: Gradient {
                GradientStop {
                    position: 0.0; color: "#FFFFFFFF"
                }
                GradientStop {
                    position: 1.0; color: hueColor
                }
            }
        }
        Rectangle
        {
            radius : 15
            smooth : true
            anchors.fill: parent
            gradient: Gradient {
                GradientStop {
                    position: 1.0; color: "#FF000000"
                }
                GradientStop {
                    position: 0.0; color: "#00000000"
                }
            }
        }
        Rectangle
        {
            id : cursor_elem
            radius : 360
            smooth : true
            color : "transparent"
            width : tepee.mobileRes / 4
            height : tepee.mobileRes / 4
            border
            {
                width : 2
                color : "grey"
            }
        }

        MouseArea
        {
            anchors.fill: parent
            property int oldX;
            property int oldY;
            onPressed: moveCursor(mouse);
            onPositionChanged: moveCursor(mouse);
            function   moveCursor(mouse)
            {
                cursor_elem.x = Math.max(parent.x, Math.min(parent.width - cursor_elem.width, mouseX));
                cursor_elem.y = Math.max(parent.y, Math.min(parent.height - cursor_elem.height, mouseY));
            }
        }
    }

    Rectangle
    {
        id : alpha_selector
        width: (tepee.screenSize == "large") ? tepee.mobileRes / 2 : 3 * tepee.mobileRes / 4;
        height: gradient_area.height
        color : "transparent"
        radius : 15
        anchors
        {
            left : hue_selector.right
            top : gradient_area.top
            leftMargin : tepee.mobileRes / 4
        }
        gradient: Gradient {
            GradientStop {
                position: 0.0; color: "black"
            }
            GradientStop {
                position: 1.0; color: "transparent"
            }
        }
        SliderElem
        {
            id : alpha_slider
            radius : parent.radius
            anchors.fill: parent
        }
    }

    Item
    {
        id : hue_selector
        width: (tepee.screenSize == "large") ? tepee.mobileRes / 2 : 3 * tepee.mobileRes / 4;
        height: gradient_area.height
        anchors
        {
            left : gradient_area.right
            top : gradient_area.top
            leftMargin : tepee.mobileRes / 2
        }

        Rectangle {
            radius : 15
            anchors.fill: parent
            gradient: Gradient {
                GradientStop { position: 1.0;  color: "#FF0000" }
                GradientStop { position: 0.85; color: "#FFFF00" }
                GradientStop { position: 0.76; color: "#00FF00" }
                GradientStop { position: 0.5;  color: "#00FFFF" }
                GradientStop { position: 0.33; color: "#0000FF" }
                GradientStop { position: 0.16; color: "#FF00FF" }
                GradientStop { position: 0.0;  color: "#FF0000" }
            }
        }
        SliderElem
        {
            anchors.fill: parent
            id : hue_slider
            radius : 15
        }
    }

    Rectangle
    {
        id : color_prev_rec
        color : selectedColor
        opacity: alpha
        radius : 25
        width : (tepee.screenSize == "large") ? 2 * tepee.mobileRes : tepee.mobileRes
        height : width
        border
        {
            width : 2
            color : "grey"
        }
        anchors
        {
            verticalCenter : hue_selector.verticalCenter
            right : parent.right
            rightMargin : tepee.mobileRes / 4
        }
    }

    Button
    {
        id : validate
        anchors
        {
            topMargin : tepee.mobileRes / 4
            top : color_prev_rec.bottom
            right : color_prev_rec.horizontalCenter
        }
        buttonColor: "blue"
        buttonShape: "rectangle"
        text : "Save"
        resImg : tepee.mobileRes
        numId : 170
        opacity : 1
        onButtonClicked:
        {
            okPressed();
        }
    }
    Button
    {
        id : cancel
        anchors
        {
            left : validate.right
            top : validate.top
        }
        buttonColor: "red"
        buttonShape: "rectangle"
        text : "Cancel"
        resImg : tepee.mobileRes
        numId : 171
        opacity : 1
        onButtonClicked:
        {
            cancelPressed();
        }
    }

}
