 import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
//import QtQuick 1.1

Item
{
    id : agenda_item
    y : tepee.mobileRes;
    property bool    isEdited : false;
    property int     currentTaskId : -1;
    // ITEM FOR TASK CREATION EDITION VIEW

    width : main_win_rec.width - (2 * tepee.mobileRes)
    height : main_win_rec.height - (2 * tepee.mobileRes)
    x : tepee.mobileRes
    Gradient
    {
        id : highlight_grad
        GradientStop {position : 0.0; color : tepee.highLightColor}
        GradientStop {position : 1.0; color : tepee.highLightColor2}
    }

    Item
    {
        id : task_edit_create

        property int startSelection : 0;
        property int taskStartDay;
        property int taskEndDay;
        property int taskStartMonth;
        property int taskEndMonth;
        property int taskStartYear;
        property int taskEndYear;

        property int taskStartHour;
        property int taskStartMin;
        property int taskEndHour;
        property int taskEndMin;

        width : main_win_rec.width - (2 * tepee.mobileRes)
        height : main_win_rec.height - (2 * tepee.mobileRes)
        Behavior on opacity {NumberAnimation {duration : 500}}
        opacity : 0
        Rectangle
        {
            anchors.fill: parent
            color : tepee.elemBackColor
            radius : 45
            opacity : tepee.elemBackOpacity
            border
            {
                color : "grey"
                width : 1
            }
        }
        onOpacityChanged:
        {
            if (isEdited)
            {
                task_reado_item.opacity = 0;
                task_edit_item.opacity = 1;
            }
            else
            {
                task_reado_item.opacity = 1;
                task_edit_item.opacity = 0;
            }
        }

        // SHOWING TASK ELEM
        Item
        {
            opacity : 0
            id : task_reado_item
            anchors.fill: parent
            Text
            {
                id : title_txt
                anchors.top : parent.top
                anchors.topMargin : tepee.mobileRes / 2
                anchors.horizontalCenter: parent.horizontalCenter
                text : "Task Title Here"
                color : "white"
                font.pointSize : tepee.textSize;
            }
            Text
            {
                id : description_txt
                anchors.top : title_txt.bottom
                anchors.topMargin: tepee.mobileRes
                anchors.horizontalCenter: parent.horizontalCenter
                text : "Task Description Here"
                color : "white"
                font.pointSize : tepee.textSize;
            }
            Rectangle
            {
                color : "transparent"
                radius : 45
                smooth : true
                border
                {
                    width : 1
                    color : "white"
                }
                anchors
                {
                    top : description_txt.bottom
                    left : parent.left
                    right : parent.horizontalCenter
                    bottom : parent.bottom
                    margins : tepee.mobileRes
                }
                Text
                {
                    id : start_date
                    font.pointSize : tepee.textSize;
                    anchors.left : parent.left
                    anchors.leftMargin : tepee.mobileRes / 2
                    anchors.verticalCenter: parent.verticalCenter
                    color : "white"
                    text : "Wed 09 Feb 2010"

                }
                Text
                {
                    id : start_time
                    font.pointSize : tepee.textSize;
                    anchors.left: start_date.right
                    anchors.leftMargin: tepee.mobileRes / 4
                    anchors.verticalCenter: parent.verticalCenter
                    text : "20 : 10"
                    color : "white"
                }
            }

            Rectangle
            {
                color : "transparent"
                radius : 45
                smooth : true
                border
                {
                    width : 1
                    color : "white"
                }
                anchors
                {
                    margins : tepee.mobileRes
                    top : description_txt.bottom
                    left : parent.horizontalCenter
                    right : parent.right
                    bottom : parent.bottom
                }
                Text
                {
                    id : end_date
                    font.pointSize : tepee.textSize;
                    anchors.left : parent.left
                    anchors.leftMargin : tepee.mobileRes / 2
                    anchors.verticalCenter: parent.verticalCenter
                    text : "Wed 09 Feb 2010"
                    color : "white"
                }
                Text
                {
                    id : end_time
                    font.pointSize : tepee.textSize;
                    anchors.left: end_date.right
                    anchors.leftMargin: tepee.mobileRes / 4
                    anchors.verticalCenter: parent.verticalCenter
                    text : "20 : 15"
                    color : "white"
                }
            }
        }

        // TASK EDITING PAGE
        Item
        {
            id : task_edit_item
            anchors.fill: parent
            TextBox
            {
                id : title_tbox
                inline : true
                inputText: ""
                titleText: "Task Title :  "
                width : parent.width / 3

                function checkInput()
                {
                    (inputText.length >= 32 || inputText.length == 0) ? inputRight(false) : inputRight(true);
                }
                onInputTextChanged:
                {
                    checkInput();
                }

                anchors
                {
                    left : parent.left
                    top : parent.top
                    topMargin : tepee.mobileRes / 2
                    leftMargin : tepee.mobileRes / 4
                }
            }
            TextEditArea
            {
                anchors
                {
                    left : parent.left
                    top : title_tbox.bottom
                    topMargin : tepee.mobileRes / 4
                    leftMargin : tepee.mobileRes / 4
                }
                id : content_tbox
                inline: true
                titleText: "Task Content :"
                inputText: ""
                width : parent.width / 2
                height : tepee.mobileRes
            }
            Row
            {
                spacing : tepee.mobileRes / 4
                anchors
                {
                    top : content_tbox.bottom
                    topMargin : tepee.mobileRes / 4
                    horizontalCenter : parent.horizontalCenter
                }
                SquareQmlButton
                {
                    id : start_date_button
                    width : tepee.mobileRes
                    height : tepee.mobileRes
                    text : "Start Date"
                    onButtonClicked:
                    {
                        start_date_picker.setSelectedDate(main_date_picker.currentDayNum, main_date_picker.currentMonthNum);
                        task_edit_create.startSelection = 1;
                        task_edit_create.opacity = 0;
                        start_date_picker.opacity = 1;
                    }
                }
                SquareQmlButton
                {
                    id : start_time_button
                    width : tepee.mobileRes
                    height : tepee.mobileRes
                    text : "Start Time"
                    onButtonClicked:
                    {
                        start_time_picker.setSelectedTime(0, 0);
                        task_edit_create.startSelection = 1;
                        task_edit_create.opacity = 0;
                        start_time_picker.opacity = 1;
                    }
                }
                SquareQmlButton
                {
                    id : end_date_button
                    width : tepee.mobileRes
                    height : tepee.mobileRes
                    text : "End Date"
                    onButtonClicked:
                    {
                        start_date_picker.setSelectedDate(main_date_picker.currentDayNum, main_date_picker.currentMonthNum);
                        task_edit_create.startSelection = 2;
                        task_edit_create.opacity = 0;
                        start_date_picker.opacity = 1;
                    }
                }
                SquareQmlButton
                {
                    id : end_time_button
                    width : tepee.mobileRes
                    height : tepee.mobileRes
                    text : "End Time"
                    onButtonClicked:
                    {
                        start_time_picker.setSelectedTime(22, 15);
                        task_edit_create.startSelection = 2;
                        task_edit_create.opacity = 0;
                        start_time_picker.opacity = 1;
                    }
                }
            }
        }

        Button
        {
            id : save_new_task_button
            anchors.bottom: parent.bottom
            anchors.right: parent.horizontalCenter
            resImg : tepee.mobileRes
            numId : 179
            text : "Save"
            buttonColor: "blue"
            buttonShape: "rectangle"
            opacity : 1
            onButtonClicked:
            {
                switchToCreateEditTaskView(false);
                if (isEdited && title_tbox.inputText.length > 0 && title_tbox.inputText.length <= 32)
                {
                    if (currentTaskId == -1) // NEW TASK
                        apCtrl.addTask(title_tbox.inputText,
                                       content_tbox.inputText,
                                       task_edit_create.taskStartHour,
                                       task_edit_create.taskStartMin,
                                       task_edit_create.taskStartDay,
                                       task_edit_create.taskStartMonth + 1,
                                       task_edit_create.taskStartYear,
                                       task_edit_create.taskEndHour,
                                       task_edit_create.taskEndMin,
                                       task_edit_create.taskEndDay,
                                       task_edit_create.taskEndMonth + 1,
                                       task_edit_create.taskEndYear);
                    else                    // EDITED TASK
                        apCtrl.editTask(title_tbox.inputText,
                                        content_tbox.inputText,
                                        task_edit_create.taskStartHour,
                                        task_edit_create.taskStartMin,
                                        task_edit_create.taskStartDay,
                                        task_edit_create.taskStartMonth + 1,
                                        task_edit_create.taskStartYear,
                                        task_edit_create.taskEndHour,
                                        task_edit_create.taskEndMin,
                                        task_edit_create.taskEndDay,
                                        task_edit_create.taskEndMonth + 1,
                                        task_edit_create.taskEndYear,
                                        currentTaskId);
                }
                start_date_button.text = "Start Date";
                end_date_button.text = "End Date";
                start_time_button.text = "Start Time";
                end_time_button.text = "End Time";
                content_tbox.inputText = "";
                title_tbox.inputText = "";
            }
        }

        Button
        {
            id : cancel_new_task_button
            anchors.bottom: parent.bottom
            anchors.left: parent.horizontalCenter
            resImg : tepee.mobileRes
            numId : 180
            text : "Cancel"
            buttonColor: "red"
            buttonShape: "rectangle"
            opacity : 1
            onButtonClicked:
            {
                if (text == "Del")
                    apCtrl.rmTask(currentTaskId);
                switchToCreateEditTaskView(false);
                start_date_button.text = "Start Date";
                end_date_button.text = "End Date";
                start_time_button.text = "Start Time";
                end_time_button.text = "End Time";
                content_tbox.inputText = "";
                title_tbox.inputText = "";
            }
        }
    }

    TimePicker
    {
        id : start_time_picker
        opacity : 0
        Behavior on opacity {NumberAnimation {duration : 500}}
        backButton: true
        onBackButtonClicked:
        {
            task_edit_create.opacity = 1;
            start_time_picker.opacity = 0;
            if (task_edit_create.startSelection == 1)
            {
                task_edit_create.taskStartHour = start_time_picker.currentHour;
                task_edit_create.taskStartMin = start_time_picker.currentMin;
                start_time_button.text = "Start Time \n   " + (start_time_picker.currentHour < 10 ? "0" : "") + start_time_picker.currentHour + " : " + ((start_time_picker.currentMin < 10) ? "0" : "") + start_time_picker.currentMin;
            }
            else if (task_edit_create.startSelection == 2)
            {
                task_edit_create.taskEndHour = start_time_picker.currentHour;
                task_edit_create.taskEndMin = start_time_picker.currentMin;
                end_time_button.text = "  End Time \n  " + (start_time_picker.currentHour < 10 ? "0" : "") + start_time_picker.currentHour + " : " + ((start_time_picker.currentMin < 10) ? "0" : "") + start_time_picker.currentMin;
            }
            task_edit_create.startSelection = 0;
        }
    }

    DatePicker
    {
        opacity : 0
        Behavior on opacity {NumberAnimation {duration : 500}}
        id : start_date_picker
        anchors.fill: parent
        backButton: true
        viewType: 1
        onBackButtonClicked:
        {
            start_date_picker.opacity = 0;
            task_edit_create.opacity = 1;
            if (task_edit_create.startSelection == 1)
            {
                start_date_button.text = " Start Date\n " + start_date_picker.currentDayNum + "/" + (start_date_picker.currentMonthNum + 1) + "/" + start_date_picker.currentYear
                task_edit_create.taskStartDay = start_date_picker.currentDayNum;
                task_edit_create.taskStartMonth = start_date_picker.currentMonthNum;
                task_edit_create.taskStartYear = start_date_picker.currentYear;
            }
            else if (task_edit_create.startSelection == 2)
            {
                end_date_button.text = "  End Date\n " + start_date_picker.currentDayNum + "/" + (start_date_picker.currentMonthNum + 1) + "/" + start_date_picker.currentYear
                task_edit_create.taskEndDay = start_date_picker.currentDayNum;
                task_edit_create.taskEndMonth = start_date_picker.currentMonthNum;
                task_edit_create.taskEndYear = start_date_picker.currentYear;
            }
            task_edit_create.startSelection = 0;
        }
    }

    function switchToCreateEditTaskView(switchBack)
    {
        if (!switchBack)
        {
            agenda_flip.opacity = 1;
            task_edit_create.opacity = 0;
            cancel_new_task_button.text = "Cancel";
        }
        else
        {
            agenda_flip.opacity = 0;
            task_edit_create.opacity = 1;
        }
    }

    Flipable
    {
        id : agenda_flip
        property bool flipped : false;
        anchors.fill: parent
        Behavior on opacity {NumberAnimation {duration : 500}}

        function flip()
        {
            agenda_flip.flipped = !agenda_flip.flipped
        }

        transform: Rotation {
            id: rotation_flip
            origin.x: parent.width / 2
            origin.y: main_win_rec.height / 2
            axis.x: 0; axis.y: 1; axis.z: 0
            angle: 0
        }

        states : State {
            name : "flipped_state"
            PropertyChanges {target: rotation_flip; angle : -  180}
            when : agenda_flip.flipped
        }

        transitions: Transition {
            NumberAnimation { target: rotation_flip; property: "angle"; duration: 750 }
            NumberAnimation { target: calendar_day_quick_view; property: "opacity"; duration: 500 }
            NumberAnimation { target: day_hours_view; property: "opacity"; duration: 500 }
        }


        // MAIN AGENDA SCREEN CALENDAR GRIDVIEW + QUICK DAY VIEW
        front : Item {
            id : calendar_day_quick_view
            opacity : 1
            width : main_win_rec.width
            height : main_win_rec.height - (2 * tepee.mobileRes)
            x : -tepee.mobileRes
            // CALENDAR VIEW
            DatePicker
            {
                id : main_date_picker
                anchors.fill : parent
                optionalMod: day_view
            }

            // NEW TASK BUTTON
            Button
            {
                id : new_task_edit_button
                anchors.horizontalCenter: parent.horizontalCenter
                anchors.top: parent.bottom
                anchors.topMargin: - tepee.mobileRes / 2
                resImg : tepee.mobileRes
                numId : 174
                text : " New \n Task "
                buttonColor: "blue"
                buttonShape: "round"
                opacity : 1
                onButtonClicked:
                {
                    isEdited = true;
                    currentTaskId = -1;
                    switchToCreateEditTaskView(true);
                }
            }

            // DAY QUICK INFO VIEW
            Item
            {
                id : agenda_rec

                anchors
                {
                    left : parent.horizontalCenter
                    right : parent.right
                    top : parent.top
                    bottom : parent.bottom
                    margins : tepee.mobileRes
                }

                ListView
                {
                    id : day_view
                    anchors.fill: parent
                    clip : true
                    model : main_date_picker.getDayModel()
                    delegate : day_info_delegate
                    highlight: day_highlight
                    highlightMoveSpeed: 2000
                }
            }
        }

        // DAY HOURS View
        back : Item {
            id : day_hours_view
            anchors.fill: parent
            Rectangle
            {
                id : content_hours_rec
                width : main_win_rec.width - (2 * tepee.mobileRes)
                height : main_win_rec.height - (2 * tepee.mobileRes)
//                x : -2 * tepee.mobileRes
                color : tepee.elemBackColor
                opacity : tepee.elemBackOpacity
                radius : 45
                border
                {
                    width : 2
                    color : "grey"
                }
            }


            // ADD LISTVIEW TO SEE WEEK TASK ALONG CURRENT DAY TASK
//            ListView
//            {
//                id : week_view
//                model :
//            }

            ListView
            {
                id : task_view
                clip : true
                delegate: task_delegate
                highlight: task_delegate_highlight
                model : taskModel
                highlightMoveSpeed: 2000
                spacing: 5

                anchors
                {
                    fill : content_hours_rec
                    topMargin : tepee.mobileRes / 2
                    bottomMargin : tepee.mobileRes / 2
                    leftMargin : tepee.mobileRes / 2
                    rightMargin : tepee.mobileRes / 4
                }
            }
            Button
            {
                id : back_button
                anchors.top: content_hours_rec.bottom
                anchors.topMargin: -tepee.mobileRes / 2
                anchors.horizontalCenter: content_hours_rec.horizontalCenter
                resImg : tepee.mobileRes
                numId : 177
                text : "Back"
                buttonColor: "blue"
                buttonShape: "round"
                opacity : 1
                onButtonClicked:
                {
                    agenda_flip.flip();
                }
            }
            states :
                State {name : "ShowBarTaskView"
                when : hour_view.movingVertically
                PropertyChanges {target: verticalScrollBarTaskView; opacity : 1}

            }
            ScrollBar
            {
                id: verticalScrollBarTaskView
                width: 12; height: task_view.height-12
                anchors.right: task_view.right
                anchors.top : task_view.top
                opacity: 0
                orientation: Qt.Vertical
                position: task_view.visibleArea.yPosition
                pageSize: task_view.visibleArea.heightRatio
            }
        }
    }


    // HIGHLIGHT OFDAY VIEW
    Component
    {
        id : day_highlight
        Rectangle
        {
            width : day_view.width
            height : day_view.height
            gradient : highlight_grad
            opacity : 0.4
            radius : 360
        }
    }

    // DAY VIEW DELEGATE
    Component
    {
        id : day_info_delegate
        Item
        {
            id : del_inf_item
            width : day_view.width
            height : day_view.height
            scale : del_inf_ma.pressed ? 0.9 : 1.0
            Rectangle
            {
                id : del_inf_back
                anchors.fill: parent
                color : tepee.elemBackColor
                opacity : tepee.elemBackOpacity
                radius : 360
                border
                {
                    color : "white"
                    width : 1
                }
            }
            Text
            {
                anchors.centerIn: parent
                font.pointSize: tepee.textSize
                text : dayName + " " + dayNum + " " + main_date_picker.currentMonthName;
                color : "white"
            }

            MouseArea
            {
                id : del_inf_ma
                anchors.fill: parent
                onClicked:
                {
                    main_date_picker.setDayIndex(index);
                    apCtrl.setTaskModelDate(main_date_picker.currentDayNum,
                                            main_date_picker.currentMonthNum + 1,
                                            main_date_picker.currentYear);
                    agenda_flip.flip();
                }
            }
        }
    }

    // TASK LIST VIEW DELEGATE
    Component
    {
        id : task_delegate_highlight
        Rectangle
        {
            //            width : hour_view.width
            width : task_view.width - tepee.mobileRes / 4
            height : width
            opacity : 0.4
            radius : 15
            gradient : highlight_grad
        }
    }

    Component
    {
        id : task_delegate
        Item
        {
            width : task_view.width
            height : tepee.mobileRes

            Item
            {
                id : task_time
                scale : std_ma.pressed ? 0.9 : 1
                width : tepee.mobileRes
                height : tepee.mobileRes
                //anchors.verticalCenter: parent.verticalCenter
                Rectangle
                {
                    anchors.fill: parent
                    opacity : tepee.elemBackOpacity
                    border
                    {
                        color : "grey"
                        width : 1
                    }
                    radius : 15;
                }
                Text
                {
                    anchors.centerIn: parent
                    color : "white"
                    font.pointSize: tepee.textSize
                }
                MouseArea
                {
                    id : std_ma
                    anchors.fill: parent
                    onClicked:
                    {
                        task_view.currentIndex = index;
                    }
                }
            }

            Item
            {
                anchors
                {
                    left : task_time.right
                }
                height : tepee.mobileRes;
                width : parent.width - task_time.width;
                scale : task_delegate_ma.pressed ? 0.9 : 1
                Rectangle
                {
                    color : tepee.elemBackColor
                    radius : 15
                    smooth : true
                    opacity : tepee.elemBackOpacity
                    anchors
                    {
                        fill: parent
                        leftMargin : tepee.mobileRes / 4
                        rightMargin: tepee.mobileRes / 4
                    }
                    border
                    {
                        width : 1
                        color : "grey"
                    }
                }
                MouseArea
                {
                    id : task_delegate_ma
                    anchors.fill: parent
                    onClicked :
                    {
                        switchToCreateEditTaskView(true);
                        isEdited = false;
                        title_txt.text = taskName;
                        description_txt.text = taskComment;
                        start_date.text = taskStartDay + "/" + taskStartMonth + "/" + taskStartYear;
                        end_date.text = taskEndDay + "/" + taskEndMonth + "/" + taskEndYear;
                        start_time.text = ((taskStartHour < 10) ? "0" : "") + taskStartHour + ":" + ((taskStartMin < 10) ? "0" : "") + taskStartMin
                        end_time.text = ((taskEndHour < 10) ? "0" : "") + taskEndHour + ":" + ((taskEndMin < 10) ? "0" : "") + taskEndMin
                        currentTaskId = taskId;
                    }
                    onPressAndHold:
                    {
                        cancel_new_task_button.text = "Del";
                        switchToCreateEditTaskView(true);
                        agenda_item.currentTaskId = taskId;
                        isEdited = true;

                        task_edit_create.taskStartDay = taskStartDay;
                        task_edit_create.taskStartMonth = taskStartMonth - 1;
                        task_edit_create.taskStartYear = taskStartYear;
                        task_edit_create.taskStartHour = taskStartHour;
                        task_edit_create.taskStartMin = taskStartMin;
                        task_edit_create.taskEndDay = taskEndDay;
                        task_edit_create.taskEndMonth = taskEndMonth - 1;
                        task_edit_create.taskEndYear = taskEndYear;
                        task_edit_create.taskEndHour = taskEndHour;
                        task_edit_create.taskEndMin = taskEndMin;

                        start_date_button.text = " Start Date\n " + taskStartDay + "/" + (taskStartMonth) + "/" + taskStartYear
                        end_date_button.text = "  End Date\n " + taskEndDay + "/" + (taskEndMonth) + "/" + taskEndYear
                        start_time_button.text = "Start Time \n   " + (taskStartHour < 10 ? "0" : "") + taskStartHour + " : " + ((taskStartMin < 10) ? "0" : "") + taskStartMin;
                        end_time_button.text = " End Time \n  " + (taskEndHour < 10 ? "0" : "") + taskEndHour + " : " + ((taskEndMin < 10) ? "0" : "") + taskEndMin;

                        title_tbox.inputText = taskName;
                        content_tbox.inputText = taskComment;
                        console.log(currentTaskId);
                    }
                }
                Text
                {
                    anchors.centerIn: parent
                    color : "white"
                    text : taskName
                    font.pointSize: tepee.textSize
                }
            }

        }
    }
}
