//import QtQuick 1.1
import Qt.labs.particles 1.0
 import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import "JSONParser.js" as JSParse

Item
{
    property int mobileView : tepee.mobileRes
    property string img_name : ""
    property string countrycurrent : apCtrl.getCountry();
    property string citycurrent : apCtrl.getCity()
    property bool   updating : false;
    id : weather_item
    opacity: 1;

    x : mobileView
    y : mobileView
    width: main_win_rec.width - (2 * mobileView)
    height: main_win_rec.height -(2 * mobileView)
    property string city : apCtrl.getCity()
    property string country : apCtrl.getCountry();
    property string apiKey : "bdf8add158082407112110"
    property string url : "http://api.wunderground.com/api/285be1289d39a912/forecast7day/conditions/q/" + country +"/" + city + ".json"
    property int elemWidth : main_win_rec.width / 10;

    function retrieveWeatherData()
    {
        updating = true;
        console.log("IN APP LOAD");
        JSParse.load(weather_item.url, weather_item, country, city,textErrorWeathor);
    }

    states :
        [
        State
        {
            name : "RefreshingWeather"
            when : updating
            PropertyChanges {target: showWeatherItem; opacity : 0.4}
        }
    ]



    BusyIndicator
    {
        anchors.centerIn: parent
        width : tepee.mobileRes
        height : width
        id : busyi
        on : updating
    }

    Item
    {
        Behavior on opacity {NumberAnimation {duration : 500}}
        id : showWeatherItem
        opacity : 1
        anchors.fill : parent

        // PATHVIEW
        PathView
        {
            id : pVLocation
            property int delW : tepee.mobileRes ;
            property int delH : tepee.mobileRes / 2;
            preferredHighlightBegin: 0.5
            preferredHighlightEnd: 0.5
            focus : true
//            clip : true
            anchors
            {
                top: parent.top
                bottom: weather_rec.top
                left : parent.left
                right : parent.right
                bottomMargin: mobileView / 2
            }
            model: weatherLocationModel
            delegate: delegateL
            path: Path {
                //                startY: pVLocation.y + 3 * delH
                startX : 0;
                startY: pVLocation.height / 4;
                PathAttribute { name: "z"; value: 0 }
                PathLine
                {
                    x : pVLocation.width / 4
                    y : pVLocation.height
                }
                // CENTER ELEM
                PathLine
                {
                    x : pVLocation.width / 2
                    y : pVLocation.height / 2
                }
                PathAttribute { name: "z"; value:  800}
                // END ELEM
                PathLine
                {
                    x : 3 * pVLocation.width / 4
                    y : pVLocation.height
                }
                PathAttribute { name: "z"; value: 0 }
                PathLine
                {
                    x : pVLocation.width
                    y : pVLocation.height / 4;
                }
            }
        }


        // CURRENT WEATHER REC
        Rectangle
        {
            id : weather_rec
            color : tepee.elemBackColor
            opacity : tepee.elemBackOpacity
            radius : 15
            border
            {
                width : 1
                color : "grey"
            }
            width : parent.width
            height : 2 * mobileView
            anchors
            {
                left : parent.left
                bottom : parent.bottom
                bottomMargin : (tepee.screenSize == "large" ? tepee.mobileRes : tepee.mobileRes / 2)
            }
            Text
            {
                id : textErrorWeathor
                //anchors.fill : parent
                text : ""
                color : "white"
                font.pointSize: tepee.textSize
                anchors.horizontalCenter: parent.horizontalCenter
                anchors.top : parent.top
                anchors.topMargin: mobileView / 2

            }
        }
        Button
        {
            id : syncWeatherButton; buttonColor: "green"; buttonShape: "rectangle"
            numId: 1;
            text: "Update";
            resImg: mobileView;
            clickActionState: ""
            anchors
            {
                horizontalCenter:weather_rec.horizontalCenter
                top : weather_rec.bottom
                topMargin : 15
            }

            onButtonClicked:
            {
                console.log("UPDATE PRESSED");
                retrieveWeatherData()
            }
            opacity : 1
        }
        Button
        {
            id : addWeatherButton; buttonColor: "green"; buttonShape: "rectangle"
            numId: 1;
            text: "Add";
            resImg: mobileView;
            clickActionState: ""
            anchors
            {
                topMargin : 15
                top :weather_rec.bottom
                left : syncWeatherButton.right
                leftMargin: tepee.mobileRes / 2
            }

            onButtonClicked:
            {
                console.log("ADD PRESSED");
                showWeatherItem.opacity = 0;
                weather_additem.opacity = 1;

            }
            opacity : 1
        }

        Button
        {
            id : delWeatherButton; buttonColor: "red"; buttonShape: "rectangle"
            numId: 1;
            text: "Del";
            resImg: mobileView;
            clickActionState: ""
            anchors
            {
                topMargin : 15
                top :weather_rec.bottom
                right : syncWeatherButton.left
                rightMargin : tepee.mobileRes / 2
            }

            onButtonClicked:
            {
                console.log("DEL PRESSED");
                apCtrl.deleteWeatherFromListViewAp()
                apCtrl.deleteWeatherLocationFromListView();
                apCtrl.setCityDefaults("");
                apCtrl.setCountryDefaults("");
                apCtrl.deleteDBWeather(countrycurrent, citycurrent)
                apCtrl.deleteWeatherLocationFromDb(countrycurrent, citycurrent);
                apCtrl.LoadLocationWeatherfromDBApp();
                apCtrl.LoadWeatherfromDBapp();
                pVLocation.currentIndex = 0;
                //showWeatherItem.opacity = 0;
                // weather_additem.opacity = 1;

            }
            opacity : 1
        }
        ListView
        {
            id : view
            anchors.fill: weather_rec
            model : weatherModel
            interactive: true
            orientation : ListView.Horizontal
            spacing : 5
            clip : true
            delegate: weather_del
        }


        Component
        {
            id : weather_del
            Rectangle
            {
                color : "transparent"
                width: elemWidth
                height: 2 * (mobileView)
                Rectangle
                {

                    anchors.fill : parent;
                    //                opacity : 0.40
                    radius : 10
                    smooth : true
                    //                color : tepee.elemBackColor
                    color : "transparent"
                    border.color : "grey"
                    border.width : 2
                }
                Text
                {
                    id : dayId
                    anchors.top: parent.top
                    anchors.topMargin: 5
                    anchors.horizontalCenter: parent.horizontalCenter
                    text: weatherNameday + " " + weatherNumday + " " + weatherNamemonth
                    color : "white";
                    font.pointSize: tepee.textSize
                }

                Rectangle
                {
                    id : weather_icon
                    property int curentDateTime
                    property string iconName
                    anchors.top : dayId.bottom
                    anchors.topMargin: 5
                    anchors.verticalCenter: parent.verticalCenter
                    anchors.horizontalCenter: parent.horizontalCenter
                    curentDateTime: Qt.formatTime(new Date(), "h")
                    iconName : "weather_icons/day_" +
                               weatherCondition + ((mobileView == 139) ? "_175.png" : "_80.png")
                    Image
                    {
                        id: weather_img
                        source: weather_icon.iconName
                        anchors.horizontalCenter: parent.horizontalCenter
                        //                    anchors.fill: parent
                    }
                }
                Text
                {
                    id : conditionId
                    anchors.bottom: parent.bottom
                    anchors.bottomMargin: 5
                    anchors.horizontalCenter: parent.horizontalCenter
                    text: weatherCondition;
                    color : "white";
                    font.pointSize: tepee.textSize
                }
                Text
                {
                    id : tempId
                    anchors.bottom: conditionId.top
                    anchors.horizontalCenter: parent.horizontalCenter
                    text: weatherHighttemp + " / " + weatherLowtemp + " C";
                    color : "white";
                    font.pointSize: tepee.textSize
                }
            }
        }

    }

    Item
    {
        Behavior on opacity {NumberAnimation {duration : 500}}
        id : weather_additem
        opacity: 0;
        anchors.fill : parent
        Rectangle
        {
            //anchors.fill : parent;
            id : rectaddweather
            opacity : tepee.elemBackOpacity
            color : tepee.elemBackColor
            width :  4 * mobileView;
            height : 4 * mobileView
            smooth : true
            radius : 45
            border.color : "grey"
            border.width : 10
            //            x : 2 * mobileView
            y : mobileView / 2
            anchors.horizontalCenter: weather_additem.horizontalCenter
        }
        TextBox
        {

            id : countryBoxWeather
            titleText : "Country :  "
            width : parent.width / 5
            //anchors.centerIn: parent
           // height: (mobileView == 139) ? 30 : (mobileView == 80) ? 25 : 15
            inputText : ""
            //            anchors.top : addWeatherButton.bottom
            mobileView: tepee.mobileRes
            x :  rectaddweather.x + mobileView / 3
            y :  rectaddweather.y + mobileView
        }
        TextBox
        {
            opacity  : 1
            id : cityboxWeather
            titleText : "City :     "
            width : parent.width / 5
          //  height: (mobileView == 139) ? 30 : (mobileView == 80) ? 25 : 15
            inputText : ""
            anchors.topMargin: mobileView / 2
            anchors.top: countryBoxWeather.bottom
            anchors.left: countryBoxWeather.left
            x : 2 * mobileView
            y : 2 * mobileView
        }
        Button
        {
            opacity  : 1
            id : addWeatherButtondata; buttonColor: "green"; buttonShape: "round"
            numId: 1;
            text: "Add";
            resImg: mobileView;
            clickActionState: ""
            anchors
            {
                //horizontalCenter:weather_rec.horizontalCenter
                topMargin : mobileView  / 2
                top : cityboxWeather.bottom
                //left : cityboxWeather.right
                right : rectaddweather.right
                rightMargin : mobileView / 2
            }
            onButtonClicked:
            {
                console.log("ADD DATA PRESSED");
                apCtrl.deleteWeatherFromListViewAp();
                apCtrl.deleteWeatherLocationFromListView();

                showWeatherItem.opacity = 1;
                weather_additem.opacity = 0;
                apCtrl.addNewLocation(countryBoxWeather.inputText, cityboxWeather.inputText);
                apCtrl.LoadWeatherfromDBapp();
                apCtrl.LoadLocationWeatherfromDBApp();
                pVLocation.currentIndex = 0;
                countryBoxWeather.inputText = "";
                cityboxWeather.inputText = "";

            }
        }
        Button
        {
            opacity  : 1
            id : backaddWeatherButtondata; buttonColor: "red"; buttonShape: "round"
            numId: 1;
            text: "Back";
            resImg: mobileView;
            clickActionState: ""
            anchors
            {
                //horizontalCenter:weather_rec.horizontalCenter
                topMargin : mobileView / 2
                top : cityboxWeather.bottom
                // right : addWeatherButtondata.left
                left:rectaddweather.left
                leftMargin: mobileView / 2
                rightMargin : mobileView

            }

            onButtonClicked:
            {
                console.log("MOBILEVIEW" +mobileView);
                console.log("ADD DATA PRESSED");
                showWeatherItem.opacity = 1;
                weather_additem.opacity = 0;
            }

        }
    }


    Component
    {
        id: delegateL
        Item
        {
            id: wrapper
            width: mobileView * 2
            height: mobileView
            z : PathView.z
            property bool current: PathView.isCurrentItem
            scale : PathView.isCurrentItem ? (del_pv_ma.pressed ? 0.9 : 1.0) : (del_pv_ma.pressed ? 0.7 : 0.8)

            onCurrentChanged:{
                if (current)
                {
                    countrycurrent = weatherLocationCountry;
                    citycurrent = weatherLocationCity
                           textErrorWeathor.text = "";
                    apCtrl.setCity(weatherLocationCity);
                    apCtrl.setCountry(weatherLocationCountry);
                    apCtrl.deleteWeatherFromListViewAp();
                    apCtrl.LoadWeatherfromDBapp(weatherLocationCity, weatherLocationCountry);
                }
            }
            Rectangle
            {
                id : del_rec_back
                gradient :
                    Gradient    {
                    GradientStop {position : 0.0; color : "#44A51C"}
                    GradientStop {position : 1.0; color : "#003300"}
                }
                radius: 50
                anchors.fill: parent
                smooth: true
                opacity: wrapper.PathView.isCurrentItem ? 1 : 0.7
                border.color: wrapper.PathView.isCurrentItem ? "yellow" : "green"
                border.width: 1
                Text
                {
                    id: nameTex
                    text : weatherLocationCity + " , " + weatherLocationCountry
                    font.pointSize: tepee.textSize
                    color: "white"
                    opacity: wrapper.PathView.isCurrentItem ? 1 : 0.8
                     anchors.centerIn: del_rec_back
                }
            }
            MouseArea
            {
                id : del_pv_ma
                anchors.fill: parent
                onClicked:
                {
                    pVLocation.currentIndex = index;
                    textErrorWeathor.text = "";
                }
                onPressAndHold:
                {
                    retrieveWeatherData();
                    textErrorWeathor.text = "";
                }
            }
        }
    }
}

