//import QtQuick 1.1
 import QtQuick 1.0 // to target S60 5th Edition or Maemo 5

Item
{
    id : note_item
    y : tepee.mobileRes
    x : tepee.mobileRes
    width : main_win_rec.width - (2 * tepee.mobileRes)
    height : main_win_rec.height - (2 * tepee.mobileRes)
    property int noteIdCur;
    focus : true


    // DEL CHECK WINDOW
    Item
    {
        id : del_check_item
        opacity: 0
        Behavior on opacity {NumberAnimation {duration : 500}}
        width: main_win_rec.width / 2
        height: main_win_rec.height / 3
        anchors.centerIn: parent
        Rectangle
        {
            anchors.fill: parent
            color : tepee.elemBackColor
            opacity : tepee.elemBackOpacity
            radius : 15
        }
        Text
        {
            anchors.centerIn: parent
            text : "Do you really want to delete this note ?"
            color : "white"
            font.pointSize: tepee.textSize
        }
        Button
        {
            id : validateDelButton
            anchors.bottom: parent.bottom
            anchors.bottomMargin: 5
            x : (parent.width / 2) - validateDelButton.width
            buttonColor: "blue"
            buttonShape: "rectangle"
            text : "Yes"
            resImg : tepee.mobileRes
            numId : 170
            opacity : 1
            onButtonClicked:
            {
                del_check_item.opacity = 0;
                deleteNoteButton.clearButton();
                apCtrl.removeNote(noteIdCur);
            }
        }
        Button
        {
            id : cancelDelButton
            anchors.bottom: parent.bottom
            anchors.bottomMargin: 5
            anchors.left : validateDelButton.right
            buttonColor: "red"
            buttonShape: "rectangle"
            text : "No"
            resImg : tepee.mobileRes
            numId : 171
            opacity : 1
            onButtonClicked:
            {
                del_check_item.opacity = 0;
                addEditItem.opacity = 1;
            }
        }

    }

    // ADD NOTE REC
    Item
    {
        id : addEditItem
        opacity : 0
        anchors.fill : parent
        Behavior on opacity {NumberAnimation {duration : 500}}
        Rectangle
        {
            id : addNoteRec
            width: main_win_rec.width / 2
            height: main_win_rec.height / 2
            anchors.centerIn: parent
            opacity : tepee.elemBackOpacity
            color : tepee.elemBackColor
            smooth : true
            radius : 25
            border.color : "grey"
            border.width : 2
        }

        TextBox
        {
            id : newNoteTitle
            inline: false
            titleText: "Title : "
            inputText : ""
            width : addNoteRec.width - 15
            opacity: 0.75
            //height : (mobileView == 139) ? 55 : (mobileView == 80) ? 50 : 35
            mobileView: tepee.mobileRes
            anchors.top: addNoteRec.top
            anchors.topMargin: 10
            anchors.left: addNoteRec.left
            anchors.leftMargin: 4

            // CHECK TITLE
            onInputTextChanged:
            {
                if (inputText.length >= 32 || inputText.length == 0)
                    line_edit = false;
                else
                    line_edit = true;
                inputRight(line_edit);
            }

        }

        TextEditArea
        {
            id : newNoteContent
            inline : false
            width : addNoteRec.width - 15
            opacity: 0.75
            height : addNoteRec.height - (newNoteTitle.height + anchors.topMargin + newNoteTitle.anchors.topMargin + 20)
            titleText: "Content : "
            inputText: ""
            mobileView: tepee.mobileRes
            anchors.top: newNoteTitle.bottom
            anchors.left: addNoteRec.left
            anchors.leftMargin: 4

            // CHECK TITLE
            onInputTextChanged:
            {
                if (inputText.length >= 2000 || inputText.length == 0)
                    line_edit = false;
                else
                    line_edit = true;
                inputRight(line_edit);
            }
        }

        Button
        {
            id : addNoteButton
            anchors.top: addNoteRec.bottom
            anchors.topMargin: 5
            x : addNoteRec.x + addNoteRec.width / 2 - addNoteButton.width
            buttonColor: "blue"
            buttonShape: "rectangle"
            text : "Add"
            resImg : tepee.mobileRes
            numId : 100
            opacity : 1
            onButtonClicked:
            {
                if (newNoteContent.line_edit && newNoteTitle.line_edit)
                {
                    if (addNoteButton.text == "Add")
                        apCtrl.addNote(newNoteTitle.inputText, newNoteContent.inputText, noteIdCur);
                    else if (addNoteButton.text == "Update")
                    {
                        console.log("update");
                        addNoteButton.text = "Add";
                        deleteNoteButton.text = "Clear";
                        apCtrl.editNote(newNoteTitle.inputText, newNoteContent.inputText, noteIdCur);
                    }

                    list_note_item.opacity = 1;
                    addEditItem.opacity = 0;
                    newNoteContent.clearInput();
                    newNoteTitle.clearInput();
                }
            }
        }

        Button
        {
            id : deleteNoteButton
            anchors.top: addNoteRec.bottom
            anchors.topMargin: 5
            anchors.left: addNoteButton.right
            buttonColor: "red"
            buttonShape: "rectangle"
            text : "Clear"
            resImg : tepee.mobileRes
            numId : 101
            opacity : 1
            onButtonClicked:
            {
                if (deleteNoteButton.text == "Del")
                {
                    addEditItem.opacity = 0;
                    del_check_item.opacity = 1;
                }
                else if (deleteNoteButton.text == "Clear")
                    clearButton();
            }

            function clearButton()
            {
                if (deleteNoteButton.text == "Del")
                {
                    addNoteButton.text = "Add";
                    deleteNoteButton.text = "Clear";
                }
                list_note_item.opacity = 1;
                addEditItem.opacity = 0;
                newNoteContent.clearInput();
                newNoteTitle.clearInput();
            }
        }
    }

    Item
    {
        id : list_note_item
        anchors.fill: parent
        PathView
        {
            anchors.centerIn: parent
            id : note_view
            pathItemCount: 5
            width: main_win_rec.width;
            height: main_win_rec.height * 3 / 5;
            y : 0 //1 * tepee.mobileRes
            x : 0
            //            orientation: ListView.Horizontal
            model : noteModel
            focus : true
            // ADD A NOTE AND CALL ap apCtrl.addNote(string, string, date);
//            clip : true
            delegate: note_delegate
            //            highlight: highlight_elem
            //            highlightMoveSpeed: 1600

            Keys.onRightPressed: if (!moving && interactive) incrementCurrentIndex()
            Keys.onLeftPressed: if (!moving && interactive) decrementCurrentIndex()
            onCurrentIndexChanged: {quick_acces_list.currentIndex = currentIndex}
            highlightMoveDuration: 300;
            preferredHighlightBegin: 0.5
            preferredHighlightEnd: 0.5
            path : Path
            {
            startX: 0;
            startY: tepee.mobileRes * 3;
            PathAttribute { name: "z"; value: 0 }
            //            PathAttribute { name: "angle"; value: 70 }
            PathAttribute { name: "iconScale"; value: 0.5 }
            PathAttribute { name: "opacityV"; value: 0.5 }

            PathLine { x : (main_win_rec.width) / 2 ; y : tepee.mobileRes * 2;}
            PathAttribute { name: "z"; value:   400 }
            //            PathAttribute { name: "angle"; value: 0 }
            PathAttribute { name: "iconScale"; value: 1.0 }
            PathAttribute { name: "opacityV"; value: 1.0 }

            PathLine { x : main_win_rec.width ; y : tepee.mobileRes * 2;}
            PathAttribute { name: "z"; value: 0 }
            //            PathAttribute { name: "angle"; value: -70 }
            PathAttribute { name: "iconScale"; value: 0.5}
            PathAttribute { name: "opacityV"; value: 0.5 }
        }

    }

    Item
    {
        width : tepee.mobileRes
        height : main_win_rec.height * 3 / 5
        anchors.verticalCenter: parent.verticalCenter
        anchors.right: list_note_item.right
        Rectangle
        {
            anchors.fill: parent
            color : tepee.elemBackColor
            opacity : tepee.elemBackOpacity
            radius : 15
            smooth : true
            border.color : "white"
            border.width: 1
        }
        ListView
        {
            id : quick_acces_list
            anchors.fill: parent
            clip : true
            model : noteModel
            delegate: quick_note_del
            highlight: quick_highlight
            highlightMoveSpeed: 1600
        }

    }



    Button
    {
        id : add_nnote_button
        anchors.horizontalCenter: note_view.horizontalCenter
        anchors.top : note_view.bottom
        anchors.topMargin: - tepee.mobileRes / 4
        buttonColor: "blue"
        buttonShape: "round"
        resImg: tepee.mobileRes
        numId : 136
        text : "New"
        opacity : 1
        onButtonClicked:
        {
            list_note_item.opacity = 0;
            addEditItem.opacity = 1;
        }
    }

}
//HIGHLIGHT_ELEM
Component
{
    id : highlight_elem
    Rectangle
    {
        width: main_win_rec.width / 1
        height: main_win_rec.height / 1
        smooth : true
        gradient :
            Gradient {
            GradientStop {position : 0.0; color : tepee.highLightColor}
            GradientStop {position : 1.0; color : tepee.highLightColor2}
        }
        opacity : 0.4
        radius : 45
    }
}


// NOTE DELEGATE
Component
{
    id : note_delegate

    Flipable
    {
        id : main_rec
        scale : note_del_ma.pressed ? PathView.iconScale - 0.1 : PathView.iconScale
        opacity : PathView.opacityV
        z : PathView.z
        width: main_win_rec.width  / 3
        height: main_win_rec.height / 3
        property bool flipped : false
        property bool isCurrent : PathView.isCurrentItem

        MouseArea
        {
            id : note_del_ma
            anchors.fill : parent
            onClicked :
            {
                console.log(isCurrent);
                note_view.currentIndex = index;
                quick_acces_list.currentIndex = index;
                main_rec.flipped = !main_rec.flipped;
            }
            onPressAndHold:
            {

                list_note_item.opacity = 0;
                addEditItem.opacity = 1;

                note_item.noteIdCur = noteId
                addNoteButton.text = "Update"
                deleteNoteButton.text = "Del"
                newNoteContent.clearInput();
                newNoteTitle.clearInput();
                newNoteTitle.inputText = delegateTitle.text
                newNoteContent.inputText = delegateContent.text
            }
        }


        transform: Rotation {
            id: rotation_elem
            origin.x: main_rec.width/2
            origin.y: main_rec.height/2
            axis.x: 0; axis.y: 1; axis.z: 0
            angle: 0
        }

        states : State  {
            name : "back";
            PropertyChanges {target: rotation_elem; angle : 180}
            PropertyChanges {target: main_rec; width : main_win_rec.width / 2; height : main_win_rec.height / 2}
            when :   main_rec.flipped && main_rec.PathView.isCurrentItem
        }
        transitions: Transition {
            NumberAnimation { target: rotation_elem; property: "angle"; duration: 500 }
            NumberAnimation { target: main_rec; property: "height"; duration: 500 }
            NumberAnimation { target: main_rec; property: "width"; duration: 500 }
        }



        front : Item        {
            id : front_item
            anchors.fill: parent

            Rectangle
            {
                anchors.fill : parent
                gradient :
                    Gradient    {

                    //YELLOW
                    //                GradientStop {position : 0.0; color : "#CCFF00"}
                    //                GradientStop {position : 1.0; color : "#FF9900"}

                    GradientStop {position : 0.0; color : "#44A51C"}
                    GradientStop {position : 1.0; color : "#003300"}
                }
                opacity :  main_rec.isCurrent ? 0.9 : 0.7
                smooth : true
                radius : 45
                border.color : main_rec.isCurrent ? "yellow" : "green"
                border.width : 1
            }

            Text
            {
                id : delegateTitle
                clip : true
                anchors
                {
                    horizontalCenter : parent.horizontalCenter
                    bottom : parent.verticalCenter
                    bottomMargin : tepee.mobileRes / 2
                }
                font.pointSize: tepee.textSize
                text : notetitle
                color : "white"
            }
            Text
            {
                anchors
                {
                    horizontalCenter : parent.horizontalCenter
                    top : parent.verticalCenter
                    topMargin : tepee.mobileRes / 4
                }
                font.pointSize: tepee.textSize
                color : "white"
                text : getSmallContent(notecontent);
                function    getSmallContent(cnt)
                {
                    var str = new String(cnt);
                    if (str.length > 32)
                        str = str.substring(0, 32);
                    str += "...";
                    return (str);
                }
            }


        }
        back : Item        {
            id : back_item
            anchors.fill: parent
            Rectangle
            {
                anchors.fill : parent
                gradient :
                    Gradient    {

                    //YELLOW
                    GradientStop {position : 0.0; color : "#CCFF00"}
                    GradientStop {position : 1.0; color : "#FF9900"}

                    //                    GradientStop {position : 0.0; color : "#44A51C"}
                    //                    GradientStop {position : 1.0; color : "#003300"}
                }
                opacity :  main_rec.PathView.isCurrentItem ? 0.9 : 0.6
                smooth : true
                radius : 45
                border.color : "black"
                border.width : 1
            }

            Text
            {
                id : delegateContent
                wrapMode: Text.WordWrap
//                maximumLineCount: 10
                clip : true
                x : parent.width / 8
                width : 3 * parent.width / 4
                font.pointSize: tepee.textSize
                anchors.verticalCenter: parent.verticalCenter

                text : notecontent
                color : "white"
            }
        }
    }

}


// QUICK NOTE delegate
Component
{
    id : quick_note_del
    Item
    {
        width : tepee.mobileRes
        height : tepee.mobileRes
        scale : quick_del_ma.pressed ? 0.9 : 1
        Rectangle
        {
            anchors.fill: parent
            gradient :
                Gradient    {
                GradientStop {position : 0.0; color : "#000033"}
                GradientStop {position : 1.0; color : "black"}
            }
            opacity : 0.4
            radius : 15
            smooth : true
            border.color : "grey"
            border.width: 1
        }
        Text
        {
            id : note_title_txt
            anchors.centerIn: parent
            text : noteId;
            color : "white"
            font.pointSize: tepee.textSize
        }
        MouseArea
        {
            id : quick_del_ma
            anchors.fill: parent
            onClicked:
            {
                note_view.currentIndex = index;
                quick_acces_list.currentIndex = index;
            }
        }
    }
}
//QUICK NOTE HIGHLIGHT
Component
{
    id : quick_highlight
    Rectangle
    {
        width: tepee.mobileRes
        height: tepee.mobileRes
        gradient :
            Gradient {
            GradientStop {position : 0.0; color : tepee.highLightColor}
            GradientStop {position : 1.0; color : tepee.highLightColor2}
        }
        opacity : 0.4
        radius : 15
    }
}

}


