 import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
//import QtQuick 1.1
import Qt.labs.folderlistmodel 1.0


//FAIRE UNE LISTVIEW QUI CONTIENDRA PLUSIEURS LISTVIEW QUI SERONT LES REPERTOIRES

Item
{
    function getFileNameFromPath(str_param)
    {
        var str = str_param.toString();
        return (str.substring(str.lastIndexOf("/")));
    }

    function getParentDirFromPath(str_p)
    {
        var str = str_p.toString();
        return (str.substring(0, str.lastIndexOf("/")));
    }

    id : browser_item
    signal selectedFile(string file);
    signal clearView(bool cViewBool);
    property string previousPath;
    property string filename : loader_browser.getFilename();
    property variant filtersearch : loader_browser.getFilterSearch();
    property int cellHeight : tepee.mobileRes;
    property int cellWidth : folder_view.width
    property string selected_name;

    onSelected_nameChanged:
    {
        console.log("Selected Name changed " + selected_name);
        selectedFile(selected_name);
    }

    Component.onCompleted: {console.log("fname " + filename);}

    ListView
    {
        id : folder_view
        anchors.fill: browser_item
        spacing : 2
        clip : true
        onModelChanged: {console.log("Model was changed size : " + folder_view.count);}
        FolderListModel
        {
            id : folder_model
            folder : filename
            sortField: FolderListModel.Type
            nameFilters : browser_item.filtersearch;
        }
        model : folder_model
        delegate:
            Component       {
            id : folder_component
            FileLoader
            {
                width : browser_item.cellWidth
                height : browser_item.cellHeight
                filename_loader: fileName;
                showPic : loader_browser.getShowPic()
                source: (folder_model.isFolder(index)) ? "FolderDelegate.qml" : "FileDelegate.qml"
            }
        }
        header :
            Component        {
            id : header_del
            Rectangle
            {
                width : browser_item.cellWidth
                height : browser_item.cellHeight
                color : "transparent"
                scale : header_ma.pressed ? 0.9 : 1
                Rectangle
                {
                    id : back_header
                    gradient :
                        Gradient    {
                        GradientStop {position : 0.0; color : "darkblue"}
                        GradientStop {position : 1.0; color : "black"}
                    }
                    opacity : 0.7
                    radius : 15
                    anchors.fill : parent
                }
                Text
                {
                    text : getFileNameFromPath(folder_model.folder)
                    anchors.centerIn: parent
                    font.pointSize: (tepee.mobileRes == 139) ? 25 : (tepee.mobileRes == 80) ? 16 : 7
                    color : "white"
                }
                MouseArea
                {
                    id : header_ma
                    anchors.fill : parent
                    onClicked :
                    {
                        folder_model.folder = getParentDirFromPath(folder_model.folder);
                    }
                }
            }
        }
    }
    Button
    {
        id : back_button
        anchors.top : folder_view.bottom
        //        anchors.topMargin: tepee.mobileRes / 8
        anchors.horizontalCenter: parent.horizontalCenter
        buttonColor: "blue"
        buttonShape: "round"
        resImg: tepee.mobileRes
        numId : 135
        text : "Cancel"
        opacity : 1
        onButtonClicked: clearView(true );
    }
}

