//import QtQuick 1.1
 import QtQuick 1.0 // to target S60 5th Edition or Maemo 5


MouseArea {
    property int numId : 0
    property string clickActionState;
    property alias text : button_label.text
    property int resImg : 139
    property string buttonColor : "grey"

    id: button_item
    width : resImg
    height: button_item.width
    opacity : 0
    Behavior on opacity {SequentialAnimation {PauseAnimation { duration: numId * 500} NumberAnimation {duration : 1000}}}
    hoverEnabled: true // Must be true son onEntered can react

    signal buttonReleased
    signal buttonClicked

    function setNormalButton()
    {
        button_image_hover.visible = false;
        button_image.visible = true;
        button_image_pressed.visible = false;
    }

    onClicked :
    {
        button_item.buttonClicked();
    }

    onEntered :
    {
        button_image_hover.visible = true;
        button_image.visible = false;
        button_image_pressed.visible = false;
    }
    onExited :
    {
        button_image_hover.visible = false;
        button_image.visible = true;
        button_image_pressed.visible = false;
    }
    onPressed :
    {
        button_image_hover.visible = false;
        button_image.visible = false;
        button_image_pressed.visible = true;
    }

    onReleased :
    {
        button_item.buttonReleased();
        button_item.setNormalButton();
    }

    Image
    {
        id : button_image_hover
        width : button_item.width;
        height : button_item.height;
        fillMode : Image.Stretch;
        source : "Buttons/button_round_fly_" + buttonColor + "_" + resImg + ".png"
        visible : false
        //        scale : button_item.pressed ? 1.1 : 1.0
    }


    Image
    {
        id: button_image_pressed
        width  : button_item.width
        height : button_item.height
        fillMode: Image.Stretch
        source: "Buttons/button_round_pressed_" + buttonColor + "_" + resImg + ".png"
        visible : false
    }

    Image
    {
        id: button_image
        width  : button_item.width
        height : button_item.height
        fillMode: Image.Stretch
        source: "Buttons/button_round_normal_" + buttonColor + "_" + resImg + ".png"
        visible : true
    }


    Text
    {
        id: button_label
        anchors.centerIn: parent
        font.pointSize: (resImg == 139) ? 15 : (resImg == 80) ? 12 : 4
        color: "white"
    }

    // STATE MUST BE DEFINE IN THE LOWEST FILE WHEN THEY AFFECT THE BUTTON ITSELF AS COMPONENT ARE PRIVATE FROM THE OUTSIDE
    states :
        [
        State

        {
            name : "redclicked_1"
            PropertyChanges {target : button1; opacity : 0}
        },

        State
        {
            name : "redclicked_2"
            PropertyChanges {target : background_rect ; opacity : 0}
        }
    ]

}
