#include "connectionthread.h"

ConnectionThread::ConnectionThread() : QThread()
{
    this->start();
    QObject::connect(this, SIGNAL(socketDisconnected()), this, SLOT(connectionDisconnected()));
}

ConnectionThread::~ConnectionThread()
{
}

void ConnectionThread::run()
{
    Connection  Con; // MANAGES CONNECTION
    Manage      Man; // MANAGES DB TRANSACTIONS AND COMMANDS

    // REGISTERING TYPES FOR SIGNALS
    qRegisterMetaType<QHostAddress>("QHostAddress");
    qRegisterMetaType<QList<QSqlRecord> >("QList<QSqlRecord>");

    // SIGNAL POUR OUVRIR CONNECTION
    QObject::connect(this, SIGNAL(connectToServer(QString,int)), &Con, SLOT(openConnection(QString,int)));
    // SIGNAL POUR CLEARER BUFFER DEPUIS MANAGE
    QObject::connect(&Man, SIGNAL(clearOutBuffer(int)), &Con, SLOT(clearReadBuff(int)));
    // SIGNAL POUR ENVOYER DATA DEPUIS THIS
    QObject::connect(this, SIGNAL(sendData(unsigned char*,int)), &Con, SLOT(writeCircularBuff(unsigned char*,int)));
    // SIGNAL POUR ENVOYER DATA DEPUIS Man
    QObject::connect(&Man, SIGNAL(sendData(unsigned char*,int)), &Con, SLOT(writeCircularBuff(unsigned char*,int)));
    // SIGNAL POUR RECEVOIR DATA VERS MAN
    QObject::connect(&Con, SIGNAL(recvData(unsigned char*,int)), &Man, SLOT(recvFromServer(unsigned char*,int)));
    // SIGNAL POUR INDIQUER PERTE CONNECTION AU MANAGER
    QObject::connect(&Con, SIGNAL(disconnected()), &Man, SLOT(lostServerConnection()));
    // SIGNAL POUR ENVOYER DONNER D"INFORMATION CONNECTION A MANAGE LORSQUE ON EST CONNECTE
    QObject::connect(this, SIGNAL(AuthOnServer(QString, QString)), &Man, SLOT(AuthOnServer(QString,QString)));
    // CONNECTION TO DB MANAGER FOR REQUESTING REQUEST AND SENDING RESULTS
    QObject::connect(this, SIGNAL(queryBM(QString,int)), &Man, SLOT(execQuery(QString,int)));
    QObject::connect(&Man, SIGNAL(queryRet(QList<QSqlRecord>,int)), this, SIGNAL(retQueryBm(QList<QSqlRecord>,int)));
    // FORWARDING SOCKET SIGNAL TO CURRENT CLASS FOR FUTURE GUI INTERACTION
    QObject::connect(&Con, SIGNAL(connected()), this, SIGNAL(socketConnected()));
    QObject::connect(&Con, SIGNAL(disconnected()), this, SIGNAL(socketDisconnected()));
    // TRANSMIT SYNCHING PROGRESS TO CONNECTION THREAD CLASS
    QObject::connect(&Man, SIGNAL(synchingProgress(QVariant)), this, SIGNAL(synchingProgress(QVariant)));

    this->exec();
}

void    ConnectionThread::initSyncServer(QString a, int b, QString us_, QString pass_)
{
    std::cout << "Init Connection" << std::endl;
    this->pass = pass_;
    this->user = us_;
    QObject::connect(this, SIGNAL(socketConnected()), this, SLOT(connectionConnected()));
    emit (connectToServer(a, b));
}

void    ConnectionThread::connectionDisconnected()
{
    std::cout << "CONNECTION DISCONNECTED IN CONNECTIONTHREAD" << std::endl;
}

void    ConnectionThread::connectionConnected()
{
    std::cout << "CONNECTION CONNECTED SENDING AUTH INFO TO MANAGE" << std::endl;
    QObject::disconnect(this, SIGNAL(socketConnected()), this, SLOT(connectionConnected()));
    emit(AuthOnServer(this->user, this->pass));
}

