using GLib;
using Gtk;

public class Tear.Quickbar : ComboBoxEntry {
	private EntryCompletion completion;
	private string last_item;
	private string last_item_type;
	public ListStore completionmodel;
	public ListStore listmodel;

    construct {
		
		this.last_item = "";
		this.last_item_type = "";

		this.listmodel = new ListStore(2, typeof(string), typeof(uint));
		this.set_model((TreeModel) listmodel);
		this.set_text_column (0);
		
		this.completionmodel = new ListStore(2, typeof(string), typeof(uint));
		
		this.completion = new EntryCompletion();
		this.completion.set_model((TreeModel) completionmodel);
		this.completion.set_text_column (0);
		this.completion.set_match_func ( (EntryCompletionMatchFunc) completion_match );
		this.completion.match_selected += completion_selected;
		this.completion.set_popup_completion (true);

		((Gtk.Entry) this.get_child()).set_completion(this.completion);
		((Gtk.Entry) this.get_child()).set("hildon-input-mode", 0x1F, null); // set dictionary mode without the need of the patched gtk bindings.

    }
    
    public void on_focus () {
	    
    }

    public void on_change_enabled (bool state) {
	    if (state)
   			((Editable) get_child()).changed += on_change;
		else
			((Editable) get_child()).changed -= on_change;
    }

    public static bool completion_match ( EntryCompletion completion, string key, TreeIter iter ) {
	    string item;
	    string? output;

	   	completion.model.get (iter, 0, out item, -1);
	   	if (item != null)
	   		output = item.up().str(key.up());
	   	else output = null;

		return (output != null);
    }

 	public static bool completion_selected ( EntryCompletion completion, TreeModel model, TreeIter iter ) {
		string item;

		model.get ( iter, 0, out item, -1 );
	   	if (item != null) {
			var tmp = item.split("\n");
			
			Gtk.Entry ent = ((Gtk.Entry) completion.get_entry());
			ent.set_text(tmp[1]);
			ent.activate();
	   	}

		return true;
 	}
 
    private void on_change () {
		if (this.active != -1) {
			var tmp = ((Entry) get_child()).text.split("\n");
			((Entry) get_child()).text = tmp[1];
			((Entry) get_child()).activate;
		}
    }
	    
	public bool populate() {
	    int nrows, ncols, result, i;
	    string[] table;
		TreeIter iter;
#if FREMANTLE
		var limit = ";";
#else		
		var limit = " LIMIT 100;";
#endif

        table = dbqueue.pull ("SELECT `name`, `addr` FROM `quickdata` WHERE `type` = 'history' ORDER by `access_date` DESC" + limit, out nrows, out ncols, out result );
		
        if (result != Sqlite.OK) { 
            return false;
        } else
	        if (table != null) {
	
		   	    this.listmodel.clear();
				for (i = 1; i <= nrows; i++) {
			        append_text(table[i*2]+"\n"+table[i*2+1]);
			        if (i > 20)
			        	i = nrows;
			    }
		
			    this.completionmodel.clear(); 
				for (i = 1; i <= nrows; i++) {
			        completionmodel.append (out iter);
			        completionmodel.set (iter, 0, table[i*2]+"\n"+table[i*2+1], 1, 2, -1);
				}
	        }

        return true;
	}

    public bool has_bookmark (string word) {
	    int nrows = 0, ncols, result;
	    string[] table;

        table = dbqueue.pull ("SELECT * FROM `bookmark` WHERE `addr` = '"+  str_replace("'", "''", word) +"';", out nrows, out ncols, out result);

        if (result != Sqlite.OK) { 
            return false;
        }
	
    	return (nrows > 0) ? true : false;
    }

	public void refresh_bookmarks() {
	    int nrows, ncols, result, i;
	    string[] table;

        table = dbqueue.pull ("SELECT `name`, `addr` FROM `bookmark`;", out nrows, out ncols, out result);
        if (result != Sqlite.OK) { 
            return;
        } else
	        if (table != null) {
				var bookmark_collection = new HashTable<string,string>(str_hash, str_equal);
				for (i = 1; i <= nrows; i++) {
			        bookmark_collection.insert (table[i*2], table[i*2+1]);
				}
				
				((Tear.UIManager) uim).merge_ui_path = "/tool-popup/tool-bookmarks/tool-book-placeholder";
				((Tear.UIManager) uim).m_id = 10000;

				((Tear.UIManager) uim).update_action_collection ( bookmark_collection, "Bookmark" );
	        }

		table = dbqueue.pull ("SELECT `name`, `addr` FROM `quickdata` WHERE `type` = 'bookmarklet';", out nrows, out ncols, out result);
        if (result != Sqlite.OK) { 
            return;
        } else
	        if (table != null) {
				var bookmarklet_collection = new HashTable<string,string>(str_hash, str_equal);
				for (i = 1; i <= nrows; i++) {
			        bookmarklet_collection.insert (table[i*2], table[i*2+1]);
				}
				
				((Tear.UIManager) uim).merge_ui_path = "/tool-popup/tool-booklet-placeholder";
				((Tear.UIManager) uim).m_id = 10001;
		
				((Tear.UIManager) uim).update_action_collection ( bookmarklet_collection, "Bookmarklet" );
	        }
	        
	}

    public bool add_quickbar_item (string? name, string addr, string type, string path) {
	    int nrows, ncols, result;
	    string[] table;
	    string checkname;

		if (name == null)
			return false;

		if ((this.last_item != addr) || (this.last_item_type != type)) {
			if (type == "history")
				checkname = "";
			else
				checkname = "`name` = \""+ name +"\" and ";

   	        table = dbqueue.pull ("SELECT * FROM `quickdata` WHERE `type` = '"+ type +"' and "+ checkname +"`addr` = '"+  str_replace("'", "''", addr) +"';", out nrows, out ncols, out result );

	        if (result != Sqlite.OK) { 
	            return false;
	        } else {

		        if ((nrows == 1) && (type != "bookmarklet") && (type != "search")) {
		        	result = dbqueue.push ("UPDATE OR IGNORE `quickdata` SET `name` = '"+ str_replace("'", "''", name) +"', `addr` = '"+ str_replace("'", "''", addr) +"', `path` = '"+ path +"', `type` = '"+ type +"', `access_date` = datetime('now'), `opened` = 1 WHERE "+ checkname +"`addr` = '"+ addr +"' and `type` = '"+ type +"';" );
			        if (result != Sqlite.OK) { 
			            return false;
			        }
		        } else {
	        		if (nrows < 1) {
				        result = dbqueue.push ("INSERT OR IGNORE INTO `quickdata` (`name`, `addr`, `path`, `type`, `access_date`, `opened`) VALUES ('"+  str_replace("'", "''", name) +"', '"+  str_replace("'", "''", addr) +"', '"+ path +"', '"+ type +"', datetime('now'), 1);" );
				        if (result != Sqlite.OK) { 
				            return false;
				        }
	        		} else
	        			return false;
		        }
				this.last_item = addr;
				this.last_item_type = type;
	
				if (type == "bookmark") {
					dbqueue.push ("DROP VIEW IF EXISTS `bookmark`;");
					dbqueue.push ("CREATE TEMP VIEW `bookmark` AS SELECT DISTINCT (`addr`) as `addr`, `name` FROM `quickdata` WHERE `type` = 'bookmark';");
					this.refresh_bookmarks();
				}
				
	    	}
		}
        
        return true;
    }

    public bool remove_quickbar_item (string addr, string type) {
	    int result;

		if (DEBUG)
			warning ( "remove item " + addr );
	
		if (addr == null)
			return false;

    	result = dbqueue.push ("delete from `quickdata` WHERE `addr` = '"+ addr +"' and `type` = '"+ type +"';" );
        if (result != Sqlite.OK) { 
            return false;
        }

		if (type == "bookmark") {
			dbqueue.push ("DROP VIEW IF EXISTS `bookmark`;");
			dbqueue.push ("CREATE TEMP VIEW `bookmark` AS SELECT DISTINCT (`addr`) as `addr`, `name` FROM `quickdata` WHERE `type` = 'bookmark';");
			this.refresh_bookmarks();
		}
        
        return true;
    }
    
}