using GLib;
using Gtk;
using WebKit;

public class Tear.Menu : Gtk.Menu {
	
	public unowned Tear.BrowserWindow parent_window { get; set construct; }

    public Menu ( Tear.BrowserWindow bw ) {
        this.parent_window = bw;
    }
    
	public void empty () {
        if (this.children.length() > 0) {
	        for (int i = (int) this.children.length()-1; i >= 0; i--) {
		        this.children.nth_data(i).destroy();
        	}
  	  	}
	}
	
	public void add_history_item( WebHistoryItem item, bool prepend ) {
		
        var title = shorten_string ( str_replace("=", "&#061;", str_replace("&", "&amp;", item.get_title())) );
        var uri = shorten_string ( str_replace("=", "&#061;", str_replace("&", "&amp;", item.get_uri())) );
        
        var menuitem = new Tear.MenuItem ( "<b>"+title+"</b>\n"+uri, item );
        
		menuitem.activate += (s) => {
			var web_view = this.parent_window.web_view;
			web_view.stop_loading ();
			web_view.go_to_back_forward_item( ((Tear.MenuItem) s).item );
		};
		
		if (prepend)
			this.prepend(menuitem);
		else
			this.append(menuitem);
	}
        
}