using GLib;
using PCRE;

public class Tear.Blocker : Object {

	public bool disabled;

	private Tear.Rule[] blacklist;
	private string[] blackruleset;
	private Tear.Rule[] whitelist;
	private string[] whiteruleset;
	
// ?	private string[,] domain_subsets;

	construct {
		disabled = true;
		
		var keyfile = new KeyFile();
		
		if ( keyfile.load_from_file ( "/home/user/.tear/blocker.list", 0 ) ) {

			whiteruleset = keyfile.get_keys ("Whitelist");
			blackruleset = keyfile.get_keys ("Blacklist");

			if (blackruleset != null) {
				disabled = false;

				blacklist = new Tear.Rule[0];
				string error;
				int erroffset;

				foreach ( string br in blackruleset ) {
					var new_rule = new Tear.Rule();
					
					new_rule.domain = br;
					new_rule.rule = keyfile.get_value("Blacklist", br);
					new_rule.regex = PRegex.compile( (new_rule.domain == "*" ? "" : ".*"+new_rule.domain)+new_rule.rule, PCRE.Options.UTF8, out error, out erroffset, null );
					if (new_rule.regex == null)
						warning ( error + ": " + erroffset.to_string() );

					blacklist += new_rule;
				}

				if (whiteruleset != null) {
					whitelist = new Tear.Rule[0];
					
					foreach ( string wr in whiteruleset ) {
						var new_rule = new Tear.Rule();
						
						new_rule.domain = wr;
						new_rule.rule = keyfile.get_value("Whitelist", wr);
						new_rule.regex = PRegex.compile( (new_rule.domain == "*" ? "" : ".*"+new_rule.domain)+new_rule.rule, PCRE.Options.CASELESS & PCRE.Options.ANCHORED, out error, out erroffset, null );
	
						whitelist += new_rule;
					}
				}
			}
		}
		if (disabled)
			warning ( "No rule file found at /home/user/.tear/blocker.list. Blocker disabled." );
		
	}
	
//	public void prepare_domain_subset( string uri ) {
//		if (disabled)
//			return;
//		
//		string error;
//		int erroffset;
//		var regex = PRegex.compile( "^\w+\:\/\/(.+\@.+\:)?([\w\d\.\-]+)(?=[\/\?$])", PCRE.Options.CASELESS, out error, out erroffset, null );
//		
//		int[] ov = new int[3];
//		
//		if ( PRegex.exec( regex, null, uri, (int) uri.length, 0, 0, ov ) >= 0 ) {
//			warning ( "Uri "+ uri + " has been blocked by rule " + rule.rule + " for domain " + rule.domain );
//			return true;
//		}
//		
//	}
	
    public bool block_uri ( string uri ) {
		if (disabled)
			return false;

		int[] ov = new int[20];

		foreach ( Tear.Rule rule in blacklist ) {
			if ( PRegex.exec( rule.regex, null, uri, (int) uri.length, 0, 0, ov ) >= 0 ) {
				warning ( "Uri "+ uri + " has been blocked by rule " + rule.rule + " for domain " + rule.domain );
				return true;
			}
		}
		
		return false;
    }
}
