using GLib;
using Gtk;

public class Tear.Uri : GLib.Object { // Directly taken from GLib 2.16 and converted to Vala.

	private static long unescape_character (string scanner)
	{
		long first_digit;
		long second_digit;
	
		first_digit = scanner[0].xdigit_value();
		if (first_digit < 0)
			return -1;
	
		second_digit = scanner[1].xdigit_value();
		if (second_digit < 0)
			return -1;
	
		return (first_digit << 4) | second_digit;
	}

	public static string?	unescape_segment (string escaped_string, long escaped_string_end, string illegal_characters) {
		long input;
		StringBuilder output = new StringBuilder();
		long character;
		
		if (escaped_string_end == 0)
			escaped_string_end = escaped_string.length;
			
		for (input = 0; input < escaped_string_end; input++) {
			character = escaped_string[input];
			
			if (character == '%') {
				input++;
				
				if (escaped_string_end - input < 2)
					return null;
				
				character = unescape_character (escaped_string.substring(input, 2));
				
				if (character <= 0 || (illegal_characters != null && illegal_characters.chr (-1, (unichar) character) != null))
					return null;
				
				input++;
			}
			output.append_unichar((unichar) character);
		}
		
		return output.str;
	}

	public static string	unescape_string (string escaped_string, string illegal_characters) {
		return unescape_segment (escaped_string, 0, illegal_characters);
	}

}