using GLib;
using Gdk;
using Gtk;
using WebKit;
using Hildon;

public class Tear.WebKitView : WebView {

	private bool clicking;
	private bool menulock;
	private bool menudown;
	private bool enterdown;
	private bool autoscrolling;
	private bool redo_keydown;
	private bool kinetic_scrolling;
	private double oldx;
	private double oldy;
	private GLib.TimeVal firsttime;
	private GLib.TimeVal oldtime;
	private GLib.TimeVal menutime;
	private GLib.TimeVal entertime;
	private double offsetx;
	private double offsety;
	private unowned Gdk.EventKey last_keydown;
	private HashTable<uint,uint> pressed;

	public unowned Gdk.EventButton button_event;

	construct {
//#if !FREMANTLE
		this.button_press_event += on_webview_clicked;
		this.motion_notify_event += on_webview_motion;
		this.button_release_event += on_webview_release;
//#endif

		this.clicking = false;
		this.menudown = false;
		this.menulock = false;
		this.redo_keydown = false;
		this.pressed = new HashTable<uint,uint>( int_hash, int_equal );
	}
	
	public bool on_webview_keydown (Tear.BrowserWindow bw, Gdk.EventKey ev) {

		uint fid = 0;
		uint fkey = 0;
		this.menudown = false;
		this.enterdown = false;
		var event = ev;
		
#if FREMANTLE
		if (ev.keyval == Hardkey.INCREASE || ev.keyval == Hardkey.DECREASE) {
			if (pressed.lookup_extended( event.keyval, out fkey, out fid )) {
				if (Source.remove( fid ))
					double_keypress( event );
				pressed.remove( fkey );
				
				return true;
			}
	
			var timeout = (int) Math.round(options.get_option( "double_press_timeout" ).to_double()*1000);
			var id = Timeout.add( timeout, () => {
	
				if (pressed.lookup_extended( event.keyval, out fkey, out fid )) {
					if (Source.remove( fid ))
						single_keypress( event );
					pressed.remove( fkey );
				}
				
				return false;
			} );
			
			pressed.insert( ev.keyval, id );
		}
#endif
		
		switch (ev.keyval) {
#if FREMANTLE
			case Gdk.KeySyms.Shift_L:
				if ((ev.state & Gdk.ModifierType.MOD5_MASK) == Gdk.ModifierType.MOD5_MASK) {
					Banner.show_information( bw, null, "Scroll Lock on" );
					this.menulock = true;
				} else
					this.menulock = false;
#else
			case Gdk.KeySyms.F4:
#endif
				this.menudown = true;
				menutime.get_current_time();
				return true;
				break;
#if FREMANTLE
			case Gdk.KeySyms.KP_Enter:
				if ((ev.state & Gdk.ModifierType.MOD5_MASK) == Gdk.ModifierType.MOD5_MASK) {
					bw.get_app_menu().popup(bw);
				}
				if ((ev.state & Gdk.ModifierType.CONTROL_MASK) == Gdk.ModifierType.CONTROL_MASK) {
					
					var act = (ToggleAction) ((Tear.UIManager) uim).action_group.get_action("view-fullscreen");
					
					if (act != null)
						act.activate();
				}
				break;
#else
			case Gdk.KeySyms.Return:

				if (!redo_keydown) {
					this.enterdown = true;
 					entertime.get_current_time();
 					if (options.get_option( "wake_toolbar_shortcut_speed" ) == "short") {
 						last_keydown = ev;
 						return true;
					}
				} else 
					redo_keydown = false;
				
				break;
			case Gdk.KeySyms.F7:
				((ToggleAction) ((Tear.UIManager) uim).action_group.get_action("tool-zoomin")).activate();
				break;
			case Gdk.KeySyms.F8:
				((ToggleAction) ((Tear.UIManager) uim).action_group.get_action("tool-zoomout")).activate();
				break;
#endif
			case Gdk.KeySyms.Escape:
				if (bw.web_view.can_go_back ())
			    	bw.web_view.go_back ();

				break;
			case Gdk.KeySyms.F6:
				((ToggleAction) ((Tear.UIManager) uim).action_group.get_action("view-fullscreen")).activate();
				break;
		}

		return false;
	}

	public void MenuPosition (Gtk.Menu menu, out int x, out int y, out bool push_in) {
		
		this.parent.get_toplevel().window.get_origin (out x, out y);
		x = x + 10;
		
		push_in = true;
	}
	
	public void single_keypress ( Gdk.EventKey ev ) {
		switch (ev.keyval) {
			case Hardkey.INCREASE:
				((ToggleAction) ((Tear.UIManager) uim).action_group.get_action("view-fullscreen")).activate();
				break;
			case Hardkey.DECREASE:
				((Tear.BrowserWindow) this.get_toplevel()).drawer.set_goal( 1 );
				break;
		}
	}

	public void double_keypress ( Gdk.EventKey ev ) {
		switch (ev.keyval) {
			case Hardkey.INCREASE:
				((ToggleAction) ((Tear.UIManager) uim).action_group.get_action("tool-zoomin")).activate();
				break;
			case Hardkey.DECREASE:
				((ToggleAction) ((Tear.UIManager) uim).action_group.get_action("tool-zoomout")).activate();
				break;
		}
	}

	public bool on_webview_keyup (Tear.BrowserWindow bw, Gdk.EventKey ev) {
	
#if FREMANTLE
		if (ev.keyval == Gdk.KeySyms.Shift_L){
			var newtime = TimeVal();
			newtime.get_current_time();
			
			this.menudown = false;

			if (DEBUG)
				warning ( "keyup" );
		}
#else
		if ((ev.keyval == Gdk.KeySyms.F4) || (ev.keyval == Gdk.KeySyms.Return)){
			var newtime = TimeVal();
			newtime.get_current_time();
			
			if (this.menudown)
				if ((newtime.tv_sec - menutime.tv_sec) < 1.0) 
					program.get_common_menu().popup(null, null, MenuPosition, 0, get_current_event_time());

			if (this.enterdown && options.get_option( "wake_toolbar_shortcut_speed" ) == "short") {
				if ((newtime.tv_sec - entertime.tv_sec) < 0.7)
					bw.drawer.set_goal( 1 );
				else {
					redo_keydown = true;
					this.enterdown = false;
 					main_do_event( (Gdk.Event) last_keydown );
				}
			} else
				if (this.enterdown && options.get_option( "wake_toolbar_shortcut_speed" ) == "long")
					if ((newtime.tv_sec - entertime.tv_sec) > 0.5) {
						bw.drawer.set_goal( 1 );
						this.menudown = false;
						this.enterdown = false;
						return true;
					}

			this.menudown = false;
			this.enterdown = false;

			if (DEBUG)
				warning ( "keyup" );
		}
#endif
		return false;
	}

	
	bool on_webview_clicked (Tear.WebKitView wv, Gdk.EventButton ev) {
		if (autoscrolling) autoscrolling = false;
		this.button_event = ev;
		
		((Tear.BrowserWindow) this.get_toplevel()).drawer.set_goal( 0 );

		if (!this.menudown && !this.menulock) {
			oldx = ev.x;
			oldy = ev.y;
			
			offsetx = ev.x;
			offsety = ev.y;
	
			firsttime.get_current_time();
			oldtime.get_current_time();

			GLib.Timeout.add (1000/10, check_wait);

			this.clicking = true;
		}

		return false;
	}

	bool check_wait() { 
		var newtime = TimeVal();
		newtime.get_current_time();

		if (!(this.clicking))
			return false;

		if (get_time_offset(newtime, oldtime) > 0.2) {
			offsetx = oldx;
			offsety = oldy;
			oldtime.get_current_time();

			return true;
		}

		return true;
	}

	bool on_webview_release (Tear.WebKitView wv, Gdk.EventButton ev) {
		this.clicking = false;
		
		if (!this.menudown && !this.menulock) {
			var newtime = TimeVal();
			
			newtime.get_current_time();

			if (get_time_offset(newtime, oldtime) <= 0.2 && ((ev.x > offsetx + 20 || ev.x < offsetx - 20) || (ev.y > offsety + 20 || ev.y < offsety - 20))) {
				
				offsety -= ev.y;
				offsety /= 2;
				offsetx -= ev.x;
				offsetx /= 2;
	
				if (this.kinetic_scrolling) {
					autoscrolling = true;
					GLib.Timeout.add (1000/30, auto_scrolling);
				}
				
				return true;
			}
	
			hover_uri = "";
		}
		return false;
	}
	
	double get_time_offset (TimeVal newtime, TimeVal oldtime) {
		
		double secs = 0;
		long diff_sec = newtime.tv_sec - oldtime.tv_sec;
		
		if (diff_sec > 0) {
			secs = 1000000 * diff_sec;
		}
		
		return (secs + (newtime.tv_usec - oldtime.tv_usec)) / 1000000;
	}

	bool auto_scrolling() { 
		Gtk.ScrolledWindow sw;
		double effect, effectx, effecty, move;
		var newtime = TimeVal();
		
		newtime.get_current_time();
		
		effect = get_time_offset(newtime, oldtime);
		
		effect = Math.pow(GLib.Math.E, -effect);
		effectx = effect * offsetx;
		effecty = effect * offsety;
		
		if (autoscrolling && effect > 0.1) {
			sw = (Gtk.ScrolledWindow) this.get_ancestor(GLib.Type.from_name("GtkScrolledWindow"));
			
			move = sw.vadjustment.value + effecty;
			if (sw.vadjustment.lower <= move && move <= (sw.vadjustment.upper - sw.vadjustment.page_size))
				sw.vadjustment.value = move;

			move = sw.hadjustment.value + effectx;
			if (sw.hadjustment.lower <= move && move <= (sw.hadjustment.upper - sw.hadjustment.page_size))
				sw.hadjustment.value = move;
			
			return true;
		}
		autoscrolling = false;
		return false;
	}

	bool on_webview_motion (Tear.WebKitView wv, Gdk.EventMotion ev) {
		double aux;
		ScrolledWindow sw;
		var newtime = TimeVal();
			
		if (clicking && !this.menudown && !this.menulock) {
			newtime.get_current_time();

			sw = (Gtk.ScrolledWindow) this.get_ancestor(GLib.Type.from_name("GtkScrolledWindow"));

			if (sw != null) {
				if (ev.x != oldx) {
					aux = sw.hadjustment.value + oldx - ev.x;
					if (sw.hadjustment.lower <= aux && aux <= (sw.hadjustment.upper - sw.hadjustment.page_size)) {
						sw.hadjustment.value = aux;
					}
				}
	
				if (ev.y != oldy) {
					aux = sw.vadjustment.value + oldy - ev.y;
					if (sw.vadjustment.lower <= aux && aux <= (sw.vadjustment.upper - sw.vadjustment.page_size)) {
						sw.vadjustment.value = aux;
					}
				}
			}
		}
		
		oldx = ev.x;
		oldy = ev.y;

		if (this.menudown || this.menulock)
			return false;
		else return true;
	}
	
	public unowned WebKit.Node create_glass() {
        unowned WebKit.Document document = ((WebKit.WebView) this).get_main_frame().get_dom_document();
        unowned WebKit.Element element = document.create_element("div");
        element.set_attribute("style", "position: fixed; display: table-cell; vertical-align: middle; text-align: center; left: 0; top: 0; width: 100%; height: 100%; background: url("+glass_bg+");");
        ((WebKit.Node) document.get_body()).append_child((WebKit.Node) element);
        
        return (WebKit.Node) element;
	}
	
	public unowned WebKit.Node create_container(WebKit.Node element) {
        unowned WebKit.Document document = ((WebKit.WebView) this).get_main_frame().get_dom_document();
        unowned WebKit.Element container = document.create_element("div");
        container.set_attribute("style", """
			width: 500px; height: auto;
		""");
        element.append_child((WebKit.Node) container);
        
        return (WebKit.Node) container;
    }
    
    public unowned WebKit.Node create_button(WebKit.Node container, string title, string href) {
        unowned WebKit.Document document = ((WebKit.WebView) this).get_main_frame().get_dom_document();
        
        unowned WebKit.Element button = document.create_element("a");
        unowned WebKit.Element span = document.create_element("span");
        button.set_attribute("style", """
		    width: 150px; height: 50px; font: bold 16px Arial, Helvetica, sans-serif; padding: 0 10px 10px 0; margin: 0 5px 5px 0;
			-webkit-border-image: url(data:image/png;base64,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) 10 10 10 10 / 10px 10px stretch stretch;
		    color: white; text-decoration: none; display: inline-block; float: left;
		""");
		button.set_attribute("href", href);
		button.set_attribute("onclick", "this.parentNode.parentNode.removeChild(this.parentNode);");
		
        span.set_attribute("style", """
			display: table-cell; margin-left: -20px; margin-right: -20px; line-height: 18px; display: table-cell; width: 150px; height: 50px;
			vertical-align: middle; text-align: center;
		""");
		((WebKit.Node) span).set_text_content(title);
        ((WebKit.Node) button).append_child((WebKit.Node) span);
        container.append_child((WebKit.Node) button);
        
        return (WebKit.Node) button;
    }

	public void refresh_settings() {
		
		this.settings.auto_load_images = options.set_or_get_bool( "auto_load_images", true, true, "Load Images" );
		this.settings.auto_shrink_images = options.set_or_get_bool( "auto_shrink_images", true, true, "Shrink Images" );
		this.settings.enable_plugins = options.set_or_get_bool( "enable_plugins", true, true, "Enable Plugins" );
		this.settings.enable_scripts = options.set_or_get_bool( "enable_scripts", true, true, "Enable Javascript" );
		this.settings.resizable_text_areas = options.set_or_get_bool( "resizable_text_areas", true, true, "Resizable Text Areas" );
		this.settings.enable_developer_extras = options.set_or_get_bool( "enable_developer_extras", true, true, "Developer Tools" );
		this.settings.print_backgrounds = options.set_or_get_bool( "print_backgrounds", true, true, "Print Backgrounds" );
		this.set_full_content_zoom ( options.set_or_get_bool( "full_content_zoom", true, true, "Full Content Zoom" ) );
		this.settings.user_stylesheet_uri = options.set_or_get( "user_stylesheet_uri", user_stylesheet, true, "User Stylesheet", "file", user_stylesheet );
		if ("0.1".to_double() != 0)
			this.settings.zoom_step = (float) options.set_or_get( "zoom_step", "0.1", true, "Zoom Step", "float", "0.05|0.1|0.2|0.5|1.0" ).to_double();

		string user_agent = options.set_or_get( "user_agent", this.settings.user_agent, true, "User Agent", "string", "Tear|Apple iPhone 3.1|Mozilla Firefox 3.5.3|Google Chrome 3|Apple Safari 4.0.3|Internet Explorer 7|Internet Explorer 8" );
		switch (user_agent) {
			case "Tear":
				options.update_option ( "user_agent", this.settings.user_agent );
				break;
			case "Apple iPhone 3.1":
				options.update_option ( "user_agent", "Mozilla/5.0 (iPhone; U; CPU iPhone OS 3_1 like Mac OS X; en-us) AppleWebKit/528.18 (KHTML, like Gecko) Version/4.0 Mobile/7C97d Safari/528.16" );
				break;
			case "Mozilla Firefox 3.5.3":
				options.update_option ( "user_agent", "Mozilla/5.0 (Windows; U; Windows NT 6.1; en; rv:1.9.1.3) Gecko/20090824 Firefox/3.5.3" );
				break;
			case "Google Chrome 3":
				options.update_option ( "user_agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US) AppleWebKit/532.0 (KHTML, like Gecko) Chrome/3.0.201.0 Safari/532.0" );
				break;
			case "Apple Safari 4.0.3":
				options.update_option ( "user_agent", "Mozilla/5.0 (Windows; U; Windows NT 6.0; en-us) AppleWebKit/531.9 (KHTML, like Gecko) Version/4.0.3 Safari/531.9" );
				break;
			case "Internet Explorer 7":
				options.update_option ( "user_agent", "Mozilla/5.0 (compatible; MSIE 7.0; Windows NT 6.0; en-US)" );
				break;
			case "Internet Explorer 8":
				options.update_option ( "user_agent", "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1; Trident/4.0)" );
				break;
			default:
				this.settings.user_agent = user_agent;
				if (user_agent == "" || user_agent == null)
					options.update_option ( "user_agent", this.settings.user_agent );
				break;
		}

		this.kinetic_scrolling = options.set_or_get_bool( "kinetic_scrolling", true, true, "Kinetik Scrolling" );

		string scroll_option = options.get_option("scrollbar");
		((Tear.BrowserWindow) this.get_toplevel()).set_scrollbars(scroll_option);
		
		this.settings.cursive_font_family = options.set_or_get( "cursive_font_family", this.settings.cursive_font_family, true, "Cursive Font Family", "string", this.settings.cursive_font_family );
		this.settings.default_encoding = options.set_or_get( "default_encoding", this.settings.default_encoding, true, "Default Encoding", "string", this.settings.default_encoding );
		this.settings.default_font_family = options.set_or_get( "default_font_family", this.settings.default_font_family, true, "Default Font Family", "string", this.settings.default_font_family );
		this.settings.fantasy_font_family = options.set_or_get( "fantasy_font_family", this.settings.fantasy_font_family, true, "Fantasy Font Family", "string", this.settings.fantasy_font_family );
		this.settings.monospace_font_family = options.set_or_get( "monospace_font_family", this.settings.monospace_font_family, true, "Monospace Font Family", "string", this.settings.monospace_font_family );
		this.settings.sans_serif_font_family = options.set_or_get( "sans_serif_font_family", this.settings.sans_serif_font_family, true, "Sans-serif Font Family", "string", this.settings.sans_serif_font_family );
		this.settings.serif_font_family = options.set_or_get( "serif_font_family", this.settings.serif_font_family, true, "Serif Font Family", "string", this.settings.serif_font_family );
		this.settings.default_monospace_font_size = options.set_or_get( "default_monospace_font_size", this.settings.default_monospace_font_size.to_string(), true, "Default Monospace Font Size", "int", "9|10|11|12|14|16|18|20" ).to_int();
		this.settings.default_font_size = options.set_or_get( "default_font_size", this.settings.default_font_size.to_string(), true, "Default Font Size", "int", "9|10|11|12|14|16|18|20" ).to_int();
		
		home_address = options.set_or_get( "home_page", "about:blank", true, "Home Page", "string", "Dashboard|talk.maemo.org|maemo.org" );
		switch (home_address) {
			case "Dashboard":
				home_address = "about:blank";
				break;
			case "talk.maemo.org":
				home_address = "http://talk.maemo.org";
				break;
			case "Dashboard":
				home_address = "http://www.maemo.org";
				break;
		}
	}

}
