using GLib;
using Gdk;
using Gtk;
using Hildon;
using Osso;
using ConIc;
using WebKit;
using GConf;
using Config;
using PCRE;
using X;

public Hildon.Program program;
public List<Gtk.Window> windows;
#if FREMANTLE
public unowned Hildon.WindowStack stack;
#endif
public Tear.About about; 
public Tear.UIManager uim;
public Tear.OptionsManager options;
public Tear.ConnectionManager connmanager;
public Tear.Service dbus_service;
public Tear.Blocker blocker;
public Tear.DBQueue dbqueue;
public Tear.DownloadManager download_manager;
public bool accels_last_state;
public bool saving_session = false;
public string tear_folder;
public string quickdb_name;
public string hover_uri;
public string search_uri;
public string home_address;
public string user_stylesheet;

#if FREMANTLE
public const SizeType button_size = SizeType.FINGER_HEIGHT | SizeType.AUTO_WIDTH;
#endif
public const bool DEBUG = false;
public const string TITLE = "Tear";
public const string DEFAULT_PROTOCOL = "http";
public const string[] menu_pages = { "Page", "Tools", "Private", "About" };

public const string glass_bg = """data:image/png;base64,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""";
public const string button_bg = """data:image/png;base64,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""";
public const string HOMEPAGE = """<?xml version="1.0" encoding="UTF-8"?>
<?access-control allow="*"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml"
	  xmlns:svg="http://www.w3.org/2000/svg"
	  xmlns:xlink="http://www.w3.org/1999/xlink">
	<head>
		<meta http-equiv="Content-Type" content="application/xhtml+xml;charset=utf-8" />
		<title>Dashboard</title>
		<style>
			html, body { width: 100%; height: 100%; margin: 0; padding: 0; background: #568; }
			html>body .canvas { display: none; }
			html>body .obj  { display: block; cursor: pointer; margin: 0 8px; width: 15px; }

			.Hover, .Selected, .HoverLast, .SelectedLast, .HoverOuter, .SelectedOuter, .TabsInnerContainer, .TabsOuterContainer {
				background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADgAAAXcCAYAAAB3a00tAAAACXBIWXMAAAsTAAALEwEAmpwYAAAABGdBTUEAALGOfPtRkwAAACBjSFJNAAB6JQAAgIMAAPn/AACA6QAAdTAAAOpgAAA6mAAAF2+SX8VGAAAiG0lEQVR42mJkQAMbNmz4z0BD4O/vz4jMb1mwl6b2AQSge4pRAIZBoJo1a7dSyFS6ZOv/X1RCl27RJgeGUlrhUO/kVH4/llKinDM4Vf2EmVEphZh5QER+0XWPGCM/H1uXifZthlbVmr/Bv9cV+xrX+uO8qNvI2EkU4M/IQfwOxozHLYBYYJ5D9hitAchzyB6jJQAIICYYg16egwF6eA4EAAKICRZ79AKw2KMXAAggpuEceyAAEECMoAw9nAFAADExDHMAEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAHEsnHjxv/+/v5YJf/9+4cV////n+H9+/cMjIyMcMzExIQTg+RhYMKakwwx7oZY7fv77z/Q/P9g80Hsv2D7gGJA/tuP3xhAxjDB7WRgYAabzwimmZlg7mAEq4EBgAAa9jEIEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEDD3oMAATTsPQgQQMPegwABNOw9CBBAw96DAAE07D0IEEBgD166dImulp6+/oRudgEEEFNAQAD3/fv36WZhTYIz481Hr+lmH0AAgWLw73CORYAAdI49CoAwDIWT6Fjc3EToJC7dvKEH8Qi9gEeS4uLWxiTQThr4yM8LL0GhF4YY46UD7z2EEEwspXzCzJBSAkRsENEvqtdwzlmzHydrXuYRtnUyLRcWfzZ/rbPdk5n01/2A2lC7CdCZP1ruqP6BtlPjFUCMUMwJxMJALAX06Alahqi/vz8jMh/mUVoBgABiBIUW0OegWOSGelIUiAWhfFZql7RA+5bRMysABBALlAblw+9ADEqmv4H4CxDzAjEHkpohCQACiAUaqv+BsQjy2D+oB78C8XtoDDIPZQ8CBBA4iaIIQEoEZiTMSOUk+pWeHgQIMABAtgCvoBD/xwAAAABJRU5ErkJggg==);
				background-repeat: no-repeat;
			}
			
			.TabsOuterContainer.TabsRight .Hover, .TabsOuterContainer.TabsRight .Selected, .TabsOuterContainer.TabsRight .HoverLast, .TabsOuterContainer.TabsRight .SelectedLast, .TabsOuterContainer.TabsRight .HoverOuter, .TabsOuterContainer.TabsRight .SelectedOuter, .TabsOuterContainer.TabsRight .TabsInnerContainer, .TabsOuterContainer.TabsRight {
				background-image: url(data:image/png;base64,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);
			}
		
			.TabsOuterContainer { background-position: 0 0; padding-top: 5px; position: absolute; top: 80px; right: 94%; width: 28px; }
			.TabsOuterContainer.TabsRight { left: 94%; right: auto; }
			.TabsInnerContainer { background-position: 0 100%; width: 28px; }

			.TabsInnerContainer ul { list-style-type: none; margin: 0; padding: 0; }
			.TabsInnerContainer li { display: block; padding: 5px 0; cursor: pointer; border-bottom: 1px solid #CCC; }
			.TabsInnerContainer .lastLI { border-bottom: 0; }

			.Hover, .Selected { background-position: -28px 60%; }
			.HoverLast, .SelectedLast { background-position: -28px 100%; }
			.HoverOuter, .SelectedOuter { background-position: -28px 0;  }

			.TabLink { font: 14px Tahoma, sans-serif; text-rendering: optimizeSpeed; fill:#888; white-space: nowrap; }

			#HistoryContainer, #BookmarksContainer, #MostUsedContainer,
			#History2Container, #Bookmarks2Container, #SearchesContainer
					{ position: absolute; top: 75px; left: 6%; width: 88%; height: 75%; min-height: 270px; border: 1px solid #CCC;
					  background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAALCAIAAAAmzuBxAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAABHSURBVHjaYvz9+zcDXgAQQCwgzMKCRwVAADExEAIAAURYBUAAEVYBEECEVQAEEGEVAAFEWAVAABFWARBAhFUABBBhFQABBgBqVAMVHVYwGAAAAABJRU5ErkJggg==) repeat; }


			form { height: 48px; top: 5px; position: relative; }
			#logo { width: 64px; height: 64px; background-image: url(data:image/png;base64,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);
					background-position: left middle; background-repeat: no-repeat; display: inline-block; vertical-align: middle; }
			#q, #s { font: normal 22px sans-serif; color: #CCC; border: 1px solid #1E3651 !important; vertical-align: middle;
					 width: 174px; height: 40px; -moz-border-radius: 15px; -webkit-border-radius: 15px; display: inline-block; outline: 0; }
			#q { height: 26px; padding: 7px; color: #999; width: 346px; margin-right: 10px; background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAArCAMAAACO/BLrAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAAPUExURWqAnGh9mGN3klxvh1dpgDX3SCcAAADJSURBVHjaYmABCCAGZoAAYmACCCAGRoAAYmAACCAGBoAAYmAACCAGBoAAYmAACCAGBoAAYmAACCAGBoAAYmAACCAGBoAAYmAACCAGBoAAYmAACCAGBoAAYmAACCAGBoAAYmAACCAGBoAAYmAACCAGBoAAYmAACCAGBoAAYmAACCAGBoAAYmAACCAGBoAAYmAACCAGBoAAYmAACCAGBoAAYmAACCAGBoAAYmAACCAGBoAAYmAACCAGBoAAYmAACCAGBoAAYmAACDAAA5QACyvS/LEAAAAASUVORK5CYII=) repeat-x; }
			#s { -moz-box-shadow: 2px 2px 3px #000; width: 174px; background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAQAAAArCAMAAABo1dmvAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAEXUExURUZZbi5BViU5TUZabkVZbSo9Uiw/VC9DV0hccUFVaUBUaTFFWSs/U0BTaC5CVj1RZTRIXCc7T0RXbEJWa0tfdD5SZkNXa1Bjd0NWaz9TZzBDWCk9UR8yRyY6Tk5hdic6TiI2S0lccTdKX0hccEhbbyg7UB0xRUdabi5CV0peckdbb0dab0JVak9id0RYbTFEWUVZbixAVDVJXig7TzhLYD1QZB8zRzVIXSE0SD9SZiU4TT1QZTxQZDNGWyg8UURXa0JVaR4xRSc7UD5RZjdLYC9CVx4yRzhMYCc6T0JWai1AVS1BVT5SZzxQZSA0SCAzSDBEWE9jd0VYbCxAVUVYbSE1STNGWiw/UztPY01gdE1gdTxPY05idrKPemMAAAFDSURBVHjaYnCOjggCCCAGGx8WU4AAYpBk5ucHCCAGFS5RLoAAYtDh5VUECCAGTjFNToAAYmARkRAGCCCGKAYhZoAAYtAO0ZMDCCAGBmVdBoAAYuAIVGcGCCAGcQ5mDoAAYuBQZxYHCCCwGEAAMWjFsLAABBCDnLaeFkAAMTDYi0UCBBCDMFAfQAAxCGk6cAIEEIOiDq8nQAAxcFmKqgAEEIOvpIE1QAAxMAqE8wAEEIOsjJoZQAAx+DuqyQMEEINbqJMMQAAxKEhb+AEEEAOblQITQAAxeDAx8QEEEIMga4AxQAAxGNqysgIEEIM5IxsfQAAxSDEyKgEEEIMGt4srQAAxcLuzswMEEIOJvgY3QACBxQACiCGY3cgLIIAYvAV4eAACiCGMTZoNIIAYWFVV9QECiEHWjl0eIIAYBPmYmAACDABCUBW3giKpXgAAAABJRU5ErkJggg==) repeat-x; }

			.quickdial { width: 100%; height: 99%; min-height: 260px; display: inline-block; padding-top: 0.5%; position: absolute; padding-left: 1%;
						 vertical-align: middle; }
			.quickdial div { width: 32%; margin: 2px; height: 31%; float: left; font-size: 48px; overflow: hidden; line-height: 90px;
							 color: #7AD; border: 1px solid #568; text-align: center; font-weight: bold; background: #BCE url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAAhCAIAAACX21boAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAACgSURBVHjaYjxy+QlAALEI8LIDBBATAwMDQACBMEAAgTBAAIEwQACBMEAAgTBAAIEwQACBMEAAgTBAAIEwQACBMEAAgTBAAIEwQACBMEAAgTBAADEx/GcACCAQDRBATP//MwAEENN/BgaAAAKxAQIIxAYIIBANEEAgGiCAQDRAAIHEAQIIyP4PEEAgNkAAgdQDBBCIDxBAIDZAAIFogAADAFXbEdR6I8YpAAAAAElFTkSuQmCC) repeat-x;
							 -moz-border-radius: 7px; -moz-box-shadow: 2px 2px 3px #000; vertical-align: middle; }
			.quickdial div a { display: block; width: 100%; height: 100%; font-size: 14px; font-weight: normal; color: #369;
							   text-decoration: none; word-wrap: break-word; line-height: 20px; }
		</style>

		<script language="javascript" type="text/javascript">
		<![CDATA[
//MooTools, <http://mootools.net>, My Object Oriented (JavaScript) Tools. Copyright (c) 2006-2008 Valerio Proietti, <http://mad4milk.net>, MIT Style License.

var MooTools={version:"1.2.1",build:"0d4845aab3d9a4fdee2f0d4a6dd59210e4b697cf"};var Native=function(K){K=K||{};var A=K.name;var I=K.legacy;var B=K.protect;
var C=K.implement;var H=K.generics;var F=K.initialize;var G=K.afterImplement||function(){};var D=F||I;H=H!==false;D.constructor=Native;D.$family={name:"native"};
if(I&&F){D.prototype=I.prototype;}D.prototype.constructor=D;if(A){var E=A.toLowerCase();D.prototype.$family={name:E};Native.typize(D,E);}var J=function(N,L,O,M){if(!B||M||!N.prototype[L]){N.prototype[L]=O;
}if(H){Native.genericize(N,L,B);}G.call(N,L,O);return N;};D.alias=function(N,L,O){if(typeof N=="string"){if((N=this.prototype[N])){return J(this,L,N,O);
}}for(var M in N){this.alias(M,N[M],L);}return this;};D.implement=function(M,L,O){if(typeof M=="string"){return J(this,M,L,O);}for(var N in M){J(this,N,M[N],L);
}return this;};if(C){D.implement(C);}return D;};Native.genericize=function(B,C,A){if((!A||!B[C])&&typeof B.prototype[C]=="function"){B[C]=function(){var D=Array.prototype.slice.call(arguments);
return B.prototype[C].apply(D.shift(),D);};}};Native.implement=function(D,C){for(var B=0,A=D.length;B<A;B++){D[B].implement(C);}};Native.typize=function(A,B){if(!A.type){A.type=function(C){return($type(C)===B);
};}};(function(){var A={Array:Array,Date:Date,Function:Function,Number:Number,RegExp:RegExp,String:String};for(var G in A){new Native({name:G,initialize:A[G],protect:true});
}var D={"boolean":Boolean,"native":Native,object:Object};for(var C in D){Native.typize(D[C],C);}var F={Array:["concat","indexOf","join","lastIndexOf","pop","push","reverse","shift","slice","sort","splice","toString","unshift","valueOf"],String:["charAt","charCodeAt","concat","indexOf","lastIndexOf","match","replace","search","slice","split","substr","substring","toLowerCase","toUpperCase","valueOf"]};
for(var E in F){for(var B=F[E].length;B--;){Native.genericize(window[E],F[E][B],true);}}})();var Hash=new Native({name:"Hash",initialize:function(A){if($type(A)=="hash"){A=$unlink(A.getClean());
}for(var B in A){this[B]=A[B];}return this;}});Hash.implement({forEach:function(B,C){for(var A in this){if(this.hasOwnProperty(A)){B.call(C,this[A],A,this);
}}},getClean:function(){var B={};for(var A in this){if(this.hasOwnProperty(A)){B[A]=this[A];}}return B;},getLength:function(){var B=0;for(var A in this){if(this.hasOwnProperty(A)){B++;
}}return B;}});Hash.alias("forEach","each");Array.implement({forEach:function(C,D){for(var B=0,A=this.length;B<A;B++){C.call(D,this[B],B,this);}}});Array.alias("forEach","each");
function $A(C){if(C.item){var D=[];for(var B=0,A=C.length;B<A;B++){D[B]=C[B];}return D;}return Array.prototype.slice.call(C);}function $arguments(A){return function(){return arguments[A];
};}function $chk(A){return !!(A||A===0);}function $clear(A){clearTimeout(A);clearInterval(A);return null;}function $defined(A){return(A!=undefined);}function $each(C,B,D){var A=$type(C);
((A=="arguments"||A=="collection"||A=="array")?Array:Hash).each(C,B,D);}function $empty(){}function $extend(C,A){for(var B in (A||{})){C[B]=A[B];}return C;
}function $H(A){return new Hash(A);}function $lambda(A){return(typeof A=="function")?A:function(){return A;};}function $merge(){var E={};for(var D=0,A=arguments.length;
D<A;D++){var B=arguments[D];if($type(B)!="object"){continue;}for(var C in B){var G=B[C],F=E[C];E[C]=(F&&$type(G)=="object"&&$type(F)=="object")?$merge(F,G):$unlink(G);
}}return E;}function $pick(){for(var B=0,A=arguments.length;B<A;B++){if(arguments[B]!=undefined){return arguments[B];}}return null;}function $random(B,A){return Math.floor(Math.random()*(A-B+1)+B);
}function $splat(B){var A=$type(B);return(A)?((A!="array"&&A!="arguments")?[B]:B):[];}var $time=Date.now||function(){return +new Date;};function $try(){for(var B=0,A=arguments.length;
B<A;B++){try{return arguments[B]();}catch(C){}}return null;}function $type(A){if(A==undefined){return false;}if(A.$family){return(A.$family.name=="number"&&!isFinite(A))?false:A.$family.name;
}if(A.nodeName){switch(A.nodeType){case 1:return"element";case 3:return(/\S/).test(A.nodeValue)?"textnode":"whitespace";}}else{if(typeof A.length=="number"){if(A.callee){return"arguments";
}else{if(A.item){return"collection";}}}}return typeof A;}function $unlink(C){var B;switch($type(C)){case"object":B={};for(var E in C){B[E]=$unlink(C[E]);
}break;case"hash":B=new Hash(C);break;case"array":B=[];for(var D=0,A=C.length;D<A;D++){B[D]=$unlink(C[D]);}break;default:return C;}return B;}var Browser=$merge({Engine:{name:"unknown",version:0},Platform:{name:(window.orientation!=undefined)?"ipod":(navigator.platform.match(/mac|win|linux/i)||["other"])[0].toLowerCase()},Features:{xpath:!!(document.evaluate),air:!!(window.runtime),query:!!(document.querySelector)},Plugins:{},Engines:{presto:function(){return(!window.opera)?false:((arguments.callee.caller)?960:((document.getElementsByClassName)?950:925));
},trident:function(){return(!window.ActiveXObject)?false:((window.XMLHttpRequest)?5:4);},webkit:function(){return(navigator.taintEnabled)?false:((Browser.Features.xpath)?((Browser.Features.query)?525:420):419);
},gecko:function(){return(document.getBoxObjectFor==undefined)?false:((document.getElementsByClassName)?19:18);}}},Browser||{});Browser.Platform[Browser.Platform.name]=true;
Browser.detect=function(){for(var B in this.Engines){var A=this.Engines[B]();if(A){this.Engine={name:B,version:A};this.Engine[B]=this.Engine[B+A]=true;
break;}}return{name:B,version:A};};Browser.detect();Browser.Request=function(){return $try(function(){return new XMLHttpRequest();},function(){return new ActiveXObject("MSXML2.XMLHTTP");
});};Browser.Features.xhr=!!(Browser.Request());Browser.Plugins.Flash=(function(){var A=($try(function(){return navigator.plugins["Shockwave Flash"].description;
},function(){return new ActiveXObject("ShockwaveFlash.ShockwaveFlash").GetVariable("$version");})||"0 r0").match(/\d+/g);return{version:parseInt(A[0]||0+"."+A[1]||0),build:parseInt(A[2]||0)};
})();function $exec(B){if(!B){return B;}if(window.execScript){window.execScript(B);}else{var A=document.createElement("script");A.setAttribute("type","text/javascript");
A[(Browser.Engine.webkit&&Browser.Engine.version<420)?"innerText":"text"]=B;document.head.appendChild(A);document.head.removeChild(A);}return B;}Native.UID=1;
var $uid=(Browser.Engine.trident)?function(A){return(A.uid||(A.uid=[Native.UID++]))[0];}:function(A){return A.uid||(A.uid=Native.UID++);};var Window=new Native({name:"Window",legacy:(Browser.Engine.trident)?null:window.Window,initialize:function(A){$uid(A);
if(!A.Element){A.Element=$empty;if(Browser.Engine.webkit){A.document.createElement("iframe");}A.Element.prototype=(Browser.Engine.webkit)?window["[[DOMElement.prototype]]"]:{};
}A.document.window=A;return $extend(A,Window.Prototype);},afterImplement:function(B,A){window[B]=Window.Prototype[B]=A;}});Window.Prototype={$family:{name:"window"}};
new Window(window);var Document=new Native({name:"Document",legacy:(Browser.Engine.trident)?null:window.Document,initialize:function(A){$uid(A);A.head=A.getElementsByTagName("head")[0];
A.html=A.getElementsByTagName("html")[0];if(Browser.Engine.trident&&Browser.Engine.version<=4){$try(function(){A.execCommand("BackgroundImageCache",false,true);
});}if(Browser.Engine.trident){A.window.attachEvent("onunload",function(){A.window.detachEvent("onunload",arguments.callee);A.head=A.html=A.window=null;
});}return $extend(A,Document.Prototype);},afterImplement:function(B,A){document[B]=Document.Prototype[B]=A;}});Document.Prototype={$family:{name:"document"}};
new Document(document);Array.implement({every:function(C,D){for(var B=0,A=this.length;B<A;B++){if(!C.call(D,this[B],B,this)){return false;}}return true;
},filter:function(D,E){var C=[];for(var B=0,A=this.length;B<A;B++){if(D.call(E,this[B],B,this)){C.push(this[B]);}}return C;},clean:function(){return this.filter($defined);
},indexOf:function(C,D){var A=this.length;for(var B=(D<0)?Math.max(0,A+D):D||0;B<A;B++){if(this[B]===C){return B;}}return -1;},map:function(D,E){var C=[];
for(var B=0,A=this.length;B<A;B++){C[B]=D.call(E,this[B],B,this);}return C;},some:function(C,D){for(var B=0,A=this.length;B<A;B++){if(C.call(D,this[B],B,this)){return true;
}}return false;},associate:function(C){var D={},B=Math.min(this.length,C.length);for(var A=0;A<B;A++){D[C[A]]=this[A];}return D;},link:function(C){var A={};
for(var E=0,B=this.length;E<B;E++){for(var D in C){if(C[D](this[E])){A[D]=this[E];delete C[D];break;}}}return A;},contains:function(A,B){return this.indexOf(A,B)!=-1;
},extend:function(C){for(var B=0,A=C.length;B<A;B++){this.push(C[B]);}return this;},getLast:function(){return(this.length)?this[this.length-1]:null;},getRandom:function(){return(this.length)?this[$random(0,this.length-1)]:null;
},include:function(A){if(!this.contains(A)){this.push(A);}return this;},combine:function(C){for(var B=0,A=C.length;B<A;B++){this.include(C[B]);}return this;
},erase:function(B){for(var A=this.length;A--;A){if(this[A]===B){this.splice(A,1);}}return this;},empty:function(){this.length=0;return this;},flatten:function(){var D=[];
for(var B=0,A=this.length;B<A;B++){var C=$type(this[B]);if(!C){continue;}D=D.concat((C=="array"||C=="collection"||C=="arguments")?Array.flatten(this[B]):this[B]);
}return D;},hexToRgb:function(B){if(this.length!=3){return null;}var A=this.map(function(C){if(C.length==1){C+=C;}return C.toInt(16);});return(B)?A:"rgb("+A+")";
},rgbToHex:function(D){if(this.length<3){return null;}if(this.length==4&&this[3]==0&&!D){return"transparent";}var B=[];for(var A=0;A<3;A++){var C=(this[A]-0).toString(16);
B.push((C.length==1)?"0"+C:C);}return(D)?B:"#"+B.join("");}});Function.implement({extend:function(A){for(var B in A){this[B]=A[B];}return this;},create:function(B){var A=this;
B=B||{};return function(D){var C=B.arguments;C=(C!=undefined)?$splat(C):Array.slice(arguments,(B.event)?1:0);if(B.event){C=[D||window.event].extend(C);
}var E=function(){return A.apply(B.bind||null,C);};if(B.delay){return setTimeout(E,B.delay);}if(B.periodical){return setInterval(E,B.periodical);}if(B.attempt){return $try(E);
}return E();};},run:function(A,B){return this.apply(B,$splat(A));},pass:function(A,B){return this.create({bind:B,arguments:A});},bind:function(B,A){return this.create({bind:B,arguments:A});
},bindWithEvent:function(B,A){return this.create({bind:B,arguments:A,event:true});},attempt:function(A,B){return this.create({bind:B,arguments:A,attempt:true})();
},delay:function(B,C,A){return this.create({bind:C,arguments:A,delay:B})();},periodical:function(C,B,A){return this.create({bind:B,arguments:A,periodical:C})();
}});Number.implement({limit:function(B,A){return Math.min(A,Math.max(B,this));},round:function(A){A=Math.pow(10,A||0);return Math.round(this*A)/A;},times:function(B,C){for(var A=0;
A<this;A++){B.call(C,A,this);}},toFloat:function(){return parseFloat(this);},toInt:function(A){return parseInt(this,A||10);}});Number.alias("times","each");
(function(B){var A={};B.each(function(C){if(!Number[C]){A[C]=function(){return Math[C].apply(null,[this].concat($A(arguments)));};}});Number.implement(A);
})(["abs","acos","asin","atan","atan2","ceil","cos","exp","floor","log","max","min","pow","sin","sqrt","tan"]);String.implement({test:function(A,B){return((typeof A=="string")?new RegExp(A,B):A).test(this);
},contains:function(A,B){return(B)?(B+this+B).indexOf(B+A+B)>-1:this.indexOf(A)>-1;},trim:function(){return this.replace(/^\s+|\s+$/g,"");},clean:function(){return this.replace(/\s+/g," ").trim();
},camelCase:function(){return this.replace(/-\D/g,function(A){return A.charAt(1).toUpperCase();});},hyphenate:function(){return this.replace(/[A-Z]/g,function(A){return("-"+A.charAt(0).toLowerCase());
});},capitalize:function(){return this.replace(/\b[a-z]/g,function(A){return A.toUpperCase();});},escapeRegExp:function(){return this.replace(/([-.*+?^${}()|[\]\/\\])/g,"\\$1");
},toInt:function(A){return parseInt(this,A||10);},toFloat:function(){return parseFloat(this);},hexToRgb:function(B){var A=this.match(/^#?(\w{1,2})(\w{1,2})(\w{1,2})$/);
return(A)?A.slice(1).hexToRgb(B):null;},rgbToHex:function(B){var A=this.match(/\d{1,3}/g);return(A)?A.rgbToHex(B):null;},stripScripts:function(B){var A="";
var C=this.replace(/<script[^>]*>([\s\S]*?)<\/script>/gi,function(){A+=arguments[1]+"\n";return"";});if(B===true){$exec(A);}else{if($type(B)=="function"){B(A,C);
}}return C;},substitute:function(A,B){return this.replace(B||(/\\?\{([^{}]+)\}/g),function(D,C){if(D.charAt(0)=="\\"){return D.slice(1);}return(A[C]!=undefined)?A[C]:"";
});}});Hash.implement({has:Object.prototype.hasOwnProperty,keyOf:function(B){for(var A in this){if(this.hasOwnProperty(A)&&this[A]===B){return A;}}return null;
},hasValue:function(A){return(Hash.keyOf(this,A)!==null);},extend:function(A){Hash.each(A,function(C,B){Hash.set(this,B,C);},this);return this;},combine:function(A){Hash.each(A,function(C,B){Hash.include(this,B,C);
},this);return this;},erase:function(A){if(this.hasOwnProperty(A)){delete this[A];}return this;},get:function(A){return(this.hasOwnProperty(A))?this[A]:null;
},set:function(A,B){if(!this[A]||this.hasOwnProperty(A)){this[A]=B;}return this;},empty:function(){Hash.each(this,function(B,A){delete this[A];},this);
return this;},include:function(B,C){var A=this[B];if(A==undefined){this[B]=C;}return this;},map:function(B,C){var A=new Hash;Hash.each(this,function(E,D){A.set(D,B.call(C,E,D,this));
},this);return A;},filter:function(B,C){var A=new Hash;Hash.each(this,function(E,D){if(B.call(C,E,D,this)){A.set(D,E);}},this);return A;},every:function(B,C){for(var A in this){if(this.hasOwnProperty(A)&&!B.call(C,this[A],A)){return false;
}}return true;},some:function(B,C){for(var A in this){if(this.hasOwnProperty(A)&&B.call(C,this[A],A)){return true;}}return false;},getKeys:function(){var A=[];
Hash.each(this,function(C,B){A.push(B);});return A;},getValues:function(){var A=[];Hash.each(this,function(B){A.push(B);});return A;},toQueryString:function(A){var B=[];
Hash.each(this,function(F,E){if(A){E=A+"["+E+"]";}var D;switch($type(F)){case"object":D=Hash.toQueryString(F,E);break;case"array":var C={};F.each(function(H,G){C[G]=H;
});D=Hash.toQueryString(C,E);break;default:D=E+"="+encodeURIComponent(F);}if(F!=undefined){B.push(D);}});return B.join("&");}});Hash.alias({keyOf:"indexOf",hasValue:"contains"});
var Event=new Native({name:"Event",initialize:function(A,F){F=F||window;var K=F.document;A=A||F.event;if(A.$extended){return A;}this.$extended=true;var J=A.type;
var G=A.target||A.srcElement;while(G&&G.nodeType==3){G=G.parentNode;}if(J.test(/key/)){var B=A.which||A.keyCode;var M=Event.Keys.keyOf(B);if(J=="keydown"){var D=B-111;
if(D>0&&D<13){M="f"+D;}}M=M||String.fromCharCode(B).toLowerCase();}else{if(J.match(/(click|mouse|menu)/i)){K=(!K.compatMode||K.compatMode=="CSS1Compat")?K.html:K.body;
var I={x:A.pageX||A.clientX+K.scrollLeft,y:A.pageY||A.clientY+K.scrollTop};var C={x:(A.pageX)?A.pageX-F.pageXOffset:A.clientX,y:(A.pageY)?A.pageY-F.pageYOffset:A.clientY};
if(J.match(/DOMMouseScroll|mousewheel/)){var H=(A.wheelDelta)?A.wheelDelta/120:-(A.detail||0)/3;}var E=(A.which==3)||(A.button==2);var L=null;if(J.match(/over|out/)){switch(J){case"mouseover":L=A.relatedTarget||A.fromElement;
break;case"mouseout":L=A.relatedTarget||A.toElement;}if(!(function(){while(L&&L.nodeType==3){L=L.parentNode;}return true;}).create({attempt:Browser.Engine.gecko})()){L=false;
}}}}return $extend(this,{event:A,type:J,page:I,client:C,rightClick:E,wheel:H,relatedTarget:L,target:G,code:B,key:M,shift:A.shiftKey,control:A.ctrlKey,alt:A.altKey,meta:A.metaKey});
}});Event.Keys=new Hash({enter:13,up:38,down:40,left:37,right:39,esc:27,space:32,backspace:8,tab:9,"delete":46});Event.implement({stop:function(){return this.stopPropagation().preventDefault();
},stopPropagation:function(){if(this.event.stopPropagation){this.event.stopPropagation();}else{this.event.cancelBubble=true;}return this;},preventDefault:function(){if(this.event.preventDefault){this.event.preventDefault();
}else{this.event.returnValue=false;}return this;}});var Class=new Native({name:"Class",initialize:function(B){B=B||{};var A=function(){for(var E in this){if($type(this[E])!="function"){this[E]=$unlink(this[E]);
}}this.constructor=A;if(Class.prototyping){return this;}var D=(this.initialize)?this.initialize.apply(this,arguments):this;if(this.options&&this.options.initialize){this.options.initialize.call(this);
}return D;};for(var C in Class.Mutators){if(!B[C]){continue;}B=Class.Mutators[C](B,B[C]);delete B[C];}$extend(A,this);A.constructor=Class;A.prototype=B;
return A;}});Class.Mutators={Extends:function(C,A){Class.prototyping=A.prototype;var B=new A;delete B.parent;B=Class.inherit(B,C);delete Class.prototyping;
return B;},Implements:function(A,B){$splat(B).each(function(C){Class.prototying=C;$extend(A,($type(C)=="class")?new C:C);delete Class.prototyping;});return A;
}};Class.extend({inherit:function(B,E){var A=arguments.callee.caller;for(var D in E){var C=E[D];var G=B[D];var F=$type(C);if(G&&F=="function"){if(C!=G){if(A){C.__parent=G;
B[D]=C;}else{Class.override(B,D,C);}}}else{if(F=="object"){B[D]=$merge(G,C);}else{B[D]=C;}}}if(A){B.parent=function(){return arguments.callee.caller.__parent.apply(this,arguments);
};}return B;},override:function(B,A,E){var D=Class.prototyping;if(D&&B[A]!=D[A]){D=null;}var C=function(){var F=this.parent;this.parent=D?D[A]:B[A];var G=E.apply(this,arguments);
this.parent=F;return G;};B[A]=C;}});Class.implement({implement:function(){var A=this.prototype;$each(arguments,function(B){Class.inherit(A,B);});return this;
}});var Chain=new Class({$chain:[],chain:function(){this.$chain.extend(Array.flatten(arguments));return this;},callChain:function(){return(this.$chain.length)?this.$chain.shift().apply(this,arguments):false;
},clearChain:function(){this.$chain.empty();return this;}});var Events=new Class({$events:{},addEvent:function(C,B,A){C=Events.removeOn(C);if(B!=$empty){this.$events[C]=this.$events[C]||[];
this.$events[C].include(B);if(A){B.internal=true;}}return this;},addEvents:function(A){for(var B in A){this.addEvent(B,A[B]);}return this;},fireEvent:function(C,B,A){C=Events.removeOn(C);
if(!this.$events||!this.$events[C]){return this;}this.$events[C].each(function(D){D.create({bind:this,delay:A,"arguments":B})();},this);return this;},removeEvent:function(B,A){B=Events.removeOn(B);
if(!this.$events[B]){return this;}if(!A.internal){this.$events[B].erase(A);}return this;},removeEvents:function(C){if($type(C)=="object"){for(var D in C){this.removeEvent(D,C[D]);
}return this;}if(C){C=Events.removeOn(C);}for(var D in this.$events){if(C&&C!=D){continue;}var B=this.$events[D];for(var A=B.length;A--;A){this.removeEvent(D,B[A]);
}}return this;}});Events.removeOn=function(A){return A.replace(/^on([A-Z])/,function(B,C){return C.toLowerCase();});};var Options=new Class({setOptions:function(){this.options=$merge.run([this.options].extend(arguments));
if(!this.addEvent){return this;}for(var A in this.options){if($type(this.options[A])!="function"||!(/^on[A-Z]/).test(A)){continue;}this.addEvent(A,this.options[A]);
delete this.options[A];}return this;}});var Element=new Native({name:"Element",legacy:window.Element,initialize:function(A,B){var C=Element.Constructors.get(A);
if(C){return C(B);}if(typeof A=="string"){return document.newElement(A,B);}return $(A).set(B);},afterImplement:function(A,B){Element.Prototype[A]=B;if(Array[A]){return ;
}Elements.implement(A,function(){var C=[],G=true;for(var E=0,D=this.length;E<D;E++){var F=this[E][A].apply(this[E],arguments);C.push(F);if(G){G=($type(F)=="element");
}}return(G)?new Elements(C):C;});}});Element.Prototype={$family:{name:"element"}};Element.Constructors=new Hash;var IFrame=new Native({name:"IFrame",generics:false,initialize:function(){var E=Array.link(arguments,{properties:Object.type,iframe:$defined});
var C=E.properties||{};var B=$(E.iframe)||false;var D=C.onload||$empty;delete C.onload;C.id=C.name=$pick(C.id,C.name,B.id,B.name,"IFrame_"+$time());B=new Element(B||"iframe",C);
var A=function(){var F=$try(function(){return B.contentWindow.location.host;});if(F&&F==window.location.host){var G=new Window(B.contentWindow);new Document(B.contentWindow.document);
$extend(G.Element.prototype,Element.Prototype);}D.call(B.contentWindow,B.contentWindow.document);};(window.frames[C.id])?A():B.addListener("load",A);return B;
}});var Elements=new Native({initialize:function(F,B){B=$extend({ddup:true,cash:true},B);F=F||[];if(B.ddup||B.cash){var G={},E=[];for(var C=0,A=F.length;
C<A;C++){var D=$.element(F[C],!B.cash);if(B.ddup){if(G[D.uid]){continue;}G[D.uid]=true;}E.push(D);}F=E;}return(B.cash)?$extend(F,this):F;}});Elements.implement({filter:function(A,B){if(!A){return this;
}return new Elements(Array.filter(this,(typeof A=="string")?function(C){return C.match(A);}:A,B));}});Document.implement({newElement:function(A,B){if(Browser.Engine.trident&&B){["name","type","checked"].each(function(C){if(!B[C]){return ;
}A+=" "+C+'="'+B[C]+'"';if(C!="checked"){delete B[C];}});A="<"+A+">";}return $.element(this.createElement(A)).set(B);},newTextNode:function(A){return this.createTextNode(A);
},getDocument:function(){return this;},getWindow:function(){return this.window;}});Window.implement({$:function(B,C){if(B&&B.$family&&B.uid){return B;}var A=$type(B);
return($[A])?$[A](B,C,this.document):null;},$$:function(A){if(arguments.length==1&&typeof A=="string"){return this.document.getElements(A);}var F=[];var C=Array.flatten(arguments);
for(var D=0,B=C.length;D<B;D++){var E=C[D];switch($type(E)){case"element":F.push(E);break;case"string":F.extend(this.document.getElements(E,true));}}return new Elements(F);
},getDocument:function(){return this.document;},getWindow:function(){return this;}});$.string=function(C,B,A){C=A.getElementById(C);return(C)?$.element(C,B):null;
};$.element=function(A,D){$uid(A);if(!D&&!A.$family&&!(/^object|embed$/i).test(A.tagName)){var B=Element.Prototype;for(var C in B){A[C]=B[C];}}return A;
};$.object=function(B,C,A){if(B.toElement){return $.element(B.toElement(A),C);}return null;};$.textnode=$.whitespace=$.window=$.document=$arguments(0);
Native.implement([Element,Document],{getElement:function(A,B){return $(this.getElements(A,true)[0]||null,B);},getElements:function(A,D){A=A.split(",");
var C=[];var B=(A.length>1);A.each(function(E){var F=this.getElementsByTagName(E.trim());(B)?C.extend(F):C=F;},this);return new Elements(C,{ddup:B,cash:!D});
}});(function(){var H={},F={};var I={input:"checked",option:"selected",textarea:(Browser.Engine.webkit&&Browser.Engine.version<420)?"innerHTML":"value"};
var C=function(L){return(F[L]||(F[L]={}));};var G=function(N,L){if(!N){return ;}var M=N.uid;if(Browser.Engine.trident){if(N.clearAttributes){var P=L&&N.cloneNode(false);
N.clearAttributes();if(P){N.mergeAttributes(P);}}else{if(N.removeEvents){N.removeEvents();}}if((/object/i).test(N.tagName)){for(var O in N){if(typeof N[O]=="function"){N[O]=$empty;
}}Element.dispose(N);}}if(!M){return ;}H[M]=F[M]=null;};var D=function(){Hash.each(H,G);if(Browser.Engine.trident){$A(document.getElementsByTagName("object")).each(G);
}if(window.CollectGarbage){CollectGarbage();}H=F=null;};var J=function(N,L,S,M,P,R){var O=N[S||L];var Q=[];while(O){if(O.nodeType==1&&(!M||Element.match(O,M))){if(!P){return $(O,R);
}Q.push(O);}O=O[L];}return(P)?new Elements(Q,{ddup:false,cash:!R}):null;};var E={html:"innerHTML","class":"className","for":"htmlFor",text:(Browser.Engine.trident||(Browser.Engine.webkit&&Browser.Engine.version<420))?"innerText":"textContent"};
var B=["compact","nowrap","ismap","declare","noshade","checked","disabled","readonly","multiple","selected","noresize","defer"];var K=["value","accessKey","cellPadding","cellSpacing","colSpan","frameBorder","maxLength","readOnly","rowSpan","tabIndex","useMap"];
Hash.extend(E,B.associate(B));Hash.extend(E,K.associate(K.map(String.toLowerCase)));var A={before:function(M,L){if(L.parentNode){L.parentNode.insertBefore(M,L);
}},after:function(M,L){if(!L.parentNode){return ;}var N=L.nextSibling;(N)?L.parentNode.insertBefore(M,N):L.parentNode.appendChild(M);},bottom:function(M,L){L.appendChild(M);
},top:function(M,L){var N=L.firstChild;(N)?L.insertBefore(M,N):L.appendChild(M);}};A.inside=A.bottom;Hash.each(A,function(L,M){M=M.capitalize();Element.implement("inject"+M,function(N){L(this,$(N,true));
return this;});Element.implement("grab"+M,function(N){L($(N,true),this);return this;});});Element.implement({set:function(O,M){switch($type(O)){case"object":for(var N in O){this.set(N,O[N]);
}break;case"string":var L=Element.Properties.get(O);(L&&L.set)?L.set.apply(this,Array.slice(arguments,1)):this.setProperty(O,M);}return this;},get:function(M){var L=Element.Properties.get(M);
return(L&&L.get)?L.get.apply(this,Array.slice(arguments,1)):this.getProperty(M);},erase:function(M){var L=Element.Properties.get(M);(L&&L.erase)?L.erase.apply(this):this.removeProperty(M);
return this;},setProperty:function(M,N){var L=E[M];if(N==undefined){return this.removeProperty(M);}if(L&&B[M]){N=!!N;}(L)?this[L]=N:this.setAttribute(M,""+N);
return this;},setProperties:function(L){for(var M in L){this.setProperty(M,L[M]);}return this;},getProperty:function(M){var L=E[M];var N=(L)?this[L]:this.getAttribute(M,2);
return(B[M])?!!N:(L)?N:N||null;},getProperties:function(){var L=$A(arguments);return L.map(this.getProperty,this).associate(L);},removeProperty:function(M){var L=E[M];
(L)?this[L]=(L&&B[M])?false:"":this.removeAttribute(M);return this;},removeProperties:function(){Array.each(arguments,this.removeProperty,this);return this;
},hasClass:function(L){return this.className.contains(L," ");},addClass:function(L){if(!this.hasClass(L)){this.className=(this.className+" "+L).clean();
}return this;},removeClass:function(L){this.className=this.className.replace(new RegExp("(^|\\s)"+L+"(?:\\s|$)"),"$1");return this;},toggleClass:function(L){return this.hasClass(L)?this.removeClass(L):this.addClass(L);
},adopt:function(){Array.flatten(arguments).each(function(L){L=$(L,true);if(L){this.appendChild(L);}},this);return this;},appendText:function(M,L){return this.grab(this.getDocument().newTextNode(M),L);
},grab:function(M,L){A[L||"bottom"]($(M,true),this);return this;},inject:function(M,L){A[L||"bottom"](this,$(M,true));return this;},replaces:function(L){L=$(L,true);
L.parentNode.replaceChild(this,L);return this;},wraps:function(M,L){M=$(M,true);return this.replaces(M).grab(M,L);},getPrevious:function(L,M){return J(this,"previousSibling",null,L,false,M);
},getAllPrevious:function(L,M){return J(this,"previousSibling",null,L,true,M);},getNext:function(L,M){return J(this,"nextSibling",null,L,false,M);},getAllNext:function(L,M){return J(this,"nextSibling",null,L,true,M);
},getFirst:function(L,M){return J(this,"nextSibling","firstChild",L,false,M);},getLast:function(L,M){return J(this,"previousSibling","lastChild",L,false,M);
},getParent:function(L,M){return J(this,"parentNode",null,L,false,M);},getParents:function(L,M){return J(this,"parentNode",null,L,true,M);},getChildren:function(L,M){return J(this,"nextSibling","firstChild",L,true,M);
},getWindow:function(){return this.ownerDocument.window;},getDocument:function(){return this.ownerDocument;},getElementById:function(O,N){var M=this.ownerDocument.getElementById(O);
if(!M){return null;}for(var L=M.parentNode;L!=this;L=L.parentNode){if(!L){return null;}}return $.element(M,N);},getSelected:function(){return new Elements($A(this.options).filter(function(L){return L.selected;
}));},getComputedStyle:function(M){if(this.currentStyle){return this.currentStyle[M.camelCase()];}var L=this.getDocument().defaultView.getComputedStyle(this,null);
return(L)?L.getPropertyValue([M.hyphenate()]):null;},toQueryString:function(){var L=[];this.getElements("input, select, textarea",true).each(function(M){if(!M.name||M.disabled){return ;
}var N=(M.tagName.toLowerCase()=="select")?Element.getSelected(M).map(function(O){return O.value;}):((M.type=="radio"||M.type=="checkbox")&&!M.checked)?null:M.value;
$splat(N).each(function(O){if(typeof O!="undefined"){L.push(M.name+"="+encodeURIComponent(O));}});});return L.join("&");},clone:function(O,L){O=O!==false;
var R=this.cloneNode(O);var N=function(V,U){if(!L){V.removeAttribute("id");}if(Browser.Engine.trident){V.clearAttributes();V.mergeAttributes(U);V.removeAttribute("uid");
if(V.options){var W=V.options,S=U.options;for(var T=W.length;T--;){W[T].selected=S[T].selected;}}}var X=I[U.tagName.toLowerCase()];if(X&&U[X]){V[X]=U[X];
}};if(O){var P=R.getElementsByTagName("*"),Q=this.getElementsByTagName("*");for(var M=P.length;M--;){N(P[M],Q[M]);}}N(R,this);return $(R);},destroy:function(){Element.empty(this);
Element.dispose(this);G(this,true);return null;},empty:function(){$A(this.childNodes).each(function(L){Element.destroy(L);});return this;},dispose:function(){return(this.parentNode)?this.parentNode.removeChild(this):this;
},hasChild:function(L){L=$(L,true);if(!L){return false;}if(Browser.Engine.webkit&&Browser.Engine.version<420){return $A(this.getElementsByTagName(L.tagName)).contains(L);
}return(this.contains)?(this!=L&&this.contains(L)):!!(this.compareDocumentPosition(L)&16);},match:function(L){return(!L||(L==this)||(Element.get(this,"tag")==L));
}});Native.implement([Element,Window,Document],{addListener:function(O,N){if(O=="unload"){var L=N,M=this;N=function(){M.removeListener("unload",N);L();
};}else{H[this.uid]=this;}if(this.addEventListener){this.addEventListener(O,N,false);}else{this.attachEvent("on"+O,N);}return this;},removeListener:function(M,L){if(this.removeEventListener){this.removeEventListener(M,L,false);
}else{this.detachEvent("on"+M,L);}return this;},retrieve:function(M,L){var O=C(this.uid),N=O[M];if(L!=undefined&&N==undefined){N=O[M]=L;}return $pick(N);
},store:function(M,L){var N=C(this.uid);N[M]=L;return this;},eliminate:function(L){var M=C(this.uid);delete M[L];return this;}});window.addListener("unload",D);
})();Element.Properties=new Hash;Element.Properties.style={set:function(A){this.style.cssText=A;},get:function(){return this.style.cssText;},erase:function(){this.style.cssText="";
}};Element.Properties.tag={get:function(){return this.tagName.toLowerCase();}};Element.Properties.html=(function(){var C=document.createElement("div");
var A={table:[1,"<table>","</table>"],select:[1,"<select>","</select>"],tbody:[2,"<table><tbody>","</tbody></table>"],tr:[3,"<table><tbody><tr>","</tr></tbody></table>"]};
A.thead=A.tfoot=A.tbody;var B={set:function(){var E=Array.flatten(arguments).join("");var F=Browser.Engine.trident&&A[this.get("tag")];if(F){var G=C;G.innerHTML=F[1]+E+F[2];
for(var D=F[0];D--;){G=G.firstChild;}this.empty().adopt(G.childNodes);}else{this.innerHTML=E;}}};B.erase=B.set;return B;})();if(Browser.Engine.webkit&&Browser.Engine.version<420){Element.Properties.text={get:function(){if(this.innerText){return this.innerText;
}var A=this.ownerDocument.newElement("div",{html:this.innerHTML}).inject(this.ownerDocument.body);var B=A.innerText;A.destroy();return B;}};}Element.Properties.events={set:function(A){this.addEvents(A);
}};Native.implement([Element,Window,Document],{addEvent:function(E,G){var H=this.retrieve("events",{});H[E]=H[E]||{keys:[],values:[]};if(H[E].keys.contains(G)){return this;
}H[E].keys.push(G);var F=E,A=Element.Events.get(E),C=G,I=this;if(A){if(A.onAdd){A.onAdd.call(this,G);}if(A.condition){C=function(J){if(A.condition.call(this,J)){return G.call(this,J);
}return true;};}F=A.base||F;}var D=function(){return G.call(I);};var B=Element.NativeEvents[F];if(B){if(B==2){D=function(J){J=new Event(J,I.getWindow());
if(C.call(I,J)===false){J.stop();}};}this.addListener(F,D);}H[E].values.push(D);return this;},removeEvent:function(C,B){var A=this.retrieve("events");if(!A||!A[C]){return this;
}var F=A[C].keys.indexOf(B);if(F==-1){return this;}A[C].keys.splice(F,1);var E=A[C].values.splice(F,1)[0];var D=Element.Events.get(C);if(D){if(D.onRemove){D.onRemove.call(this,B);
}C=D.base||C;}return(Element.NativeEvents[C])?this.removeListener(C,E):this;},addEvents:function(A){for(var B in A){this.addEvent(B,A[B]);}return this;
},removeEvents:function(A){if($type(A)=="object"){for(var C in A){this.removeEvent(C,A[C]);}return this;}var B=this.retrieve("events");if(!B){return this;
}if(!A){for(var C in B){this.removeEvents(C);}this.eliminate("events");}else{if(B[A]){while(B[A].keys[0]){this.removeEvent(A,B[A].keys[0]);}B[A]=null;}}return this;
},fireEvent:function(D,B,A){var C=this.retrieve("events");if(!C||!C[D]){return this;}C[D].keys.each(function(E){E.create({bind:this,delay:A,"arguments":B})();
},this);return this;},cloneEvents:function(D,A){D=$(D);var C=D.retrieve("events");if(!C){return this;}if(!A){for(var B in C){this.cloneEvents(D,B);}}else{if(C[A]){C[A].keys.each(function(E){this.addEvent(A,E);
},this);}}return this;}});Element.NativeEvents={click:2,dblclick:2,mouseup:2,mousedown:2,contextmenu:2,mousewheel:2,DOMMouseScroll:2,mouseover:2,mouseout:2,mousemove:2,selectstart:2,selectend:2,keydown:2,keypress:2,keyup:2,focus:2,blur:2,change:2,reset:2,select:2,submit:2,load:1,unload:1,beforeunload:2,resize:1,move:1,DOMContentLoaded:1,readystatechange:1,error:1,abort:1,scroll:1};
(function(){var A=function(B){var C=B.relatedTarget;if(C==undefined){return true;}if(C===false){return false;}return($type(this)!="document"&&C!=this&&C.prefix!="xul"&&!this.hasChild(C));
};Element.Events=new Hash({mouseenter:{base:"mouseover",condition:A},mouseleave:{base:"mouseout",condition:A},mousewheel:{base:(Browser.Engine.gecko)?"DOMMouseScroll":"mousewheel"}});
})();Element.Properties.styles={set:function(A){this.setStyles(A);}};Element.Properties.opacity={set:function(A,B){if(!B){if(A==0){if(this.style.visibility!="hidden"){this.style.visibility="hidden";
}}else{if(this.style.visibility!="visible"){this.style.visibility="visible";}}}if(!this.currentStyle||!this.currentStyle.hasLayout){this.style.zoom=1;}if(Browser.Engine.trident){this.style.filter=(A==1)?"":"alpha(opacity="+A*100+")";
}this.style.opacity=A;this.store("opacity",A);},get:function(){return this.retrieve("opacity",1);}};Element.implement({setOpacity:function(A){return this.set("opacity",A,true);
},getOpacity:function(){return this.get("opacity");},setStyle:function(B,A){switch(B){case"opacity":return this.set("opacity",parseFloat(A));case"float":B=(Browser.Engine.trident)?"styleFloat":"cssFloat";
}B=B.camelCase();if($type(A)!="string"){var C=(Element.Styles.get(B)||"@").split(" ");A=$splat(A).map(function(E,D){if(!C[D]){return"";}return($type(E)=="number")?C[D].replace("@",Math.round(E)):E;
}).join(" ");}else{if(A==String(Number(A))){A=Math.round(A);}}this.style[B]=A;return this;},getStyle:function(G){switch(G){case"opacity":return this.get("opacity");
case"float":G=(Browser.Engine.trident)?"styleFloat":"cssFloat";}G=G.camelCase();var A=this.style[G];if(!$chk(A)){A=[];for(var F in Element.ShortStyles){if(G!=F){continue;
}for(var E in Element.ShortStyles[F]){A.push(this.getStyle(E));}return A.join(" ");}A=this.getComputedStyle(G);}if(A){A=String(A);var C=A.match(/rgba?\([\d\s,]+\)/);
if(C){A=A.replace(C[0],C[0].rgbToHex());}}if(Browser.Engine.presto||(Browser.Engine.trident&&!$chk(parseInt(A)))){if(G.test(/^(height|width)$/)){var B=(G=="width")?["left","right"]:["top","bottom"],D=0;
B.each(function(H){D+=this.getStyle("border-"+H+"-width").toInt()+this.getStyle("padding-"+H).toInt();},this);return this["offset"+G.capitalize()]-D+"px";
}if((Browser.Engine.presto)&&String(A).test("px")){return A;}if(G.test(/(border(.+)Width|margin|padding)/)){return"0px";}}return A;},setStyles:function(B){for(var A in B){this.setStyle(A,B[A]);
}return this;},getStyles:function(){var A={};Array.each(arguments,function(B){A[B]=this.getStyle(B);},this);return A;}});Element.Styles=new Hash({left:"@px",top:"@px",bottom:"@px",right:"@px",width:"@px",height:"@px",maxWidth:"@px",maxHeight:"@px",minWidth:"@px",minHeight:"@px",backgroundColor:"rgb(@, @, @)",backgroundPosition:"@px @px",color:"rgb(@, @, @)",fontSize:"@px",letterSpacing:"@px",lineHeight:"@px",clip:"rect(@px @px @px @px)",margin:"@px @px @px @px",padding:"@px @px @px @px",border:"@px @ rgb(@, @, @) @px @ rgb(@, @, @) @px @ rgb(@, @, @)",borderWidth:"@px @px @px @px",borderStyle:"@ @ @ @",borderColor:"rgb(@, @, @) rgb(@, @, @) rgb(@, @, @) rgb(@, @, @)",zIndex:"@",zoom:"@",fontWeight:"@",textIndent:"@px",opacity:"@"});
Element.ShortStyles={margin:{},padding:{},border:{},borderWidth:{},borderStyle:{},borderColor:{}};["Top","Right","Bottom","Left"].each(function(G){var F=Element.ShortStyles;
var B=Element.Styles;["margin","padding"].each(function(H){var I=H+G;F[H][I]=B[I]="@px";});var E="border"+G;F.border[E]=B[E]="@px @ rgb(@, @, @)";var D=E+"Width",A=E+"Style",C=E+"Color";
F[E]={};F.borderWidth[D]=F[E][D]=B[D]="@px";F.borderStyle[A]=F[E][A]=B[A]="@";F.borderColor[C]=F[E][C]=B[C]="rgb(@, @, @)";});(function(){Element.implement({scrollTo:function(H,I){if(B(this)){this.getWindow().scrollTo(H,I);
}else{this.scrollLeft=H;this.scrollTop=I;}return this;},getSize:function(){if(B(this)){return this.getWindow().getSize();}return{x:this.offsetWidth,y:this.offsetHeight};
},getScrollSize:function(){if(B(this)){return this.getWindow().getScrollSize();}return{x:this.scrollWidth,y:this.scrollHeight};},getScroll:function(){if(B(this)){return this.getWindow().getScroll();
}return{x:this.scrollLeft,y:this.scrollTop};},getScrolls:function(){var I=this,H={x:0,y:0};while(I&&!B(I)){H.x+=I.scrollLeft;H.y+=I.scrollTop;I=I.parentNode;
}return H;},getOffsetParent:function(){var H=this;if(B(H)){return null;}if(!Browser.Engine.trident){return H.offsetParent;}while((H=H.parentNode)&&!B(H)){if(D(H,"position")!="static"){return H;
}}return null;},getOffsets:function(){if(Browser.Engine.trident){var L=this.getBoundingClientRect(),J=this.getDocument().documentElement;return{x:L.left+J.scrollLeft-J.clientLeft,y:L.top+J.scrollTop-J.clientTop};
}var I=this,H={x:0,y:0};if(B(this)){return H;}while(I&&!B(I)){H.x+=I.offsetLeft;H.y+=I.offsetTop;if(Browser.Engine.gecko){if(!F(I)){H.x+=C(I);H.y+=G(I);
}var K=I.parentNode;if(K&&D(K,"overflow")!="visible"){H.x+=C(K);H.y+=G(K);}}else{if(I!=this&&Browser.Engine.webkit){H.x+=C(I);H.y+=G(I);}}I=I.offsetParent;
}if(Browser.Engine.gecko&&!F(this)){H.x-=C(this);H.y-=G(this);}return H;},getPosition:function(K){if(B(this)){return{x:0,y:0};}var L=this.getOffsets(),I=this.getScrolls();
var H={x:L.x-I.x,y:L.y-I.y};var J=(K&&(K=$(K)))?K.getPosition():{x:0,y:0};return{x:H.x-J.x,y:H.y-J.y};},getCoordinates:function(J){if(B(this)){return this.getWindow().getCoordinates();
}var H=this.getPosition(J),I=this.getSize();var K={left:H.x,top:H.y,width:I.x,height:I.y};K.right=K.left+K.width;K.bottom=K.top+K.height;return K;},computePosition:function(H){return{left:H.x-E(this,"margin-left"),top:H.y-E(this,"margin-top")};
},position:function(H){return this.setStyles(this.computePosition(H));}});Native.implement([Document,Window],{getSize:function(){var I=this.getWindow();
if(Browser.Engine.presto||Browser.Engine.webkit){return{x:I.innerWidth,y:I.innerHeight};}var H=A(this);return{x:H.clientWidth,y:H.clientHeight};},getScroll:function(){var I=this.getWindow();
var H=A(this);return{x:I.pageXOffset||H.scrollLeft,y:I.pageYOffset||H.scrollTop};},getScrollSize:function(){var I=A(this);var H=this.getSize();return{x:Math.max(I.scrollWidth,H.x),y:Math.max(I.scrollHeight,H.y)};
},getPosition:function(){return{x:0,y:0};},getCoordinates:function(){var H=this.getSize();return{top:0,left:0,bottom:H.y,right:H.x,height:H.y,width:H.x};
}});var D=Element.getComputedStyle;function E(H,I){return D(H,I).toInt()||0;}function F(H){return D(H,"-moz-box-sizing")=="border-box";}function G(H){return E(H,"border-top-width");
}function C(H){return E(H,"border-left-width");}function B(H){return(/^(?:body|html)$/i).test(H.tagName);}function A(H){var I=H.getDocument();return(!I.compatMode||I.compatMode=="CSS1Compat")?I.html:I.body;
}})();Native.implement([Window,Document,Element],{getHeight:function(){return this.getSize().y;},getWidth:function(){return this.getSize().x;},getScrollTop:function(){return this.getScroll().y;
},getScrollLeft:function(){return this.getScroll().x;},getScrollHeight:function(){return this.getScrollSize().y;},getScrollWidth:function(){return this.getScrollSize().x;
},getTop:function(){return this.getPosition().y;},getLeft:function(){return this.getPosition().x;}});Native.implement([Document,Element],{getElements:function(H,G){H=H.split(",");
var C,E={};for(var D=0,B=H.length;D<B;D++){var A=H[D],F=Selectors.Utils.search(this,A,E);if(D!=0&&F.item){F=$A(F);}C=(D==0)?F:(C.item)?$A(C).concat(F):C.concat(F);
}return new Elements(C,{ddup:(H.length>1),cash:!G});}});Element.implement({match:function(B){if(!B||(B==this)){return true;}var D=Selectors.Utils.parseTagAndID(B);
var A=D[0],E=D[1];if(!Selectors.Filters.byID(this,E)||!Selectors.Filters.byTag(this,A)){return false;}var C=Selectors.Utils.parseSelector(B);return(C)?Selectors.Utils.filter(this,C,{}):true;
}});var Selectors={Cache:{nth:{},parsed:{}}};Selectors.RegExps={id:(/#([\w-]+)/),tag:(/^(\w+|\*)/),quick:(/^(\w+|\*)$/),splitter:(/\s*([+>~\s])\s*([a-zA-Z#.*:\[])/g),combined:(/\.([\w-]+)|\[(\w+)(?:([!*^$~|]?=)(["']?)([^\4]*?)\4)?\]|:([\w-]+)(?:\(["']?(.*?)?["']?\)|$)/g)};
Selectors.Utils={chk:function(B,C){if(!C){return true;}var A=$uid(B);if(!C[A]){return C[A]=true;}return false;},parseNthArgument:function(F){if(Selectors.Cache.nth[F]){return Selectors.Cache.nth[F];
}var C=F.match(/^([+-]?\d*)?([a-z]+)?([+-]?\d*)?$/);if(!C){return false;}var E=parseInt(C[1]);var B=(E||E===0)?E:1;var D=C[2]||false;var A=parseInt(C[3])||0;
if(B!=0){A--;while(A<1){A+=B;}while(A>=B){A-=B;}}else{B=A;D="index";}switch(D){case"n":C={a:B,b:A,special:"n"};break;case"odd":C={a:2,b:0,special:"n"};
break;case"even":C={a:2,b:1,special:"n"};break;case"first":C={a:0,special:"index"};break;case"last":C={special:"last-child"};break;case"only":C={special:"only-child"};
break;default:C={a:(B-1),special:"index"};}return Selectors.Cache.nth[F]=C;},parseSelector:function(E){if(Selectors.Cache.parsed[E]){return Selectors.Cache.parsed[E];
}var D,H={classes:[],pseudos:[],attributes:[]};while((D=Selectors.RegExps.combined.exec(E))){var I=D[1],G=D[2],F=D[3],B=D[5],C=D[6],J=D[7];if(I){H.classes.push(I);
}else{if(C){var A=Selectors.Pseudo.get(C);if(A){H.pseudos.push({parser:A,argument:J});}else{H.attributes.push({name:C,operator:"=",value:J});}}else{if(G){H.attributes.push({name:G,operator:F,value:B});
}}}}if(!H.classes.length){delete H.classes;}if(!H.attributes.length){delete H.attributes;}if(!H.pseudos.length){delete H.pseudos;}if(!H.classes&&!H.attributes&&!H.pseudos){H=null;
}return Selectors.Cache.parsed[E]=H;},parseTagAndID:function(B){var A=B.match(Selectors.RegExps.tag);var C=B.match(Selectors.RegExps.id);return[(A)?A[1]:"*",(C)?C[1]:false];
},filter:function(F,C,E){var D;if(C.classes){for(D=C.classes.length;D--;D){var G=C.classes[D];if(!Selectors.Filters.byClass(F,G)){return false;}}}if(C.attributes){for(D=C.attributes.length;
D--;D){var B=C.attributes[D];if(!Selectors.Filters.byAttribute(F,B.name,B.operator,B.value)){return false;}}}if(C.pseudos){for(D=C.pseudos.length;D--;D){var A=C.pseudos[D];
if(!Selectors.Filters.byPseudo(F,A.parser,A.argument,E)){return false;}}}return true;},getByTagAndID:function(B,A,D){if(D){var C=(B.getElementById)?B.getElementById(D,true):Element.getElementById(B,D,true);
return(C&&Selectors.Filters.byTag(C,A))?[C]:[];}else{return B.getElementsByTagName(A);}},search:function(I,H,N){var B=[];var C=H.trim().replace(Selectors.RegExps.splitter,function(Y,X,W){B.push(X);
return":)"+W;}).split(":)");var J,E,U;for(var T=0,P=C.length;T<P;T++){var S=C[T];if(T==0&&Selectors.RegExps.quick.test(S)){J=I.getElementsByTagName(S);
continue;}var A=B[T-1];var K=Selectors.Utils.parseTagAndID(S);var V=K[0],L=K[1];if(T==0){J=Selectors.Utils.getByTagAndID(I,V,L);}else{var D={},G=[];for(var R=0,Q=J.length;
R<Q;R++){G=Selectors.Getters[A](G,J[R],V,L,D);}J=G;}var F=Selectors.Utils.parseSelector(S);if(F){E=[];for(var O=0,M=J.length;O<M;O++){U=J[O];if(Selectors.Utils.filter(U,F,N)){E.push(U);
}}J=E;}}return J;}};Selectors.Getters={" ":function(H,G,I,A,E){var D=Selectors.Utils.getByTagAndID(G,I,A);for(var C=0,B=D.length;C<B;C++){var F=D[C];if(Selectors.Utils.chk(F,E)){H.push(F);
}}return H;},">":function(H,G,I,A,F){var C=Selectors.Utils.getByTagAndID(G,I,A);for(var E=0,D=C.length;E<D;E++){var B=C[E];if(B.parentNode==G&&Selectors.Utils.chk(B,F)){H.push(B);
}}return H;},"+":function(C,B,A,E,D){while((B=B.nextSibling)){if(B.nodeType==1){if(Selectors.Utils.chk(B,D)&&Selectors.Filters.byTag(B,A)&&Selectors.Filters.byID(B,E)){C.push(B);
}break;}}return C;},"~":function(C,B,A,E,D){while((B=B.nextSibling)){if(B.nodeType==1){if(!Selectors.Utils.chk(B,D)){break;}if(Selectors.Filters.byTag(B,A)&&Selectors.Filters.byID(B,E)){C.push(B);
}}}return C;}};Selectors.Filters={byTag:function(B,A){return(A=="*"||(B.tagName&&B.tagName.toLowerCase()==A));},byID:function(A,B){return(!B||(A.id&&A.id==B));
},byClass:function(B,A){return(B.className&&B.className.contains(A," "));},byPseudo:function(A,D,C,B){return D.call(A,C,B);},byAttribute:function(C,D,B,E){var A=Element.prototype.getProperty.call(C,D);
if(!A){return(B=="!=");}if(!B||E==undefined){return true;}switch(B){case"=":return(A==E);case"*=":return(A.contains(E));case"^=":return(A.substr(0,E.length)==E);
case"$=":return(A.substr(A.length-E.length)==E);case"!=":return(A!=E);case"~=":return A.contains(E," ");case"|=":return A.contains(E,"-");}return false;
}};Selectors.Pseudo=new Hash({checked:function(){return this.checked;},empty:function(){return !(this.innerText||this.textContent||"").length;},not:function(A){return !Element.match(this,A);
},contains:function(A){return(this.innerText||this.textContent||"").contains(A);},"first-child":function(){return Selectors.Pseudo.index.call(this,0);},"last-child":function(){var A=this;
while((A=A.nextSibling)){if(A.nodeType==1){return false;}}return true;},"only-child":function(){var B=this;while((B=B.previousSibling)){if(B.nodeType==1){return false;
}}var A=this;while((A=A.nextSibling)){if(A.nodeType==1){return false;}}return true;},"nth-child":function(G,E){G=(G==undefined)?"n":G;var C=Selectors.Utils.parseNthArgument(G);
if(C.special!="n"){return Selectors.Pseudo[C.special].call(this,C.a,E);}var F=0;E.positions=E.positions||{};var D=$uid(this);if(!E.positions[D]){var B=this;
while((B=B.previousSibling)){if(B.nodeType!=1){continue;}F++;var A=E.positions[$uid(B)];if(A!=undefined){F=A+F;break;}}E.positions[D]=F;}return(E.positions[D]%C.a==C.b);
},index:function(A){var B=this,C=0;while((B=B.previousSibling)){if(B.nodeType==1&&++C>A){return false;}}return(C==A);},even:function(B,A){return Selectors.Pseudo["nth-child"].call(this,"2n+1",A);
},odd:function(B,A){return Selectors.Pseudo["nth-child"].call(this,"2n",A);}});Element.Events.domready={onAdd:function(A){if(Browser.loaded){A.call(this);
}}};(function(){var B=function(){if(Browser.loaded){return ;}Browser.loaded=true;window.fireEvent("domready");document.fireEvent("domready");};if(Browser.Engine.trident){var A=document.createElement("div");
(function(){($try(function(){A.doScroll("left");return $(A).inject(document.body).set("html","temp").dispose();}))?B():arguments.callee.delay(50);})();
}else{if(Browser.Engine.webkit&&Browser.Engine.version<525){(function(){(["loaded","complete"].contains(document.readyState))?B():arguments.callee.delay(50);
})();}else{window.addEvent("load",B);document.addEvent("DOMContentLoaded",B);}}})();var JSON=new Hash({$specialChars:{"\b":"\\b","\t":"\\t","\n":"\\n","\f":"\\f","\r":"\\r",'"':'\\"',"\\":"\\\\"},$replaceChars:function(A){return JSON.$specialChars[A]||"\\u00"+Math.floor(A.charCodeAt()/16).toString(16)+(A.charCodeAt()%16).toString(16);
},encode:function(B){switch($type(B)){case"string":return'"'+B.replace(/[\x00-\x1f\\"]/g,JSON.$replaceChars)+'"';case"array":return"["+String(B.map(JSON.encode).filter($defined))+"]";
case"object":case"hash":var A=[];Hash.each(B,function(E,D){var C=JSON.encode(E);if(C){A.push(JSON.encode(D)+":"+C);}});return"{"+A+"}";case"number":case"boolean":return String(B);
case false:return"null";}return null;},decode:function(string,secure){if($type(string)!="string"||!string.length){return null;}if(secure&&!(/^[,:{}\[\]0-9.\-+Eaeflnr-u \n\r\t]*$/).test(string.replace(/\\./g,"@").replace(/"[^"\\\n\r]*"/g,""))){return null;
}return eval("("+string+")");}});Native.implement([Hash,Array,String,Number],{toJSON:function(){return JSON.encode(this);}});var Request=new Class({Implements:[Chain,Events,Options],options:{url:"",data:"",headers:{"X-Requested-With":"XMLHttpRequest",Accept:"text/javascript, text/html, application/xml, text/xml, */*"},async:true,format:false,method:"post",link:"ignore",isSuccess:null,emulation:true,urlEncoded:true,encoding:"utf-8",evalScripts:false,evalResponse:false},initialize:function(A){this.xhr=new Browser.Request();
this.setOptions(A);this.options.isSuccess=this.options.isSuccess||this.isSuccess;this.headers=new Hash(this.options.headers);},onStateChange:function(){if(this.xhr.readyState!=4||!this.running){return ;
}this.running=false;this.status=0;$try(function(){this.status=this.xhr.status;}.bind(this));if(this.options.isSuccess.call(this,this.status)){this.response={text:this.xhr.responseText,xml:this.xhr.responseXML};
this.success(this.response.text,this.response.xml);}else{this.response={text:null,xml:null};this.failure();}this.xhr.onreadystatechange=$empty;},isSuccess:function(){return((this.status>=200)&&(this.status<300));
},processScripts:function(A){if(this.options.evalResponse||(/(ecma|java)script/).test(this.getHeader("Content-type"))){return $exec(A);}return A.stripScripts(this.options.evalScripts);
},success:function(B,A){this.onSuccess(this.processScripts(B),A);},onSuccess:function(){this.fireEvent("complete",arguments).fireEvent("success",arguments).callChain();
},failure:function(){this.onFailure();},onFailure:function(){this.fireEvent("complete").fireEvent("failure",this.xhr);},setHeader:function(A,B){this.headers.set(A,B);
return this;},getHeader:function(A){return $try(function(){return this.xhr.getResponseHeader(A);}.bind(this));},check:function(A){if(!this.running){return true;
}switch(this.options.link){case"cancel":this.cancel();return true;case"chain":this.chain(A.bind(this,Array.slice(arguments,1)));return false;}return false;
},send:function(I){if(!this.check(arguments.callee,I)){return this;}this.running=true;var G=$type(I);if(G=="string"||G=="element"){I={data:I};}var D=this.options;
I=$extend({data:D.data,url:D.url,method:D.method},I);var E=I.data,B=I.url,A=I.method;switch($type(E)){case"element":E=$(E).toQueryString();break;case"object":case"hash":E=Hash.toQueryString(E);
}if(this.options.format){var H="format="+this.options.format;E=(E)?H+"&"+E:H;}if(this.options.emulation&&["put","delete"].contains(A)){var F="_method="+A;
E=(E)?F+"&"+E:F;A="post";}if(this.options.urlEncoded&&A=="post"){var C=(this.options.encoding)?"; charset="+this.options.encoding:"";this.headers.set("Content-type","application/x-www-form-urlencoded"+C);
}if(E&&A=="get"){B=B+(B.contains("?")?"&":"?")+E;E=null;}this.xhr.open(A.toUpperCase(),B,this.options.async);this.xhr.onreadystatechange=this.onStateChange.bind(this);
this.headers.each(function(K,J){try{this.xhr.setRequestHeader(J,K);}catch(L){this.fireEvent("exception",[J,K]);}},this);this.fireEvent("request");this.xhr.send(E);
if(!this.options.async){this.onStateChange();}return this;},cancel:function(){if(!this.running){return this;}this.running=false;this.xhr.abort();this.xhr.onreadystatechange=$empty;
this.xhr=new Browser.Request();this.fireEvent("cancel");return this;}});(function(){var A={};["get","post","put","delete","GET","POST","PUT","DELETE"].each(function(B){A[B]=function(){var C=Array.link(arguments,{url:String.type,data:$defined});
return this.send($extend(C,{method:B.toLowerCase()}));};});Request.implement(A);})();Element.Properties.send={set:function(A){var B=this.retrieve("send");
if(B){B.cancel();}return this.eliminate("send").store("send:options",$extend({data:this,link:"cancel",method:this.get("method")||"post",url:this.get("action")},A));
},get:function(A){if(A||!this.retrieve("send")){if(A||!this.retrieve("send:options")){this.set("send",A);}this.store("send",new Request(this.retrieve("send:options")));
}return this.retrieve("send");}};Element.implement({send:function(A){var B=this.get("send");B.send({data:this,url:A||B.options.url});return this;}});Request.HTML=new Class({Extends:Request,options:{update:false,evalScripts:true,filter:false},processHTML:function(C){var B=C.match(/<body[^>]*>([\s\S]*?)<\/body>/i);
C=(B)?B[1]:C;var A=new Element("div");return $try(function(){var D="<root>"+C+"</root>",G;if(Browser.Engine.trident){G=new ActiveXObject("Microsoft.XMLDOM");
G.async=false;G.loadXML(D);}else{G=new DOMParser().parseFromString(D,"text/xml");}D=G.getElementsByTagName("root")[0];for(var F=0,E=D.childNodes.length;
F<E;F++){var H=Element.clone(D.childNodes[F],true,true);if(H){A.grab(H);}}return A;})||A.set("html",C);},success:function(D){var C=this.options,B=this.response;
B.html=D.stripScripts(function(E){B.javascript=E;});var A=this.processHTML(B.html);B.tree=A.childNodes;B.elements=A.getElements("*");if(C.filter){B.tree=B.elements.filter(C.filter);
}if(C.update){$(C.update).empty().set("html",B.html);}if(C.evalScripts){$exec(B.javascript);}this.onSuccess(B.tree,B.elements,B.html,B.javascript);}});
Element.Properties.load={set:function(A){var B=this.retrieve("load");if(B){B.cancel();}return this.eliminate("load").store("load:options",$extend({data:this,link:"cancel",update:this,method:"get"},A));
},get:function(A){if(A||!this.retrieve("load")){if(A||!this.retrieve("load:options")){this.set("load",A);}this.store("load",new Request.HTML(this.retrieve("load:options")));
}return this.retrieve("load");}};Element.implement({load:function(){this.get("load").send(Array.link(arguments,{data:Object.type,url:String.type}));return this;
}});Request.JSON=new Class({Extends:Request,options:{secure:true},initialize:function(A){this.parent(A);this.headers.extend({Accept:"application/json","X-Request":"JSON"});
},success:function(A){this.response.json=JSON.decode(A,this.options.secure);this.onSuccess(this.response.json,A);}});


			function mouseClick(e) {

				if (e.target) {
					switch (e.target.nodeName) {
						case 'text':
							var target = e.target.textContent.replace(/\s+/g, '');
							break;
						case 'li':
							var target = $(e.target).getElement('div').get('text').replace(/\s+/g, '');
							break;
						case 'svg':
							var target = e.target.getElement('text').textContent.replace(/\s+/g, '');
							break;
					}
				} else return;

				$$('li').each( function(el, key) {
					if (el.getNext())
						var sl = 'Selected';
					else
						var sl = 'SelectedLast';

					var current = el.getElement('div').get('text').replace(/\s+/g, '');

					if (current == this) {

						el.addClass(sl);
						if (!el.getPrevious())
							el.getParent('.TabsOuterContainer').addClass('SelectedOuter');

						$(current+'Container').set('styles', {display: 'block'});
					} else {
						if ( el.className.test(/Selected\w*/) ) {
							el.removeClass('Selected').removeClass('SelectedLast');
							if (!el.getPrevious())
								el.getParent('.TabsOuterContainer').removeClass('SelectedOuter');
						}

						$(current+'Container').set('styles', {display: 'none'});
					}

				}, target);
			}

			window.addEvent('domready', function() {
				var selectedTab = $('_DASHBOARD_SELECTEDTAB_TEMPLATE_Tab');
				
				selectedTab.addClass( selectedTab.getNext() ? 'Selected' : 'SelectedLast' );
					
				if (!selectedTab.getPrevious())
					selectedTab.getParent('.TabsOuterContainer').addClass('SelectedOuter');
							
				$('containers').getElements('div[id$=Container]').each( function(el) {
					el.style.display = 'none';
				} );
				$('_DASHBOARD_SELECTEDTAB_TEMPLATE_Container').style.display = 'block';
				
				$$('li').each( function(el, key) {
					el.addEvent( 'click', mouseClick );
				});
			});
		]]>
		</script>
	</head>
	<body>
		<center id="c">
			<form name="f" method="get" action="http://www.google.com/search">
				<div id="logo"></div>
				<input type="text" id="q" name="q" value="Enter search text here" onclick="this.style.color = '#333'; this.value='';"/>
				<input type="submit" value="Search Google" id="s"/>
			</form>
		</center>
		<div class="TabsOuterContainer">
			<div class="TabsInnerContainer">
				<ul>
					<li id="HistoryTab">
						<div class="canvas">History</div>
						<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="20px" height="55px" cursor="pointer">
								<text x="-50" y="18" transform="rotate(-90)" class="TabLink">History</text>
						</svg>
					</li>
					<li id="BookmarksTab">
						<div class="canvas">Bookmarks</div>
						<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="20px" height="85px" cursor="pointer">
								<text x="-80" y="18" transform="rotate(-90)" class="TabLink">Bookmarks</text>
						</svg>
					</li>
					<li id="MostUsedTab" class="lastLI">
						<div class="canvas">Most Used</div>
						<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="20px" height="85px" cursor="pointer">
								<text x="-75" y="18" transform="rotate(-90)" class="TabLink">Most Used</text>
						</svg>
					</li>
				</ul>
			</div>
		</div>
		<div class="TabsOuterContainer TabsRight">
			<div class="TabsInnerContainer">
				<ul>
					<li id="History2Tab">
						<div class="canvas">History 2</div>
						<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="20px" height="60px" cursor="pointer">
								<text x="0" y="-10" transform="rotate(90)" class="TabLink">History 2</text>
						</svg>
					</li>
					<li id="Bookmarks2Tab">
						<div class="canvas">Bookmarks 2</div>
						<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="20px" height="85px" cursor="pointer">
								<text x="0" y="-10" transform="rotate(90)" class="TabLink">Bookmarks 2</text>
						</svg>
					</li>
					<li id="SearchesTab" class="lastLI">
						<div class="canvas">Searches</div>
						<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="20px" height="80px" cursor="pointer">
								<text x="5" y="-10" transform="rotate(90)" class="TabLink">Searches</text>
						</svg>
					</li>
				</ul>
			</div>
		</div>
		<div id="containers">
			<div id="HistoryContainer">
				<div class="quickdial">
					<div id="11">1</div>
					<div id="12">2</div>
					<div id="13">3</div>
					<div id="14">4</div>
					<div id="15">5</div>
					<div id="16">6</div>
					<div id="17">7</div>
					<div id="18">8</div>
					<div id="19">9</div>
				</div>
			</div>
			<div id="BookmarksContainer">
				<div class="quickdial">
					<div id="21">1</div>
					<div id="22">2</div>
					<div id="23">3</div>
					<div id="24">4</div>
					<div id="25">5</div>
					<div id="26">6</div>
					<div id="27">7</div>
					<div id="28">8</div>
					<div id="29">9</div>
				</div>
			</div>
			<div id="MostUsedContainer">
				<div class="quickdial">
					<div id="31">1</div>
					<div id="32">2</div>
					<div id="33">3</div>
					<div id="34">4</div>
					<div id="35">5</div>
					<div id="36">6</div>
					<div id="37">7</div>
					<div id="38">8</div>
					<div id="39">9</div>
				</div>
			</div>
			<div id="History2Container">
				<div class="quickdial">
					<div id="41">1</div>
					<div id="42">2</div>
					<div id="43">3</div>
					<div id="44">4</div>
					<div id="45">5</div>
					<div id="46">6</div>
					<div id="47">7</div>
					<div id="48">8</div>
					<div id="49">9</div>
				</div>
			</div>
			<div id="Bookmarks2Container">
				<div class="quickdial">
					<div id="51">1</div>
					<div id="52">2</div>
					<div id="53">3</div>
					<div id="54">4</div>
					<div id="55">5</div>
					<div id="56">6</div>
					<div id="57">7</div>
					<div id="58">8</div>
					<div id="59">9</div>
				</div>
			</div>
			<div id="SearchesContainer">
				<div class="quickdial">
					<div id="61">1</div>
					<div id="62">2</div>
					<div id="63">3</div>
					<div id="64">4</div>
					<div id="65">5</div>
					<div id="66">6</div>
					<div id="67">7</div>
					<div id="68">8</div>
					<div id="69">9</div>
				</div>
			</div>
		</div>
	</body>
</html>
""";

public string? str_replace(string needle, string new_needle, string? haystack) {
	string[] buf;
	
	if (haystack == null)
		return null;

	buf = haystack.split(needle);

	var output = haystack.joinv(new_needle, buf);

	return output;
}

public string? str_capitalize_and_shrink(string input) {
	
	if (input == null)
		return null;

	if (input == "")
		return "";

	StringBuilder output = new StringBuilder("");

	output.append_unichar( input[0].toupper() );
	for (var i = 1; i <= input.len() - 1; i++) {
		 if (input[i-1] == ' ' || input[i-1] == '\t')
		 	output.append_unichar( input[i].toupper() );
		 else
			if (input[i] != ' ' && input[i] != '\t')
				output.append_unichar( input[i] );
	}
		
	return output.str;
}

public string shorten_string( string input, int length = 50 ) {

	if (length < 20)
		length = 20;

	if ( input.len() > length )
		return input.substring( 0, length - 10 ) + "..." + input.substring( input.len() - 10, 10 );

	return input;
}

public bool preg_test (string haystack, string? needle) {
	if ( needle == null ) {
		return false;
	}
	
	string error;
	int erroffset;
	int[] ov = new int[20];
	
	var regex = PRegex.compile( needle, PCRE.Options.CASELESS, out error, out erroffset, null );
	return (PRegex.exec( regex, null, haystack, (int) haystack.length, 0, 0, ov ) >= 0 ? true : false );
}

public void empty_history() {
    dbqueue.push ( "DELETE FROM `quickdata` WHERE `type` = 'history';" );
    dbqueue.db.exec ( "VACUUM;" ); 
}

public void empty_searches() {
    dbqueue.push ( "DELETE FROM `quickdata` WHERE `type` = 'search';" );
    dbqueue.db.exec ( "VACUUM;" ); 
}

public void empty_cookies() {
	FileUtils.set_contents( Environment.get_home_dir () + "/.webkitcookies", "" );
}

/* Can be refactored to a class (along with the windows List) */
public Tear.BrowserWindow? get_topmost_window() {
    foreach (Gtk.Window window in windows) {
        if (((Hildon.Window) window).is_topmost) 
			return ((Tear.BrowserWindow) window);
    }
    return null;
}

public void refresh_all_settings() {
    foreach (Gtk.Window window in windows) {
	    if ( ((Tear.BrowserWindow) window).web_view != null )
			((Tear.BrowserWindow) window).web_view.refresh_settings();
    }
}

public void on_action_activated (Gtk.UIManager sender, Gtk.Action action) 	{
	var win = get_topmost_window ();
	string action_name = action.name;

	switch (action_name) {

		case "windows-new":
            new Tear.BrowserWindow ().start ();
		break;

		case "windows-opennew":
			if (DEBUG)
				warning( hover_uri );
            new Tear.BrowserWindow ().start (hover_uri);
		break;
		case "windows-open":
			if (DEBUG)
				warning( hover_uri );
			win.web_view.stop_loading ();
	        win.web_view.open (hover_uri);
		break;
		
		case "windows-undo":
			int nrows, ncols, result;
			
	        var table = dbqueue.pull ("SELECT `addr` FROM `quickdata` WHERE type = 'history' ORDER by `close_date` DESC LIMIT 1;", out nrows, out ncols, out result );
	        if (result == Sqlite.OK) { 
		        new Tear.BrowserWindow ().start ( table[1] );
        	}
		break;

//		case "page-openloc":
//		break;
		case "page-openfile":
				var file_chooser = new Hildon.FileChooserDialog.with_properties ( win, "action", FileChooserAction.OPEN );

				var result = file_chooser.run();
				file_chooser.hide();
				
				if (result == Gtk.ResponseType.OK)
					win.start("file://"+file_chooser.get_filename());

		break;
//		case "page-saveas":
//		break;
		case "page-add-bookmark":
#if FREMANTLE
			win.add_bookmark_fremantle();
#else
			win.add_bookmark();
#endif
		break;
#if FREMANTLE
		case "page-remove-bookmark":
			win.remove_bookmark_fremantle();
		break;
#endif
		case "tools-rss":
#if FREMANTLE
			win.open_rss_fremantle();
#else
//			win.open_rss();
#endif
		break;
		case "page-details":
#if FREMANTLE
			win.page_details_fremantle();
#else
//			win.page_details();
#endif
		break;
		case "page-set-homepage":
			options.update_option ( "home_page", win.web_view.get_main_frame().get_uri() );
		break;
//		case "page-details":
//		break; 
		
		case "edit-cut": 
			if (win.web_view.can_cut_clipboard ())
		    	win.web_view.cut_clipboard ();
		break;
		case "edit-copy":
			if (win.web_view.can_copy_clipboard ())
		    	win.web_view.copy_clipboard ();
		break;
		case "edit-paste":
			if (win.web_view.can_paste_clipboard ())
		    	win.web_view.paste_clipboard ();
		break;
		case "edit-select-all":
			win.web_view.select_all ();
		break;

		case "devel-inspect":
			win.web_view.inspect();
		break;

		case "tool-dashboard":
			win.start("about:blank");
		break;
		
//		case "view-encoding":
//		break;
//		
		case "tools-find":
			win.findbar_show();
		break;
//		case "tools-downloads":
//		break;
//		case "tools-preferences":
//		break;
		
		case "close-window":
		    win.destroy();
		break;
		case "close-all-windows":
			main_quit();
		break;
		case "close-remember":
			saving_session = true;
			options.update_option( "saved_session", "true" );
			main_quit();
		break;
		
		case "view-zoom100":
	    	win.web_view.set_zoom_level(1);
	    	
	    	Banner.show_information(win, null, "Zoom 100%");
		break;
		case "tool-zoomin":
	    	win.web_view.zoom_in();
	    	
	    	var zl = win.web_view.zoom_level*100; 
	    	Banner.show_information(win, null, "Zoom "+zl.to_string()+"%");
		break;
		case "tool-zoomout":
	    	win.web_view.zoom_out();

	    	var zl = win.web_view.zoom_level*100;
	    	Banner.show_information(win, null, "Zoom "+zl.to_string()+"%");
		break;
		case "tool-showimages":
			var act = (ToggleAction) ((Tear.UIManager) uim).action_group.get_action("tool-showimages");
			options.update_option( "auto_load_images", act.active.to_string() );
			refresh_all_settings();
		break;
		case "tool-javascript":
			var act = (ToggleAction) ((Tear.UIManager) uim).action_group.get_action("tool-javascript");
			options.update_option( "enable_scripts", act.active.to_string() );
			refresh_all_settings();
		break;
		case "tool-plugins":
			var act = (ToggleAction) ((Tear.UIManager) uim).action_group.get_action("tool-plugins");
			options.update_option( "enable_plugins", act.active.to_string() );
			refresh_all_settings();
		break;
		case "tools-clearcookies":
			var message = new MessageDialog.with_markup(win, DialogFlags.MODAL, MessageType.QUESTION, ButtonsType.OK_CANCEL, 
							   "Do you really want to remove all cookies?");
							   
			var result = message.run();
			message.hide();
			
			if (result == Gtk.ResponseType.OK)
				empty_cookies();
		break;
		case "tools-clearhistory":
			var message = new MessageDialog.with_markup(win, DialogFlags.MODAL, MessageType.QUESTION, ButtonsType.OK_CANCEL, 
							   "Do you really want to empty your history?");
							   
			var result = message.run();
			message.hide();
			
			if (result == Gtk.ResponseType.OK) {
				empty_history();
	    	}
		break;
		case "tools-clearsearches":
			var message = new MessageDialog.with_markup(win, DialogFlags.MODAL, MessageType.QUESTION, ButtonsType.OK_CANCEL, 
							   "Do you really want to purge your searches?");
							   
			var result = message.run();
			message.hide();
			
			if (result == Gtk.ResponseType.OK) {
				empty_searches();
	    	}
		break;
		case "tools-downloads":
			download_manager.show_all ();
			download_manager.present ();
		break;

		case "tools-options":
			options.show_all ();
			options.present ();
		break;

		case "toolbar-back":
			if (win.web_view.can_go_back ())
		    	win.web_view.go_back ();
		break;
		case "toolbar-forward":
			if (win.web_view.can_go_forward ())
		    	win.web_view.go_forward ();
		break;
		case "toolbar-reload":
	    	win.web_view.reload ();
		break;

		case "view-show-toolbar":
		case "view-show-toolbar-full":
			var act = (ToggleAction) ((Tear.UIManager) uim).action_group.get_action(action_name);
		
			bool stf = act.active;
			options.update_option( act.tooltip, stf.to_string() );
			win.update_toolbar( win.allocation.width, win.allocation.height );
		break;
		case "view-show-progressline":
		case "view-show-progressline-full":
			var act = (ToggleAction) ((Tear.UIManager) uim).action_group.get_action(action_name);
			
			options.update_option( act.tooltip, act.active.to_string() );
			win.update_toolbar( win.allocation.width, win.allocation.height );
		break;
		case "view-show-toolbar-bottom":
		case "view-show-toolbar-bottom-full":
			var act = (ToggleAction) ((Tear.UIManager) uim).action_group.get_action(action_name);
			
		    string orientation = (act.active ? "bottom" : "top");
			options.update_option( act.tooltip, orientation );
			win.update_toolbar( win.allocation.width, win.allocation.height );
		break;

		case "view-fullscreen":
		    if (win.window.get_state() == WindowState.FULLSCREEN)
		    	win.unfullscreen();
		    else
		    	win.fullscreen();
	    	
		break;
		
		case "help-about":
			if (!about.visible)
				about.show ();
		break;
		
		default:
			if (DEBUG)
				warning ("unhandled event"); 
		break;
	}
}

#if FREMANTLE
public class Tear.BrowserWindow : Hildon.StackableWindow { 
#else
public class Tear.BrowserWindow : Hildon.Window { 
#endif	

	    public Tear.Quickbar quickbar;
	    public Tear.WebKitView web_view; 
//#if FREMANTLE
//		public PannableArea scrolled_window;
//#else
		public ScrolledWindow scrolled_window;
//#endif
	    public Tear.WebKitView inspected_view;
	    public bool has_toolbar { get; construct; }
	    public bool is_fullscreen;
		public Tear.Drawer drawer;
	    public ProgressBar progress;
	    public VBox entry_progress;
	    public VBox vbox;
	    
	    private ToolButton back_button;
	    private ToolButton forward_button;
	    private ToolButton reload_button;
	    private ToolButton stop_button;
	    private ToolButton add_button;
	    private ToolButton empty_button;
	    private ToolButton bookmark_button;
	    private Toolbar toolbar;
	    private ToolItem entry_toolitem;

		private Gtk.Image bookmark_image;
		private Gtk.Image bookmark_rss_image;
		private Gtk.Image empty_image;
		private Gtk.Image empty_rss_image;

#if FREMANTLE
	    public int chosen;
	    private unowned Hildon.CheckButton fullscreen_button;
		private Hildon.AppMenu[] menus;
	    private Hildon.Dialog page_dialog;
#else
	    private Gtk.Menu tool_popup;
	    private ToolButton menu_button;
	    private ToolButton go_button;
#endif
	    private Tear.Menu back_menu;
	    private Tear.Menu forward_menu;
	    private Tear.Menu reload_menu;
	    private bool load_commited;
	    private bool pulsing;
	    private string old_uri;
	    private Hildon.FindToolbar findbar;
	    private string bookmarklet_href;
	    private string bookmarklet_title;
	    
	    private struct RSSFeed {
		    public string title;
		    public string href;
	    }
	    
	    private RSSFeed[] rss_feeds;

	    public BrowserWindow (bool toolbar = true, WebView? inspected_view = null) {
	        this.has_toolbar = toolbar;
	        this.inspected_view = (Tear.WebKitView) inspected_view;
	    }

	    construct {
		    
			this.set_icon_from_file (Config.PIXMAPS_DIR + "/" + Config.PACKAGE + ".png"); 
            program.add_window (this);
#if FREMANTLE
            if (windows.length() == 0)
            	stack = WindowStack.get_default();
#endif
            windows.append(this);

   			Gtk.rc_parse_string("""
			style "tear-toolbar"
			{
				GtkToolbar::internal-padding = 7
				GtkToolbar::button-relief = GTK_RELIEF_NORMAL
				GtkToolbar::shadow-type = GTK_SHADOW_NONE
				GtkToolbar::max-child-expand = 800
				GtkToolbar::space-size = 15
			}
			widget "*MainToolbar*" style "tear-toolbar"
			
			style "tear-window"
			{
				HildonWindow::borders = { 8, 8, 0, 4 }
			}
			widget "*TearWindow*" style "tear-window"
   	        """);

   	        this.set_name("TearWindow");
   	        
            is_fullscreen = (this.window.get_state() == WindowState.FULLSCREEN);
            pulsing = false;
			this.rss_feeds = new RSSFeed[0];
			
            this.set_events (Gdk.EventMask.KEY_PRESS_MASK | Gdk.EventMask.KEY_RELEASE_MASK);
            
			this.destroy += (s) => {
				if (!saving_session) {
					var frame = this.web_view.get_main_frame();
		        	dbqueue.push ("UPDATE OR IGNORE `quickdata` SET `close_date` = datetime('now'), `opened` = 0 WHERE `addr` = '"+ frame.get_uri() +"' and `type` = 'history';" );
		        }
	        	
	        	windows.remove(this);
				
				if (windows.length () < 1) {
					this.web_view.stop_loading ();
					Gtk.main_quit ();
				}
			};
			
			create_webview ();
             
   	        if (has_toolbar) {
   	        	create_widgets ();
				add_accel_group (uim.get_accel_group ());
			    
	        	connect_signals ();
	        	this.quickbar.grab_focus ();
        	} else {
	        	this.add (scrolled_window);
	        	this.show_all ();
        	}

	    }

		protected void findbar_show () {
			findbar.visible = !findbar.visible;
			findbar.highlight_entry(true);
		}

		protected void findbar_search () {
			if(findbar.prefix == "")
			{
				Banner.show_information(this, null, "Enter the text to be found");
				return;
			}
			if(!this.web_view.search_text(findbar.prefix, false, true, true)) Banner.show_information(this, null, "\""+findbar.prefix+"\""+" not found");
		}

	    private void create_webview () {
	        this.web_view = new Tear.WebKitView ();

//#if FREMANTLE
//	        scrolled_window = new PannableArea.full ( PannableAreaMode.ACCEL, true, 0, 200, 0.8, 20 );
//	        scrolled_window.initial_hint = true;
//	        scrolled_window.low_friction_mode = false;
//	        scrolled_window.add (this.web_view);
//#else
   	        scrolled_window = new ScrolledWindow (null, null);
	        scrolled_window.set_policy (PolicyType.AUTOMATIC, PolicyType.AUTOMATIC);
	        scrolled_window.add (this.web_view);
//#endif
	        
			this.set_scrollbars( options.set_or_get("scrollbar", "normal", true, "Scrollbar", "string", "normal|thumb|none" ) );
	    }

#if FREMANTLE
		private int get_menu_index( string label ) {
			var output = 0;
			
			for ( var i = 0; i < menu_pages.length; i++ ) {
				if (label == menu_pages[i])
					output = i;
			}
			
			return output;
		}
				
		private void filter_callback( Gtk.RadioButton button ) {
			var label = ((Gtk.RadioButton) button).get_label();
			if (label == "About") {
				about.go();
			} else {
				var to_be_chosen = get_menu_index( label );
				if (chosen != to_be_chosen) {
//					var note = new Note.information ( this, chosen.to_string() );
//					note.run();
//					note.hide();
					
					chosen = to_be_chosen;
					this.set_app_menu(this.menus[chosen]);
					
					Timeout.add( 100, test );
					
					unowned List<Gtk.RadioButton> filters = (List<Gtk.RadioButton>) this.menus[chosen].get_filters();
					
					foreach ( Gtk.RadioButton filter in filters ) {
						filter.pressed -= filter_callback;
						
						if (filter.get_label() != label)
							filter.active = false;

						filter.pressed += filter_callback;
					}
				}
			}
		}
		
		private bool test () {
			this.menus[chosen].show();
			
			return false;
		}
		
		private unowned Hildon.Button? get_appmenu_button( int menu_number, string title ) {
			unowned List<Hildon.Button> buttons = (List<Hildon.Button>) this.menus[menu_number].get_items();
			
			foreach ( unowned Hildon.Button button in buttons ) {
				
				if (button.get_label() == title)
					return button;
			}
			
			return null;
		}
		
		private void build_tabs( AppMenu menu, int index ) {
			var radio = (Gtk.RadioButton) Hildon.gtk_radio_button_new(button_size, null);
			radio.set_label( menu_pages[0] );
			radio.set_mode( false );
			if (index == 0)
				radio.set_active( true );

			radio.clicked += filter_callback; 
				
			menu.add_filter( radio );
			
			for (var j = 1; j < menu_pages.length; j++) {
				
				var radio_clone = (Gtk.RadioButton) Hildon.gtk_radio_button_new_from_widget(button_size, radio);
				radio_clone.set_label( menu_pages[j] );
				radio_clone.set_mode( false );

				if (index == j)
					radio_clone.set_active( true );
					
				radio_clone.pressed += filter_callback;
				
				menu.add_filter( radio_clone );
			}
			
		}
		
		private void populate_fremantle_menus() {
			
			chosen = 0;
			this.menus = new AppMenu[0];
			
			for (var i = 0; i < menu_pages.length-1; i++) {

				this.menus += new AppMenu();

//				if (i == 0)
				build_tabs( this.menus[i], i );

				switch (menu_pages[i]) {
				    case "Tools":
					    for ( var j = 0; j < uim.tools.length; j++ ) {  
						    unowned Action act = (Action) uim.action_group.get_action( uim.tools[j].name );
						    
							Hildon.Button button = new Hildon.Button( button_size, ButtonArrangement.HORIZONTAL );
							act.connect_proxy ( button );
					        this.menus[i].append( button );
				    	}
					    for ( var j = 0; j < uim.toggles.length; j++ ) {
					    	unowned ToggleAction act = (ToggleAction) uim.action_group.get_action( uim.toggles[j].name );
					    	
							Hildon.CheckButton button = new Hildon.CheckButton( button_size );
							if (uim.toggles[j].name == "view-fullscreen")
								this.fullscreen_button = button;
							
							button.set_active(act.active);
							act.connect_proxy ( button );
					        this.menus[i].append( button );
				    	}
				    	break;
				    case "Private":
					    for ( var j = 0; j < uim.private_data.length; j++ ) {  
						    unowned Action act = (Action) uim.action_group.get_action( uim.private_data[j].name );
						    
							Hildon.Button button = new Hildon.Button( button_size, ButtonArrangement.HORIZONTAL );
							act.connect_proxy ( button );
					        this.menus[i].append( button );
				    	}
				    	break;
					default:
					    for ( var j = 0; j < uim.page.length; j++ ) {  
						    Action act = uim.action_group.get_action( uim.page[j].name );
						    
							Hildon.Button button = new Hildon.Button( button_size, ButtonArrangement.HORIZONTAL );
							act.connect_proxy ( button );
					        this.menus[i].append( button );
				    	}
				    	break;
	    		}
		    	
				this.menus[i].show_all();
			}
		    
			this.set_app_menu(this.menus[0]);
			
			this.page_dialog = new Hildon.Dialog();
			this.page_dialog.title = "Bookmark Actions";
			
			var half = (int) Math.ceil(uim.page_actions.length / 2);
			for ( var i = 0; i < half; i++ ) {
				var hbox = new Gtk.HBox(true, 0);
				
			    for ( var j = 0; j < 2; j++ ) {
				    if (i*2 + j <= uim.page_actions.length) {
					    unowned Action act = (Action) uim.action_group.get_action( uim.page_actions[i*2 + j].name );
					    
						Hildon.Button button = new Hildon.Button( button_size, ButtonArrangement.HORIZONTAL );
						act.connect_proxy ( button );
						button.clicked.connect( (s) => { 
							((Widget) s).get_toplevel().hide();
						} );
						hbox.add( button );
			    	}
		    	}
		    	if (i == 1)
		    		this.page_dialog.vbox.pack_start( new Label( "Page Actions" ), true, false, 5 );
		    	
		        this.page_dialog.vbox.pack_start( hbox, true, false, 0 );
	    	}
	    	this.page_dialog.vbox.show_all();
		}
#endif

	    private void create_widgets () {

      		this.fresh_settings();
	        if (DEBUG)
	        	warning ("Creation Started");
      		
	        this.toolbar = new Toolbar ();
	        
			this.findbar = new FindToolbar ("Find");
			this.findbar.close += findbar_show;
			this.findbar.search += findbar_search;
			this.add_toolbar (this.findbar);

			var prefix = Config.APP_DIR.concat("/", Config.APPNAME);
			this.back_button = new ToolButton( new Gtk.Image.from_file( prefix + "_back.png" ), "Back" );
			this.forward_button = new ToolButton( new Gtk.Image.from_file( prefix + "_forward.png" ), "Forward" );
			this.reload_button = new ToolButton( new Gtk.Image.from_file( prefix + "_refresh.png" ), "Refresh" );
			this.stop_button = new ToolButton( new Gtk.Image.from_file( prefix + "_stop.png" ), "Stop" );
			this.add_button = new ToolButton( new Gtk.Image.from_file( prefix + "_add.png" ), "New Window" );
#if !FREMANTLE
			this.menu_button = new ToolButton( new Gtk.Image.from_icon_name("qgn_list_hw_button_up", Gtk.IconSize.SMALL_TOOLBAR), "Menu" );
			this.go_button = new ToolButton( new Gtk.Image.from_file( prefix + "_go.png" ), "Go" );
#endif
			this.bookmark_image = new Gtk.Image.from_file( prefix + "_bookmark.png");
			this.bookmark_rss_image = new Gtk.Image.from_file( prefix + "_bookmark_rss.png");
			this.empty_image = new Gtk.Image.from_file( prefix + "_no_bookmark.png");
			this.empty_rss_image = new Gtk.Image.from_file( prefix + "_no_bookmark_rss.png");
			this.bookmark_rss_image.show();
			this.empty_rss_image.show();
			
			this.empty_button = new ToolButton( this.empty_image, "Not bookmarked" );
			this.bookmark_button = new ToolButton( this.bookmark_image, "Bookmarked" );
			this.bookmark_button.hide();
	        
   	        this.back_button.sensitive = false;
	        this.forward_button.sensitive = false;

   	        this.back_menu = new Tear.Menu(this);
	        this.forward_menu = new Tear.Menu(this);
	        this.reload_menu = new Tear.Menu(this);
	        
	        fill_reload_menu();
			reload_menu.show_all();
   	        ((Widget) this.reload_button).tap_and_hold_setup( reload_menu, null, Gtk.TapAndHoldFlags.NONE | Gtk.TapAndHoldFlags.NO_INTERNALS);
    
	        toolbar.add (this.empty_button);
	        toolbar.add (this.bookmark_button);
	        toolbar.add (this.reload_button);
	        toolbar.add (this.stop_button);
	        toolbar.add (new SeparatorToolItem ());
	        toolbar.add (this.add_button);
	       
	        this.quickbar = new Tear.Quickbar();
	        this.progress = new ProgressBar ();
	        this.quickbar.height_request = 42;
	        this.progress.height_request = 15;
	        this.entry_progress = new VBox ( false, 0 );
	        this.entry_progress.pack_start (this.quickbar, false, false, 0);
	        this.entry_progress.pack_start (this.progress, false, false, 0);
	        this.entry_progress.height_request = 60;
	        
	        ((Widget) this.web_view).tap_and_hold_setup( null, null, Gtk.TapAndHoldFlags.NONE );
		
			this.entry_toolitem = new ToolItem ();
			this.entry_toolitem.set_expand (true);
			this.entry_toolitem.add (this.entry_progress);
#if !FREMANTLE
	        this.tool_popup = (Gtk.Menu) uim.get_widget("/tool-popup");
#endif
						
	        toolbar.add (this.entry_toolitem);
#if !FREMANTLE
	        toolbar.add (this.go_button);
#endif
	        toolbar.add (this.back_button);
	        toolbar.add (this.forward_button);
#if !FREMANTLE
	        toolbar.add (new SeparatorToolItem ());
	        toolbar.add (this.menu_button);
#endif
	        toolbar.height_request = 65;
	        
	        this.show_all ();
	        
			this.drawer = new Tear.Drawer("bottom");
			this.drawer.show();
			this.add( this.drawer );
			
			this.drawer.set_over( this.toolbar );
			this.toolbar.show();
   	        this.toolbar.set_name("MainToolbar");

	        this.vbox = new VBox (false, 0);
	        this.vbox.pack_start (scrolled_window, true, true, 0);
			this.vbox.show_all();
			this.drawer.set_under( this.vbox );

			this.drawer.set_min( options.get_bool( "show_toolbar" ) ? -1 : 0 );
			
	       	this.quickbar.populate();
			this.quickbar.refresh_bookmarks();
      		this.quickbar.on_change_enabled(true);
      		
			options.set_buffered();
      		this.web_view.refresh_settings();
			if (options.cache.lookup("options_backend").title != "Options Backend")
				options.flush(true);
			else
				options.flush(false);

	        if (DEBUG)
	        	warning ("Update Toggles");
			uim.update_toggles();

#if FREMANTLE
			populate_fremantle_menus();
#endif

	        this.show_all ();
			this.findbar.hide();
	        
	    }

		private void fresh_settings() {
			options.set_or_get( "options_backend", "sqlite", false, "Options Backend", "string", "sqlite" );
	        if (DEBUG)
	        	warning ("First Setting");
			
			options.set_buffered();
			options.set_or_get_bool( "show_toolbar", true, true, "Show Toolbar" );
			options.set_or_get_bool( "show_toolbar_fullscreen", false, true, "Show Toolbar in Fullscreen" );
			options.set_or_get_bool( "show_progressline", false, true, "Show Progress Line" );
			options.set_or_get_bool( "show_progressline_fullscreen", true, true, "Show Progress Line in Fullscreen" );
			bool should_be_fullscreen = options.set_or_get_bool( "fullscreen_by_default", false, true, "Start in Fullscreen" );
			options.set_or_get( "toolbar_orientation", "bottom", true, "Toolbar Orientation", "string", "top|bottom" );
			options.set_or_get( "toolbar_orientation_fullscreen", "bottom", true, "Toolbar Orientation in Fullscreen", "string", "top|bottom" );
			options.set_or_get( "wake_toolbar_shortcut", "D-Enter", true, "Popup Toolbar with", "string", "D-Enter" );
			options.set_or_get( "wake_toolbar_shortcut_speed", "long", true, "Toolbar Popup Speed", "string", "short|long" );
			options.set_or_get_bool( "empty_cookies_on_exit", false, true, "Clear Cookies on Exit" );
			options.set_or_get_bool( "empty_history_on_exit", false, true, "Clear History on Exit" );
			options.set_or_get( "double_press_timeout", "0.4", true, "Double Keypress Timeout (s)", "float", "0.2|0.4|0.6|0.8|1|2" );
			options.flush(false);
			
			if (should_be_fullscreen)
				this.fullscreen();
		}
		
		private bool update_callback () {
			this.is_fullscreen = (this.window.get_state() == WindowState.FULLSCREEN);
			string state = this.is_fullscreen ? "_fullscreen" : "";
			
			int width, height;
			this.get_size( out width, out height );
			
			var act = (ToggleAction) uim.action_group.get_action("view-fullscreen");
		    act.action_group = null;
		    if (act.active != this.is_fullscreen) 
	    		act.active = this.is_fullscreen;
#if FREMANTLE
			fullscreen_button.set_active( this.is_fullscreen );
#endif
		    act.action_group = uim.action_group;

		    string orientation = options.get_option( "toolbar_orientation"+state ) == "bottom" ? "bottom" : "top";
		    if ( this.drawer.orientation != orientation )
		    	this.drawer.set_orientation( orientation );	
		    	
			bool stf = options.get_bool( "show_toolbar"+state );
		    this.drawer.set_min( stf ? -1 : 0 );
		    
		    bool hidden_toolbar = (this.drawer.min == this.drawer.goal && this.drawer.min == 0);
		    
			bool show = options.get_bool( "show_progressline"+state );
		    if ( show && !stf && hidden_toolbar ) {
				this.progress.reparent( this.vbox );
		        this.scrolled_window.height_request = height - 8;
		        this.quickbar.height_request = 42;
		        this.progress.height_request = 20;
		        this.entry_progress.height_request = 60;
			} else {
				this.progress.reparent( this.entry_progress );
		        this.scrolled_window.height_request = height;
		        this.quickbar.height_request = 42;
		        this.progress.height_request = 20;
		        this.entry_progress.height_request = 60;
			}
			
			return false;
		}
		
		public void update_toolbar ( int width, int height ) {
			Timeout.add( 10, update_callback );
    	}
    	
    	public void set_scrollbars( string scroll_option ) {
#if !FREMANTLE
			if (scroll_option.down() == "thumb") { 
				Hildon.helper_set_thumb_scrollbar (this.scrolled_window, true);
				this.scrolled_window.set_policy( PolicyType.AUTOMATIC, PolicyType.AUTOMATIC );
			} else if (scroll_option.down() == "none")
				this.scrolled_window.set_policy( PolicyType.NEVER, PolicyType.NEVER );
			else {
				Hildon.helper_set_thumb_scrollbar (this.scrolled_window, false);
				this.scrolled_window.set_policy( PolicyType.AUTOMATIC, PolicyType.AUTOMATIC );
			}
			this.scrolled_window.queue_draw();
#endif
    	}
	    	    
	    private void connect_signals () {
	        this.web_view.load_started += (s, f) => {
		        if (DEBUG)
		        	warning ("load started");
		        	
				// show stop button
				this.reload_button.hide();
				this.stop_button.show();

		        this.progress.show();
		        this.progress.set_fraction (0);
		        
		        this.old_uri = s.get_main_frame().get_uri();
		        
		        if (!this.pulsing) {
		        	this.pulsing = true;
					GLib.Timeout.add (1000/15, auto_pulse);
#if FREMANTLE
					gtk_window_set_progress_indicator(this, 1);
#endif
				}
		        
		        this.web_view.has_focus = true;
	        };
	        this.web_view.load_finished += (s, f) => {
		        if (DEBUG)
		        	warning ("load finished");
#if FREMANTLE
					gtk_window_set_progress_indicator(this, 0);
#endif
		        this.progress.hide();
	            update_reload ();
	            
		        check_feeds();

				if (this.rss_feeds.length > 0) {
		        	this.empty_button.set_icon_widget ( empty_rss_image );
		        	this.bookmark_button.set_icon_widget ( bookmark_rss_image );
		        } else {
		        	this.empty_button.set_icon_widget ( empty_image );
		        	this.bookmark_button.set_icon_widget ( bookmark_image );
	        	}
		        
				var uri = ((Gtk.Entry) this.quickbar.get_child()).text; 

				if (uri == "about:blank" && s.get_main_frame().get_title() != "Dashboard") {
			        ((Gtk.Entry) this.quickbar.get_child()).activate();
			        return;
				}
			
	        };

	        this.web_view.navigation_requested += (s, frame, request) => {
		        
				if (connmanager.status != ConIc.ConnectionStatus.CONNECTED) {
					connmanager.ensure_connection( s, request.get_uri() );
				}
				
				return WebKit.NavigationResponse.ACCEPT;
	        };

	        this.web_view.mime_type_policy_decision_requested += (s, frame, request, mimetype, decision) => {
		        
				if (blocker.block_uri( request.get_uri() )) {
					decision.ignore();
					return true;
				}
				
				return false;
	        }; 

//	        this.web_view.resource_policy_decision_requested += (s, frame, uri, request) => {
//
//				if (blocker.block_uri( uri )) {
//					return true;
//				}
//				
//				return false;
//	        };

			this.web_view.download_created += (s, d) => {
				if (DEBUG)
					warning("download created");

				var filename = d.suggested_filename;
				var buf = filename.split( "." );
				this.pulsing = false;
#if FREMANTLE
				gtk_window_set_progress_indicator(this, 0);
#endif
				this.progress.hide();
	            update_reload ();

				var file_chooser = new Hildon.FileChooserDialog.with_properties ( get_topmost_window(), "action", FileChooserAction.SAVE,
																			  	"autonaming", true,
																			  	"open-button-text", "Save" );
				var button = file_chooser.add_button ( "Open", Gtk.ResponseType.ACCEPT );
				var vbox = (Gtk.Box) button.get_parent();
				vbox.reorder_child(button,0);

				file_chooser.set_current_name ( d.suggested_filename );

				var result = file_chooser.run();
				file_chooser.hide();
				
				var download_action = "";
				
				switch (result) {
					case Gtk.ResponseType.ACCEPT:
						download_action = "open";
					break;
					
					case Gtk.ResponseType.OK:
						download_action = "save";
					break;

					default:
						return false;
					break;
				} 
				d.local_uri = "file://"+file_chooser.get_filename();
				download_manager.add_download_item( d.get_uri(), file_chooser.get_filename(), download_action, d.get_total_size() );

				d.progress_update += download_manager.progress_update_cb;
				d.finished += download_manager.finished_cb;
				d.started += download_manager.started_cb;
				d.error += download_manager.error_cb;
				
				return true;
			};

	        this.web_view.tap_and_hold += (s, w) => {
		        var wve = s.button_event;
		        
				wve.button = 3; 
	       		main_do_event((Gdk.Event) wve);
	        };
	        this.web_view.populate_popup += (m, link, text, imgeurl) => {

//		        unowned WebKit.Node glass = this.web_view.create_glass();
//		        unowned WebKit.Node container = this.web_view.create_container(glass);
//		        this.web_view.create_button(container, "Open in New Window", "");
		        
				m.append( new SeparatorMenuItem() );
				
		        var sa = new ImageMenuItem.from_stock(Gtk.STOCK_SELECT_ALL, null);
        		sa.activate += (s) => {
			    	this.web_view.select_all ();
				};
				m.append(sa);
				
				bookmarklet_href = link.escape("");
				bookmarklet_title = text;

				if (bookmarklet_href.has_prefix("javascript:")) {
					var title = "";
					
					if (this.quickbar.has_bookmark(bookmarklet_href))
						title = "Remove Bookmarklet";
			        else
			        	title = "Add Bookmarklet";
		        	var sb = new ImageMenuItem.with_label(title);
			        	
	        		sb.activate += (s) => {
				    	update_bookmarklet(bookmarklet_href, bookmarklet_title);
					};
					m.append( new SeparatorMenuItem() );
					m.append(sb);
				}

				m.show_all();
				
				return false;
	        };
	        
	        this.web_view.load_progress_changed += (p) => {
		        if (DEBUG)
		        	warning ("load progress changed");
		        	
		        this.pulsing = false;

		        this.progress.set_fraction (p * 0.01);
	        };
	        this.web_view.load_committed += (f) => {
		        if (DEBUG)
		        	warning ("load commited"); 
		        var uri = f.get_uri ();

		        dbqueue.push ("UPDATE OR IGNORE `quickdata` SET `opened` = 0 WHERE `addr` = '"+ this.old_uri +"' and `type` = 'history';" );
		        
	      		this.quickbar.on_change_enabled(false);
	            ((Gtk.Entry) this.quickbar.get_child()).text = uri;
	      		this.quickbar.on_change_enabled(true);
	      		
				this.load_commited = true;
	        };
	        this.web_view.title_changed += (w, t) => {
		        if (DEBUG)
		        	warning ("title changed");
	            this.set_title( "%s".printf (t) );
	            update_buttons ();
	            
		        var uri = w.get_uri ();

				if (this.load_commited) {
					this.load_commited = false;
					
			        if (uri == "about:blank")
			        	return;

					Timeout.add_seconds( 1, () => {
				        check_feeds();
			
						if (this.rss_feeds.length > 0) {
				        	this.empty_button.set_icon_widget ( empty_rss_image );
				        	this.bookmark_button.set_icon_widget ( bookmark_rss_image );
				        } else {
				        	this.empty_button.set_icon_widget ( empty_image );
				        	this.bookmark_button.set_icon_widget ( bookmark_image );
			        	}
	
						return false;
					} );
					
			        if (this.quickbar.has_bookmark(uri)) {
			        	
			        	this.empty_button.hide();
			        	this.bookmark_button.show();
			        } else {
				        this.quickbar.add_quickbar_item( t, uri, "history", "");
				        
			        	this.bookmark_button.hide();
			        	this.empty_button.show();
			        }
		    	}
	        };
      		this.web_view.get_inspector().inspect_web_view += (w) => {
		        if (DEBUG)
		        	warning ("inspect web view");
		        	
	      		var tbw = new Tear.BrowserWindow (false, w);
	            tbw.set_title( "Web Inspector" );
	            
	      		return tbw.web_view;
      		};

      		this.web_view.create_web_view += (s, f) => {
		        if (DEBUG)
		        	warning ("create web view");
		        	
	      		var bw = new Tear.BrowserWindow ();
	            bw.set_title( "Untitled" );
	            
	      		return bw.web_view;
      		};

      		this.web_view.web_view_ready += (s) => {
		        if (DEBUG)
		        	warning ("show web view");
		        var bw = ((Tear.BrowserWindow) s.get_toplevel());
		        
	      		bw.show_all();
	      		bw.findbar.hide();
	        	bw.bookmark_button.visible = false;
                bw.reload_button.visible = false;

	      		return true;
      		};

	        ((Gtk.Entry) this.quickbar.get_child()).activate += on_activate;
	        this.empty_button.clicked += this.add_bookmark;
	        this.bookmark_button.clicked += this.remove_bookmark;
	        this.add_button.clicked += this.on_add;
	        this.back_button.clicked += this.web_view.go_back;
	        this.forward_button.clicked += this.web_view.go_forward;
	        this.reload_button.clicked += this.web_view.reload;
	        this.stop_button.clicked += (s) => {
   		        this.pulsing = false;
	        	this.web_view.stop_loading();
#if FREMANTLE
				gtk_window_set_progress_indicator(this, 0);
#endif
		        this.progress.hide();
	            update_reload ();
        	};
#if !FREMANTLE
	        this.go_button.clicked += this.on_activate;
	        this.menu_button.clicked += this.on_popup;
#endif
			
			((Gtk.Entry) this.quickbar.get_child()).button_press_event += (self, event) => {
				
				if (!((Gtk.Editable) self).get_selection_bounds ( null, null ) && !((Gtk.Widget) self).has_focus) {
					((Gtk.Editable) self).select_region( 0, -1 );
					((Gtk.Entry) self).im_context.show();
					((Gtk.Widget) self).grab_focus();
					return true;
				} else
					return false;
			};
			((Gtk.Entry) this.quickbar.get_child()).key_press_event += (self, event) => {
				if ((event.state & Gdk.ModifierType.CONTROL_MASK) == Gdk.ModifierType.CONTROL_MASK)
					switch (event.keyval) {
						case Gdk.KeySyms.C:
						case Gdk.KeySyms.c:
							((Gtk.Editable) self).copy_clipboard();
							return true;
							break;
						case Gdk.KeySyms.V:
						case Gdk.KeySyms.v:
							((Gtk.Editable) self).paste_clipboard();
							return true;
							break;
						case Gdk.KeySyms.X:
						case Gdk.KeySyms.x:
							((Gtk.Editable) self).cut_clipboard();
							return true;
							break;
						case Gdk.KeySyms.A:
						case Gdk.KeySyms.a:
							((Gtk.Editable) self).select_region(0, -1);
							return true;
							break;
					}
		
				return false;
			};
			this.configure_event += (s, event) => {
				this.update_toolbar( event.width, event.height );
				return false;
			};
			this.key_press_event += this.web_view.on_webview_keydown;
			this.key_release_event += this.web_view.on_webview_keyup;
#if FREMANTLE
//			this.map_event.connect( dbus_service.enable_accelerometer );
//			this.unmap_event.connect( dbus_service.disable_accelerometer );
			this.map_event.connect( on_map_event );
#endif
			
			this.drawer.on_before_show += (s) => {
		        if (DEBUG)
		        	warning ("on drawer show");
		        	
				bool show = options.get_bool( "show_progressline" );
				bool show_full = options.get_bool( "show_progressline_fullscreen" );
			    if ((this.is_fullscreen && show_full) || 
				    (!this.is_fullscreen && show)) {

				    this.progress.reparent( this.entry_progress );
			        this.scrolled_window.height_request = this.allocation.height;
				}
			};
			this.drawer.on_before_hide += (s) => {
		        if (DEBUG)
		        	warning ("on drawer hide");

				bool show = options.get_bool( "show_progressline" );
				bool show_full = options.get_bool( "show_progressline_fullscreen" );
			    if ((this.is_fullscreen && (bool) show_full) || 
				    (!this.is_fullscreen && (bool) show)) {
					    
					this.progress.reparent( this.vbox );
			        this.scrolled_window.height_request = this.allocation.height - 10;
				}
			};
   	    }

	    private void fill_reload_menu () {
	        var menuitem = new Tear.MenuItem ( "<b>Reload Page</b>\nReloads the page using cache when needed.", null );
			menuitem.activate += (s) => {
				this.web_view.stop_loading ();
				this.web_view.reload();
			};
			reload_menu.append(menuitem);

	        menuitem = new Tear.MenuItem ( "<b>Force Reload Page</b>\nReloads the page requesting every resource again.", null );
			menuitem.activate += (s) => {
				this.web_view.stop_loading ();
				this.web_view.reload_bypass_cache();
			};
			reload_menu.append(menuitem);
	    }
	    
		private string? populate_quickdial ( string homepage ) {
		    int nrows = 0, ncols, result, i;
		    string[] table;
		    string output = homepage;
	
	        table = dbqueue.pull ("SELECT `name`, `addr` FROM `quickdata` WHERE `type` = 'history' ORDER by `access_date` DESC LIMIT 18;", out nrows, out ncols, out result);
	        	
	        if (result != Sqlite.OK) { 
	            return homepage;
	        }
	        
	        if (table != null) {
		        if (nrows > 0) {
					for (i = 1; i <= 9; i++) {
						if (i > nrows) break;
				        output = str_replace( "<div id=\""+(i+10).to_string()+"\">"+i.to_string()+"</div>", "<div><a href=\""+str_replace("<", "&lt;", str_replace("&", "&amp;", table[i*2+1]))+"\">"+str_replace("<", "&lt;", str_replace("&", "&amp;", table[i*2]))+"</a></div>", output);
				    }
					for (i = 10; i <= 18; i++) {
						if (i > nrows) break;
				        output = str_replace( "<div id=\""+(i+31).to_string()+"\">"+(i-9).to_string()+"</div>", "<div><a href=\""+str_replace("<", "&lt;", str_replace("&", "&amp;", table[i*2+1]))+"\">"+str_replace("<", "&lt;", str_replace("&", "&amp;", table[i*2]))+"</a></div>", output);
				    }
				    if (DEBUG)
		        		warning ("populated output");
	        	}
	        }

	        table = dbqueue.pull ("SELECT `name`, `addr` FROM `bookmark` ORDER by `access_date` DESC LIMIT 18;", out nrows, out ncols, out result);
	        	
	        if (result != Sqlite.OK) { 
	            return homepage;
	        }
	        
	        if (table != null) {
		        if (nrows > 0) {
					for (i = 1; i <= 9; i++) {
						if (i > nrows) break;
				        output = str_replace( "<div id=\""+(i+20).to_string()+"\">"+i.to_string()+"</div>", "<div><a href=\""+str_replace("<", "&lt;", str_replace("&", "&amp;", table[i*2+1]))+"\">"+str_replace("<", "&lt;", str_replace("&", "&amp;", table[i*2]))+"</a></div>", output);
				    }
					for (i = 10; i <= 18; i++) {
						if (i > nrows) break;
				        output = str_replace( "<div id=\""+(i+41).to_string()+"\">"+(i-9).to_string()+"</div>", "<div><a href=\""+str_replace("<", "&lt;", str_replace("&", "&amp;", table[i*2+1]))+"\">"+str_replace("<", "&lt;", str_replace("&", "&amp;", table[i*2]))+"</a></div>", output);
				    }
				    if (DEBUG)
		        		warning ("populated output");
	        	}
	        }

	        table = dbqueue.pull ("SELECT distinct(`addr`), `name`  FROM `quickdata` ORDER by `visits` DESC LIMIT 9;", out nrows, out ncols, out result);
	        	
	        if (result != Sqlite.OK) { 
	            return homepage;
	        }
	        
	        if (table != null) {
		        if (nrows > 0) {
					for (i = 1; i <= nrows; i++) {
				        output = str_replace( "<div id=\""+(i+30).to_string()+"\">"+(i).to_string()+"</div>", "<div><a href=\""+str_replace("<", "&lt;", str_replace("&", "&amp;", table[i*2]))+"\">"+str_replace("<", "&lt;", str_replace("&", "&amp;", table[i*2+1]))+"</a></div>", output);
				    }
				    if (DEBUG)
		        		warning ("populated output");
	        	}
	        }

	        table = dbqueue.pull ("SELECT `name`, `addr` FROM `quickdata` WHERE `type` = 'search' ORDER by `access_date` DESC LIMIT 9;", out nrows, out ncols, out result);
	        
	        if (result != Sqlite.OK) { 
	            return homepage;
	        }
	        
	        if (table != null) {
		        if (nrows > 0) {
					for (i = 1; i <= nrows; i++) {
				        output = str_replace( "<div id=\""+(i+60).to_string()+"\">"+i.to_string()+"</div>", "<div><a href=\""+str_replace("<", "&lt;", str_replace("&", "&amp;", table[i*2+1]))+"\">"+str_replace("<", "&lt;", str_replace("&", "&amp;", table[i*2]))+"</a></div>", output);
				    }
				    if (DEBUG)
		        		warning ("populated output");
	        	}
	        }
	        
			string default_page = options.set_or_get( "dashboard_default", "history", true, "Default Dashboard Page", "string", "History|History 2|Bookmarks|Bookmarks 2|Most Used|Searches" );
			default_page = str_capitalize_and_shrink(default_page);
			
			output = str_replace("_DASHBOARD_SELECTEDTAB_TEMPLATE_", str_capitalize_and_shrink(default_page), output);
				
			return output;
        }

	    private void update_reload () {
			this.reload_button.show();
			this.stop_button.hide();
		}

	    private void update_buttons () {

	        this.back_button.sensitive = this.web_view.can_go_back ();
	        this.forward_button.sensitive = this.web_view.can_go_forward ();
	        
	        var bflist = this.web_view.get_back_forward_list();
	        unowned List<WebKit.WebHistoryItem> backs = bflist.get_back_list_with_limit (5);
	        unowned List<WebKit.WebHistoryItem> forwards = bflist.get_forward_list_with_limit (5);
	        
	        back_menu.empty();
	        foreach ( WebKit.WebHistoryItem item in backs ) { 
		        back_menu.add_history_item( item, true );
	        }
			back_menu.show_all();
   	        ((Widget) this.back_button).tap_and_hold_setup( back_menu, null, Gtk.TapAndHoldFlags.NONE | Gtk.TapAndHoldFlags.NO_INTERNALS);
			
	        forward_menu.empty();
	        foreach ( WebKit.WebHistoryItem item in forwards ) {
		        forward_menu.add_history_item( item, false );
	        }
			forward_menu.show_all();
   	        ((Widget) this.forward_button).tap_and_hold_setup( forward_menu, null, Gtk.TapAndHoldFlags.NONE | Gtk.TapAndHoldFlags.NO_INTERNALS);
	    }

		private bool auto_pulse () {
			this.progress.pulse ();

			if (this.pulsing)
				return true;
			else return false;
		}

	    private void on_add () {
            new Tear.BrowserWindow ().start ();
	    }

		public void check_feeds() {
			this.rss_feeds = {};
			
			unowned WebKit.Document document = ((WebKit.WebView) this.web_view).get_main_frame().get_dom_document();
			unowned WebKit.NodeList links = ((WebKit.Element) document.get_elements_by_tag_name ( "head" ).item(0)).get_elements_by_tag_name( "link" );
			for ( var i = 0; i < links.get_length(); i++) {
				unowned WebKit.HTMLLinkElement link = (WebKit.HTMLLinkElement) links.item(i);
				
				if (link.get_rel() == "alternate" && preg_test(((WebKit.HTMLElement) link).get_outer_html(), "application\\/rss\\+xml") )
					this.rss_feeds += RSSFeed() { title = ((HTMLElement) link).get_title(), href = link.get_href() };
			}
		}

#if FREMANTLE

		public void open_rss_fremantle() {
		    Hildon.PickerDialog dialog;
		    Hildon.TouchSelector selector;

			dialog = new PickerDialog ( null );
//			dialog.set_done_label ("Open");
			dialog.set_title ( "Choose Feeds" );

			string[] choices = {};
			for (var i = 0; i < this.rss_feeds.length; i++) {
				if (this.rss_feeds[i].title != null)
	    			choices += this.rss_feeds[i].title;
	    		else
	    			choices += this.rss_feeds[i].href;
			}
			selector = options.create_selector( choices, 0, TouchSelectorSelectionMode.SINGLE );
			
			dialog.set_selector( selector );

		    var rd = dialog.run();
		    dialog.hide();
		    
		    if (rd == ResponseType.OK) {
				unowned List<TreePath> paths = selector.get_selected_rows(0);
				int[] indices = new int[0];
				
				foreach ( TreePath path in paths ) {
					indices += path.get_indices()[0];
				}

				for ( var i = 0; i < indices.length; i++ ) {
					var current_uri = this.rss_feeds[indices[i]].href;
					
					Hildon.mime_open_file_with_mime_type ( dbus_service.connection, current_uri, "application/news_reader" );
		    	}
	    	}
		}
		
		public Gtk.HBox render_detail_row ( string title, string info ) {
			
			var hbox = new Gtk.HBox( false, 0 );
			
			var name = new Label( title );
			name.set_justify( Justification.LEFT );
			name.set_use_markup(true);
			name.width_request = 120;
			var detail = new Label( info );
			detail.set_justify( Justification.LEFT );
			detail.set_use_markup(false);
			detail.set_line_wrap(true);
			
			hbox.pack_start( name, false, false, 0 );
			hbox.pack_start( detail, false, false, 0);
			
			return hbox;
		}
		
		public void page_details_fremantle() {
			
			var details_dialog = new Hildon.Dialog();
			details_dialog.title = "Page Details";
			
			var title = new Label( this.web_view.get_main_frame().title );
			title.set_justify( Justification.LEFT );
		    details_dialog.vbox.add( title );
		    
		    unowned WebKit.Document doc = ((WebKit.WebView) this.web_view).get_main_frame().get_dom_document();
		    unowned WebKit.DOMWindow win = ((WebKit.WebView) this.web_view).get_main_frame().get_dom_window();
		    unowned WebKit.PluginArray plugins = win.get_navigator().get_plugins();

   		    string plugin_list = "";
   		    
   		    for (var i = 0; i < plugins.get_length(); i++) {
	   		    var plugin_name = plugins.item(i).get_name();
	   		    
	   		    if (!preg_test(plugin_list, plugin_name))
	   		    	plugin_list += "; " + plugin_name;
   		    }
   		    plugin_list = plugin_list.substring(2);
		    
		    details_dialog.vbox.add( render_detail_row( "<b>Address</b>: ", this.web_view.get_main_frame().uri ) );
		    details_dialog.vbox.add( render_detail_row( "<b>Referrer</b>: ", doc.get_referrer() ) );
		    details_dialog.vbox.add( render_detail_row( "<b>Encoding</b>: ", doc.get_character_set() ) );
		    details_dialog.vbox.add( render_detail_row( "<b>Modified</b>: ", doc.get_last_modified() ) );
		    details_dialog.vbox.add( render_detail_row( "<b>Plugins</b>: ", plugin_list ) );
		    
//			unowned WebKit.Document document = ((WebKit.WebView) this.web_view).get_main_frame().get_dom_document();
//			unowned WebKit.NodeList metas = ((WebKit.Element) document.get_elements_by_tag_name ( "head" ).item(0)).get_elements_by_tag_name( "meta" );
		    
	    	details_dialog.vbox.show_all();
	    	details_dialog.run();
	    	details_dialog.hide();
		}

		public void bookmark_dialog(bool add_bookmark) {
			unowned Action act;
			
			var first_hbox = (Gtk.HBox) this.page_dialog.vbox.get_children().nth_data(0);
			var bookmark_button = (Hildon.Button) first_hbox.get_children().nth_data(0);

			if (add_bookmark)
		    	act = (Action) uim.action_group.get_action( "page-add-bookmark" );
		    else 
		    	act = (Action) uim.action_group.get_action( "page-remove-bookmark" );
			act.connect_proxy ( bookmark_button );

			var rss_act = (Action) uim.action_group.get_action( "tools-rss" );
			
			if (this.rss_feeds.length > 0)
				rss_act.set_sensitive( true );
			else
				rss_act.set_sensitive( false );

			this.page_dialog.run();
			this.page_dialog.hide();
		}
		
	    public void add_bookmark_fremantle () {
			var uri = ((Gtk.Entry) this.quickbar.get_child()).text;

	        if (!this.quickbar.has_bookmark(uri)) {
			    this.quickbar.add_quickbar_item( this.web_view.get_main_frame().get_title(), uri, "bookmark", "/" );
		    	this.empty_button.hide();
		    	this.bookmark_button.show();
	        }
	    }
	    
	    public void remove_bookmark_fremantle () {
			var uri = ((Gtk.Entry) this.quickbar.get_child()).text;

	        if (this.quickbar.has_bookmark(uri)) {
			    this.quickbar.remove_quickbar_item( uri, "bookmark" );
	        	this.bookmark_button.hide();
	        	this.empty_button.show();
	        }
	    }
#else
	    private void on_popup () {
		    
			uim.update_toggles();
		    
			this.tool_popup.popup(null, null, null, 0, get_current_event_time());
	    }
#endif


	    public void add_bookmark () {
			var uri = ((Gtk.Entry) this.quickbar.get_child()).text;
			if (uri.has_prefix("javascript:")) {
				update_bookmarklet(uri, "");
				return;
			}

#if FREMANTLE
			bookmark_dialog( true );
#else
	        if (!this.quickbar.has_bookmark(uri)) {
			    this.quickbar.add_quickbar_item( this.web_view.get_main_frame().get_title(), uri, "bookmark", "/" );
		    	this.empty_button.hide();
		    	this.bookmark_button.show();
	        }
#endif
	    }

	    public void remove_bookmark () {
			var uri = ((Gtk.Entry) this.quickbar.get_child()).text;
			if (uri.has_prefix("javascript:")) {
				update_bookmarklet(uri, "");
				return;
			}

#if FREMANTLE
			bookmark_dialog( false );
#else
	        if (this.quickbar.has_bookmark(uri)) {
			    this.quickbar.remove_quickbar_item( uri, "bookmark" );
	        	this.bookmark_button.hide();
	        	this.empty_button.show();
	        }
#endif
	    }
	    
	    private void update_bookmarklet(string uri, string title) {
		    if (this.quickbar.has_bookmark(uri)) {
				this.quickbar.remove_quickbar_item( uri, "bookmarklet" );
		    } else {
				var message = new MessageDialog(this, DialogFlags.MODAL, MessageType.QUESTION, ButtonsType.OK_CANCEL, 
													   "Enter a name for this bookmarklet:");
 				var entry = new Gtk.Entry();
				entry.text = title;
				entry.show();
				message.vbox.add(entry);
				
				var result = message.run();
				message.hide();
				
				if (result == Gtk.ResponseType.OK) {
				 	this.quickbar.add_quickbar_item( entry.text, uri, "bookmarklet", "/" ); 
				}
		    }
	    }

		public string normalize_uri( string uri, bool search = true ) {
			
			string output = "";
			
		    if (uri.str("://") == null) {
		        if (uri.str(".") != null)
		        	output = "%s://%s".printf (DEFAULT_PROTOCOL, uri);
		        else {
		        	if (search) {
		        		output = search_uri + uri;
		        		this.quickbar.add_quickbar_item( uri, output, "search", "/" ); 
	        		}
		        	else
		        		output = "";
		        }
		    } else output = uri;
		    
			return output;
		}
		
	    private void on_activate () {
	        var uri = ((Gtk.Entry) this.quickbar.get_child()).text;
			this.web_view.stop_loading ();

			if (DEBUG)
				warning ( uri );

			if (uri == "about:blank") {
		        this.web_view.load_string(populate_quickdial(HOMEPAGE), "application/xhtml+xml", "UTF-8", "about:blank");
		        return;
			}
			
			if (uri.has_prefix("javascript:")) {
				this.web_view.execute_script( uri.substring( 11 ) );
				return;
			}

	        this.web_view.open ( normalize_uri( uri ) );
	    }
	    
	    public void start (string uri = "") {
	        if (DEBUG)
	        	warning ("start window");
		    
        	this.bookmark_button.visible = false;
			this.reload_button.visible = false;

			if (uri != "" && uri != "about:blank") {
				if (uri.has_prefix("javascript:")) {
					this.web_view.execute_script( Uri.unescape_string( uri.substring( 11 ), "") );
					return;
				}

				this.web_view.open ( uri );
				return;
			}
			
			if (home_address != "about:blank" && uri != "about:blank") {
				this.web_view.open ( home_address );
				return;
			}

			var pop = populate_quickdial(HOMEPAGE);
	        if (DEBUG)
				warning("returned from populate");
	        this.web_view.load_string(pop, "application/xhtml+xml", "UTF-8", "about:blank");
	        if (DEBUG)
	        	warning ("end starting window");
	    }
	    
	    static bool check_if_dirty() {
		    int nrows, ncols, result;
		    
		    string saved = options.get_option( "saved_session" );
		    string dirty = options.get_option( "dirty" );
		    if (dirty == "true" || saved == "true") {
			    var table = dbqueue.pull ("SELECT `name`, `addr` FROM `quickdata` WHERE `opened` = 1;", out nrows, out ncols, out result );
			    
			    if (nrows > 0) {
#if FREMANTLE
				    Hildon.PickerDialog dialog;
				    Hildon.TouchSelector selector;
#else
				    MessageDialog dialog;
#endif
				    
				    dbqueue.push ("update `quickdata` set `opened` = 0 WHERE `opened` = 1;");
				    
				    if (dirty == "true") {
#if FREMANTLE
						dialog = new PickerDialog ( null ); // "Tear was not closed normally.\nDo you want to restore the previous session?"
						dialog.set_done_label ("OK");
						dialog.set_title ( "Restore Session" );
			
						string[] choices = {};
					    for (var i = 2; i <= nrows*ncols; i = i + ncols) {
				    		choices += table[i];
					    }
					    
						selector = options.create_selector( choices, -1, TouchSelectorSelectionMode.MULTIPLE );
						
						dialog.set_selector( selector );
#else
				    	dialog = new MessageDialog.with_markup( null, 0, MessageType.QUESTION, ButtonsType.OK_CANCEL, 
				    											"Tear was not closed normally.\nDo you want to restore the previous session?" );
#endif
				    } else {
					    for (var i = 2; i <= nrows*ncols; i = i + ncols) {
				    		new Tear.BrowserWindow ().start ( table[i+1] );
					    }
					    options.update_option( "saved_session", "false", false );
					    return true;
			    	}
			    				
#if !FREMANTLE
				    var vb = new VBox( true, 1 );
				    dialog.vbox.add ( vb );
				    vb.show();
				    
				    Tear.CheckButton chk;
				    for (var i = 2; i <= nrows*ncols; i = i + ncols) {
					    chk = new Tear.CheckButton(table[i], true, table[i+1]);
					    vb.add ( chk );
				    }
				    vb.show_all();
#endif

				    var rd = dialog.run();
				    dialog.hide();
				    if (rd == ResponseType.OK) {
#if FREMANTLE
						unowned List<TreePath> paths = selector.get_selected_rows(0);
						int[] indices = new int[0];
						
						foreach ( TreePath path in paths ) {
							indices += path.get_indices()[0];
						}

						for ( var i = 0; i < indices.length; i++ ) {
				    		new Tear.BrowserWindow ().start ( table[i*2+3] );
				    	}
				    	
						if (indices.length > 0)
							return true;
#else					    
			    		var activecount = 0;
				    	foreach ( unowned Tear.CheckButton child in (GLib.List<Tear.CheckButton>) vb.get_children() ) {
				    		if (child.get_active()) {
					    		activecount++;
					    		new Tear.BrowserWindow ().start ( child.uri );
				    		}
			    		}
			    		if (activecount > 0)
			    			return true;
#endif
			    	}
				}
	    	}
	    	return false;
	    }

#if FREMANTLE
// Ungrab the zoom keys.
		private bool on_map_event( Widget widget, Gdk.Event event ) {
			if (widget.window != null) {
    			uchar[] value = {1};
				X.Atom hildon_zoom_key_atom = x11_get_xatom_by_name("_HILDON_ZOOM_KEY_ATOM");
//				X.Atom hildon_portrait_support = x11_get_xatom_by_name("_HILDON_PORTRAIT_MODE_SUPPORT");
				X.Display display = x11_drawable_get_xdisplay( widget.window );
				X.Window window = x11_drawable_get_xid( widget.window );

			    display.change_property ( window, hildon_zoom_key_atom, XA_INTEGER, 32,
		                     X.PropMode.Replace, value, 1 );
//			    display.change_property ( window, hildon_portrait_support, XA_CARDINAL, 32,
//		                     X.PropMode.Replace, value, 1 );
			}
			
			return false;
		}
#endif

        static int main (string[] args) {

                Intl.bindtextdomain(Config.GETTEXT_PACKAGE, Config.LOCALE_DIR);
                Intl.textdomain(Config.GETTEXT_PACKAGE); 

#if FREMANTLE
				Hildon.gtk_init( ref args );
#else
                Gtk.init (ref args);
#endif

		        Environment.set_application_name (Config.PACKAGE_NAME);
				var uri = "";
				if (args.length > 1) { 
					uri = args[1]; 
				}
				
				dbus_service = new Tear.Service ( uri );
				if (!dbus_service.oneinstance)
					return 0;
		        
		        tear_folder = Environment.get_home_dir () + "/." + Config.PACKAGE + "/";
				user_stylesheet = "file://" + tear_folder;
				quickdb_name = tear_folder + Config.PACKAGE + ".db";
				search_uri = "http://www.google.com/search?q=";

//				accels_last_state = Settings.get_accels();
//				if (accels_last_state)
//					Settings.set_accels(false);

				program = Hildon.Program.get_instance ();
			    dbqueue = new Tear.DBQueue();
			    blocker = new Tear.Blocker();
			    connmanager = new Tear.ConnectionManager();
			    options = new Tear.OptionsManager();

		        if (DEBUG)
					warning("Starting UIM");
   			    uim = UIManager.get_instance ();
			    uim.post_activate += on_action_activated;

				about = new Tear.About ();
				download_manager = new Tear.DownloadManager ();

#if !FREMANTLE
		        if (DEBUG)
					warning("Creating Menu");
				Gtk.Menu menu = new Gtk.Menu ();
	
				Gtk.Widget mb = uim.get_widget("/menu");
			    foreach (Gtk.Widget element in ((Container) mb).get_children()) {
			        element.reparent(menu);
			    }

       	        program.set_common_menu (menu);
#endif
			    			    
		        if (DEBUG)
					warning("Starting Browser");
			    if (!check_if_dirty()) {
    				var window = new Tear.BrowserWindow ();
    				window.start ( window.normalize_uri( uri, false ) );
    			}
    			
			    options.update_option( "dirty", "true", false );

                Gtk.main();

				if (options.get_option( "empty_cookies_on_exit" ) == "true")
					empty_cookies();
				if (options.get_option( "empty_history_on_exit" ) == "true")
					empty_history();
			
//				Settings.set_accels(accels_last_state);
				options.update_option( "dirty", "false", false );
                
                return 0;
        }
}

