using GLib;
using Gtk;
using Hildon;

#if FREMANTLE
public class Tear.CheckButton : Hildon.CheckButton
#else
public class Tear.CheckButton : Gtk.CheckButton
#endif
{
	
	public string uri { get; set construct; }

	public new string label {
		get { return ((Gtk.Button) base).get_label(); } 
		set construct { ((Gtk.Button) base).set_label( value ); }
	}
#if !FREMANTLE
	public bool active { 
		get { return ((Gtk.ToggleButton) base).get_active(); } 
		set construct { ((Gtk.ToggleButton) base).set_active( value ); }
	} 
#endif

    public CheckButton (string label, bool active, string uri) {
        this.label = label;
        this.uri = uri;
#if !FREMANTLE
        this.active = active;
#endif
    }
    
}