'''
Task Poach - Strives to be a Task Coach compatible TODO app.
Copyright (C) 2012 computerinfo21@gmail.com>

Task Poach is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Task Poach is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

from PyQt4.QtGui import QStandardItemModel
from sortFilter import *
from selection import *
from tskXml.tskXml import *
from ui.rowHeight import *
import xml.etree.ElementTree as ET
from thirdparty.guid import *

class taskPoachModel():
    def __init__(self, parent, maemo5, settings, taskTreeView):
        self.taskModel = QStandardItemModel()
        self.categoryModel = QStandardItemModel()
        self.qSIRow = []
        self.__maemo5 = maemo5
        self.__settings = settings
        self.taskTreeView = taskTreeView
        self.__updatingModel = False
        self.parent = parent
        self.selection = ""
        #print id(self)

    def generateNew(self, filename):
        guidString = generate()
        # build a tree structure
        root = ET.Element("tasks")
        
        syncmlConfig = ET.SubElement(root, "syncmlconfig")
        taskcoach_guid = ET.SubElement(syncmlConfig, "TaskCoach-" + guidString)
        spds = ET.SubElement(taskcoach_guid, "spds")
        sources = ET.SubElement(spds, "sources")
        syncTasks = ET.SubElement(sources, "TaskCoach-" + guidString + ".Tasks")
        notes = ET.SubElement(sources, "TaskCoach-" + guidString + ".Notes")
        syncml = ET.SubElement(spds, "syncml")
        auth = ET.SubElement(syncml, "Auth")
        conn = ET.SubElement(syncml, "Conn")
        guid = ET.SubElement(root, "guid")
        guid.text = guidString
        
        # wrap it in an ElementTree instance, and save as XML
        tree = ET.ElementTree(root)
        tree.write(filename)
    
    def loadModel(self, filename):
        #Multiple selection mode, can enable but need to modify other methods first or only the last highlighted selection will be acted on currently.
        #ui.taskTreeView.setSelectionMode(QtGui.QAbstractItemView.ExtendedSelection)
        self.setUpdatingModel(False)
        
        #Disable the buttons that should only be available when a item is highlighted
        #self.newSubTask.setEnabled(False)
        #self.editTask.setEnabled(False)
        #self.delTask.setEnabled(False)
        
        #self.path = "testTasksOutput.tsk"
        #self.filename = "testTasksOutput.tsk"
        
        #self.tskFileObject = tskFile(self, self.filename, self.taskModel, self.categoryModel, self.viewSelectedCategories, self.viewSelectedCategoryItemIds, self.settings)
        #changing the way filtering works to use QSortFilterProxy instead of while parsing the file, instead of above line need the one below
        self.tskFileObject = tskFile(self, filename, self.taskModel, self.categoryModel, self.__settings)
        
        
        #When opening a file, save it in settings to be loaded next time if that setting is set
        #print str(self.filename)
        self.__settings.set("file", "lastfile", str(filename))
        self.__settings.save()
        
        self.tskFileObject.read()
        self.etree = self.tskFileObject.getTree()
        
        #self.hideCompleteTasks()
            
        if self.__maemo5:
            delegate = RowHeightDelegate()
            self.taskTreeView.setItemDelegate(delegate)
        #self.proxy = QSortFilterProxyModel()
        #self.proxy = TextSortModel(self, self.hidecompleted)
        #self.proxy = NumberSortModel()
        self.setUpProxyModel()
        
        #For windows focus, turns out did not need to use to adjust scrollto after child windows return control to parent
        #self.setFocusPolicy(Qt.StrongFocus)
        
        self.selection = modelSelectionTracker(self)
        connection = QObject.connect(self.taskTreeView.selectionModel(), SIGNAL("selectionChanged(QItemSelection, QItemSelection)"), self.selection.slot)
        self.taskModel.itemChanged.connect(self.parent.on_itemChanged)
        
        self.parent.updateTaskView()
        self.parent.show()
    
    #Updating model bool set & get
    def updatingModel(self):
        return self.__updatingModel
        
    def setUpdatingModel(self, updating):
        self.__updatingModel = updating
        
    def setUpProxyModel(self):
        self.proxy = TextSortModel(self)
        self.proxy.dynamicSortFilter = True
        self.proxy.setSourceModel(self.taskModel)
        self.taskTreeView.setModel(self.proxy)
