#include "symfonierichtextdelegate.h"



void SymfonieRichTextDelegate::paint(QPainter* painter, const QStyleOptionViewItem & option, const QModelIndex &index) const
{
    QStyleOptionViewItemV4 optionV4 = option;
      // initStyleOption(&optionV4, index);

       QStyle *style = optionV4.widget? optionV4.widget->style() : QApplication::style();

       QTextDocument doc;
        optionV4.text = index.data().toString();
       doc.setHtml(optionV4.text);

       /// Painting item without text

       style->drawControl(QStyle::CE_ItemViewItem, &optionV4, painter);

       QAbstractTextDocumentLayout::PaintContext ctx;

       // Highlighting text if item is selected
       if (optionV4.state & QStyle::State_Selected){
           ctx.palette.setColor(QPalette::Text, optionV4.palette.color(QPalette::Active, QPalette::HighlightedText));
       }

       QRect textRect = style->subElementRect(QStyle::SE_ItemViewItemText, &optionV4);
       painter->save();
       painter->translate(textRect.topLeft());
       painter->setClipRect(textRect.translated(-textRect.topLeft()));
       doc.documentLayout()->draw(painter, ctx);
       painter->restore();

}

QSize SymfonieRichTextDelegate::sizeHint ( const QStyleOptionViewItem & option, const QModelIndex & index ) const
{

    QStyleOptionViewItemV4 options = option;
    //initStyleOption(&options, index);

    QTextDocument doc;
    doc.setHtml(options.text);
    doc.setTextWidth(options.rect.width());
    return QSize(doc.idealWidth(), doc.size().height());



}
