#ifndef SYMFONIEEQUALIZERWINDOW_H
#define SYMFONIEEQUALIZERWINDOW_H

#include <QMainWindow>
#include <Phonon>

class QStringList;
class SymfonieQSlider;

namespace Ui {
    class SymfonieEqualizerWindow;
}

class SymfonieEqualizerWindow : public QMainWindow {
    Q_OBJECT
public:
    SymfonieEqualizerWindow(Phonon::Effect *effect, QWidget *parent = 0);
    ~SymfonieEqualizerWindow();
    void saveBandValue(int band, int value);
    int getBandValue(int band);
    void saveState();

public Q_SLOTS:
    void slideValueChangedSlot(int index, int value);

protected:
    void changeEvent(QEvent *e);

private:
    Ui::SymfonieEqualizerWindow *ui;
    Phonon::Effect *effect;
    static QString bandNames[];
   QList<SymfonieQSlider*> *sliderList;

   static const int EQ_BAR_MIN = 1; //0
   static const int EQ_BAR_MAX = 9; //10
};

#endif // SYMFONIEEQUALIZERWINDOW_H
