#include <QtGui>
#include <QLabel>
#include <QFileSystemModel>
#include <QTreeView>
#include <QListWidget>
#include <Phonon>
#include <QPushButton>
//#include <QMaemo5InformationBox>
#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "symfoniemediaplayer.h"
#include "symfonieplaylistitem.h"
#include <qglobal.h>
#include "symfonieinfowindow.h"
#include <QHBoxLayout>
#include <QWidget>
#include "symfonierichtextdelegate.h"
#include "symfonieplaylist.h"
#include "symfoniedb.h"
#include "symfonieaboutdialog.h"
#include "symfonietimerwindow.h"
#include "symfonieequalizerwindow.h"



MainWindow::MainWindow(const QApplication *app, SymfonieMediaPlayer* player, QWidget *parent) :
        QMainWindow(parent),
        app(app),
        ui(new Ui::MainWindow),
        timerWindow(NULL),
        player(player),
        equalizerWindow(new SymfonieEqualizerWindow(this->getPlayer()->getEqualizerEffect(), this)),

        isInPortait(false),
        isResumePlayback(false)
{
    ui->setupUi(this);

    setAttribute(Qt::WA_Maemo5LandscapeOrientation, true);

    this->ui->mainToolBar2->hide();

    //set up menus
    orientationGroup = new QActionGroup(this);
    orientationGroup->setExclusive(true);

    orientationLandscape = new QAction(QIcon::fromTheme("general_landscape", QIcon(QLatin1String(":/images/landscape"))), tr("Landscape"), orientationGroup);
    orientationLandscape->setCheckable(true);
    orientationLandscape->setChecked(true);

    orientationAuto = new QAction(tr("Auto"), orientationGroup);
    orientationAuto->setCheckable(true);
    orientationAuto->setChecked(false);

    orientationPortrait = new QAction(QIcon::fromTheme("general_portrait", QIcon(QLatin1String(":/images/portrait"))), tr("Portrait"), orientationGroup);
    orientationPortrait->setCheckable(true);

    this->ui->menuBar->addActions(orientationGroup->actions());

    connect(orientationGroup, SIGNAL(triggered(QAction *)), this, SLOT(orientationChanged(QAction *)));
    // connect(a1, SIGNAL(triggered()), this, SLOT(toggleFullScreenOn()));
    //connect(a2, SIGNAL(triggered()), this, SLOT(toggleFullScreenOff()));



    this->toggleFullScreenAction = new QAction(QIcon::fromTheme("general_fullsize"), QString(), this);
    this->toggleFullScreenAction->setCheckable(true);
    connect(this->toggleFullScreenAction, SIGNAL(toggled(bool)), this, SLOT(toggleFullScreen(bool)));



    connect(this->getPlayer(), SIGNAL(timerStoppedSignal()), this, SLOT(playerTimerStoppedSlot()));
    connect(this->getPlayer(), SIGNAL(timerRemainTimeChangedSignal(int)), this, SLOT(playerTimerRemainTimeChangedSlot(int)));



    this->timerWindow = new SymfonieTimerWindow(this);
    this->connect(this->timerWindow, SIGNAL(setTimerSignal(int)), this, SLOT(updateTimerSlot(int)));
    this->connect(this->timerWindow, SIGNAL(clearTimerSignal()), this, SLOT(clearTimerSlot()));

    this->setMenuActionTimerText(0);

    connect(this->ui->menuActionTimer, SIGNAL(triggered()), this, SLOT(showTimerWindowSlot()));

    connect(this->ui->menuActionEqualizer, SIGNAL(triggered()), this, SLOT(showEqualizerWindowSlot()));



    connect(this->ui->menuActionAbout, SIGNAL(triggered()), this, SLOT(showAboutWindowSlot()));


    this->ui->subToolBar->hide();
    this->ui->subToolBar2->hide();


    //this->ui->fileListWidget->setItemDelegate(new SymfonieRichTextDelegate());

    this->seekSlider = new Phonon::SeekSlider();
    this->seekSlider->setMediaObject(player->getMediaObject());

    this->ui->sliderPanel->layout()->addWidget(this->seekSlider);



    this->volumeSlider = new Phonon::VolumeSlider(this->getPlayer()->getAudioOutput(), this);
    //this->volumeSlider->setSizePolicy(QSizePolicy::Maximum, QSizePolicy::Maximum);



    this->setAttribute(Qt::WA_Maemo5StackedWindow);

    //button2  = new QPushButton("Click here to open another stacked window", this);
    // button2->setAttribute(Qt::WA_Maemo5StackedWindow);
    //  button2->setWindowFlags(button2->windowFlags() | Qt::Window);


    playAction = new QAction(style()->standardIcon(QStyle::SP_MediaPlay), tr("Play"), ui->mainToolBar);
    playAction->setShortcut(tr("Crl+A"));
    //playAction->setDisabled(true);

    stopAction = new QAction(style()->standardIcon(QStyle::SP_MediaStop), tr("Stop"), ui->mainToolBar);
    stopAction->setShortcut(tr("Crl+S"));
    // stopAction->setDisabled(true);

    prevAction = new QAction(style()->standardIcon(QStyle::SP_MediaSkipBackward), tr("Previous"), ui->mainToolBar);
    prevAction->setShortcut(tr("Crl+R"));


    nextAction = new QAction(style()->standardIcon(QStyle::SP_MediaSkipForward), tr("Next"), ui->mainToolBar);
    nextAction->setShortcut(tr("Crl+N"));





    this->goUpAction =  new QAction(style()->standardIcon(QStyle::SP_ArrowUp), tr("Go Up"), ui->mainToolBar);
    connect(goUpAction, SIGNAL(triggered()), this, SLOT(goUpSlot()));

    this->switchOrientationAction = new QAction(style()->standardIcon(QStyle::SP_BrowserReload),
                                                tr("Switch Orientation"), ui->mainToolBar);


    this->showInfoWindowAction  = new QAction(tr("Seek"), ui->mainToolBar);
    this->showInfoWindowAction->setCheckable(true);
    connect(showInfoWindowAction, SIGNAL(triggered()), this, SLOT(showInfoWindowSlot()));


    this->showToolBar2Action  = new QAction(style()->standardIcon(QStyle::SP_MediaVolume), tr("Show Volume"), ui->mainToolBar);
    this->showToolBar2Action->setCheckable(true);
    connect(showToolBar2Action, SIGNAL(triggered()), this, SLOT(showToolBar2Slot()));


    this->goHomeAction = new QAction(style()->standardIcon(QStyle::SP_ComputerIcon), tr("Go Home"), ui->mainToolBar);
    connect(goHomeAction, SIGNAL(triggered()), this, SLOT(goHomeSlot()));


    this->goToCurDir = new QAction(style()->standardIcon(QStyle::SP_DesktopIcon), tr("Go to current directory"), ui->mainToolBar);
    connect(goToCurDir, SIGNAL(triggered()), this, SLOT(goToCurDirSlot()));

    connect(playAction, SIGNAL(triggered()), this, SLOT(playSlot()));
    connect(stopAction, SIGNAL(triggered()), this, SLOT(stopSlot()));
    connect(prevAction, SIGNAL(triggered()), this, SLOT(playPrevSlot()));
    connect(nextAction, SIGNAL(triggered()), this, SLOT(playNextSlot()));
    connect(player, SIGNAL(mediaStateChangedSignal(Phonon::State,Phonon::State)),
            this, SLOT(mediaStateChangedSlot(Phonon::State,Phonon::State)));

    connect(this->player->getMediaObject(), SIGNAL(tick(qint64)), this, SLOT(playerTickSlot(qint64)));


    connect(nextAction, SIGNAL(triggered()), this, SLOT(showInfoWindowSlot()));


    this->ui->mainToolBar->addAction(this->goHomeAction);
    this->ui->mainToolBar->addAction(this->goUpAction);
    this->ui->mainToolBar->addAction(this->goToCurDir);

    ui->mainToolBar->addAction(prevAction);
    ui->mainToolBar->addAction(playAction);
    // ui->mainToolBar->addAction(stopAction);
    ui->mainToolBar->addAction(nextAction);

    ui->mainToolBar->addAction(showInfoWindowAction);
    ui->mainToolBar->addAction(this->showToolBar2Action);
    ui->mainToolBar->addAction(this->toggleFullScreenAction);




    qDebug() << this->ui->mainToolBar->height();

    //eq->show();
    this->ui->subToolBar2->addWidget(this->volumeSlider);




    //ui->mainToolBar->addAction(switchOrientationAction);
    // QObject::connect(playAction, SIGNAL(triggered()), button2, SLOT(show()));

    //ui->mainToolBar->addWidget(slider);
    connect(this->player, SIGNAL(scanDirCompletedSignal(SymfoniePlayList*, QString)),
            this, SLOT(playerScanDirCompletedSlot(SymfoniePlayList*, QString)));
    this->player->init();


    QString lastPlayedFile = SymfonieDb::getInstance()->getSetting("last_played_file").toString();
    QString lastPlayedDir;
    

    if(lastPlayedFile.length() == 0){
        lastPlayedDir = SymfonieDb::getInstance()->getSetting("last_browsed_dir").toString();
    }else{
        lastPlayedDir = QFileInfo(lastPlayedFile).canonicalPath();
    }

    QFileInfo info = QFileInfo(lastPlayedDir);
    if(info.exists()){
        this->isResumePlayback = true;
        this->getPlayer()->scanDir(lastPlayedDir);
    }else{
        this->goHomeSlot();
    }



    
    // this->player->scanDir(this->getCurrentDiretory(), true);


    connect(this->ui->fileListWidget, SIGNAL(activated(QModelIndex)),
            this, SLOT(itemActivatedSlot(QModelIndex)));


    //this->setHO();

}



MainWindow::~MainWindow()
{

    this->saveState();
    delete ui;
    delete playAction;
    delete stopAction;
    delete prevAction;
    delete nextAction;

    delete toggleFullScreenAction;
    delete switchOrientationAction;
    delete showInfoWindowAction;
    delete showToolBar2Action;
    delete goUpAction;
    delete goHomeAction;
    delete goToCurDir;
    if(this->timerWindow != NULL){
        delete this->timerWindow;
    }
    if(this->equalizerWindow != NULL){
        delete this->equalizerWindow;
    }
    delete this->player;
}

void MainWindow::playerTimerStoppedSlot(){
    if(this->timerWindow != NULL){
        this->timerWindow->setTimerStateEnabled(false);
    }
}

void MainWindow::orientationChanged(QAction *action)
{


    if (action == this->orientationAuto){
        setAttribute(Qt::WA_Maemo5AutoOrientation, true);

    }else if (action == this->orientationPortrait){
        setAttribute(Qt::WA_Maemo5PortraitOrientation, true);
        this->ui->mainToolBar2->addAction(this->goHomeAction);
        this->ui->mainToolBar2->addAction(this->goUpAction);
        this->ui->mainToolBar2->addAction(this->goToCurDir);
        this->ui->mainToolBar2->addAction(this->toggleFullScreenAction);



        this->ui->mainToolBar->removeAction(this->goHomeAction);
        this->ui->mainToolBar->removeAction(this->goUpAction);
        this->ui->mainToolBar->removeAction(this->goToCurDir);
        this->ui->mainToolBar->removeAction(this->toggleFullScreenAction);

        this->ui->mainToolBar2->show();
    }else{
        setAttribute(Qt::WA_Maemo5LandscapeOrientation, true);
        this->ui->mainToolBar->addAction(this->goHomeAction);
        this->ui->mainToolBar->addAction(this->goUpAction);
        this->ui->mainToolBar->addAction(this->goToCurDir);
        this->ui->mainToolBar->addAction(this->toggleFullScreenAction);

        this->ui->mainToolBar2->removeAction(this->goHomeAction);
        this->ui->mainToolBar2->removeAction(this->goUpAction);
        this->ui->mainToolBar2->removeAction(this->goToCurDir);
        this->ui->mainToolBar2->removeAction(this->toggleFullScreenAction);
        this->ui->mainToolBar2->hide();

    }

    this->orientationLandscape->setChecked(action == this->orientationLandscape);
    this->orientationPortrait->setChecked(action == this->orientationPortrait);
    this->orientationAuto->setChecked(action == this->orientationAuto);


}

void MainWindow::toggleFullScreenOn(){
    toggleFullScreen(true);
}

void MainWindow::toggleFullScreenOff(){
    toggleFullScreen(false);
}


void MainWindow::toggleFullScreen(bool b)
{
    qDebug() << "toggleFullScreen: " << b;
    setWindowState(b ? windowState() | Qt::WindowFullScreen
        : windowState() & ~Qt::WindowFullScreen);
}


void MainWindow::updateTimerSlot(int time){
    this->setMenuActionTimerText(time);
    this->timerWindow->updateStateInfo(time);
    this->getPlayer()->doTimer(time);
}

void MainWindow::clearTimerSlot(){
    this->getPlayer()->stopTimer();
}

void MainWindow::setMenuActionTimerText(int time){
    //qDebug() << "--------------------------setMenuActionTimerText: "<< time;
    if(time == 0){
        this->ui->menuActionTimer->setText("Sleep Timer");
    }else{
        this->ui->menuActionTimer->setText(SymfonieTimerWindow::getTimerDescription(time));
    }

}

void MainWindow::playerTimerRemainTimeChangedSlot(int time){
    qDebug() << "playerTimerRemainTimeChangedSlot: " << time;

    //this->ui->menuActionTimer
    if(this->timerWindow->isVisible()){
        this->timerWindow->updateStateInfo(time);
    }



  //  if(this->ui->mainMenu->isActiveWindow()){
    /** @todo optimize this, only do this when menu is shown */
        this->setMenuActionTimerText(time);
   // }

}


void MainWindow::goUpSlot(){
    qDebug() << this->curentDirectory;
    if(this->getCurrentDiretory().length() == 0){
        this->goHomeSlot();
    }else{
        QFileInfo info = QFileInfo(this->getCurrentDiretory() + "/..");
        // qDebug() << "up to : " <<info.canonicalFilePath();
        this->getPlayer()->scanDir(info.canonicalFilePath());
    }
}

bool MainWindow::saveLastDir(){
    qDebug() << "trying to save dir: " << this->currentPlayList->getCurrentDirectory();

    QFileInfo info = QFileInfo(this->getCurrentDiretory());
    if(info.exists()){
        SymfonieDb::getInstance()->saveSetting("last_browsed_dir", info.canonicalFilePath());
        return true;

    }
    SymfonieDb::getInstance()->saveSetting("last_browsed_dir", QVariant(""));
    return false;
}


void MainWindow::saveState(){
    this->saveLastDir();
    qDebug() << "curent time: "<<this->getPlayer()->getMediaObject()->currentTime();
    if(this->getPlayer()->getCurrentPlaybackIndex() != -1){
        SymfonieDb::getInstance()->saveSetting("last_played_position", QVariant(this->getPlayer()->getMediaObject()->currentTime()));
    }else{
        SymfonieDb::getInstance()->saveSetting("last_played_position", QVariant(0));
    }

    SymfonieDb::getInstance()->saveSetting("is_seekSlider_visible", QVariant(this->ui->subToolBar->isVisible() ? 1:1));
    qDebug() << "is_seekSlider_visible" << SymfonieDb::getInstance()->getSetting("is_seekSlider_visible");
}

void MainWindow::showAboutWindowSlot(){
    SymfonieAboutDialog *dialog = new SymfonieAboutDialog(this);
    dialog->show();
    //auto deleted
}

void MainWindow::showTimerWindowSlot(){
    this->timerWindow->show();
}

void MainWindow::showEqualizerWindowSlot(){
    this->equalizerWindow->show();
}


void MainWindow::goToCurDirSlot(){
    //QString filePath = this->getPlayer()->getFilePathAt(this->getPlayer()->getCurrentDirectory());
    // QFileInfo dirInfo = QFileInfo(filePath);
    QString currentPath = this->getPlayer()->getCurrentDirectory();

    if(currentPath.length() == 0){
        return;
    }else if(QString::compare(this->getCurrentDiretory(), currentPath) == 0){
        return;
    }else{
        this->getPlayer()->scanDir(currentPath);
    }
}

void MainWindow::playerTickSlot(qint64 time)
{
    if(this->ui->sliderPanel->isVisible()){
        QTime displayTime(0, (time / 60000) % 60, (time / 1000) % 60);
        int tt = this->getPlayer()->getMediaObject()->totalTime();
        QTime totalTime(0, (tt / 60000) % 60, (tt / 1000) % 60);
        this->ui->sliderLabel->setText(displayTime.toString("mm:ss") + "/" + totalTime.toString("mm:ss"));

    }
}

SymfoniePlayList* MainWindow::createHomePlayList(){
    SymfoniePlayList *playList = new SymfoniePlayList();
    SymfoniePlayListItemFolder *homeFolder = new SymfoniePlayListItemFolder(
            QDir::homePath () + "/MyDocs/.sounds"
            );
    homeFolder->setDisplayName(tr("My Music"));
    playList->addFolder(homeFolder);

    QString mediaPath = "/media";
    QDir mediaDir = QDir(mediaPath);
    QStringList mediaList = mediaDir.entryList(
            QStringList(),
            QDir::Dirs|QDir::NoDotAndDotDot|QDir::Drives|QDir::AllDirs
            );

    for (int i = 0; i < mediaList.size(); i++) {
        QFileInfo fileInfo(mediaPath + "/" +mediaList.at(i));
        if(!fileInfo.isDir()){
            continue;
        }

        SymfoniePlayListItemFolder *folder =  new SymfoniePlayListItemFolder(fileInfo.canonicalFilePath());
        folder->setDisplayName(fileInfo.fileName());
        playList->addFolder(folder);

    }


    return playList;
}

void MainWindow::goHomeSlot(){
    this->currentPlayList = this->createHomePlayList();
    this->insertItem(this->currentPlayList);
    this->setCurrentDirectory("");
}


void MainWindow::showInfoWindowSlot(){
    if(this->ui->sliderPanel->isVisible()){
        this->ui->sliderPanel->hide();
        this->showInfoWindowAction->setChecked(false);
    }else{
        this->ui->sliderPanel->show();
        this->showInfoWindowAction->setChecked(true);
    }

    this->setActionToggleState();
}

void MainWindow::setActionToggleState(){
    this->showInfoWindowAction->setChecked(this->ui->subToolBar->isVisible());
    this->showToolBar2Action->setChecked(this->ui->subToolBar2->isVisible());
}




void MainWindow::showToolBar2Slot(){
    qDebug() << "showToolBar2Slot()";
    if(this->ui->subToolBar2->isVisible()){
        this->ui->subToolBar2->hide();
    }else{
        this->ui->subToolBar2->show();
    }
    this->setActionToggleState();
}


void MainWindow::stopSlot(){
}


void MainWindow::setHO(){
    qDebug() << "HO";
    // setAttribute(Qt::WA_Maemo5ForceLandscapeOrientation, true);
    //setAttribute(Qt::WA_Maemo5ForcePortraitOrientation, false);
    //this->setAttribute(Qt::WA_Maemo5StackedWindow);
    //this->setAttribute(Qt::WA_Maemo5StackedWindow, false);
    this->isInPortait = false;
}

void MainWindow::setPO(){
    qDebug() << "PO";
    //setAttribute(Qt::WA_Maemo5ForceLandscapeOrientation, true);
    //setAttribute(Qt::WA_Maemo5ForcePortraitOrientation, true);
    //  this->setAttribute(Qt::WA_Maemo5StackedWindow, true);

    this->isInPortait = true;
}

void MainWindow::switchOrientationSlot(){
    if(this->isInPortait){
        this->setHO();
    }else{
        this->setPO();
    }
}

void MainWindow::playerDirectoryChangedSlot(QString dir){
    qDebug() << "dir changed:" << dir;

}



void MainWindow::insertItem(SymfoniePlayList* playList){
    qDebug() << "MainWindow::insertItem" ;
    this->ui->fileListWidget->clear();
    int currentPlaybackIndex =  this->player->getCurrentPlaybackIndex();
    QString currentPlaybackFile;
    if(currentPlaybackIndex != -1){
        currentPlaybackFile = this->getPlayer()->getFilePathAt(currentPlaybackIndex);
    }



    QList<SymfoniePlayListItem*> *itemList = playList->getItemList();
    int counter=0;
    foreach (SymfoniePlayListItem *item, *itemList){
        //
        QListWidgetItem *newItem = new QListWidgetItem;



        if(item->getItemType() == SymfoniePlayListItem::Directory){
            newItem->setIcon(style()->standardIcon(QStyle::SP_DirIcon));
        }else if(item->getItemType() == SymfoniePlayListItem::File){
            newItem->setIcon(style()->standardIcon(QStyle::SP_FileIcon));
        }else if(item->getItemType() == SymfoniePlayListItem::DotDot){
            newItem->setIcon(style()->standardIcon(QStyle::SP_ArrowUp));
        }


        newItem->setText(item->getDisplayName());
        ui->fileListWidget->insertItem(counter, newItem);




        if(item->getItemType() == SymfoniePlayListItem::File){
            qDebug() << currentPlaybackIndex << this->getCurrentDiretory() << this->getPlayer()->getCurrentDirectory();
            if(currentPlaybackIndex != -1 && QString::compare(this->getCurrentDiretory(), this->getPlayer()->getCurrentDirectory()) == 0){
                if(QString::compare(item->getName(), currentPlaybackFile) == 0){
                    newItem->setSelected(true);
                    qDebug() << currentPlaybackFile << "selected";

                }
            }
        }

        counter++;
    }
}


void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void MainWindow::itemActivatedSlot(QModelIndex index)
{
    int row = index.row();
    SymfoniePlayList *playList = this->currentPlayList;
    SymfoniePlayListItem *item = playList->get(row);

    if(item == NULL){
        qFatal("play list is empty when itemActivated event received.");
    }

    QString path = item->getName();
    qDebug() << "item index: " << index << " item at: " << path << item->getItemTypeName() << " curdir:" << this->getCurrentDiretory();

    if(item->getItemType() == SymfoniePlayListItem::Directory ||
       item->getItemType() == SymfoniePlayListItem::DotDot){
        this->setCurrentDirectory(path);
        this->getPlayer()->scanDir(this->getCurrentDiretory());


    }else if(item->getItemType() == SymfoniePlayListItem::File){
        if(QString::compare(this->getCurrentDiretory(), this->getPlayer()->getCurrentDirectory()) == 0){

        }else{
            //this->getPlayer()->scanDir(this->getCurrentDiretory(), true);

            this->getPlayer()->setPlayList(this->currentPlayList);

        }

        if(row == this->getPlayer()->getCurrentPlaybackIndex() && (
                this->player->getMediaObject()->state() == Phonon::PlayingState ||
                this->player->getMediaObject()->state() == Phonon::PausedState
                )){
           this->getPlayer()->playOrPause();
        }else{
            this->player->enqueue(row);
            this->player->play();

        }

    }

}


void MainWindow::setPlayer(SymfonieMediaPlayer *player){
    this->player = player;
}

SymfonieMediaPlayer * MainWindow::getPlayer(){
    return this->player;
}


void MainWindow::playSlot(){
    this->player->playOrPause();

}

void MainWindow::playNextSlot(){
    qDebug() << "next";
    this->player->playNext();


}

void MainWindow::playPrevSlot(){
    qDebug() << "prev";
    this->player->playPrevious();

}

void MainWindow::mediaStateChangedSlot(Phonon::State newState, Phonon::State){  //oldState
    Phonon::MediaObject *mediaObject = this->getPlayer()->getMediaObject();
    switch (newState) {
    case Phonon::ErrorState:
        if (mediaObject->errorType() == Phonon::FatalError) {
            QMessageBox::warning(this, tr("Fatal Error"),
                                 mediaObject->errorString());
        } else {
            QMessageBox::warning(this, tr("Error"),
                                 mediaObject->errorString());
        }
        break;
       case Phonon::PlayingState:
        // playAction->setEnabled(false);
        playAction->setIcon(style()->standardIcon(QStyle::SP_MediaPause));
        //pauseAction->setEnabled(true);
        stopAction->setEnabled(true);

        qDebug() << "Current playback index: " << this->player->getCurrentPlaybackIndex() ;

        if(QString::compare(this->getCurrentDiretory(), this->getPlayer()->getCurrentDirectory()) == 0){
            this->ui->fileListWidget->setCurrentItem( this->ui->fileListWidget->item(
                    this->player->getCurrentPlaybackIndex()
                    ),
                                                      QItemSelectionModel::SelectCurrent);
        }

        break;
       case Phonon::StoppedState:
        stopAction->setEnabled(false);
        playAction->setEnabled(true);
        playAction->setIcon(style()->standardIcon(QStyle::SP_MediaPlay));
        //pauseAction->setEnabled(false);
        // timeLcd->display("00:00");
        break;
       case Phonon::PausedState:
        //pauseAction->setEnabled(false);
        stopAction->setEnabled(true);
        //playAction->setEnabled(true);
        playAction->setIcon(style()->standardIcon(QStyle::SP_MediaPlay));
        break;
       case Phonon::BufferingState:
        qDebug() << "buffering";
        break;
       default:
        ;
    }
}



QString MainWindow::getCurrentDiretory(){
    return this->curentDirectory;
}

void MainWindow::setCurrentDirectory(QString path){
    this->curentDirectory = path;
}



void MainWindow::playerScanDirCompletedSlot(SymfoniePlayList* playList, QString path){
    qDebug() << "playerScanDirCompletedSlot done scaned: " << path << " item found: " << playList->getSize();
    this->currentPlayList = playList;
    this->setCurrentDirectory(playList->getCurrentDirectory());
    this->insertItem(playList);





    if(this->isResumePlayback == true){
        this->isResumePlayback = false;
        QVariant indexBuff = SymfonieDb::getInstance()->getSetting("last_played_index");
        /** @todo QVariant doesn't seek to take qint64, potential information loss */
        qint64 seekTo = SymfonieDb::getInstance()->getSetting("last_played_position").toInt();
        if(indexBuff.toString().length() != 0){
            int index = indexBuff.toInt();
            if(index != -1){
                this->getPlayer()->setPlayList(playList);
                this->getPlayer()->enqueue(index);
                qDebug() << " queue index: " << index;
                if(seekTo > 0){
                    this->getPlayer()->play(seekTo);
                }else{
                    this->getPlayer()->play();
                }
            }
        }
    }


}
