#!/usr/bin/python
# stringsearch.py: Search for text in .mo files
# Stringmodding Scripts for Maemo 5
# Thomas Perl <thp.io/about>; 2011-02-07

import glob
import subprocess
import os
import sys

if len(sys.argv) == 1:
    print 'usage: %s text to search for' % (sys.argv[0],)
    sys.exit(1)

s = (' '.join(sys.argv[1:])).lower()
search_in = '/usr/share/locale/'+os.environ['LANG']+'/LC_MESSAGES/*.mo'
for file in glob.glob(search_in):
    data = subprocess.Popen(['msgunfmt', file], stdout=subprocess.PIPE)
    for line in data.stdout:
        if s in line.lower():
            print file, '->', line.strip()
    data.wait()

