//      stopish.h
//
//      Copyright 2009 Michael Cronenworth <michael@melchior>
//
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
//      MA 02110-1301, USA.


#ifndef __STOPISH_H__
#define __STOPISH_H__

#define STOPISH_MODE_START  0
#define STOPISH_MODE_PAUSE  1
#define STOPISH_MODE_RESUME 2

#define STOPISH_PORTRAIT  0
#define STOPISH_LANDSCAPE 1

#define TIMER_PRECISION_HOUR   0
#define TIMER_PRECISION_MINUTE 1

// stopish.c
gint dbus_callback( const gchar *interface, const gchar *method,
	                GArray *arguments, gpointer data, osso_rpc_t *retval );
int stopish_get_mode( void );

// timer.c
char *stopish_get_time_string( void );
long int stopish_get_time_timer( void );
void stopish_set_time_start( long int time );
void stopish_timer_resume( void );
void stopish_timer_save( void );
long int stopish_current_time( void );
void stopish_timer_set_precision( int setting );
int stopish_timer_get_precision( void );

#endif
