
#include <q-extras/qemaemo5dynamicwidgethelper.h>
#include <q-extras/qtsingleapplication.h>
#include <q-extras/qesettingsmanager.h>
#include "stickynoteswidget.hpp"
#include "appeventlistener.hpp"

#define SETTING_SAVED_WIDGETS_COMPATIBILITY "QMaemo5DynamicWidgetHelper-SavedWidgetIds"

int main(int argc, char *argv[])
{
    QApplication::setApplicationName("Sticky Notes");
    QApplication::setOrganizationName("Venemo");
    // APP_VERSION and APP_BETA are defined in the .pro file
    QApplication::setApplicationVersion(QString(APP_VERSION)
#if APP_BETA
        + " beta"
#endif
        );

    QtSingleApplication app(argc, argv);
    qDebug() << "Launched Sticky Notes app";

    if (app.isRunning())
    {
        qDebug() << "Another instance of the app is running.";
        if (app.arguments().contains("in-background"))
        {
            qDebug() << "Closing that other instance.";
            app.sendMessage(APP_MESSAGE_CLOSE);
        }
        else
        {
            qDebug() << "Asking it to offer to create a new widget and closing this one.";
            app.sendMessage(APP_MESSAGE_ADDWIDGET);
            return 0;
        }
    }

    // <compatibility>
    // Ensuring that notes from previous versions of the app are displayed in this version as well.
    // NOTE: this is for 0.1.x => 0.2.x settings format
    QSettings settings;
    if (settings.allKeys().contains(SETTING_SAVED_WIDGETS_COMPATIBILITY))
    {
        settings.setValue(SETTING_SAVED_WIDGET_IDS, settings.value(SETTING_SAVED_WIDGETS_COMPATIBILITY));
        settings.remove(SETTING_SAVED_WIDGETS_COMPATIBILITY);
    }
    // </compatibility>

    // <compatibility>
    // Ensuring that notes from previous versions of the app are displayed in this version as well.
    // NOTE: this is for 0.2.x => 0.3.x settings format
    QList<QString> savedWidgets(QeSettingsManager::retrieveBinary<QList<QString> >(SETTING_SAVED_WIDGET_IDS));
    for (int i = 0; i < savedWidgets.count(); i++)
    {
        savedWidgets[i].remove("{").remove("}");
    }
    QeSettingsManager::storeBinary<QList<QString> >(SETTING_SAVED_WIDGET_IDS, savedWidgets);
    foreach (QString item, settings.allKeys())
    {
        if (item.contains("position") || item.contains("homescreen"))
        {
            settings.remove(item);
        }
        else if (item.contains("{") || item.contains("}"))
        {
            QString newItem = item;
            newItem.remove("{").remove("}");
            settings.setValue(newItem, settings.value(item));
            settings.remove(item);
        }
    }
    // </compatibility>

    app.setQuitOnLastWindowClosed(false);
    AppEventListener::instance();

    if (app.arguments().contains("forget-widgets"))
    {
        qDebug() << "We were asked to forget all widgets!";
        QeMaemo5DynamicWidgetHelper::globalInstance()->forgetAllWidgets();
    }
    else
    {
        qDebug() << "Restoring all widgets";
        QeMaemo5DynamicWidgetHelper::globalInstance()->restoreWidgets<StickyNotesWidget>();
    }

    if (!app.arguments().contains("in-background") && QeMaemo5DynamicWidgetHelper::globalInstance()->widgets().count() == 0)
    {
        qDebug() << "Adding a new widget, as there are none yet.";
        StickyNotesWidget::createAndShowNew();
    }

    return app.exec();
}
