/*
 * This file is a part of hildon-extras
 *
 * Copyright (C) 2010 Timur Kristf <venemo@msn.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version. or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef QT_HE_WRAPPER_H
#define QT_HE_WRAPPER_H

#include <QtGui>

class QtHeWrapper
{
public:
    static QColor showHeSimpleColorDialog(QWidget *parent = NULL, const QColor &defaultColor = QColor(), bool showAdvancedButton = true, const QString &dialogTitle = "");
    static QColor showHeColorDialog(QWidget *parent = NULL, const QColor &defaultColor = QColor(), const QString &dialogTitle = "");
    static void showHeAboutDialog(QWidget *parent, const QString &description, const QString &copyright, const QString &websiteUrl = "", const QString &bugtrackerUrl = "", const QString &donateUrl = "", const QString &iconName = "", const QString &appName = QApplication::applicationName(), const QString &version = QApplication::applicationVersion());
    static QFont showHeFontDialog(QWidget *parent = NULL, const QFont &defaultFont = QFont(), const QString &dialogTitle = "");
};

#endif
