#include "dialogs.hpp"
#include <QVBoxLayout>

Dialogs *Dialogs::_instance = NULL;

Dialogs::Dialogs(QObject *parent)
    : QObject(parent),
      _quickOptionsDialog(NULL)
{
}

Dialogs *Dialogs::instance()
{
    if (_instance == NULL)
    {
        _instance = new Dialogs();
    }
    return _instance;
}

void Dialogs::showQuickOptionsDialog()
{
    static bool isShown = false;

    if (_quickOptionsDialog == NULL)
    {
        _quickOptionsDialog = new QDialog;
        _quickOptionsDialog->setWindowTitle("Quick options");
        _backgroundColorButton = new QPushButton("Change background colour");
        _foregroundColorButton = new QPushButton("Change foreground colour");
        _fontButton = new QPushButton("Change font");
        _alphaSlider = new QSlider(Qt::Horizontal);
        _alphaSlider->setMinimum(0);
        _alphaSlider->setMaximum(255);
        QVBoxLayout *layout = new QVBoxLayout;
        layout->addWidget(_backgroundColorButton);
        layout->addWidget(_foregroundColorButton);
        layout->addWidget(_fontButton);
        QHBoxLayout *hLayout = new QHBoxLayout;
        hLayout->addWidget(new QLabel("Opacity"));
        hLayout->addWidget(_alphaSlider);
        layout->addLayout(hLayout);
        _quickOptionsDialog->setLayout(layout);
    }

    if (!isShown && QObject::sender()->inherits("StickyNotesWidget"))
    {
        isShown = true;
        StickyNotesWidget *stickyNotes = (StickyNotesWidget*)QObject::sender();

        disconnect(_backgroundColorButton, SIGNAL(clicked()), 0, 0);
        disconnect(_foregroundColorButton, SIGNAL(clicked()), 0, 0);
        disconnect(_fontButton, SIGNAL(clicked()), 0, 0);
        disconnect(_alphaSlider, SIGNAL(valueChanged(int)), 0, 0);

        connect(_backgroundColorButton, SIGNAL(clicked()), stickyNotes, SLOT(showBackgroundColorSelection()));
        connect(_foregroundColorButton, SIGNAL(clicked()), stickyNotes, SLOT(showForegroundColorSelection()));
        connect(_fontButton, SIGNAL(clicked()), stickyNotes, SLOT(showFontSelection()));
//        connect(_alphaSlider, SIGNAL(valueChanged(int)), stickyNotes, SLOT(setAlpha(int)));

//        connect(_backgroundColorButton, SIGNAL(clicked()), _quickOptionsDialog, SLOT(hide()));
//        connect(_foregroundColorButton, SIGNAL(clicked()), _quickOptionsDialog, SLOT(hide()));
//        connect(_fontButton, SIGNAL(clicked()), _quickOptionsDialog, SLOT(hide()));

        _alphaSlider->setValue(stickyNotes->backgroundColor().alpha());
        _quickOptionsDialog->exec();
        stickyNotes->setAlpha(_alphaSlider->value());
        isShown = false;
    }
}
