#ifndef STICKYNOTESWIDGET_HPP
#define STICKYNOTESWIDGET_HPP

#include <QtCore>
#include <QtGui>
#include "qemaemo5dynamichomescreenwidget.h"

#define STICKY_NOTES_ALPHA_DEFAULT_VALUE 185

namespace Ui {
    class StickyNotesWidget;
}

class StickyNotesWidget : public QeMaemo5DynamicHomescreenWidget
{
    Q_OBJECT

private:
    Ui::StickyNotesWidget *ui;
    bool _isChanged;
    QColor _backgroundColor;
    QColor _foregroundColor;
    QTimer *_timer;

protected:
    void paintEvent(QPaintEvent *event);
    void changeEvent(QEvent *e);
    void showSettingsDialog();
    bool restoreWidgetState();

public:
    static StickyNotesWidget *createAndShowNew();

    explicit StickyNotesWidget(QWidget *parent = 0);
    ~StickyNotesWidget();

    bool isChanged() const;
    void setBackgroundColor(const QColor &color);
    void setForegroundColor(const QColor &color);
    void setFont(const QFont &font);
    const QColor &backgroundColor() const;
    const QColor &foregroundColor() const;

signals:
    void optionsButtonClicked();

public slots:
    void saveText();
    void toggleToolbar();
    void setToggleButtonsState();
    void setAlpha(int newAlpha);
    void showBackgroundColorSelection();
    void showForegroundColorSelection();
    void showFontSelection();

private slots:
    void on_txtNote_selectionChanged();
    void on_txtNote_cursorPositionChanged();
    void on_btnStrikeThrough_clicked();
    void on_btnUnderline_clicked();
    void on_btnItalic_clicked();
    void on_btnBold_clicked();
    void on_txtNote_textChanged();
    void on_btnAdd_clicked();
    void on_btnOptions_clicked();
    void on_btnExit_clicked();
};

#endif // STICKYNOTESWIDGET_HPP
