#include "stickynotestextedit.hpp"

StickyNotesTextEdit::StickyNotesTextEdit(QWidget *parent)
    : QTextEdit(parent),
      _hasBeenFocused(false)
{
    connect(this, SIGNAL(focusChanged()), this, SLOT(removeInitialText()));
}

void StickyNotesTextEdit::focusInEvent(QFocusEvent *e)
{
    QTextEdit::focusInEvent(e);
    focusChanged();
}

void StickyNotesTextEdit::focusOutEvent(QFocusEvent *e)
{
    QTextEdit::focusOutEvent(e);
    focusChanged();
}

void StickyNotesTextEdit::showEvent(QShowEvent *e)
{
    QTextEdit::showEvent(e);
}

void StickyNotesTextEdit::removeInitialText()
{
    if (!_hasBeenFocused && hasFocus())
    {
        _hasBeenFocused = true;

        if (toPlainText() == STICKY_NOTES_TEXT_EDIT_INITIAL_TEXT)
        {
            setText(QString());
        }
    }
}

void StickyNotesTextEdit::toggleStrikeThrough()
{
    QTextCharFormat format = currentCharFormat();
    format.setFontStrikeOut(!format.fontStrikeOut());
    setCurrentCharFormat(format);
}
