#define QT_NO_KEYWORDS

#include "qemaemo5dynamicwidgethelper.h"
#include "qemaemo5dynamichomescreenwidget.h"
#include "qesettingsmanager.h"
#include <gtk/gtk.h>
#include <gconf/gconf.h>
#include <gconf/gconf-value.h>
#include <gconf/gconf-client.h>

#define DESKTOP_GCONF_ENTRY "/apps/osso/hildon-desktop/views/current"

static GConfClient *gconfClient;
static int _currentHomeScreen = -1;
static QList<int> *restoredHomescreens;

static void gconf_key_changed_callback(GConfClient* client, guint cnxn_id, GConfEntry* entry, gpointer user_data)
{
    Q_UNUSED(client);
    Q_UNUSED(cnxn_id);
    Q_UNUSED(user_data);
    qDebug() << "gconf callback received";
    if (gconf_entry_get_value (entry) != NULL && gconf_entry_get_value (entry)->type == GCONF_VALUE_INT)
    {
        _currentHomeScreen = (int)gconf_value_get_int(gconf_entry_get_value(entry));
        qDebug() << "gconf says, current home screen =" << _currentHomeScreen;

        QeMaemo5DynamicWidgetHelper::globalInstance()->updateCurrentHomeScreen();
    }
}

QeMaemo5DynamicWidgetHelper *QeMaemo5DynamicWidgetHelper::_globalInstance = NULL;

QeMaemo5DynamicWidgetHelper *QeMaemo5DynamicWidgetHelper::globalInstance()
{
    if (_globalInstance == NULL)
        _globalInstance = new QeMaemo5DynamicWidgetHelper();

    return _globalInstance;
}

QeMaemo5DynamicWidgetHelper::QeMaemo5DynamicWidgetHelper()
    : _widgets(new QList<QeMaemo5DynamicHomescreenWidget*>()), _savedAppletIds(new QList<QString>(QeSettingsManager::retrieveBinary<QList<QString> >(SETTING_SAVED_WIDGET_IDS)))
{
    qDebug() << "initalizing widget helper";
    if (!gconf_is_initialized())
    {
        gconf_init(NULL, NULL, NULL);
        qDebug() << "gconf initialized";
    }
    restoredHomescreens = new QList<int>();

    gconfClient = gconf_client_get_default();
    gconf_client_add_dir(gconfClient, DESKTOP_GCONF_ENTRY, GCONF_CLIENT_PRELOAD_NONE, NULL);
    gconf_client_notify_add(gconfClient, DESKTOP_GCONF_ENTRY, gconf_key_changed_callback, NULL, NULL, NULL);

    _currentHomeScreen = gconf_value_get_int(gconf_entry_get_value(gconf_client_get_entry(gconfClient, DESKTOP_GCONF_ENTRY, NULL, true, NULL)));
    qDebug() << "current home screen=" << _currentHomeScreen;

}

void QeMaemo5DynamicWidgetHelper::updateCurrentHomeScreen()
{
    if (!restoredHomescreens->contains(currentHomeScreen()))
    {
        restoredHomescreens->append(currentHomeScreen());
        qDebug() << "re-adding widgets to homescreen:" << currentHomeScreen();
        for (int i = 0; i < _widgets->count(); i++)
        {
            QeMaemo5DynamicHomescreenWidget *current = _widgets->operator [](i);
            //qDebug() << "examining widget:" << current->appletId() << "supposed desktop:" << current->homescreenNumber();
            if (current->homescreenNumber() == currentHomeScreen())
            {
                current->show();
                qDebug() << "widget shown:" << current->appletId();
            }
        }
    }
    // Hack needed because of Maemo.org bug 10725: https://bugs.maemo.org/show_bug.cgi?id=10725
    // This stuff will make sure that the gconf callback will also save the widget position in the required corner case.
    for (int i = 0; i < _widgets->count(); i++)
    {
        QeMaemo5DynamicHomescreenWidget *current = _widgets->operator [](i);
        if (current->_isVisibleOnCurrentHomescreen && current->_hackSequenceForSavingFromCallback >= 2 && current->_hackSequenceCount > 2)
        {
            qDebug() << "widget position for:" << current->appletId() << "is now saved by helper";
            current->savePosition();
        }
        current->_hackSequenceForSavingFromCallback = 0;
    }
}

int QeMaemo5DynamicWidgetHelper::currentHomeScreen()
{
    //qDebug() << "someone asked for current homescreen";
    //qDebug() << "according to gconf, it is:" << gconf_value_get_int(gconf_entry_get_value(gconf_client_get_entry(gconfClient, DESKTOP_GCONF_ENTRY, NULL, true, NULL)));
    return _currentHomeScreen;
}

void QeMaemo5DynamicWidgetHelper::registerWidget(QeMaemo5DynamicHomescreenWidget *widget)
{
    if (!_widgets->contains(widget))
        _widgets->append(widget);;
    if (!_savedAppletIds->contains(widget->appletId()))
        _savedAppletIds->append(widget->appletId());

    QeSettingsManager::storeBinary<QList<QString> >(SETTING_SAVED_WIDGET_IDS, *_savedAppletIds);
    qDebug() << "widget registered:" << widget->appletId() << "supposed desktop:" << widget->homescreenNumber();;
}

void QeMaemo5DynamicWidgetHelper::registerAll(const QList<QeMaemo5DynamicHomescreenWidget *> list)
{
    for (int i = 0; i < list.count(); i++)
    {
        registerWidget(list[i]);
    }
}

void QeMaemo5DynamicWidgetHelper::unregisterWidget(QeMaemo5DynamicHomescreenWidget *widget)
{
    if (_widgets->contains(widget))
        _widgets->removeOne(widget);
    if (_savedAppletIds->contains(widget->appletId()))
        _savedAppletIds->removeOne(widget->appletId());
    QeSettingsManager::storeBinary<QList<QString> >(SETTING_SAVED_WIDGET_IDS, *_savedAppletIds);
    qDebug() << "widget unregistered:" << widget->appletId();
}

void QeMaemo5DynamicWidgetHelper::unregisterAll(const QList<QeMaemo5DynamicHomescreenWidget *> list)
{
    for (int i = 0; i < list.count(); i++)
    {
        unregisterWidget(list[i]);
    }
}

bool QeMaemo5DynamicWidgetHelper::isWidgetRegistered(QeMaemo5DynamicHomescreenWidget *widget)
{
    return _widgets->contains(widget);
}

const QList<QString> &QeMaemo5DynamicWidgetHelper::savedAppletIds()
{
    return *_savedAppletIds;
}

const QList<QeMaemo5DynamicHomescreenWidget*> &QeMaemo5DynamicWidgetHelper::widgets()
{
    return *_widgets;
}

void QeMaemo5DynamicWidgetHelper::forgetAllWidgets()
{
    _savedAppletIds->clear();
    QeSettingsManager::removeSettingsStartingWith(SETTING_SAVED_WIDGET_IDS);
    QeSettingsManager::removeSettingsStartingWith(WIDGET_SETTINGS_BASE_APPLETID);
    qDebug() << "forgot all widgets";
}
