#ifndef QMAEMO5DYNAMICWIDGETHELPER_H
#define QMAEMO5DYNAMICWIDGETHELPER_H

#include <QtCore>
#include "qmaemo5dynamichomescreenwidget.h"

class QMaemo5DynamicWidgetHelper
{

private:

    static QMaemo5DynamicWidgetHelper *_globalInstance;

    QList<QMaemo5DynamicHomescreenWidget*> *_widgets;
    QList<QString> *_savedAppletIds;

    explicit QMaemo5DynamicWidgetHelper();

protected:

public:

    static QMaemo5DynamicWidgetHelper *globalInstance();

    int currentHomeScreen();
    void registerWidget(QMaemo5DynamicHomescreenWidget *widget);
    void unregisterWidget(QMaemo5DynamicHomescreenWidget *widget);
    bool isWidgetRegistered(QMaemo5DynamicHomescreenWidget *widget);
    const QList<QMaemo5DynamicHomescreenWidget*> &widgets();
    void updateCurrentHomeScreen();
    const QList<QString> &savedAppletIds();

    void forgetAllWidgets();
    template<typename TWidget> void reAddWidgets();

};

template<typename TWidget>
void QMaemo5DynamicWidgetHelper::reAddWidgets()
{
    for (int i = 0; i < savedAppletIds().count(); i++)
    {
        qDebug() << "beginning to re-add widget:" << savedAppletIds().at(i);
        TWidget *newWidget = new TWidget();
        qDebug() << "ha!";

        if (!newWidget->restoreAppletId(savedAppletIds().at(i)))
        {
            qDebug() << "this widget is not able to restore itelf, so we won't add it";
            delete newWidget;
        }
        else
        {
            qDebug() << "registering widget";
            registerWidget(newWidget);
        }
    }
    qDebug() << "widgets re-added";
    updateCurrentHomeScreen();
}

#endif // QMAEMO5DYNAMICWIDGETHELPER_H
