/* mafw.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Mafw", lower_case_cprefix = "mafw_")]
namespace Mafw {
	[Compact]
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public class Callbas {
		public weak GLib.Closure closure;
		public weak GLib.Array gvargs;
		public static void argv2gval (GLib.Value value, GLib.Type type, void* args);
		public int defer ();
		public void invoke ();
	}
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public class Extension : GLib.InitiallyUnowned {
		public void add_property (string name, GLib.Type type);
		public void emit_property_changed (string property, GLib.Value value);
		[NoWrapper]
		public virtual void get_extension_property (string name, Mafw.ExtensionPropertyCallback cb, void* udata);
		public unowned string get_name ();
		public unowned string get_plugin ();
		public void get_property (string name, Mafw.ExtensionPropertyCallback cb, void* udata);
		public unowned string get_uuid ();
		[NoWrapper]
		public virtual unowned GLib.PtrArray list_extension_properties ();
		public unowned GLib.PtrArray list_properties ();
		[NoWrapper]
		public virtual void set_extension_property (string name, GLib.Value value);
		public void set_name (string name);
		public bool set_property (string name, GLib.Value value);
		public bool set_property_boolean (string name, bool value);
		public bool set_property_char (string name, char value);
		public bool set_property_double (string name, double value);
		public bool set_property_float (string name, float value);
		public bool set_property_int (string name, int value);
		public bool set_property_int64 (string name, int64 value);
		public bool set_property_long (string name, long value);
		public bool set_property_string (string name, string value);
		public bool set_property_uchar (string name, uchar value);
		public bool set_property_uint (string name, uint value);
		public bool set_property_uint64 (string name, uint64 value);
		public bool set_property_ulong (string name, ulong value);
		public string name { get; set construct; }
		public string plugin { get; construct; }
		public string uuid { get; construct; }
		public virtual signal void error (uint p0, int p1, string p2);
		public virtual signal void property_changed (string p0, GLib.Value p1);
	}
	[Compact]
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public class ExtensionProperty {
		public weak string name;
		public GLib.Type type;
	}
	[Compact]
	[CCode (copy_function = "mafw_filter_copy", cheader_filename = "libmafw/mafw.h")]
	public class Filter {
		public Mafw.FilterType type;
		[CCode (has_construct_function = false)]
		public Filter (Mafw.FilterType type);
		public unowned Mafw.Filter add_children_n ();
		public unowned Mafw.Filter copy ();
		public static unowned Mafw.Filter parse (string filter);
		public static unowned string quote (string str);
		public unowned string to_string ();
		public static unowned string unquote (string str);
		public static unowned string unquote_char (string str, string cp);
	}
	[Compact]
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public class PluginDescriptor {
		public weak GLib.Callback deinitialize;
		public weak GLib.Callback initialize;
		public weak Mafw.PluginDescriptorPublic pub;
	}
	[Compact]
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public class PluginDescriptorPublic {
		public weak string description;
		public weak string name;
		public weak string version;
	}
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public class Registry : GLib.Object {
		public void add_extension (Mafw.Extension extension);
		public unowned Mafw.Extension get_extension_by_uuid (string uuid);
		public static unowned Mafw.Registry get_instance ();
		public unowned GLib.List get_renderers ();
		public unowned GLib.List get_sources ();
		public unowned GLib.List list_plugins ();
		public bool load_plugin (string name) throws GLib.Error;
		public void load_plugins ();
		public void remove_extension (Mafw.Extension extension);
		public bool unload_plugin (string name) throws GLib.Error;
		public void unload_plugins ();
		public virtual signal void renderer_added (Mafw.Renderer p0);
		public virtual signal void renderer_removed (Mafw.Renderer p0);
		public virtual signal void source_added (Mafw.Source p0);
		public virtual signal void source_removed (Mafw.Source p0);
	}
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public class Renderer : Mafw.Extension {
		public virtual bool assign_playlist (Mafw.Playlist playlist) throws GLib.Error;
		public virtual void emit_buffering_info (float fraction);
		public void emit_metadata (string name, GLib.Type type, uint nargs);
		public virtual void get_current_metadata (Mafw.RendererMetadataResultCB callback);
		public virtual void get_position (Mafw.RendererPositionCB callback);
		public virtual void get_status (Mafw.RendererStatusCB callback);
		public virtual void goto_index (uint index, Mafw.RendererPlaybackCB callback);
		public virtual void next (Mafw.RendererPlaybackCB callback);
		public virtual void pause (Mafw.RendererPlaybackCB callback);
		public virtual void play (Mafw.RendererPlaybackCB callback);
		public virtual void play_object (string object_id, Mafw.RendererPlaybackCB callback);
		public virtual void play_uri (string uri, Mafw.RendererPlaybackCB callback);
		public virtual void previous (Mafw.RendererPlaybackCB callback);
		public virtual void resume (Mafw.RendererPlaybackCB callback);
		public virtual void set_position (Mafw.RendererSeekMode mode, int seconds, Mafw.RendererPositionCB callback);
		public virtual void stop (Mafw.RendererPlaybackCB callback);
		public virtual signal void buffering_info (float status);
		public virtual signal void media_changed (int index, string object_id);
		public virtual signal void metadata_changed (string metadata, GLib.ValueArray p1);
		public virtual signal void playlist_changed (GLib.Object playlist);
		public virtual signal void state_changed (int state);
	}
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public class Source : Mafw.Extension {
		public static bool all_keys (string keys);
		public virtual uint browse (string object_id, bool recursive, Mafw.Filter filter, string sort_criteria, string metadata_keys, uint skip_count, uint item_count, Mafw.SourceBrowseResultCb browse_cb);
		public virtual bool cancel_browse (uint browse_id) throws GLib.Error;
		public virtual void create_object (string parent, GLib.HashTable metadata, Mafw.SourceObjectCreatedCb cb);
		public static unowned string create_objectid (string uri);
		public virtual void destroy_object (string object_id, Mafw.SourceObjectDestroyedCb cb);
		//[CCode (instance_pos = -1)]
		public virtual void get_metadata (string object_id, [CCode (array_length = false)] string[] metadata_keys, Mafw.SourceMetadataResultCb metadata_cb);
		public virtual void get_metadatas (string object_ids, string metadata_keys, Mafw.SourceMetadataResultsCb metadatas_cb);
		public virtual int get_update_progress (int processed_items, int remaining_items, int remaining_time);
		public virtual void set_metadata (string object_id, GLib.HashTable metadata, Mafw.SourceMetadataSetCb cb);
		public static bool split_objectid (string objectid, string extensionid, string itemid);
		public virtual signal void container_changed (string p0);
		public virtual signal void metadata_changed (string p0);
		public virtual signal void updating (int p0, int p1, int p2, int p3);
	}
	[Compact]
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public class URISource {
	}
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public interface Playlist {
		public abstract bool append_item (string oid) throws GLib.Error;
		public abstract bool append_items (string oid) throws GLib.Error;
		public bool append_uri (string uri) throws GLib.Error;
		public static void cancel_get_items_md (void* op);
		public abstract bool clear () throws GLib.Error;
		public abstract bool decrement_use_count () throws GLib.Error;
		public abstract unowned string get_item (uint index) throws GLib.Error;
		public abstract unowned string get_items (uint first_index, uint last_index) throws GLib.Error;
		public void* get_items_md (uint from, int to, string[] keys, Mafw.PlaylistGetItemsCB cb, void* cbarg, GLib.DestroyNotify free_cbarg);
		public abstract void get_last_index (uint index, string object_id) throws GLib.Error;
		public unowned string get_name ();
		public abstract bool get_next (uint index, string object_id) throws GLib.Error;
		public abstract bool get_prev (uint index, string object_id) throws GLib.Error;
		public bool get_repeat ();
		public abstract uint get_size () throws GLib.Error;
		public abstract void get_starting_index (uint index, string object_id) throws GLib.Error;
		public abstract bool increment_use_count () throws GLib.Error;
		public abstract bool insert_item (uint index, string objectid) throws GLib.Error;
		public abstract bool insert_items (uint index, string objectid) throws GLib.Error;
		public bool insert_uri (uint index, string uri) throws GLib.Error;
		public bool is_shuffled ();
		public abstract bool move_item (uint from, uint to) throws GLib.Error;
		public abstract bool remove_item (uint index) throws GLib.Error;
		public void set_name (string name);
		public void set_repeat (bool repeat);
		public abstract bool shuffle () throws GLib.Error;
		public abstract bool unshuffle () throws GLib.Error;
		public signal void contents_changed (uint p0, uint p1, uint p2);
		public signal void item_moved (uint p0, uint p1);
	}
	[CCode (cprefix = "MAFW_ERROR_", has_type_id = false, cheader_filename = "libmafw/mafw.h")]
	public enum Error {
		PLUGINS_NOT_SUPPORTED,
		PLUGIN_LOAD_FAILED,
		PLUGIN_INIT_FAILED,
		PLUGIN_NAME_CONFLICT,
		PLUGIN_NOT_LOADED
	}
	[CCode (cprefix = "MAFW_EXTENSION_ERROR_", has_type_id = false, cheader_filename = "libmafw/mafw.h")]
	public enum ExtensionError {
		EXTENSION_NOT_AVAILABLE,
		UNSUPPORTED_OPERATION,
		NETWORK_DOWN,
		SERVICE_NOT_RESPONDING,
		EXTENSION_NOT_RESPONDING,
		INVALID_PROPERTY,
		SET_PROPERTY,
		GET_PROPERTY,
		ACCESS_DENIED,
		INVALID_PARAMS,
		OUT_OF_MEMORY,
		FAILED
	}
	[CCode (cprefix = "", has_type_id = false, cheader_filename = "libmafw/mafw.h")]
	public enum FilterType {
		MAFW_F_INVALID,
		mafw_f_and,
		mafw_f_or,
		mafw_f_not,
		MAFW_F_COMPLEX,
		mafw_f_exists,
		mafw_f_eq,
		mafw_f_lt,
		mafw_f_gt,
		mafw_f_approx,
		MAFW_F_LAST
	}
	[CCode (cprefix = "", has_type_id = false, cheader_filename = "libmafw/mafw.h")]
	public enum PlayState {
		Stopped,
		Playing,
		Paused,
		Transitioning,
		_LastMafwPlayState
	}
	[CCode (cprefix = "MAFW_PLAYLIST_ERROR_", has_type_id = false, cheader_filename = "libmafw/mafw.h")]
	public enum PlaylistError {
		DATABASE,
		INVALID_NAME,
		INVALID_INDEX,
		PLAYLIST_NOT_FOUND,
		IMPORT_FAILED,
		INVALID_IMPORT_ID
	}
	[CCode (cprefix = "MAFW_RENDERER_ERROR_", has_type_id = false, cheader_filename = "libmafw/mafw.h")]
	public enum RendererError {
		NO_MEDIA,
		URI_NOT_AVAILABLE,
		INVALID_URI,
		MEDIA_NOT_FOUND,
		STREAM_DISCONNECTED,
		TYPE_NOT_AVAILABLE,
		PLAYBACK,
		UNABLE_TO_PERFORM,
		UNSUPPORTED_TYPE,
		UNSUPPORTED_RESOLUTION,
		UNSUPPORTED_FPS,
		DRM,
		DEVICE_UNAVAILABLE,
		CORRUPTED_FILE,
		PLAYLIST_PARSING,
		CODEC_NOT_FOUND,
		VIDEO_CODEC_NOT_FOUND,
		AUDIO_CODEC_NOT_FOUND,
		NO_PLAYLIST,
		INDEX_OUT_OF_BOUNDS,
		CANNOT_PLAY,
		CANNOT_STOP,
		CANNOT_PAUSE,
		CANNOT_SET_POSITION,
		CANNOT_GET_POSITION,
		CANNOT_GET_STATUS
	}
	[CCode (cprefix = "MAFW_RENDERER_ERROR_POLICY_", has_type_id = false, cheader_filename = "libmafw/mafw.h")]
	public enum RendererErrorPolicy {
		CONTINUE,
		STOP
	}
	[CCode (cprefix = "", has_type_id = false, cheader_filename = "libmafw/mafw.h")]
	public enum RendererSeekMode {
		SeekAbsolute,
		SeekRelative
	}
	[CCode (cprefix = "MAFW_SOURCE_ERROR_", has_type_id = false, cheader_filename = "libmafw/mafw.h")]
	public enum SourceError {
		INVALID_OBJECT_ID,
		OBJECT_ID_NOT_AVAILABLE,
		INVALID_SEARCH_STRING,
		INVALID_SORT_STRING,
		INVALID_BROWSE_ID,
		PEER,
		BROWSE_RESULT_FAILED,
		GET_METADATA_RESULT_FAILED,
		UNSUPPORTED_METADATA_KEY,
		DESTROY_OBJECT_FAILED,
		PLAYLIST_PARSING_FAILED
	}
	[CCode (cheader_filename = "libmafw/mafw.h", has_target = false)]
	public delegate void ExtensionPropertyCallback (Mafw.Extension _self, string name, GLib.Value value, void* udata, GLib.Error error);
	[CCode (cheader_filename = "libmafw/mafw.h", has_target = false)]
	public delegate bool MetadataComparator (Mafw.FilterType rel, string key, GLib.Value lhsgv, GLib.Value rshgv);
	[CCode (cheader_filename = "libmafw/mafw.h", has_target = false)]
	public delegate void PlaylistGetItemsCB (Mafw.Playlist pls, uint index, string object_id, GLib.HashTable metadata, void* cbarg);
	[CCode (cheader_filename = "libmafw/mafw.h", has_target = false)]
	public delegate void RendererMetadataResultCB (Mafw.Renderer _self, string object_id, GLib.HashTable metadata, void* user_data, GLib.Error error);
	[CCode (cheader_filename = "libmafw/mafw.h", has_target = false)]
	public delegate void RendererPlaybackCB (Mafw.Renderer _self, void* user_data, GLib.Error error);
	[CCode (cheader_filename = "libmafw/mafw.h", has_target = false)]
	public delegate void RendererPositionCB (Mafw.Renderer _self, int position, void* user_data, GLib.Error error);
	[CCode (cheader_filename = "libmafw/mafw.h", instance_pos = 5.9)]
	public delegate void RendererStatusCB (Mafw.Renderer _self, Mafw.Playlist playlist, uint index, Mafw.PlayState state, string object_id, GLib.Error error);
	[CCode (cheader_filename = "libmafw/mafw.h", has_target = false)]
	public delegate void SourceBrowseResultCb (Mafw.Source _self, uint browse_id, int remaining_count, uint index, string object_id, GLib.HashTable metadata, void* user_data, GLib.Error error);
	[CCode (cheader_filename = "libmafw/mafw.h", instance_pos = 3.9)]
	public delegate void SourceMetadataResultCb (Mafw.Source _self, string object_id, GLib.HashTable metadata, GLib.Error? error);
	[CCode (cheader_filename = "libmafw/mafw.h", has_target = false)]
	public delegate void SourceMetadataResultsCb (Mafw.Source _self, GLib.HashTable metadatas, void* user_data, GLib.Error error);
	[CCode (cheader_filename = "libmafw/mafw.h", has_target = false)]
	public delegate void SourceMetadataSetCb (Mafw.Source _self, string object_id, string failed_keys, void* user_data, GLib.Error error);
	[CCode (cheader_filename = "libmafw/mafw.h", has_target = false)]
	public delegate void SourceObjectCreatedCb (Mafw.Source _self, string object_id, void* user_data, GLib.Error error);
	[CCode (cheader_filename = "libmafw/mafw.h", has_target = false)]
	public delegate void SourceObjectDestroyedCb (Mafw.Source _self, string object_id, void* user_data, GLib.Error error);
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_ADDED;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_ALBUM;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_ALBUM_ART;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_ALBUM_ART_LARGE_URI;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_ALBUM_ART_MEDIUM_URI;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_ALBUM_ART_SMALL_URI;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_ALBUM_ART_URI;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_ALBUM_INFO_URI;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_ARTIST;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_ARTIST_INFO_URI;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_AUDIO_BITRATE;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_AUDIO_CODEC;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_BITRATE;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_BPP;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_CHILDCOUNT_1;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_CHILDCOUNT_2;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_CHILDCOUNT_3;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_CHILDCOUNT_4;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_CHILDCOUNT_5;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_CHILDCOUNT_6;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_CHILDCOUNT_7;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_CHILDCOUNT_8;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_CHILDCOUNT_9;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_COMMENT;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_COMPOSER;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_COPYRIGHT;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_COUNT;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_DESCRIPTION;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_DIDL;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_DURATION;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_ENCODING;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_EXIF_XML;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_FILENAME;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_FILESIZE;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_GENRE;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_ICON;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_ICON_URI;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_IS_SEEKABLE;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_LAST_PLAYED;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_LYRICS;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_LYRICS_URI;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_MIME;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_MODIFIED;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_ORGANIZATION;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_PAUSED_POSITION;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_PAUSED_THUMBNAIL_URI;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_PLAY_COUNT;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_PROTOCOL_INFO;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_RATING;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_RENDERER_ART_URI;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_RES_X;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_RES_Y;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_TAGS;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_THUMBNAIL;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_THUMBNAIL_LARGE_URI;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_THUMBNAIL_MEDIUM_URI;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_THUMBNAIL_SMALL_URI;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_THUMBNAIL_URI;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_TITLE;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_TRACK;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_URI;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_VIDEO_BITRATE;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_VIDEO_CODEC;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_VIDEO_FRAMERATE;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_VIDEO_SOURCE;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_KEY_YEAR;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_VALUE_MIME_AUDIO;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_VALUE_MIME_CONTAINER;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_VALUE_MIME_VIDEO;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string METADATA_VALUE_VARIOUS_VALUES;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string PLUGIN_SUFFIX;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string PROPERTY_EXTENSION_ACTIVATE;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string PROPERTY_RENDERER_AUTOPAINT;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string PROPERTY_RENDERER_COLORKEY;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string PROPERTY_RENDERER_ERROR_POLICY;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string PROPERTY_RENDERER_MUTE;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string PROPERTY_RENDERER_TRANSPORT_ACTIONS;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string PROPERTY_RENDERER_VOLUME;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string PROPERTY_RENDERER_XID;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const int SOURCE_BROWSE_ALL;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const int SOURCE_INVALID_BROWSE_ID;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string SOURCE_KEY_WILDCARD;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public const string URI_SOURCE_UUID;
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static bool db_begin ();
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static int db_bind_blob (Sqlite.Statement stmt, int col, void* val, int size);
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static int db_bind_int (Sqlite.Statement stmt, int col, int val);
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static int db_bind_int64 (Sqlite.Statement stmt, int col, int64 val);
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static int db_bind_null (Sqlite.Statement stmt, int col);
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static int db_bind_text (Sqlite.Statement stmt, int col, owned string val);
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static int db_change (Sqlite.Statement stmt, bool csint_may_fail);
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static void* db_column_blob (Sqlite.Statement stmt, int col);
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static int db_column_int (Sqlite.Statement stmt, int col);
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static int64 db_column_int64 (Sqlite.Statement stmt, int col);
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static bool db_commit ();
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static int db_delete (Sqlite.Statement stmt);
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static int db_do (Sqlite.Statement stmt);
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static int db_exec (string query);
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static unowned Sqlite.Database db_get ();
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static int db_nchanges ();
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static unowned Sqlite.Statement db_prepare (string query);
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static bool db_rollback ();
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static int db_select (Sqlite.Statement stmt, bool expect_row);
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static void db_trace ();
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static unowned Mafw.URISource get_uri_source ();
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static void log_init (string doms);
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static void metadata_add_something (GLib.HashTable md, string key, GLib.Type argvtype, uint nvalues);
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static int metadata_compare (GLib.HashTable md1, GLib.HashTable md2, string terms, Mafw.MetadataComparator funcomp);
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static bool metadata_filter (GLib.HashTable md, Mafw.Filter filter, Mafw.MetadataComparator funcomp);
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public unowned GLib.Value? metadata_first (GLib.HashTable md, string key);
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static unowned string metadata_freeze (GLib.HashTable md, size_t sstreamp);
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static unowned GLib.ByteArray metadata_freeze_bary (GLib.HashTable md);
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static unowned GLib.HashTable metadata_new ();
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static uint metadata_nvalues (void* value);
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static bool metadata_ordered (Mafw.FilterType rel, string key, GLib.Value lhsgv, GLib.Value rhsgv);
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static void metadata_print (GLib.HashTable md, string domain);
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static void metadata_print_one (string key, void* val, string domain);
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static void metadata_release (GLib.HashTable md);
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static unowned string metadata_relevant_keys (string keys, Mafw.Filter filter, string sorting);
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static unowned string metadata_sorting_terms (string sorting);
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static unowned GLib.HashTable metadata_thaw (string stream, size_t sstream);
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static unowned GLib.HashTable metadata_thaw_bary (GLib.ByteArray bary);
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static unowned string metadata_val_freeze (void* val, size_t sstreamp);
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static void metadata_val_freeze_bary (GLib.ByteArray bary, void* val);
	[CCode (cheader_filename = "libmafw/mafw.h")]
	public static void* metadata_val_thaw_bary (GLib.ByteArray bary, size_t i);
}
