/*
 * This file is part of hildon-status-menu-widget-example
 *
 * Copyright (C) 2009 Nokia Corporation. All rights reserved.
 *
 * This maemo code example is licensed under a MIT-style license,
 * that can be found in the file called "COPYING" in the root
 * directory.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <sys/wait.h>
#include <hildon/hildon.h>

#include "lib-ssh-status-menu-widget.h"

#define SSH_STATUS_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE (obj, \
                            TYPE_SSH_STATUS, SSHStatusPrivate))

struct _SSHStatusPrivate
{
    GtkWidget *label;
    gpointer data;
};

HD_DEFINE_PLUGIN_MODULE (SSHStatus, ssh_status, HD_TYPE_STATUS_MENU_ITEM);

static void ssh_status_cb (gpointer, gpointer);

static void
ssh_status_class_finalize (SSHStatusClass *klass) {}

static void
ssh_status_class_init (SSHStatusClass *klass)
{
    g_type_class_add_private (klass, sizeof (SSHStatusPrivate));
}

GtkWidget *image;
GtkWidget *b;

static void ssh_status_init (SSHStatus *plugin)
{
    plugin->priv = SSH_STATUS_GET_PRIVATE (plugin);

    /*
    GtkIconTheme *icon_theme = gtk_icon_theme_get_default ();
    GList *list = gtk_icon_theme_list_icons (icon_theme, NULL);
    GdkPixbuf *pixbuf = gtk_icon_theme_load_icon (icon_theme, "general_email",
            STATUS_AREA_SSH_ICON_SIZE, GTK_ICON_LOOKUP_NO_SVG, NULL);
    hd_status_plugin_item_set_status_area_icon (HD_STATUS_PLUGIN_ITEM (plugin),
            pixbuf);
    g_object_unref (pixbuf);*/

    //GtkWidget *b = gtk_label_new ("SSH message");
    image = gtk_image_new_from_file ("/usr/share/icons/hicolor/scalable/hildon/ssh-status-big.png");

    b = hildon_button_new (HILDON_SIZE_FINGER_HEIGHT,
            HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    hildon_button_set_style (HILDON_BUTTON(b),
            HILDON_BUTTON_STYLE_PICKER);
    hildon_button_set_image (HILDON_BUTTON(b), image);

    /* WEXITSTATUS(system("sudo /usr/sbin/ssh-status.sh stop")); */
    int status = WEXITSTATUS(system("sudo /usr/sbin/ssh-status.sh check"));

    if (status == 0)
        hildon_button_set_title (HILDON_BUTTON(b), "SSH Status: ON");
    else
        hildon_button_set_title (HILDON_BUTTON(b), "SSH Status: OFF");

    hildon_button_set_alignment (HILDON_BUTTON(b),
            0.0, 0.0, 1.0, 1.0);

    g_signal_connect_after (G_OBJECT (b), "clicked",
            G_CALLBACK (ssh_status_cb), plugin);

    gtk_widget_show_all (b);

    plugin->priv->label = b;

    gtk_container_add (GTK_CONTAINER (plugin), plugin->priv->label);

    gtk_widget_show_all (plugin->priv->label);

    gtk_widget_show (GTK_WIDGET (plugin));
}

static gboolean run(gpointer plugin)
{
    char* env_var;
    int status =  WEXITSTATUS(system("sudo /usr/sbin/ssh-status.sh change"));

    if (status == 2) {
        /* Put the icon at the status bar*/	
        GdkPixbuf *pixbuf = gdk_pixbuf_new_from_file_at_size ("/usr/share/icons/hicolor/scalable/hildon/ssh_off.png",
                STATUS_AREA_SSH_ICON_SIZE,
                STATUS_AREA_SSH_ICON_SIZE,
                NULL);
        hd_status_plugin_item_set_status_area_icon (HD_STATUS_PLUGIN_ITEM (plugin), pixbuf);
        g_object_unref (pixbuf);
        hildon_button_set_title (HILDON_BUTTON(b), "SSH Status: OFF");
    } else if (status == 0) {
        /* unset tray icon if set */
        hd_status_plugin_item_set_status_area_icon (HD_STATUS_PLUGIN_ITEM (plugin), NULL);
        hildon_button_set_title (HILDON_BUTTON(b), "SSH Status: ON");
    }
    
    return FALSE;
}

static void ssh_status_cb (gpointer instance, gpointer plugin)
{
    g_idle_add(run, plugin);
}

