/*
 * This file is part of hildon-status-menu-widget-example
 *
 * Copyright (C) 2009 Nokia Corporation. All rights reserved.
 *
 * This maemo code example is licensed under a MIT-style license,
 * that can be found in the file called "COPYING" in the root
 * directory.
 *
 */

#ifndef __SSH_STATUS_PLUGIN_H__
#define __SSH_STATUS_PLUGIN_H__

#include <libhildondesktop/libhildondesktop.h>

G_BEGIN_DECLS

#define TYPE_SSH_STATUS            (ssh_status_get_type ())

#define SSH_STATUS(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                                    TYPE_SSH_STATUS, SSHStatus))

#define SSH_STATUS_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), \
                                TYPE_SSH_STATUS, SSHStatusClass))

#define IS_SSH_STATUS(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                                                    TYPE_SSH_STATUS))

#define IS_SSH_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                                                    TYPE_SSH_STATUS))

#define SSH_STATUS_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                            TYPE_SSH_STATUS, SSHStatusClass))

#define STATUS_AREA_SSH_ICON_SIZE 22

typedef struct _SSHStatus        SSHStatus;
typedef struct _SSHStatusClass   SSHStatusClass;
typedef struct _SSHStatusPrivate SSHStatusPrivate;

struct _SSHStatus
{
    HDStatusMenuItem parent;

    SSHStatusPrivate *priv;
};

struct _SSHStatusClass
{
    HDStatusMenuItemClass parent;
};

GType ssh_status_get_type (void);

G_END_DECLS

#endif
