#ifndef CONSTANTS_CORE_H
#define CONSTANTS_CORE_H

#include <qplatformdefs.h>

// Debug configuration:
#ifndef DEBUG_MODE
  #define DEBUG_MODE 0 // 1 Debug enabled, 0 Debug disabled
#endif

// Constants;
#define SERVERVERSION_MAJOR 7
#define SERVERVERSION_MIDDLE 5
#define SERVERVERSION_MINOR 1
#define NORMALSCREENOFFSET 46
#define PROGRESSINTERVAL 2000
#define RESPONSEINTERVAL 300
#define REINITDELAY 5000
#define ITEMSELECTTIME 500
#define MAXITEMSPERREQUEST 100
#define MAXTREEITEMSPERREQUEST 5000
#define DISCOVERYPORT_SC 3483
#define DISCOVERYPORT_CS 3483
#define JSON_TIMEOUT 30000

#define STATUSTAGS " tags:ailjJcesdxKuN"
#define ALBUMTAGS " tags:ailjJceu"
#define IDTAGS " tags:pse"
#define GENERAL_TAGS " tags:alsu" // url etc.
#define TITLES_TAGS " tags:als" // url etc.
#define FOLDER_TAGS " tags:lsu" // url etc.

#define NO_HTTP_MYSB_ADDRESS "www.mysqueezebox.com"
#define MYSB_ADDRESS "http://www.mysqueezebox.com"
#define MYSB_ADDRESS_LOGIN "http://www.mysqueezebox.com/user/login"
#define IPADDRESS "127.0.0.1"
#define HTTPPORT 9000

#define JSON_EXT "/jsonrpc.js"
#define COMET_EXT "/cometd"
#define MAX_ITEMS 260000

#define COMET_SUBSCR_CH "/slim/subscribe"
#define COMET_REQUEST_CH "/slim/request"

#if defined(Q_OS_SYMBIAN)
#define SCREEN_HEIGHT 640
#define SCREEN_WIDTH 360
#define LOCALALBUMARTSUFFIX "/cover_360x360.png"
#endif // SYMBIAN

#if defined(MEEGO_EDITION_HARMATTAN)
//#if not defined(Q_OS_SYMBIAN)
#define SCREEN_HEIGHT 854
#define SCREEN_WIDTH 480
#define LOCALALBUMARTSUFFIX "/cover_480x480.png"
#endif // MEEGO

#ifdef Q_WS_MAEMO_5
#define SCREEN_HEIGHT 800
#define SCREEN_WIDTH 480
#define LOCALALBUMARTSUFFIX "/cover_415x415.png"
#endif
#endif // CONSTANTS_CORE_H
