#ifndef SQUEEZSTERCORE_H
#define SQUEEZSTERCORE_H

#include <qplatformdefs.h>
#include <QObject>
#include <QtNetwork>
#include <QList>
#include <QVariant>
#include <QUdpSocket>
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QAuthenticator>
#include <QUrl>
#include <QTimer>
#include <QStringList>
#include <QSettings>
#include <QUuid>
#include <QStringBuilder>
#include <qplatformdefs.h>
#include "constantscore.h"
#include "versioncore.h"
#include "qtjson/json.h"
#include <QSystemNetworkInfo>
#if defined(MEEGO_EDITION_HARMATTAN) || defined(Q_WS_MAEMO_5) || defined(Q_OS_SYMBIAN)
#include <QSystemScreenSaver>
#endif

// MACROS
#define ACTIVE_PLAYER_MAP playersMap[activePlayer()].toMap()
#define PLAYER_MAP(str) playersMap[str].toMap()
#define CURRENT_SONG activePlayer()[P_LOOP].toList().first().toMap()
#define _DEBUG_ if(debugFlag()) qDebug()

// Player keys
#define P_ID "player_id"
#define P_IP "player_ip"
#define P_NAME "player_name"
#define P_SONG_TITLE "current_title"
#define P_SONG_INDEX "playlist_cur_index"
#define P_INDEX "playlist index"
#define P_MODE "mode"
#define P_TIME "time"
#define P_VOLUME "mixer volume"
#define P_SHUFFLE "playlist shuffle"
#define P_REPEAT "playlist repeat"
#define P_LOOP "playlist_loop"
#define P_TIMESTAMP "playlist_timestamp"
#define P_SONG_COUNT "playlist_tracks"
#define P_POWER "power"
#define P_RATE "rate"
#define P_REMOTE "remote"
#define P_REMOTE_META "remoteMeta"

#define SONG_COVERART "coverart"
#define SONG_COVERID "coverid"
#define SONG_REMOTE "remote"
#define SONG_ARTWORK_URL "artwork_url"
#define SONG_DURATION "duration"
#define SONG_ID "id"
#define SONG_TITLE "title"
#define SONG_ALBUM "artist"
#define SONG_ARTIST "artist"

#define REM_COVERART "coverart"
#define REM_COVERID "coverid"
#define REM_REMOTE "remote"
#define REM_ARTWORK_URL "artwork_url"
#define REM_DURATION "duration"
#define REM_ID "id"
#define REM_TITLE "title"
#define REM_ALBUM "artist"
#define REM_ARTIST "artist"

// Server status

#define S_P_LOOP "players_loop"
#define S_O_P_LOOP "other_players_loop"
#define S_P_COUNT "player count"
#define S_VERSION "version"
#define S_P_ID "playerid"
#define S_P_MODEL "model"
#define S_P_NAME "name"
#define S_P_POWER "power"
#define S_P_CANPOWEROFF "canpoweroff"
#define S_P_DIGITALVOLUMECONTROL "digitalVolumeControl"

QTM_USE_NAMESPACE

using namespace QtJson;
//using namespace QtMobility;

class SqueezsterCore : public QObject
{
    Q_OBJECT
    Q_PROPERTY(QVariantMap connectionSettings READ connectionSettings WRITE setConnectionSettings NOTIFY connectionSettingsChanged)
    Q_PROPERTY(QVariantMap optionsSettings READ optionsSettings WRITE setOptionsSettings NOTIFY optionsSettingsChanged)

public:

    explicit SqueezsterCore(int debug=0, QObject *parent = 0);
    ~SqueezsterCore();

    enum CometType {CometSubscription,CometRequest};

    Q_PROPERTY(QByteArray activePlayer READ activePlayer WRITE setActivePlayer NOTIFY activePlayerChanged)
    Q_INVOKABLE QByteArray activePlayer() const {return activePlayer_i;}
    Q_INVOKABLE void setActivePlayer(QByteArray playerID) {
        _DEBUG_ << "setActivePlayer(QString playerID)";
        if(isValidPlayer(playerID)) {
            _DEBUG_ << "New playerID: " << playerID;
            activePlayer_i = playerID;
            activePlayerSet= true;
            setPlayerChanged(true);
            setCurrentSong(QVariantMap());
            emit activePlayerChanged();
        }
    }

    Q_PROPERTY(int activePlayerIndex READ activePlayerIndex WRITE setActivePlayerIndex NOTIFY activePlayerIndexChanged)
    Q_INVOKABLE int activePlayerIndex() const {return activePlayerIndex_i;}
    Q_INVOKABLE void setActivePlayerIndex(int activePlayerIndex) {activePlayerIndex_i=activePlayerIndex;emit activePlayerIndexChanged();}

    Q_PROPERTY(QVariantList nowPlayingList READ nowPlayingList WRITE setNowPlayingList NOTIFY nowPlayingListChanged)
    Q_INVOKABLE QVariantList nowPlayingList() const {return nowPlayingList_i;}
    Q_INVOKABLE void setNowPlayingList(const QVariantList& nowPlayingList) {nowPlayingList_i = nowPlayingList; _DEBUG_ << "setPlayinglist"; emit nowPlayingListChanged();}

    Q_PROPERTY(QVariantList playlistsList READ playlistsList WRITE setPlaylistsList NOTIFY playlistsListChanged)
    Q_INVOKABLE QVariantList playlistsList() const {return playlistsList_i;}
    Q_INVOKABLE void setPlaylistsList(const QVariantList& playlistsList) {playlistsList_i = playlistsList; emit playlistsListChanged();}

    Q_PROPERTY(QVariantList albumsList READ albumsList WRITE setAlbumsList NOTIFY albumsListChanged)
    Q_INVOKABLE QVariantList albumsList() const {return albumsList_i;}
    Q_INVOKABLE void setAlbumsList(const QVariantList& albumsList) {albumsList_i = albumsList; _DEBUG_ << "setAlbumslist"; emit albumsListChanged();}

    Q_PROPERTY(QVariantList favoritesList READ favoritesList WRITE setFavoritesList NOTIFY favoritesListChanged)
    Q_INVOKABLE QVariantList favoritesList() const {return favoritesList_i;}
    Q_INVOKABLE void setFavoritesList(const QVariantList& favoritesList) {favoritesList_i = favoritesList; emit favoritesListChanged();}

    Q_PROPERTY(QVariantList radiosList READ radiosList WRITE setRadiosList NOTIFY radiosListChanged)
    Q_INVOKABLE QVariantList radiosList() const {return radiosList_i;}
    Q_INVOKABLE void setRadiosList(const QVariantList& radiosList) {radiosList_i = radiosList; _DEBUG_ << "setRadioslist"; emit radiosListChanged();}

    Q_PROPERTY(QVariantList appsList READ appsList WRITE setAppsList NOTIFY appsListChanged)
    Q_INVOKABLE QVariantList appsList() const {return appsList_i;}
    Q_INVOKABLE void setAppsList(const QVariantList& appsList) {appsList_i = appsList;  _DEBUG_ << "setAppslist"; emit appsListChanged();}

    Q_PROPERTY(QVariantList treeList READ treeList WRITE setTreeList NOTIFY treeListChanged)
    Q_INVOKABLE QVariantList treeList() const {return treeList_i;}
    Q_INVOKABLE void setTreeList(const QVariantList& treeList) {treeList_i = treeList; emit treeListChanged();}

    Q_PROPERTY(QVariantList listList READ listList WRITE setListList NOTIFY listListChanged)
    Q_INVOKABLE QVariantList listList() const {return listList_i;}
    Q_INVOKABLE void setListList(const QVariantList& listList) {listList_i = listList; emit listListChanged();}

    Q_PROPERTY(QString albumartUrl READ albumartUrl WRITE setAlbumartUrl NOTIFY albumartUrlChanged)
    Q_INVOKABLE void setAlbumartUrl(const QString& url) {albumartUrl_i = url; emit albumartUrlChanged();}
    Q_INVOKABLE QString albumartUrl() const {return(albumartUrl_i);}

    Q_PROPERTY(QVariantMap currentSong READ currentSong WRITE setCurrentSong NOTIFY currentSongChanged)
    Q_INVOKABLE void setCurrentSong(const QVariantMap& song) {currentSong_i = song; emit currentSongChanged();}
    Q_INVOKABLE QVariantMap currentSong() const {return(currentSong_i);}

    Q_PROPERTY(QVariantList playersList READ playersList WRITE setPlayersList NOTIFY playersListChanged)
    Q_INVOKABLE void setPlayersList(const QVariantList& playersList) {playersList_i = playersList;  _DEBUG_ << "setPlayerslist";emit playersListChanged();}
    Q_INVOKABLE QVariantList playersList() const {return(playersList_i);}
    Q_INVOKABLE QVariantMap getPlayersList(int i) const {if(playersList_i.count())return(playersList_i[i].toMap());else return(QVariantMap());}

    Q_PROPERTY(QVariantList otherPlayersList READ otherPlayersList WRITE setOtherPlayersList NOTIFY otherPlayersListChanged)
    Q_INVOKABLE void setOtherPlayersList(const QVariantList& otherPlayersList) {otherPlayersList_i = otherPlayersList;  _DEBUG_ << "setotherPlayersList";emit otherPlayersListChanged();}
    Q_INVOKABLE QVariantList otherPlayersList() const {return(otherPlayersList_i);}
    Q_INVOKABLE QVariantMap getotherPlayersList(int i) const {if(otherPlayersList_i.count())return(otherPlayersList_i[i].toMap());else return(QVariantMap());}

    Q_PROPERTY(QVariantMap serverStatus READ serverStatus WRITE setServerStatus NOTIFY serverStatusChanged)
    void setServerStatus(const QVariantMap& serverStatus) {serverStatus_i = serverStatus; emit serverStatusChanged();}
    Q_INVOKABLE QVariantMap serverStatus() const {return(serverStatus_i);}

    Q_PROPERTY(QVariantMap playerStatus READ playerStatus WRITE setPlayerStatus NOTIFY playerStatusChanged)
    Q_INVOKABLE void setPlayerStatus(const QVariantMap& playerStatus) {playerStatus_i = playerStatus; emit playerStatusChanged();}
    Q_INVOKABLE QVariantMap playerStatus() const {return(playerStatus_i);}

    Q_PROPERTY(QString treeCommand READ treeCommand WRITE setTreeCommand)
    Q_INVOKABLE void setTreeCommand(const QString& treeCommand) {treeCommand_i = treeCommand;emit treeCommandChanged();}
    Q_INVOKABLE QString treeCommand() const {return(treeCommand_i);}

    Q_PROPERTY(QString treeTitle READ treeTitle WRITE setTreeTitle)
    Q_INVOKABLE void setTreeTitle(const QString& treeTitle) {treeTitle_i = treeTitle;emit treeTitleChanged();}
    Q_INVOKABLE QString treeTitle() const {return(treeTitle_i);}

    Q_PROPERTY(QString listCommand READ listCommand WRITE setListCommand)
    Q_INVOKABLE void setListCommand(const QString& listCommand) {listCommand_i = listCommand;emit listCommandChanged();}
    Q_INVOKABLE QString listCommand() const {return(listCommand_i);}

    Q_PROPERTY(QString listTitle READ listTitle WRITE setListTitle)
    Q_INVOKABLE void setListTitle(const QString& listTitle) {listTitle_i = listTitle;emit listTitleChanged();}
    Q_INVOKABLE QString listTitle() const {return(listTitle_i);}

    Q_PROPERTY(double playlistTimeStamp READ playlistTimeStamp WRITE setPlaylistTimeStamp)
    Q_INVOKABLE void setPlaylistTimeStamp(double time) {playlistTimeStamp_i=time; emit playlistTimeStampChanged();}
    Q_INVOKABLE double playlistTimeStamp() const {return(playlistTimeStamp_i);}

    Q_PROPERTY(QString serverHttpAddress READ serverHttpAddress NOTIFY serverHttpAddressChanged)
    Q_INVOKABLE QString serverHttpAddress() const {
        if(connectionSettings()["mysb"].toBool()) {
            return(QString("http://")+NO_HTTP_MYSB_ADDRESS);
        } else {
            return(QString("http://"+QUrl::toPercentEncoding(connectionSettings()["username"].toString())+":"+
                           QUrl::toPercentEncoding(connectionSettings()["password"].toString())+
                           "@"+connectionSettings()["ipaddress"].toString()+":"+connectionSettings()["httpport"].toString()));
        }
    }

    Q_PROPERTY(QString jsonHttpAddress READ jsonHttpAddress NOTIFY jsonHttpAddressChanged)
    Q_INVOKABLE QString jsonHttpAddress() const {return(QString(serverHttpAddress()+JSON_EXT));}

    Q_PROPERTY(QString cometHttpAddress READ cometHttpAddress NOTIFY cometHttpAddressChanged)
    Q_INVOKABLE QString cometHttpAddress() const {
        if(connectionSettings()["mysb"].toBool())
            return(QString(serverHttpAddress()+":9000"+COMET_EXT));
        else
            return(QString(serverHttpAddress()+COMET_EXT));}

    Q_PROPERTY(QString mailbox READ mailbox WRITE setMailbox NOTIFY mailboxChanged)
    Q_INVOKABLE void setMailbox(QString mailbox) {mailbox_i = mailbox;emit mailboxChanged();}
    Q_INVOKABLE QString mailbox() const {return(mailbox_i);}
    Q_INVOKABLE void clearMailbox() {mailbox_i = "";}

    Q_PROPERTY(bool favoriteExists READ favoriteExists WRITE setFavoriteExists NOTIFY favoriteExistsChanged)
    Q_INVOKABLE void setFavoriteExists(bool favoriteExists) {favoriteExists_i = favoriteExists;emit favoriteExistsChanged();}
    Q_INVOKABLE bool favoriteExists() const {return(favoriteExists_i);}

    Q_PROPERTY(int favoriteIndex READ favoriteIndex WRITE setFavoriteIndex NOTIFY favoriteIndexChanged)
    Q_INVOKABLE void setFavoriteIndex(int favoriteIndex) {favoriteIndex_i = favoriteIndex;emit favoriteIndexChanged();}
    Q_INVOKABLE int favoriteIndex() const {return(favoriteIndex_i);}

    Q_PROPERTY(QVariantList serverList READ serverList WRITE setServerList NOTIFY serverListChanged)
    Q_INVOKABLE QVariantList serverList() const {return serverList_i;}
    Q_INVOKABLE void setServerList(const QVariantList& serverList) {serverList_i = serverList;  _DEBUG_ << "setServerList" << serverList_i; emit serverListChanged();}

    Q_PROPERTY(QString squeezsterVersion READ squeezsterVersion)
    QString squeezsterVersion() {return(VERSION_CORE);}

    Q_PROPERTY(quint16 authCount READ authCount)
    quint16 authCount() {return(authCount_i);}

    Q_PROPERTY(QString favoriteName READ favoriteName WRITE setFavoriteName)
    Q_INVOKABLE void setFavoriteName(const QString& favoriteName="") {favoriteName_i = favoriteName;emit favoriteNameChanged();}
    Q_INVOKABLE QString favoriteName() const {return(favoriteName_i);}

    Q_PROPERTY(int jsonTimeOutCount READ jsonTimeOutCount WRITE setJsonTimeOutCount NOTIFY jsonTimeOutCountChanged)
    Q_INVOKABLE void setJsonTimeOutCount(int jsonTimeOutCount) {jsonTimeOutCount_i = jsonTimeOutCount;emit jsonTimeOutCountChanged();}
    Q_INVOKABLE int jsonTimeOutCount() const {return(jsonTimeOutCount_i);}

    Q_PROPERTY(int cometTimeOutCount READ cometTimeOutCount WRITE setCometTimeOutCount NOTIFY cometTimeOutCountChanged)
    Q_INVOKABLE void setCometTimeOutCount(int cometTimeOutCount) {cometTimeOutCount_i = cometTimeOutCount;emit cometTimeOutCountChanged();}
    Q_INVOKABLE int cometTimeOutCount() const {return(cometTimeOutCount_i);}

    Q_PROPERTY(int debugFlag READ debugFlag WRITE setDebugFlag NOTIFY debugFlagChanged)
    Q_INVOKABLE void setDebugFlag(int debugFlag) {debugFlag_i = debugFlag;emit debugFlagChanged();}
    Q_INVOKABLE int debugFlag() const {return(debugFlag_i);}

    Q_PROPERTY(QString listSearch READ listSearch WRITE setListSearch NOTIFY listSearchChanged)
    Q_INVOKABLE void setListSearch(QString listSearch) {listSearch_i = listSearch;emit listSearchChanged();}
    Q_INVOKABLE QString listSearch() const {return(listSearch_i);}

    QByteArray activePlayerName()
    {
        for(int i=0;i<playersList().count();i++) {
            if(activePlayer()==playersList().at(i).toMap().value("playerid")) {
                return(playersList().at(i).toMap().value("name").toByteArray());
            }
        }
        return "";
    }
    QPointer<QNetworkAccessManager> networkManager() {return httpNetworkManager;}

signals:
    void initDoneSignal();
    void cometInitDone();
    void jsonServerVersion(QString version);
    void updateListUISignal(QVariantList paramsList, QVariantMap* resultMap);
    void updateTreeUISignal(QVariantList paramsList, QVariantMap* resultMap);
    void cometServerVersion(const QString);
    void newSettings();
    void mailboxChanged();
    void networkError();
    void openHelpPage();

    void nowPlayingListChanged();
    void playlistsListChanged();
    void albumsListChanged();
    void favoritesListChanged();
    void radiosListChanged();
    void appsListChanged();
    void treeListChanged();
    void listListChanged();
    void albumartUrlChanged();
    void currentSongChanged();
    void activePlayerChanged();
    void activePlayerIndexChanged();
    void playersListChanged();
    void otherPlayersListChanged();
    void serverStatusChanged();
    void playerStatusChanged();
    void treeCommandChanged();
    void treeTitleChanged();
    void listCommandChanged();
    void listTitleChanged();
    void favoriteNameChanged();
    void playlistTimeStampChanged();
    void serverVersionOK();
    void optionsSettingsChanged();
    void connectionSettingsChanged();
    void serverHttpAddressChanged();
    void jsonHttpAddressChanged();
    void cometHttpAddressChanged();
    void favoriteExistsChanged();
    void favoriteIndexChanged();
    void jsonTimeOutCountChanged();
    void cometTimeOutCountChanged();
    void serverListChanged();
    void debugFlagChanged();
    void listSearchChanged();

public slots:
    Q_INVOKABLE void serverDiscovery();
    Q_INVOKABLE void setConnectionSettings(const QVariantMap& connectionSettings) {
        _DEBUG_ << "setConnectionSettings: " << connectionSettings;
        prevServerHttpAddress_i = serverHttpAddress();
        connectionSettings_i = connectionSettings; emit connectionSettingsChanged();emit serverHttpAddressChanged(); emit jsonHttpAddressChanged(); emit cometHttpAddressChanged();}
    Q_INVOKABLE QVariantMap connectionSettings() const {return(connectionSettings_i);}

    Q_INVOKABLE void setOptionsSettings(const QVariantMap& optionsSettings);
    Q_INVOKABLE QVariantMap optionsSettings() const {return(optionsSettings_i);}

    void start();
    void stop(QString server="");
    void restart();

    void writeConnectionSettings();
    void writeOptionsSettings();

    bool playerPlay() {return (playerStatus().value("mode").toString()=="play");}
    bool playerPause() {return (playerStatus().value("mode").toString()=="pause");}
    bool playerStop() {return (playerStatus().value("mode").toString()=="stop");}
    bool playerPower() {return (playerStatus().value("power").toString()=="1");}
    quint16 playerTime() {return(playerStatus().value("time").toInt());}
    quint16 playerDuration() {return(playerStatus().value("duration").toInt());}
    quint16 playerRepeat() {return(playerStatus().value("playlist repeat").toInt());}
    quint16 playerShuffle() {return(playerStatus().value("playlist shuffle").toInt());}
    qint8 playerVolume() {return(playerStatus().value("mixer volume").toInt());}
    bool playerMute() {return(playerVolume()<0);}
    quint16 playerSongIndex() {return(playerStatus().value("playlist_cur_index").toInt());}
    quint16 playerTotalSongs() {return(playerStatus().value("playlist_tracks").toInt());}
    void setPlayerChanged(bool state) {playerChanged_i = state;}
    bool playerChanged() {return(playerChanged_i);}
    bool playlistChanged();
    void requestList(const QString& command, QByteArray playerID="",bool subscribe=false, quint32 count=MAX_ITEMS, quint32 start=0, quint32 batch=0, QByteArray tags="");
    void sendQmlRequest(QString command) {_DEBUG_ << "sendQmlRequest()" << command;sendJson(command.split(" "),activePlayer());}
    void sendQmlCometRequest(const QString& command, QString id="", QString search="", QString type="");


private:
    QVariantList nowPlayingList_i;
    QVariantList playlistsList_i;
    QVariantList albumsList_i;
    QVariantList favoritesList_i;
    QVariantList radiosList_i;
    QVariantList appsList_i;
    QVariantList treeList_i;
    QVariantList listList_i;
    QVariantList playersList_i;
    QVariantList otherPlayersList_i;
    QString albumartUrl_i;
    QVariantMap currentSong_i;
    QVariantMap playerStatus_i;
    QByteArray activePlayer_i;
    int activePlayerIndex_i;
    QVariantMap serverStatus_i;
    QString treeCommand_i;
    QString treeTitle_i;
    QString listCommand_i;
    QString listTitle_i;
    QString favoriteName_i;
    double playlistTimeStamp_i;
    QVariantMap optionsSettings_i;
    QVariantMap connectionSettings_i;
    QString prevServerHttpAddress_i;
    QString mailbox_i;
    bool favoriteExists_i;
    int favoriteIndex_i;
    int jsonTimeOutCount_i;
    int cometTimeOutCount_i;
    QVariantList serverList_i;
    int debugFlag_i;
    QString listSearch_i;

    QPointer<QNetworkSession> networkSession;
    QPointer<QNetworkAccessManager> jsonNetworkManager;
    QPointer<QNetworkAccessManager> cometNetworkManager;
    QPointer<QNetworkAccessManager> httpNetworkManager;
    QNetworkConfigurationManager manager;
    QByteArray uuid;

    QPointer<QSettings> squeezsterSettings; //("Audiovance", "Squeezster");
    QVariantMap playersMap;
    QTcpSocket *tcpSocket;
    QUrl jsonUrl;
    QPointer<QNetworkReply> cometReply;
    QPointer<QNetworkReply> cometReplyDelete;
    QPointer<QNetworkReply> initCometReply;
    QPointer<QNetworkReply> jsonReply;
    QNetworkRequest jsonNetworkRequest;
    QNetworkRequest cometNetworkRequest;
    QByteArray cometID;
    QByteArray cometExtBA;
    QVariantMap cometExtVM;
    QString cometRawMessage;
    QStringList cometMessageList;
    QPointer<QTimer> cometTimer;
    QByteArray cometExt;
    quint16 cID;
    QByteArray cIDStr;
    quint16 cometTimeOut;
    quint16 cometInterval;
    QTimer genericTimer;

    bool activePlayerSet;
    bool initDone;
    bool loginReply;
    bool playerChanged_i;
    quint16 playerCount;
    quint16 authCount_i;
    bool disconnectEnable;
    QString mailMessage;
    QVariantMap prevPlayerStatus;

    QUdpSocket *serverUdpSocket;
    QUdpSocket *clientUdpSocket;
    //#if defined(MEEGO_EDITION_HARMATTAN) || defined(Q_WS_MAEMO_5)
    QPointer<QSystemNetworkInfo> netInfo;
    //#endif
#if defined(MEEGO_EDITION_HARMATTAN) || defined(Q_WS_MAEMO_5) || defined(Q_OS_SYMBIAN)
    QPointer<QtMobility::QSystemScreenSaver> screenSaverInhibiter;
#endif

private slots:
    // Slots called from QML:
    void consoleLog(QString str) {_DEBUG_ << "ConsoleLog:" << str;}

    void subscribeOnPlayer(QByteArray player) {sendComet((QByteArray("status - 1 subscribe:5 ")+STATUSTAGS),CometSubscription,player);}
    bool validPlayerSet() {return(!activePlayer().isEmpty() && (activePlayer()!="ff:ff:ff:ff:ff:ff"));}
    bool isValidPlayer(QByteArray playerID) {return(playerID!="ff:ff:ff:ff:ff:ff");}
    bool onMysb() {return connectionSettings()["mysb"].toBool();}
    void cometInitSubscribe();
    void cometDisconnect(QString server="");
    void cometRead();
    void cometReadDelete();
    void cometInit();
    void cometTimeOutSlot();
    void jsonTimeOutSlot();
    void replyDelete();
    void setMailboxSlot() {setMailbox(mailMessage);}
    void confChanged() {_DEBUG_ << "Network configuration changed.";}
    void onlineChanged() {_DEBUG_ << "Online state changed.";}
    void sessionErrorSlot();
    void openNetworkSession();

    void cometParse(QByteArray* cometChannel, const QVariantMap& cometData);
    QNetworkReply* cometRequest(QNetworkAccessManager* nam, QByteArray clientID, QByteArray channel, QByteArray command, QByteArray playerID, quint16 *idPtr=0);
    QByteArray cometRequestEncode(QByteArray clientID, QByteArray channel, QByteArray command, QByteArray playerID, quint16 *idPtr=0);

    void networkErrorSlot(QNetworkReply::NetworkError code);

    void requestServerVersion();
    void checkServerVersion(const QString& serverVersionStr);
    void httpAuthentSlot(QNetworkReply* reply, QAuthenticator* authenticator);
    void initEnvironment();
    void initLists();
    void initServer();
    void playerStatusSlot();
    bool playerListsEqual(QVariantList list1, QVariantList list2);
    void updateUI();

    void initCometSubscription(const QByteArray& command,quint16 period, QByteArray playerID="");
    void sendComet(const QByteArray& message, CometType type=CometRequest, QByteArray playerID="");
    QNetworkReply* sendJson(const QStringList& commandList,QByteArray playerID="", QByteArray server="");
    void jsonParse();
    void mapParse(const QVariantMap &map , const QByteArray &command,
                  const QByteArray &param1, const QByteArray &playerID="", bool treeChild=false, bool items=false);


    void readSettings();

    void envClear() {
        _DEBUG_ << "envClear";
        initDone=false;
        activePlayerSet=false;
        setPlayerChanged(true);
        setPlayersList(QVariantList());
        setCurrentSong(QVariantMap());
        playerCount=0;
        authCount_i=0;
        favoriteExists_i=false;
        jsonTimeOutCount_i=0;
    }

    void mysbLogin();
    void clearCookieJar() { // Test function
        QNetworkCookieJar* newJar=new QNetworkCookieJar();
        cometNetworkManager->setCookieJar(newJar);}
    void receiveUdpDatagram();
    void openHelpPageSlot() {emit openHelpPage();}
};

#endif // SQUEEZSTERCORE_H
