#ifndef SQUEEZERESPONSE_H
#define SQUEEZERESPONSE_H

#include <QObject>
#include <QTcpSocket>
#include <QTimer>
#include <QList>


#define RESPONSEINTERVAL 300

class squeezeResponse : public QObject
{
    Q_OBJECT

public:
        //squeezeResponse();
        explicit squeezeResponse();

        squeezeResponse(QTextStream *newStream);
        squeezeResponse(QTcpSocket* newTcpSocket,QTextStream *newStream);
        squeezeResponse(QTcpSocket* newTcpSocket);
        void setTcpSocket(QTcpSocket* newTcpSocket);
        void setTextStream(QTextStream *newStream);

        QByteArray getRawResponse();
        QList<QByteArray>* getResponse();


    public slots:
        QList<QByteArray> readResponseWait();
        void readResponse();

    signals:
        void responseReceived(QList<QByteArray>);

    private slots:

    private:
        QTcpSocket *tcpSocket;
        QTextStream *in;
        QByteArray responseByteArray;
        QList<QByteArray> responseByteArrayList;
        //QMutex* responseMutex;

        QByteArray responseFilter(QByteArray myRawResponse);
        QList<QByteArray> splitResponse(QByteArray concByteArray);
        QList<QByteArray> filterList;
};

#endif // SQUEEZERESPONSE_H
