#include <QtGui/QApplication>
#include "squeezster.h"

#include <stdio.h>
#include <stdlib.h>

QTextStream debug;

void squeezsterMsgHandler(QtMsgType type, const char *msg)
{
#if defined(DEBUGTOFILE)
//#if !defined(QT_NO_DEBUG)
  extern QTextStream debug;
    switch (type) {
    case QtDebugMsg:
        debug << "Debug:" << msg << "\n";
        break;
    case QtWarningMsg:
        debug << "Warning:" << msg << "\n";
        break;
    case QtCriticalMsg:
        debug << "Critical:" << msg << "\n";
        break;
    case QtFatalMsg:
        debug << "Fatal:" << msg << "\n";
        abort();
    }
    debug.flush();
//#endif
#endif

#if defined(DEBUGTOSTDERR)
//#if !defined(QT_NO_DEBUG)

    switch (type) {
    case QtDebugMsg:
        fprintf(stderr,"Debug: %s \n",msg);
        break;
    case QtWarningMsg:
        fprintf(stderr,"Warning: %s \n",msg);
        break;
    case QtCriticalMsg:
        fprintf(stderr,"Critical: %s \n",msg);
        break;
    case QtFatalMsg:
        fprintf(stderr,"Fatal: %s \n",msg);
        abort();
    }

//#endif
#endif
}

int main(int argc, char *argv[])
{
    // Install new messagehandler for debug messages
#if defined(INSTALLMSGHANDLER)
  #if defined(DEBUGTOFILE)
    QFile debugFile("/tmp/squeezster_debug.log");
    if(!debugFile.open(QIODevice::WriteOnly))
        qDebug("Warning: Cannot open log file");
    debug.setDevice(&debugFile);
  #endif
  qInstallMsgHandler(squeezsterMsgHandler);
#endif

    QApplication a(argc, argv);
    squeezster w;
#if defined(Q_WS_S60)
    w.showMaximized();
#else
    w.show();
#endif
    qDebug() << "Exit main()";
    return a.exec();
}
