#ifndef XMLLISTITEM_H
#define XMLLISTITEM_H

#include <QListWidgetItem>
#include <QHash>
#include <QVariant>
#include <QtDebug>
#include "squeezster_icons.h"
#include "metatypes.h"

typedef QVariantHash* variantHash_ptr;

class xmlListItem : public QListWidgetItem
{
    //Q_OBJECT
public:
    //enum {Type = QListWidgetItem::UserType+1 };
    enum {Type = 1002 };
    explicit xmlListItem(QListWidget* parent = 0);
    ~xmlListItem() {delete hash;}

    static const int xmlItemCol = 0;
    static const int xmlItem = 128;
    void addProperty(QString key, QString val);
    QString property(QString key);
    void setIcon();
    void setIcon(QIcon icon) {QListWidgetItem::setIcon(icon);}
    bool isRemote() {return((property("remote")=="1")?true:false);}
    QString command() {return(property("cmd"));}
    QString title() {return(property("title"));}
    QString artist() {return(property("artist"));}
    QString id() {return(property("id"));}
    QString item_id() {return(QString("item_id:"+property("id")));}
    QString album_id() {return(QString("album_id:"+property("id")));}
    QString folder_id() {return(QString("folder_id:"+property("id")));}
    QString track_id() {return(QString("track_id:"+property("id")));}
    QString genre_id() {return(QString("genre_id:"+property("id")));}
    QString playlist_id() {return(QString("playlist_id:"+property("id")));}
    quint16 playlistIndex() {return(property("playlist index").toInt());}
    float duration() {return(property("duration").toFloat());}
    QString albumArtUrl(QString ipAddress, quint16 httpPort);

signals:

public slots:


private:
    QVariant variant;
    QVariantHash* hash;
};

Q_DECLARE_METATYPE(xmlListItem);
Q_DECLARE_METATYPE(xmlListItem*);
//Q_DECLARE_METATYPE(QVariantHash*)
#endif // XMLLISTITEM_H
